/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.security.oauth.server;

import dev.forkhandles.result4k.Failure;
import dev.forkhandles.result4k.Result;
import dev.forkhandles.result4k.Success;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.http4k.core.Request;
import org.http4k.core.Uri;
import org.http4k.security.Nonce;
import org.http4k.security.ResponseMode;
import org.http4k.security.ResponseType;
import org.http4k.security.State;
import org.http4k.security.oauth.server.AuthRequest;
import org.http4k.security.oauth.server.AuthRequestExtractor;
import org.http4k.security.oauth.server.AuthRequestFromQueryParameters;
import org.http4k.security.oauth.server.InvalidAuthorizationRequest;
import org.http4k.security.oauth.server.InvalidRequestObject;
import org.http4k.security.oauth.server.request.RequestJWTValidator;
import org.http4k.security.oauth.server.request.RequestObject;
import org.http4k.security.oauth.server.request.RequestObjectExtractor;
import org.http4k.security.openid.RequestJwtContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\u0006\u0010\f\u001a\u00020\rH\u0016J$\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J5\u0010\u0012\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u0001H\u0013\u0012\u0004\u0012\u00020\u000b0\t\"\u0004\b\u0000\u0010\u00132\b\u0010\u0014\u001a\u0004\u0018\u0001H\u00132\b\u0010\u0015\u001a\u0004\u0018\u0001H\u0013H\u0002\u00a2\u0006\u0002\u0010\u0016J6\u0010\u0017\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u0018\u0012\u0004\u0012\u00020\u000b0\t2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/http4k/security/oauth/server/AuthRequestWithRequestAuthRequestExtractor;", "Lorg/http4k/security/oauth/server/AuthRequestExtractor;", "requestJWTValidator", "Lorg/http4k/security/oauth/server/request/RequestJWTValidator;", "combineAuthRequestRequestStrategy", "Lorg/http4k/security/oauth/server/AuthRequestWithRequestAuthRequestExtractor$CombineAuthRequestRequestStrategy;", "<init>", "(Lorg/http4k/security/oauth/server/request/RequestJWTValidator;Lorg/http4k/security/oauth/server/AuthRequestWithRequestAuthRequestExtractor$CombineAuthRequestRequestStrategy;)V", "extract", "Ldev/forkhandles/result4k/Result;", "Lorg/http4k/security/oauth/server/AuthRequest;", "Lorg/http4k/security/oauth/server/InvalidAuthorizationRequest;", "request", "Lorg/http4k/core/Request;", "combineAuthRequestAndRequestObject", "authRequest", "requestObject", "Lorg/http4k/security/oauth/server/request/RequestObject;", "nonNullValueIfExistsOrErrorIfNotEqual", "T", "authRequestValue", "requestObjectValue", "(Ljava/lang/Object;Ljava/lang/Object;)Ldev/forkhandles/result4k/Result;", "nonEmptyScopeIfExistsOrErrorIfNotEqual", "", "", "CombineAuthRequestRequestStrategy", "http4k-security-oauth"})
@SourceDebugExtension(value={"SMAP\nAuthRequestWithRequestAuthRequestExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AuthRequestWithRequestAuthRequestExtractor.kt\norg/http4k/security/oauth/server/AuthRequestWithRequestAuthRequestExtractor\n+ 2 result.kt\ndev/forkhandles/result4k/ResultKt\n*L\n1#1,124:1\n43#2,2:125\n52#2:127\n72#2,4:128\n43#2,4:132\n45#2,2:136\n108#2,4:138\n108#2,4:142\n108#2,4:146\n108#2,4:150\n108#2,4:154\n108#2,4:158\n*S KotlinDebug\n*F\n+ 1 AuthRequestWithRequestAuthRequestExtractor.kt\norg/http4k/security/oauth/server/AuthRequestWithRequestAuthRequestExtractor\n*L\n22#1:125,2\n30#1:127\n30#1:128,4\n31#1:132,4\n22#1:136,2\n51#1:138,4\n55#1:142,4\n59#1:146,4\n63#1:150,4\n68#1:154,4\n70#1:158,4\n*E\n"})
public final class AuthRequestWithRequestAuthRequestExtractor
implements AuthRequestExtractor {
    @NotNull
    private final RequestJWTValidator requestJWTValidator;
    @NotNull
    private final CombineAuthRequestRequestStrategy combineAuthRequestRequestStrategy;

    public AuthRequestWithRequestAuthRequestExtractor(@NotNull RequestJWTValidator requestJWTValidator, @NotNull CombineAuthRequestRequestStrategy combineAuthRequestRequestStrategy) {
        Intrinsics.checkNotNullParameter((Object)requestJWTValidator, (String)"requestJWTValidator");
        Intrinsics.checkNotNullParameter((Object)combineAuthRequestRequestStrategy, (String)"combineAuthRequestRequestStrategy");
        this.requestJWTValidator = requestJWTValidator;
        this.combineAuthRequestRequestStrategy = combineAuthRequestRequestStrategy;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public Result<AuthRequest, InvalidAuthorizationRequest> extract(@NotNull Request request2) {
        Result<AuthRequest, InvalidAuthorizationRequest> result;
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Result<AuthRequest, InvalidAuthorizationRequest> $this$flatMap$iv = AuthRequestFromQueryParameters.INSTANCE.extract(request2);
        boolean $i$f$flatMap = false;
        Result<AuthRequest, InvalidAuthorizationRequest> result2 = $this$flatMap$iv;
        if (result2 instanceof Success) {
            AuthRequest authRequest = (AuthRequest)((Success)$this$flatMap$iv).getValue();
            boolean bl = false;
            RequestJwtContainer requestJwtContainer = authRequest.getRequest();
            if (requestJwtContainer != null) {
                InvalidAuthorizationRequest requestJwtValidationError = this.requestJWTValidator.validate(authRequest.getClient(), requestJwtContainer);
                if (requestJwtValidationError != null) {
                    result = (Result)new Failure((Object)requestJwtValidationError);
                    return result;
                } else {
                    void $this$flatMap$iv2;
                    Result result3;
                    void $this$mapFailure$iv;
                    Result<RequestObject, InvalidRequestObject> result4 = RequestObjectExtractor.INSTANCE.extractRequestObjectFromJwt(requestJwtContainer.getValue());
                    boolean $i$f$mapFailure = false;
                    void $this$flatMapFailure$iv$iv = $this$mapFailure$iv;
                    boolean $i$f$flatMapFailure = false;
                    void var13_14 = $this$flatMapFailure$iv$iv;
                    if (var13_14 instanceof Success) {
                        result3 = $this$flatMapFailure$iv$iv;
                    } else {
                        if (!(var13_14 instanceof Failure)) throw new NoWhenBranchMatchedException();
                        Object reason$iv = ((Failure)$this$flatMapFailure$iv$iv).getReason();
                        boolean bl2 = false;
                        InvalidRequestObject it = (InvalidRequestObject)reason$iv;
                        boolean bl3 = false;
                        InvalidAuthorizationRequest invalidAuthorizationRequest = new InvalidAuthorizationRequest("Query 'request' is invalid");
                        result3 = (Result)new Failure((Object)invalidAuthorizationRequest);
                    }
                    $this$mapFailure$iv = result3;
                    boolean $i$f$flatMap2 = false;
                    void var11_11 = $this$flatMap$iv2;
                    if (var11_11 instanceof Success) {
                        RequestObject requestObject = (RequestObject)((Success)$this$flatMap$iv2).getValue();
                        boolean bl4 = false;
                        result = this.combineAuthRequestAndRequestObject(authRequest, requestObject);
                        return result;
                    } else {
                        if (!(var11_11 instanceof Failure)) throw new NoWhenBranchMatchedException();
                        result = $this$flatMap$iv2;
                    }
                }
                return result;
            } else {
                result = (Result<AuthRequest, InvalidAuthorizationRequest>)new Success((Object)authRequest);
            }
            return result;
        } else {
            if (!(result2 instanceof Failure)) throw new NoWhenBranchMatchedException();
            result = $this$flatMap$iv;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final Result<AuthRequest, InvalidAuthorizationRequest> combineAuthRequestAndRequestObject(AuthRequest authRequest, RequestObject requestObject) {
        void $this$onFailure$iv;
        Result<ResponseMode, InvalidAuthorizationRequest> $this$onFailure$iv2;
        void $this$onFailure$iv3;
        void $this$onFailure$iv4;
        void $this$onFailure$iv5;
        if (requestObject.getClient() != null && !Intrinsics.areEqual((Object)authRequest.getClient(), (Object)requestObject.getClient())) {
            return (Result)new Failure((Object)new InvalidAuthorizationRequest("'client_id' is invalid"));
        }
        Object object = this.nonNullValueIfExistsOrErrorIfNotEqual(authRequest.getRedirectUri(), requestObject.getRedirectUri());
        boolean $i$f$onFailure22 = false;
        void var6_6 = $this$onFailure$iv5;
        if (!(var6_6 instanceof Success)) {
            if (var6_6 instanceof Failure) {
                Failure it = (Failure)$this$onFailure$iv5;
                boolean bl = false;
                return (Result)it;
            }
            throw new NoWhenBranchMatchedException();
        }
        Uri uri = (Uri)((Success)$this$onFailure$iv5).getValue();
        Result<State, InvalidAuthorizationRequest> $i$f$onFailure22 = this.nonNullValueIfExistsOrErrorIfNotEqual(authRequest.getState(), requestObject.getState());
        boolean $i$f$onFailure32 = false;
        void it = $this$onFailure$iv4;
        if (!(it instanceof Success)) {
            if (it instanceof Failure) {
                Failure it2 = (Failure)$this$onFailure$iv4;
                boolean bl = false;
                return (Result)it2;
            }
            throw new NoWhenBranchMatchedException();
        }
        object = (State)((Success)$this$onFailure$iv4).getValue();
        Result<Nonce, InvalidAuthorizationRequest> $i$f$onFailure32 = this.nonNullValueIfExistsOrErrorIfNotEqual(authRequest.getNonce(), requestObject.getNonce());
        boolean $i$f$onFailure = false;
        Result<ResponseType, InvalidAuthorizationRequest> it2 = $this$onFailure$iv3;
        if (!(it2 instanceof Success)) {
            if (it2 instanceof Failure) {
                Failure it3 = (Failure)$this$onFailure$iv3;
                boolean bl = false;
                return (Result)it3;
            }
            throw new NoWhenBranchMatchedException();
        }
        Nonce nonce2 = (Nonce)((Success)$this$onFailure$iv3).getValue();
        it2 = this.nonNullValueIfExistsOrErrorIfNotEqual(authRequest.getResponseType(), requestObject.getResponseType());
        boolean $i$f$onFailure4 = false;
        Result<ResponseMode, InvalidAuthorizationRequest> bl = $this$onFailure$iv2;
        if (!(bl instanceof Success)) {
            if (bl instanceof Failure) {
                Failure it4 = (Failure)$this$onFailure$iv2;
                boolean bl2 = false;
                return (Result)it4;
            }
            throw new NoWhenBranchMatchedException();
        }
        ResponseType responseType2 = (ResponseType)((Object)((Success)$this$onFailure$iv2).getValue());
        if (responseType2 == null) {
            responseType2 = ResponseType.Code;
        }
        ResponseType responseType3 = responseType2;
        $this$onFailure$iv2 = this.nonNullValueIfExistsOrErrorIfNotEqual(authRequest.getResponseMode(), requestObject.getResponseMode());
        $i$f$onFailure4 = false;
        bl = $this$onFailure$iv2;
        if (!(bl instanceof Success)) {
            if (bl instanceof Failure) {
                Failure it5 = (Failure)$this$onFailure$iv2;
                boolean bl3 = false;
                return (Result)it5;
            }
            throw new NoWhenBranchMatchedException();
        }
        ResponseMode responseMode2 = (ResponseMode)((Object)((Success)$this$onFailure$iv2).getValue());
        Result<List<String>, InvalidAuthorizationRequest> $i$f$onFailure42 = this.nonEmptyScopeIfExistsOrErrorIfNotEqual(authRequest.getScopes(), requestObject.getScope());
        boolean $i$f$onFailure5 = false;
        void var11_26 = $this$onFailure$iv;
        if (!(var11_26 instanceof Success)) {
            if (var11_26 instanceof Failure) {
                Failure it6 = (Failure)$this$onFailure$iv;
                boolean bl4 = false;
                return (Result)it6;
            }
            throw new NoWhenBranchMatchedException();
        }
        List list = (List)((Success)$this$onFailure$iv).getValue();
        AuthRequest authRequest2 = AuthRequest.copy$default(authRequest, null, list, uri, object, responseType3, nonce2, responseMode2, null, requestObject, null, null, 1665, null);
        return (Result)new Success((Object)authRequest2);
    }

    private final <T> Result<T, InvalidAuthorizationRequest> nonNullValueIfExistsOrErrorIfNotEqual(T authRequestValue, T requestObjectValue) {
        if (authRequestValue != null && requestObjectValue != null && !Intrinsics.areEqual(authRequestValue, requestObjectValue)) {
            return (Result)new Failure((Object)new InvalidAuthorizationRequest("request object is invalid"));
        }
        return (Result)new Success(this.combineAuthRequestRequestStrategy.combine(authRequestValue, requestObjectValue));
    }

    private final Result<List<String>, InvalidAuthorizationRequest> nonEmptyScopeIfExistsOrErrorIfNotEqual(List<String> authRequestValue, List<String> requestObjectValue) {
        if (!((Collection)authRequestValue).isEmpty() && !((Collection)requestObjectValue).isEmpty() && !Intrinsics.areEqual((Object)CollectionsKt.toSet((Iterable)authRequestValue), (Object)CollectionsKt.toSet((Iterable)requestObjectValue))) {
            return (Result)new Failure((Object)new InvalidAuthorizationRequest("request object is invalid"));
        }
        return (Result)new Success(this.combineAuthRequestRequestStrategy.combine(authRequestValue, requestObjectValue));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0003\b\t\nJ)\u0010\u0002\u001a\u0004\u0018\u0001H\u0003\"\u0004\b\u0000\u0010\u00032\b\u0010\u0004\u001a\u0004\u0018\u0001H\u00032\b\u0010\u0005\u001a\u0004\u0018\u0001H\u0003H&\u00a2\u0006\u0002\u0010\u0006J0\u0010\u0002\u001a\b\u0012\u0004\u0012\u0002H\u00030\u0007\"\u0004\b\u0000\u0010\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00030\u00072\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00030\u0007H&\u0082\u0001\u0003\u000b\f\r\u00a8\u0006\u000e"}, d2={"Lorg/http4k/security/oauth/server/AuthRequestWithRequestAuthRequestExtractor$CombineAuthRequestRequestStrategy;", "", "combine", "T", "authRequestValue", "requestObjectValue", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "", "Combine", "AuthRequestOnly", "RequestObjectOnly", "Lorg/http4k/security/oauth/server/AuthRequestWithRequestAuthRequestExtractor$CombineAuthRequestRequestStrategy$AuthRequestOnly;", "Lorg/http4k/security/oauth/server/AuthRequestWithRequestAuthRequestExtractor$CombineAuthRequestRequestStrategy$Combine;", "Lorg/http4k/security/oauth/server/AuthRequestWithRequestAuthRequestExtractor$CombineAuthRequestRequestStrategy$RequestObjectOnly;", "http4k-security-oauth"})
    public static sealed interface CombineAuthRequestRequestStrategy {
        @Nullable
        public <T> T combine(@Nullable T var1, @Nullable T var2);

        @NotNull
        public <T> List<T> combine(@NotNull List<? extends T> var1, @NotNull List<? extends T> var2);

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\u0004\u001a\u0004\u0018\u0001H\u0005\"\u0004\b\u0000\u0010\u00052\b\u0010\u0006\u001a\u0004\u0018\u0001H\u00052\b\u0010\u0007\u001a\u0004\u0018\u0001H\u0005H\u0016\u00a2\u0006\u0002\u0010\bJ0\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00050\t\"\u0004\b\u0000\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\t2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00050\tH\u0016J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001\u00a8\u0006\u0012"}, d2={"Lorg/http4k/security/oauth/server/AuthRequestWithRequestAuthRequestExtractor$CombineAuthRequestRequestStrategy$AuthRequestOnly;", "Lorg/http4k/security/oauth/server/AuthRequestWithRequestAuthRequestExtractor$CombineAuthRequestRequestStrategy;", "<init>", "()V", "combine", "T", "authRequestValue", "requestObjectValue", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "", "equals", "", "other", "", "hashCode", "", "toString", "", "http4k-security-oauth"})
        public static final class AuthRequestOnly
        implements CombineAuthRequestRequestStrategy {
            @NotNull
            public static final AuthRequestOnly INSTANCE = new AuthRequestOnly();

            private AuthRequestOnly() {
            }

            @Override
            @Nullable
            public <T> T combine(@Nullable T authRequestValue, @Nullable T requestObjectValue) {
                return authRequestValue;
            }

            @Override
            @NotNull
            public <T> List<T> combine(@NotNull List<? extends T> authRequestValue, @NotNull List<? extends T> requestObjectValue) {
                Intrinsics.checkNotNullParameter(authRequestValue, (String)"authRequestValue");
                Intrinsics.checkNotNullParameter(requestObjectValue, (String)"requestObjectValue");
                return authRequestValue;
            }

            @NotNull
            public String toString() {
                return "AuthRequestOnly";
            }

            public int hashCode() {
                return -2031773445;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof AuthRequestOnly)) {
                    return false;
                }
                AuthRequestOnly cfr_ignored_0 = (AuthRequestOnly)other;
                return true;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\u0004\u001a\u0004\u0018\u0001H\u0005\"\u0004\b\u0000\u0010\u00052\b\u0010\u0006\u001a\u0004\u0018\u0001H\u00052\b\u0010\u0007\u001a\u0004\u0018\u0001H\u0005H\u0016\u00a2\u0006\u0002\u0010\bJ0\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00050\t\"\u0004\b\u0000\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\t2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00050\tH\u0016J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001\u00a8\u0006\u0012"}, d2={"Lorg/http4k/security/oauth/server/AuthRequestWithRequestAuthRequestExtractor$CombineAuthRequestRequestStrategy$Combine;", "Lorg/http4k/security/oauth/server/AuthRequestWithRequestAuthRequestExtractor$CombineAuthRequestRequestStrategy;", "<init>", "()V", "combine", "T", "authRequestValue", "requestObjectValue", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "", "equals", "", "other", "", "hashCode", "", "toString", "", "http4k-security-oauth"})
        @SourceDebugExtension(value={"SMAP\nAuthRequestWithRequestAuthRequestExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AuthRequestWithRequestAuthRequestExtractor.kt\norg/http4k/security/oauth/server/AuthRequestWithRequestAuthRequestExtractor$CombineAuthRequestRequestStrategy$Combine\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,124:1\n1#2:125\n*E\n"})
        public static final class Combine
        implements CombineAuthRequestRequestStrategy {
            @NotNull
            public static final Combine INSTANCE = new Combine();

            private Combine() {
            }

            @Override
            @Nullable
            public <T> T combine(@Nullable T authRequestValue, @Nullable T requestObjectValue) {
                T t = authRequestValue;
                if (t == null) {
                    t = requestObjectValue;
                }
                return t;
            }

            @Override
            @NotNull
            public <T> List<T> combine(@NotNull List<? extends T> authRequestValue, @NotNull List<? extends T> requestObjectValue) {
                List<T> list;
                Intrinsics.checkNotNullParameter(authRequestValue, (String)"authRequestValue");
                Intrinsics.checkNotNullParameter(requestObjectValue, (String)"requestObjectValue");
                List<T> list2 = (List<T>)authRequestValue;
                if (list2.isEmpty()) {
                    boolean bl = false;
                    list = requestObjectValue;
                } else {
                    list = list2;
                }
                return list;
            }

            @NotNull
            public String toString() {
                return "Combine";
            }

            public int hashCode() {
                return -1205131737;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Combine)) {
                    return false;
                }
                Combine cfr_ignored_0 = (Combine)other;
                return true;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\u0004\u001a\u0004\u0018\u0001H\u0005\"\u0004\b\u0000\u0010\u00052\b\u0010\u0006\u001a\u0004\u0018\u0001H\u00052\b\u0010\u0007\u001a\u0004\u0018\u0001H\u0005H\u0016\u00a2\u0006\u0002\u0010\bJ0\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00050\t\"\u0004\b\u0000\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\t2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00050\tH\u0016J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001\u00a8\u0006\u0012"}, d2={"Lorg/http4k/security/oauth/server/AuthRequestWithRequestAuthRequestExtractor$CombineAuthRequestRequestStrategy$RequestObjectOnly;", "Lorg/http4k/security/oauth/server/AuthRequestWithRequestAuthRequestExtractor$CombineAuthRequestRequestStrategy;", "<init>", "()V", "combine", "T", "authRequestValue", "requestObjectValue", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "", "equals", "", "other", "", "hashCode", "", "toString", "", "http4k-security-oauth"})
        public static final class RequestObjectOnly
        implements CombineAuthRequestRequestStrategy {
            @NotNull
            public static final RequestObjectOnly INSTANCE = new RequestObjectOnly();

            private RequestObjectOnly() {
            }

            @Override
            @Nullable
            public <T> T combine(@Nullable T authRequestValue, @Nullable T requestObjectValue) {
                return requestObjectValue;
            }

            @Override
            @NotNull
            public <T> List<T> combine(@NotNull List<? extends T> authRequestValue, @NotNull List<? extends T> requestObjectValue) {
                Intrinsics.checkNotNullParameter(authRequestValue, (String)"authRequestValue");
                Intrinsics.checkNotNullParameter(requestObjectValue, (String)"requestObjectValue");
                return requestObjectValue;
            }

            @NotNull
            public String toString() {
                return "RequestObjectOnly";
            }

            public int hashCode() {
                return 1361628770;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof RequestObjectOnly)) {
                    return false;
                }
                RequestObjectOnly cfr_ignored_0 = (RequestObjectOnly)other;
                return true;
            }
        }
    }
}

