/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.security.oauth.client;

import dev.forkhandles.result4k.Failure;
import dev.forkhandles.result4k.Result;
import dev.forkhandles.result4k.Success;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.http4k.core.Method;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.http4k.core.Uri;
import org.http4k.security.oauth.client.OAuthAuthorizationServer;
import org.http4k.security.oauth.format.OAuthMoshi;
import org.http4k.security.oauth.metadata.ResourceMetadata;
import org.http4k.security.oauth.metadata.ServerMetadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00e6\u0080\u0001\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fJ@\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\b\u0012\u00060\u0005j\u0002`\u00060\u00032%\u0010\u0007\u001a!\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\r0\bj\u0002`\u000eH\u00a6\u0002\u00a8\u0006\u0010"}, d2={"Lorg/http4k/security/oauth/client/AuthServerDiscovery;", "", "invoke", "Ldev/forkhandles/result4k/Result;", "Lorg/http4k/security/oauth/client/OAuthAuthorizationServer;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "http", "Lkotlin/Function1;", "Lorg/http4k/core/Request;", "Lkotlin/ParameterName;", "name", "request", "Lorg/http4k/core/Response;", "Lorg/http4k/core/HttpHandler;", "Companion", "http4k-security-oauth"})
public interface AuthServerDiscovery {
    @NotNull
    public static final Companion Companion = org.http4k.security.oauth.client.AuthServerDiscovery$Companion.$$INSTANCE;

    @NotNull
    public Result<OAuthAuthorizationServer, Exception> invoke(@NotNull Function1<? super Request, ? extends Response> var1);

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J$\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00072\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00070\u000b\u00a8\u0006\r"}, d2={"Lorg/http4k/security/oauth/client/AuthServerDiscovery$Companion;", "", "<init>", "()V", "fromKnownAuthServer", "Lorg/http4k/security/oauth/client/AuthServerDiscovery;", "serverUri", "Lorg/http4k/core/Uri;", "fromProtectedResource", "resourceUri", "retrieveAuthServer", "Lkotlin/Function1;", "Lorg/http4k/security/oauth/metadata/ResourceMetadata;", "http4k-security-oauth"})
    @SourceDebugExtension(value={"SMAP\nAuthServerDiscovery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AuthServerDiscovery.kt\norg/http4k/security/oauth/client/AuthServerDiscovery$Companion\n+ 2 result.kt\ndev/forkhandles/result4k/ResultKt\n*L\n1#1,55:1\n22#2,5:56\n48#2,2:61\n22#2,5:63\n50#2,2:68\n48#2,4:70\n*S KotlinDebug\n*F\n+ 1 AuthServerDiscovery.kt\norg/http4k/security/oauth/client/AuthServerDiscovery$Companion\n*L\n28#1:56,5\n50#1:61,2\n50#1:63,5\n50#1:68,2\n51#1:70,4\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @NotNull
        public final AuthServerDiscovery fromKnownAuthServer(@NotNull Uri serverUri) {
            Intrinsics.checkNotNullParameter((Object)serverUri, (String)"serverUri");
            return arg_0 -> Companion.fromKnownAuthServer$lambda$1(serverUri, arg_0);
        }

        @NotNull
        public final AuthServerDiscovery fromProtectedResource(@NotNull Uri resourceUri, @NotNull Function1<? super ResourceMetadata, Uri> retrieveAuthServer) {
            Intrinsics.checkNotNullParameter((Object)resourceUri, (String)"resourceUri");
            Intrinsics.checkNotNullParameter(retrieveAuthServer, (String)"retrieveAuthServer");
            return arg_0 -> Companion.fromProtectedResource$lambda$6(resourceUri, retrieveAuthServer, arg_0);
        }

        public static /* synthetic */ AuthServerDiscovery fromProtectedResource$default(Companion companion, Uri uri, Function1 function1, int n, Object object) {
            if ((n & 2) != 0) {
                function1 = Companion::fromProtectedResource$lambda$2;
            }
            return companion.fromProtectedResource(uri, (Function1<? super ResourceMetadata, Uri>)function1);
        }

        private static final Result fromKnownAuthServer$lambda$1(Uri $serverUri, Function1 http) {
            Result result;
            Intrinsics.checkNotNullParameter((Object)http, (String)"http");
            Response response = (Response)http.invoke((Object)Request.Companion.create$default((Request.Companion)Request.Companion, (Method)Method.GET, (Uri)$serverUri.path("/.well-known/oauth-authorization-server"), null, (int)4, null));
            if (response.getStatus().getSuccessful()) {
                Result result2;
                boolean $i$f$resultFrom = false;
                try {
                    boolean bl = false;
                    OAuthAuthorizationServer oAuthAuthorizationServer = new OAuthAuthorizationServer($serverUri, (ServerMetadata)OAuthMoshi.INSTANCE.asA(response.bodyString(), Reflection.getOrCreateKotlinClass(ServerMetadata.class)));
                    result2 = (Result)new Success((Object)oAuthAuthorizationServer);
                }
                catch (Exception x$iv) {
                    result2 = (Result)new Failure((Object)x$iv);
                }
                result = result2;
            } else {
                result = (Result)new Failure((Object)new Exception("Failed to discover OAuth endpoints"));
            }
            return result;
        }

        private static final Uri fromProtectedResource$lambda$2(ResourceMetadata it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Uri uri = it.getAuthorizationServers();
            if (uri == null || (uri = (Uri)CollectionsKt.first(uri)) == null) {
                throw new IllegalStateException("No auth servers".toString());
            }
            return uri;
        }

        /*
         * WARNING - void declaration
         */
        private static final Result fromProtectedResource$lambda$6(Uri $resourceUri, Function1 $retrieveAuthServer, Function1 http) {
            Result<OAuthAuthorizationServer, Exception> result;
            Result result2;
            ResourceMetadata it;
            void $this$flatMap$iv;
            Intrinsics.checkNotNullParameter((Object)http, (String)"http");
            Response response = (Response)http.invoke((Object)Request.Companion.create$default((Request.Companion)Request.Companion, (Method)Method.GET, (Uri)$resourceUri.path("/.well-known/oauth-protected-resource"), null, (int)4, null));
            Result result3 = response.getStatus().getSuccessful() ? (Result)new Success(OAuthMoshi.INSTANCE.asA(response.bodyString(), Reflection.getOrCreateKotlinClass(ResourceMetadata.class))) : (Result)new Failure((Object)new Exception("Failed to discover OAuth endpoints"));
            boolean $i$f$flatMap = false;
            void var6_6 = $this$flatMap$iv;
            if (var6_6 instanceof Success) {
                Result result4;
                it = (ResourceMetadata)((Success)$this$flatMap$iv).getValue();
                boolean bl = false;
                boolean $i$f$resultFrom = false;
                try {
                    boolean bl2 = false;
                    Uri uri = (Uri)$retrieveAuthServer.invoke((Object)it);
                    result4 = (Result)new Success((Object)uri);
                }
                catch (Exception x$iv) {
                    result4 = (Result)new Failure((Object)x$iv);
                }
                result2 = result4;
            } else if (var6_6 instanceof Failure) {
                result2 = $this$flatMap$iv;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            $this$flatMap$iv = result2;
            $i$f$flatMap = false;
            var6_6 = $this$flatMap$iv;
            if (var6_6 instanceof Success) {
                it = (Uri)((Success)$this$flatMap$iv).getValue();
                boolean bl = false;
                result = $$INSTANCE.fromKnownAuthServer((Uri)it).invoke((Function1<? super Request, ? extends Response>)http);
            } else if (var6_6 instanceof Failure) {
                result = $this$flatMap$iv;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return result;
        }

        static {
            $$INSTANCE = new Companion();
        }
    }
}

