/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.security.oauth.server;

import java.time.Clock;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.http4k.core.Body;
import org.http4k.core.Filter;
import org.http4k.core.Http4kKt;
import org.http4k.core.Method;
import org.http4k.core.Request;
import org.http4k.core.Uri;
import org.http4k.format.AutoMarshalling;
import org.http4k.lens.BiDiBodyLens;
import org.http4k.lens.BiDiLens;
import org.http4k.lens.BiDiLensSpec;
import org.http4k.lens.FormField;
import org.http4k.lens.Lens;
import org.http4k.lens.LensBuilder;
import org.http4k.lens.LensSpecKt;
import org.http4k.lens.Query;
import org.http4k.lens.Validator;
import org.http4k.lens.WebForm;
import org.http4k.lens.WebFormKt;
import org.http4k.routing.BindKt;
import org.http4k.routing.HttpKt;
import org.http4k.routing.RoutingHttpHandler;
import org.http4k.security.Nonce;
import org.http4k.security.ResponseMode;
import org.http4k.security.ResponseType;
import org.http4k.security.State;
import org.http4k.security.oauth.format.OAuthMoshi;
import org.http4k.security.oauth.server.AccessTokenResponseRenderer;
import org.http4k.security.oauth.server.AccessTokens;
import org.http4k.security.oauth.server.AuthRequestExtractor;
import org.http4k.security.oauth.server.AuthRequestFromQueryParameters;
import org.http4k.security.oauth.server.AuthRequestTracking;
import org.http4k.security.oauth.server.AuthRequestTrackingFilter;
import org.http4k.security.oauth.server.AuthenticationComplete;
import org.http4k.security.oauth.server.AuthoriseRequestErrorRender;
import org.http4k.security.oauth.server.AuthoriseRequestValidator;
import org.http4k.security.oauth.server.AuthorizationCodes;
import org.http4k.security.oauth.server.ClientId;
import org.http4k.security.oauth.server.ClientValidationFilter;
import org.http4k.security.oauth.server.ClientValidator;
import org.http4k.security.oauth.server.DefaultAccessTokenResponseRenderer;
import org.http4k.security.oauth.server.GenerateAccessToken;
import org.http4k.security.oauth.server.IdTokens;
import org.http4k.security.oauth.server.JsonResponseErrorRenderer;
import org.http4k.security.oauth.server.OAuthServer;
import org.http4k.security.oauth.server.SimpleAuthoriseRequestValidator;
import org.http4k.security.oauth.server.accesstoken.AccessTokenRequestAuthentication;
import org.http4k.security.oauth.server.accesstoken.ClientSecretAccessTokenRequestAuthentication;
import org.http4k.security.oauth.server.accesstoken.GrantTypesConfiguration;
import org.http4k.security.oauth.server.refreshtoken.RefreshTokens;
import org.http4k.security.oauth.server.request.RequestJWTValidator;
import org.http4k.security.openid.RequestJwtContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 42\u00020\u0001:\u00014B\u0091\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u0012\b\b\u0002\u0010\u0014\u001a\u00020\u0015\u0012\b\b\u0002\u0010\u0016\u001a\u00020\u0017\u0012\b\b\u0002\u0010\u0018\u001a\u00020\u0019\u0012\b\b\u0002\u0010\u001a\u001a\u00020\u001b\u0012\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\u0004\b\u001f\u0010 B\u008b\u0001\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010!\u001a\u00020\"\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u0012\b\b\u0002\u0010\u0014\u001a\u00020\u0015\u0012\b\b\u0002\u0010\u0016\u001a\u00020\u0017\u0012\b\b\u0002\u0010\u0018\u001a\u00020\u0019\u0012\b\b\u0002\u0010\u001a\u001a\u00020\u001b\u0012\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\u0004\b\u001f\u0010#R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010(\u001a\u00020)\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0011\u0010,\u001a\u00020-\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0011\u00100\u001a\u000201\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103\u00a8\u00065"}, d2={"Lorg/http4k/security/oauth/server/OAuthServer;", "", "tokenPath", "", "authRequestTracking", "Lorg/http4k/security/oauth/server/AuthRequestTracking;", "authoriseRequestValidator", "Lorg/http4k/security/oauth/server/AuthoriseRequestValidator;", "accessTokenRequestAuthentication", "Lorg/http4k/security/oauth/server/accesstoken/AccessTokenRequestAuthentication;", "authorizationCodes", "Lorg/http4k/security/oauth/server/AuthorizationCodes;", "accessTokens", "Lorg/http4k/security/oauth/server/AccessTokens;", "clock", "Ljava/time/Clock;", "json", "Lorg/http4k/format/AutoMarshalling;", "authRequestExtractor", "Lorg/http4k/security/oauth/server/AuthRequestExtractor;", "grantTypes", "Lorg/http4k/security/oauth/server/accesstoken/GrantTypesConfiguration;", "idTokens", "Lorg/http4k/security/oauth/server/IdTokens;", "refreshTokens", "Lorg/http4k/security/oauth/server/refreshtoken/RefreshTokens;", "requestJWTValidator", "Lorg/http4k/security/oauth/server/request/RequestJWTValidator;", "documentationUri", "tokenResponseRenderer", "Lorg/http4k/security/oauth/server/AccessTokenResponseRenderer;", "<init>", "(Ljava/lang/String;Lorg/http4k/security/oauth/server/AuthRequestTracking;Lorg/http4k/security/oauth/server/AuthoriseRequestValidator;Lorg/http4k/security/oauth/server/accesstoken/AccessTokenRequestAuthentication;Lorg/http4k/security/oauth/server/AuthorizationCodes;Lorg/http4k/security/oauth/server/AccessTokens;Ljava/time/Clock;Lorg/http4k/format/AutoMarshalling;Lorg/http4k/security/oauth/server/AuthRequestExtractor;Lorg/http4k/security/oauth/server/accesstoken/GrantTypesConfiguration;Lorg/http4k/security/oauth/server/IdTokens;Lorg/http4k/security/oauth/server/refreshtoken/RefreshTokens;Lorg/http4k/security/oauth/server/request/RequestJWTValidator;Ljava/lang/String;Lorg/http4k/security/oauth/server/AccessTokenResponseRenderer;)V", "clientValidator", "Lorg/http4k/security/oauth/server/ClientValidator;", "(Ljava/lang/String;Lorg/http4k/security/oauth/server/AuthRequestTracking;Lorg/http4k/security/oauth/server/ClientValidator;Lorg/http4k/security/oauth/server/AuthorizationCodes;Lorg/http4k/security/oauth/server/AccessTokens;Ljava/time/Clock;Lorg/http4k/format/AutoMarshalling;Lorg/http4k/security/oauth/server/AuthRequestExtractor;Lorg/http4k/security/oauth/server/accesstoken/GrantTypesConfiguration;Lorg/http4k/security/oauth/server/IdTokens;Lorg/http4k/security/oauth/server/refreshtoken/RefreshTokens;Lorg/http4k/security/oauth/server/request/RequestJWTValidator;Ljava/lang/String;Lorg/http4k/security/oauth/server/AccessTokenResponseRenderer;)V", "errorRenderer", "Lorg/http4k/security/oauth/server/JsonResponseErrorRenderer;", "authoriseRequestErrorRender", "Lorg/http4k/security/oauth/server/AuthoriseRequestErrorRender;", "tokenRoute", "Lorg/http4k/routing/RoutingHttpHandler;", "getTokenRoute", "()Lorg/http4k/routing/RoutingHttpHandler;", "authenticationStart", "Lorg/http4k/core/Filter;", "getAuthenticationStart", "()Lorg/http4k/core/Filter;", "authenticationComplete", "Lorg/http4k/security/oauth/server/AuthenticationComplete;", "getAuthenticationComplete", "()Lorg/http4k/security/oauth/server/AuthenticationComplete;", "Companion", "http4k-security-oauth"})
public final class OAuthServer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JsonResponseErrorRenderer errorRenderer;
    @NotNull
    private final AuthoriseRequestErrorRender authoriseRequestErrorRender;
    @NotNull
    private final RoutingHttpHandler tokenRoute;
    @NotNull
    private final Filter authenticationStart;
    @NotNull
    private final AuthenticationComplete authenticationComplete;
    @NotNull
    private static final BiDiLens<Request, ClientId> clientIdQueryParameter = (BiDiLens)LensBuilder.DefaultImpls.required$default((LensBuilder)((LensBuilder)Query.INSTANCE.map((Function1)Companion.clientIdQueryParameter.1.INSTANCE, (Function1)Companion.clientIdQueryParameter.2.INSTANCE)), (String)"client_id", null, null, (int)6, null);
    @NotNull
    private static final BiDiLens<Request, List<String>> scopesQueryParameter = (BiDiLens)LensBuilder.DefaultImpls.optional$default((LensBuilder)((LensBuilder)Query.INSTANCE.map(OAuthServer::scopesQueryParameter$lambda$0, OAuthServer::scopesQueryParameter$lambda$1)), (String)"scope", null, null, (int)6, null);
    @NotNull
    private static final BiDiLens<Request, Uri> redirectUriQueryParameter = (BiDiLens)LensBuilder.DefaultImpls.optional$default((LensBuilder)((LensBuilder)LensSpecKt.uri((BiDiLensSpec)((BiDiLensSpec)Query.INSTANCE))), (String)"redirect_uri", null, null, (int)6, null);
    @NotNull
    private static final BiDiLens<Request, Uri> resourceUriQueryParameter = (BiDiLens)LensBuilder.DefaultImpls.optional$default((LensBuilder)((LensBuilder)LensSpecKt.uri((BiDiLensSpec)((BiDiLensSpec)Query.INSTANCE))), (String)"resource_uri", null, null, (int)6, null);
    @NotNull
    private static final BiDiLens<Request, State> state = (BiDiLens)LensBuilder.DefaultImpls.optional$default((LensBuilder)((LensBuilder)Query.INSTANCE.map((Function1)Companion.state.1.INSTANCE, (Function1)Companion.state.2.INSTANCE)), (String)"state", null, null, (int)6, null);
    @NotNull
    private static final BiDiLens<Request, ResponseType> responseType = (BiDiLens)LensBuilder.DefaultImpls.required$default((LensBuilder)((LensBuilder)Query.INSTANCE.map((Function1)new Function1<String, ResponseType>((Object)ResponseType.Companion){

        public final ResponseType invoke(String p0) {
            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
            return ((ResponseType.Companion)this.receiver).fromQueryParameterValue(p0);
        }
    }, (Function1)Companion.responseType.2.INSTANCE)), (String)"response_type", null, null, (int)6, null);
    @NotNull
    private static final BiDiLens<Request, ResponseMode> responseMode = (BiDiLens)LensBuilder.DefaultImpls.optional$default((LensBuilder)((LensBuilder)Query.INSTANCE.map((Function1)new Function1<String, ResponseMode>((Object)ResponseMode.Companion){

        public final ResponseMode invoke(String p0) {
            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
            return ((ResponseMode.Companion)this.receiver).fromQueryParameterValue(p0);
        }
    }, (Function1)Companion.responseMode.2.INSTANCE)), (String)"response_mode", null, null, (int)6, null);
    @NotNull
    private static final BiDiLens<Request, Nonce> nonce = (BiDiLens)LensBuilder.DefaultImpls.optional$default((LensBuilder)((LensBuilder)Query.INSTANCE.map((Function1)Companion.nonce.1.INSTANCE, (Function1)Companion.nonce.2.INSTANCE)), (String)"nonce", null, null, (int)6, null);
    @NotNull
    private static final BiDiLens<Request, RequestJwtContainer> request = (BiDiLens)LensBuilder.DefaultImpls.optional$default((LensBuilder)((LensBuilder)Query.INSTANCE.map((Function1)Companion.request.1.INSTANCE, (Function1)Companion.request.2.INSTANCE)), (String)"request", null, null, (int)6, null);
    @NotNull
    private static final BiDiLens<WebForm, ClientId> clientIdForm = (BiDiLens)LensBuilder.DefaultImpls.optional$default((LensBuilder)((LensBuilder)FormField.INSTANCE.map((Function1)Companion.clientIdForm.1.INSTANCE, (Function1)Companion.clientIdForm.2.INSTANCE)), (String)"client_id", null, null, (int)6, null);
    @NotNull
    private static final BiDiLens<WebForm, String> clientSecret = (BiDiLens)LensBuilder.DefaultImpls.optional$default((LensBuilder)((LensBuilder)FormField.INSTANCE), (String)"client_secret", null, null, (int)6, null);
    @NotNull
    private static final BiDiLens<WebForm, String> code = (BiDiLens)LensBuilder.DefaultImpls.optional$default((LensBuilder)((LensBuilder)FormField.INSTANCE), (String)"code", null, null, (int)6, null);
    @NotNull
    private static final BiDiLens<WebForm, Uri> redirectUriForm = (BiDiLens)LensBuilder.DefaultImpls.optional$default((LensBuilder)((LensBuilder)LensSpecKt.uri((BiDiLensSpec)((BiDiLensSpec)FormField.INSTANCE))), (String)"redirect_uri", null, null, (int)6, null);
    @NotNull
    private static final BiDiLens<WebForm, Uri> resourceUriForm = (BiDiLens)LensBuilder.DefaultImpls.optional$default((LensBuilder)((LensBuilder)LensSpecKt.uri((BiDiLensSpec)((BiDiLensSpec)FormField.INSTANCE))), (String)"resource_uri", null, null, (int)6, null);
    @NotNull
    private static final BiDiLens<WebForm, List<String>> scopesForm = (BiDiLens)LensBuilder.DefaultImpls.optional$default((LensBuilder)((LensBuilder)FormField.INSTANCE.map(OAuthServer::scopesForm$lambda$2, OAuthServer::scopesForm$lambda$3)), (String)"scope", null, null, (int)6, null);
    @NotNull
    private static final BiDiLens<WebForm, Uri> clientAssertionType = (BiDiLens)LensBuilder.DefaultImpls.optional$default((LensBuilder)((LensBuilder)LensSpecKt.uri((BiDiLensSpec)((BiDiLensSpec)FormField.INSTANCE))), (String)"client_assertion_type", null, null, (int)6, null);
    @NotNull
    private static final BiDiLens<WebForm, String> clientAssertion = (BiDiLens)LensBuilder.DefaultImpls.optional$default((LensBuilder)((LensBuilder)FormField.INSTANCE), (String)"client_assertion", null, null, (int)6, null);
    @NotNull
    private static final BiDiLens<WebForm, String> refreshToken = (BiDiLens)LensBuilder.DefaultImpls.optional$default((LensBuilder)((LensBuilder)FormField.INSTANCE), (String)"refresh_token", null, null, (int)6, null);
    @NotNull
    private static final BiDiBodyLens<WebForm> tokenRequestWebForm;

    public OAuthServer(@NotNull String tokenPath, @NotNull AuthRequestTracking authRequestTracking, @NotNull AuthoriseRequestValidator authoriseRequestValidator, @NotNull AccessTokenRequestAuthentication accessTokenRequestAuthentication, @NotNull AuthorizationCodes authorizationCodes, @NotNull AccessTokens accessTokens, @NotNull Clock clock, @NotNull AutoMarshalling json2, @NotNull AuthRequestExtractor authRequestExtractor, @NotNull GrantTypesConfiguration grantTypes, @NotNull IdTokens idTokens, @NotNull RefreshTokens refreshTokens, @NotNull RequestJWTValidator requestJWTValidator, @Nullable String documentationUri, @NotNull AccessTokenResponseRenderer tokenResponseRenderer) {
        Intrinsics.checkNotNullParameter((Object)tokenPath, (String)"tokenPath");
        Intrinsics.checkNotNullParameter((Object)authRequestTracking, (String)"authRequestTracking");
        Intrinsics.checkNotNullParameter((Object)authoriseRequestValidator, (String)"authoriseRequestValidator");
        Intrinsics.checkNotNullParameter((Object)accessTokenRequestAuthentication, (String)"accessTokenRequestAuthentication");
        Intrinsics.checkNotNullParameter((Object)authorizationCodes, (String)"authorizationCodes");
        Intrinsics.checkNotNullParameter((Object)accessTokens, (String)"accessTokens");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)json2, (String)"json");
        Intrinsics.checkNotNullParameter((Object)authRequestExtractor, (String)"authRequestExtractor");
        Intrinsics.checkNotNullParameter((Object)grantTypes, (String)"grantTypes");
        Intrinsics.checkNotNullParameter((Object)idTokens, (String)"idTokens");
        Intrinsics.checkNotNullParameter((Object)refreshTokens, (String)"refreshTokens");
        Intrinsics.checkNotNullParameter((Object)requestJWTValidator, (String)"requestJWTValidator");
        Intrinsics.checkNotNullParameter((Object)tokenResponseRenderer, (String)"tokenResponseRenderer");
        this.errorRenderer = new JsonResponseErrorRenderer(json2, documentationUri);
        this.authoriseRequestErrorRender = new AuthoriseRequestErrorRender(authoriseRequestValidator, requestJWTValidator, this.errorRenderer, documentationUri);
        RoutingHttpHandler[] routingHttpHandlerArray = new RoutingHttpHandler[]{BindKt.bind((String)tokenPath, (Method)Method.POST).to((Function1)new GenerateAccessToken(authorizationCodes, accessTokens, clock, idTokens, refreshTokens, this.errorRenderer, grantTypes, tokenResponseRenderer))};
        this.tokenRoute = HttpKt.routes((RoutingHttpHandler[])routingHttpHandlerArray);
        this.authenticationStart = Http4kKt.then((Filter)new ClientValidationFilter(authoriseRequestValidator, this.authoriseRequestErrorRender, authRequestExtractor), (Filter)new AuthRequestTrackingFilter(authRequestTracking, authRequestExtractor, this.authoriseRequestErrorRender));
        this.authenticationComplete = new AuthenticationComplete(authorizationCodes, authRequestTracking, idTokens, documentationUri);
    }

    public /* synthetic */ OAuthServer(String string, AuthRequestTracking authRequestTracking, AuthoriseRequestValidator authoriseRequestValidator, AccessTokenRequestAuthentication accessTokenRequestAuthentication, AuthorizationCodes authorizationCodes, AccessTokens accessTokens, Clock clock, AutoMarshalling autoMarshalling, AuthRequestExtractor authRequestExtractor, GrantTypesConfiguration grantTypesConfiguration, IdTokens idTokens, RefreshTokens refreshTokens, RequestJWTValidator requestJWTValidator, String string2, AccessTokenResponseRenderer accessTokenResponseRenderer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x80) != 0) {
            autoMarshalling = (AutoMarshalling)OAuthMoshi.INSTANCE;
        }
        if ((n & 0x100) != 0) {
            authRequestExtractor = AuthRequestFromQueryParameters.INSTANCE;
        }
        if ((n & 0x200) != 0) {
            grantTypesConfiguration = GrantTypesConfiguration.Companion.default(accessTokenRequestAuthentication);
        }
        if ((n & 0x400) != 0) {
            idTokens = IdTokens.Companion.getUnsupported();
        }
        if ((n & 0x800) != 0) {
            refreshTokens = RefreshTokens.Companion.getUnsupported();
        }
        if ((n & 0x1000) != 0) {
            requestJWTValidator = RequestJWTValidator.Companion.getUnsupported();
        }
        if ((n & 0x2000) != 0) {
            string2 = null;
        }
        if ((n & 0x4000) != 0) {
            accessTokenResponseRenderer = DefaultAccessTokenResponseRenderer.INSTANCE;
        }
        this(string, authRequestTracking, authoriseRequestValidator, accessTokenRequestAuthentication, authorizationCodes, accessTokens, clock, autoMarshalling, authRequestExtractor, grantTypesConfiguration, idTokens, refreshTokens, requestJWTValidator, string2, accessTokenResponseRenderer);
    }

    public OAuthServer(@NotNull String tokenPath, @NotNull AuthRequestTracking authRequestTracking, @NotNull ClientValidator clientValidator, @NotNull AuthorizationCodes authorizationCodes, @NotNull AccessTokens accessTokens, @NotNull Clock clock, @NotNull AutoMarshalling json2, @NotNull AuthRequestExtractor authRequestExtractor, @NotNull GrantTypesConfiguration grantTypes, @NotNull IdTokens idTokens, @NotNull RefreshTokens refreshTokens, @NotNull RequestJWTValidator requestJWTValidator, @Nullable String documentationUri, @NotNull AccessTokenResponseRenderer tokenResponseRenderer) {
        Intrinsics.checkNotNullParameter((Object)tokenPath, (String)"tokenPath");
        Intrinsics.checkNotNullParameter((Object)authRequestTracking, (String)"authRequestTracking");
        Intrinsics.checkNotNullParameter((Object)clientValidator, (String)"clientValidator");
        Intrinsics.checkNotNullParameter((Object)authorizationCodes, (String)"authorizationCodes");
        Intrinsics.checkNotNullParameter((Object)accessTokens, (String)"accessTokens");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)json2, (String)"json");
        Intrinsics.checkNotNullParameter((Object)authRequestExtractor, (String)"authRequestExtractor");
        Intrinsics.checkNotNullParameter((Object)grantTypes, (String)"grantTypes");
        Intrinsics.checkNotNullParameter((Object)idTokens, (String)"idTokens");
        Intrinsics.checkNotNullParameter((Object)refreshTokens, (String)"refreshTokens");
        Intrinsics.checkNotNullParameter((Object)requestJWTValidator, (String)"requestJWTValidator");
        Intrinsics.checkNotNullParameter((Object)tokenResponseRenderer, (String)"tokenResponseRenderer");
        this(tokenPath, authRequestTracking, new SimpleAuthoriseRequestValidator(clientValidator), new ClientSecretAccessTokenRequestAuthentication(clientValidator), authorizationCodes, accessTokens, clock, json2, authRequestExtractor, grantTypes, idTokens, refreshTokens, requestJWTValidator, documentationUri, tokenResponseRenderer);
    }

    public /* synthetic */ OAuthServer(String string, AuthRequestTracking authRequestTracking, ClientValidator clientValidator, AuthorizationCodes authorizationCodes, AccessTokens accessTokens, Clock clock, AutoMarshalling autoMarshalling, AuthRequestExtractor authRequestExtractor, GrantTypesConfiguration grantTypesConfiguration, IdTokens idTokens, RefreshTokens refreshTokens, RequestJWTValidator requestJWTValidator, String string2, AccessTokenResponseRenderer accessTokenResponseRenderer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x40) != 0) {
            autoMarshalling = (AutoMarshalling)OAuthMoshi.INSTANCE;
        }
        if ((n & 0x80) != 0) {
            authRequestExtractor = AuthRequestFromQueryParameters.INSTANCE;
        }
        if ((n & 0x100) != 0) {
            grantTypesConfiguration = GrantTypesConfiguration.Companion.default(new ClientSecretAccessTokenRequestAuthentication(clientValidator));
        }
        if ((n & 0x200) != 0) {
            idTokens = IdTokens.Companion.getUnsupported();
        }
        if ((n & 0x400) != 0) {
            refreshTokens = RefreshTokens.Companion.getUnsupported();
        }
        if ((n & 0x800) != 0) {
            requestJWTValidator = RequestJWTValidator.Companion.getUnsupported();
        }
        if ((n & 0x1000) != 0) {
            string2 = null;
        }
        if ((n & 0x2000) != 0) {
            accessTokenResponseRenderer = DefaultAccessTokenResponseRenderer.INSTANCE;
        }
        this(string, authRequestTracking, clientValidator, authorizationCodes, accessTokens, clock, autoMarshalling, authRequestExtractor, grantTypesConfiguration, idTokens, refreshTokens, requestJWTValidator, string2, accessTokenResponseRenderer);
    }

    @NotNull
    public final RoutingHttpHandler getTokenRoute() {
        return this.tokenRoute;
    }

    @NotNull
    public final Filter getAuthenticationStart() {
        return this.authenticationStart;
    }

    @NotNull
    public final AuthenticationComplete getAuthenticationComplete() {
        return this.authenticationComplete;
    }

    private static final List scopesQueryParameter$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String[] stringArray = new String[]{" "};
        return CollectionsKt.toList((Iterable)StringsKt.split$default((CharSequence)it, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
    }

    private static final String scopesQueryParameter$lambda$1(List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return CollectionsKt.joinToString$default((Iterable)it, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
    }

    private static final List scopesForm$lambda$2(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String[] stringArray = new String[]{" "};
        return CollectionsKt.toList((Iterable)StringsKt.split$default((CharSequence)it, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
    }

    private static final String scopesForm$lambda$3(List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return CollectionsKt.joinToString$default((Iterable)it, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
    }

    static {
        Lens[] lensArray = new Lens[]{clientIdForm, clientSecret, code, redirectUriForm, scopesForm, clientAssertionType, clientAssertion, refreshToken, resourceUriForm};
        tokenRequestWebForm = WebFormKt.webForm((Body.Companion)Body.Companion, (Validator)Validator.Strict, (Lens[])lensArray).toLens();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR%\u0010\n\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\f\u0012\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u001f\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\tR\u001f\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\tR\u001f\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\tR\u001d\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00170\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\tR\u001f\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\tR\u001f\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\tR\u001f\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010 0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\tR\u001f\u0010\"\u001a\u0010\u0012\u0004\u0012\u00020#\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\tR\u001f\u0010%\u001a\u0010\u0012\u0004\u0012\u00020#\u0012\u0006\u0012\u0004\u0018\u00010\f0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\tR\u001f\u0010'\u001a\u0010\u0012\u0004\u0012\u00020#\u0012\u0006\u0012\u0004\u0018\u00010\f0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\tR\u001f\u0010)\u001a\u0010\u0012\u0004\u0012\u00020#\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\tR\u001f\u0010+\u001a\u0010\u0012\u0004\u0012\u00020#\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\tR%\u0010-\u001a\u0016\u0012\u0004\u0012\u00020#\u0012\f\u0012\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\tR\u001f\u0010/\u001a\u0010\u0012\u0004\u0012\u00020#\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\tR\u001f\u00101\u001a\u0010\u0012\u0004\u0012\u00020#\u0012\u0006\u0012\u0004\u0018\u00010\f0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010\tR\u001f\u00103\u001a\u0010\u0012\u0004\u0012\u00020#\u0012\u0006\u0012\u0004\u0018\u00010\f0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010\tR\u0017\u00105\u001a\b\u0012\u0004\u0012\u00020#06\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108\u00a8\u00069"}, d2={"Lorg/http4k/security/oauth/server/OAuthServer$Companion;", "", "<init>", "()V", "clientIdQueryParameter", "Lorg/http4k/lens/BiDiLens;", "Lorg/http4k/core/Request;", "Lorg/http4k/security/oauth/server/ClientId;", "getClientIdQueryParameter", "()Lorg/http4k/lens/BiDiLens;", "scopesQueryParameter", "", "", "getScopesQueryParameter", "redirectUriQueryParameter", "Lorg/http4k/core/Uri;", "getRedirectUriQueryParameter", "resourceUriQueryParameter", "getResourceUriQueryParameter", "state", "Lorg/http4k/security/State;", "getState", "responseType", "Lorg/http4k/security/ResponseType;", "getResponseType", "responseMode", "Lorg/http4k/security/ResponseMode;", "getResponseMode", "nonce", "Lorg/http4k/security/Nonce;", "getNonce", "request", "Lorg/http4k/security/openid/RequestJwtContainer;", "getRequest", "clientIdForm", "Lorg/http4k/lens/WebForm;", "getClientIdForm", "clientSecret", "getClientSecret", "code", "getCode", "redirectUriForm", "getRedirectUriForm", "resourceUriForm", "getResourceUriForm", "scopesForm", "getScopesForm", "clientAssertionType", "getClientAssertionType", "clientAssertion", "getClientAssertion", "refreshToken", "getRefreshToken", "tokenRequestWebForm", "Lorg/http4k/lens/BiDiBodyLens;", "getTokenRequestWebForm", "()Lorg/http4k/lens/BiDiBodyLens;", "http4k-security-oauth"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BiDiLens<Request, ClientId> getClientIdQueryParameter() {
            return clientIdQueryParameter;
        }

        @NotNull
        public final BiDiLens<Request, List<String>> getScopesQueryParameter() {
            return scopesQueryParameter;
        }

        @NotNull
        public final BiDiLens<Request, Uri> getRedirectUriQueryParameter() {
            return redirectUriQueryParameter;
        }

        @NotNull
        public final BiDiLens<Request, Uri> getResourceUriQueryParameter() {
            return resourceUriQueryParameter;
        }

        @NotNull
        public final BiDiLens<Request, State> getState() {
            return state;
        }

        @NotNull
        public final BiDiLens<Request, ResponseType> getResponseType() {
            return responseType;
        }

        @NotNull
        public final BiDiLens<Request, ResponseMode> getResponseMode() {
            return responseMode;
        }

        @NotNull
        public final BiDiLens<Request, Nonce> getNonce() {
            return nonce;
        }

        @NotNull
        public final BiDiLens<Request, RequestJwtContainer> getRequest() {
            return request;
        }

        @NotNull
        public final BiDiLens<WebForm, ClientId> getClientIdForm() {
            return clientIdForm;
        }

        @NotNull
        public final BiDiLens<WebForm, String> getClientSecret() {
            return clientSecret;
        }

        @NotNull
        public final BiDiLens<WebForm, String> getCode() {
            return code;
        }

        @NotNull
        public final BiDiLens<WebForm, Uri> getRedirectUriForm() {
            return redirectUriForm;
        }

        @NotNull
        public final BiDiLens<WebForm, Uri> getResourceUriForm() {
            return resourceUriForm;
        }

        @NotNull
        public final BiDiLens<WebForm, List<String>> getScopesForm() {
            return scopesForm;
        }

        @NotNull
        public final BiDiLens<WebForm, Uri> getClientAssertionType() {
            return clientAssertionType;
        }

        @NotNull
        public final BiDiLens<WebForm, String> getClientAssertion() {
            return clientAssertion;
        }

        @NotNull
        public final BiDiLens<WebForm, String> getRefreshToken() {
            return refreshToken;
        }

        @NotNull
        public final BiDiBodyLens<WebForm> getTokenRequestWebForm() {
            return tokenRequestWebForm;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

