/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.security;

import java.time.Clock;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.http4k.core.Status;
import org.http4k.core.Uri;
import org.http4k.core.cookie.Cookie;
import org.http4k.core.cookie.CookieExtensionsKt;
import org.http4k.security.AccessToken;
import org.http4k.security.CrossSiteRequestForgeryToken;
import org.http4k.security.Nonce;
import org.http4k.security.OAuthCallbackError;
import org.http4k.security.OAuthPersistence;
import org.http4k.security.PkceChallengeAndVerifier;
import org.http4k.security.openid.IdToken;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u0011H\u0016J*\u0010 \u001a\u00020\u001d2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u00152\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\u0018\u0010$\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\u0017H\u0016J\u0018\u0010&\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010'\u001a\u00020\u0019H\u0016J\u0018\u0010(\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020\u001bH\u0016J\u0010\u0010*\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020,H\u0016J\u0018\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u00032\u0006\u00100\u001a\u00020\u0003H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/http4k/security/InsecureCookieBasedOAuthPersistence;", "Lorg/http4k/security/OAuthPersistence;", "cookieNamePrefix", "", "cookieValidity", "Ljava/time/Duration;", "clock", "Ljava/time/Clock;", "<init>", "(Ljava/lang/String;Ljava/time/Duration;Ljava/time/Clock;)V", "csrfName", "nonceName", "originalUriName", "pkceChallengeCookieName", "pkceVerifierCookieName", "accessTokenCookieName", "retrieveCsrf", "Lorg/http4k/security/CrossSiteRequestForgeryToken;", "request", "Lorg/http4k/core/Request;", "retrieveToken", "Lorg/http4k/security/AccessToken;", "retrieveNonce", "Lorg/http4k/security/Nonce;", "retrieveOriginalUri", "Lorg/http4k/core/Uri;", "retrievePkce", "Lorg/http4k/security/PkceChallengeAndVerifier;", "assignCsrf", "Lorg/http4k/core/Response;", "redirect", "csrf", "assignToken", "accessToken", "idToken", "Lorg/http4k/security/openid/IdToken;", "assignNonce", "nonce", "assignOriginalUri", "originalUri", "assignPkce", "pkce", "authFailureResponse", "reason", "Lorg/http4k/security/OAuthCallbackError;", "expiring", "Lorg/http4k/core/cookie/Cookie;", "name", "value", "http4k-security-oauth"})
@SourceDebugExtension(value={"SMAP\nInsecureCookieBasedOAuthPersistence.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InsecureCookieBasedOAuthPersistence.kt\norg/http4k/security/InsecureCookieBasedOAuthPersistence\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,79:1\n1#2:80\n*E\n"})
public final class InsecureCookieBasedOAuthPersistence
implements OAuthPersistence {
    @NotNull
    private final Duration cookieValidity;
    @NotNull
    private final Clock clock;
    @NotNull
    private final String csrfName;
    @NotNull
    private final String nonceName;
    @NotNull
    private final String originalUriName;
    @NotNull
    private final String pkceChallengeCookieName;
    @NotNull
    private final String pkceVerifierCookieName;
    @NotNull
    private final String accessTokenCookieName;

    public InsecureCookieBasedOAuthPersistence(@NotNull String cookieNamePrefix, @NotNull Duration cookieValidity, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)cookieNamePrefix, (String)"cookieNamePrefix");
        Intrinsics.checkNotNullParameter((Object)cookieValidity, (String)"cookieValidity");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.cookieValidity = cookieValidity;
        this.clock = clock;
        this.csrfName = cookieNamePrefix + "Csrf";
        this.nonceName = cookieNamePrefix + "Nonce";
        this.originalUriName = cookieNamePrefix + "OriginalUri";
        this.pkceChallengeCookieName = cookieNamePrefix + "PkceChallenge";
        this.pkceVerifierCookieName = cookieNamePrefix + "PkceVerifier";
        this.accessTokenCookieName = cookieNamePrefix + "AccessToken";
    }

    public /* synthetic */ InsecureCookieBasedOAuthPersistence(String string, Duration duration, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            Duration duration2 = Duration.ofDays(1L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofDays(...)");
            duration = duration2;
        }
        if ((n & 4) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue((Object)clock2, (String)"systemUTC(...)");
            clock = clock2;
        }
        this(string, duration, clock);
    }

    @Override
    @Nullable
    public CrossSiteRequestForgeryToken retrieveCsrf(@NotNull Request request2) {
        CrossSiteRequestForgeryToken crossSiteRequestForgeryToken;
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Object object = CookieExtensionsKt.cookie((Request)request2, (String)this.csrfName);
        if (object != null && (object = object.getValue()) != null) {
            Object p0 = object;
            boolean bl = false;
            crossSiteRequestForgeryToken = new CrossSiteRequestForgeryToken((String)p0);
        } else {
            crossSiteRequestForgeryToken = null;
        }
        return crossSiteRequestForgeryToken;
    }

    @Override
    @Nullable
    public AccessToken retrieveToken(@NotNull Request request2) {
        AccessToken accessToken;
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Object object = CookieExtensionsKt.cookie((Request)request2, (String)this.accessTokenCookieName);
        if (object != null && (object = object.getValue()) != null) {
            Object it = object;
            boolean bl = false;
            accessToken = AccessToken.Companion.invoke$default(AccessToken.Companion, (String)it, null, null, null, null, 30, null);
        } else {
            accessToken = null;
        }
        return accessToken;
    }

    @Override
    @Nullable
    public Nonce retrieveNonce(@NotNull Request request2) {
        Nonce nonce2;
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Object object = CookieExtensionsKt.cookie((Request)request2, (String)this.nonceName);
        if (object != null && (object = object.getValue()) != null) {
            Object it = object;
            boolean bl = false;
            nonce2 = new Nonce((String)it);
        } else {
            nonce2 = null;
        }
        return nonce2;
    }

    @Override
    @Nullable
    public Uri retrieveOriginalUri(@NotNull Request request2) {
        Uri uri;
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Object object = CookieExtensionsKt.cookie((Request)request2, (String)this.originalUriName);
        if (object != null && (object = object.getValue()) != null) {
            Object it = object;
            boolean bl = false;
            uri = Uri.Companion.of((String)it);
        } else {
            uri = null;
        }
        return uri;
    }

    @Override
    @Nullable
    public PkceChallengeAndVerifier retrievePkce(@NotNull Request request2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Object object = CookieExtensionsKt.cookie((Request)request2, (String)this.pkceChallengeCookieName);
        if (object == null || (object = object.getValue()) == null) {
            return null;
        }
        Object object2 = CookieExtensionsKt.cookie((Request)request2, (String)this.pkceVerifierCookieName);
        if (object2 == null || (object2 = object2.getValue()) == null) {
            return null;
        }
        return new PkceChallengeAndVerifier((String)object, (String)object2);
    }

    @Override
    @NotNull
    public Response assignCsrf(@NotNull Response redirect, @NotNull CrossSiteRequestForgeryToken csrf) {
        Intrinsics.checkNotNullParameter((Object)redirect, (String)"redirect");
        Intrinsics.checkNotNullParameter((Object)csrf, (String)"csrf");
        return CookieExtensionsKt.cookie$default((Response)redirect, (Cookie)this.expiring(this.csrfName, csrf.getValue()), (boolean)false, (int)2, null);
    }

    @Override
    @NotNull
    public Response assignToken(@NotNull Request request2, @NotNull Response redirect, @NotNull AccessToken accessToken, @Nullable IdToken idToken2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter((Object)redirect, (String)"redirect");
        Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
        return CookieExtensionsKt.invalidateCookie$default((Response)CookieExtensionsKt.invalidateCookie$default((Response)CookieExtensionsKt.invalidateCookie$default((Response)CookieExtensionsKt.cookie$default((Response)redirect, (Cookie)this.expiring(this.accessTokenCookieName, accessToken.getValue()), (boolean)false, (int)2, null), (String)this.csrfName, null, null, (int)6, null), (String)this.nonceName, null, null, (int)6, null), (String)this.originalUriName, null, null, (int)6, null);
    }

    @Override
    @NotNull
    public Response assignNonce(@NotNull Response redirect, @NotNull Nonce nonce2) {
        Intrinsics.checkNotNullParameter((Object)redirect, (String)"redirect");
        Intrinsics.checkNotNullParameter((Object)nonce2, (String)"nonce");
        return CookieExtensionsKt.cookie$default((Response)redirect, (Cookie)this.expiring(this.nonceName, nonce2.getValue()), (boolean)false, (int)2, null);
    }

    @Override
    @NotNull
    public Response assignOriginalUri(@NotNull Response redirect, @NotNull Uri originalUri) {
        Intrinsics.checkNotNullParameter((Object)redirect, (String)"redirect");
        Intrinsics.checkNotNullParameter((Object)originalUri, (String)"originalUri");
        return CookieExtensionsKt.cookie$default((Response)redirect, (Cookie)this.expiring(this.originalUriName, originalUri.toString()), (boolean)false, (int)2, null);
    }

    @Override
    @NotNull
    public Response assignPkce(@NotNull Response redirect, @NotNull PkceChallengeAndVerifier pkce) {
        Intrinsics.checkNotNullParameter((Object)redirect, (String)"redirect");
        Intrinsics.checkNotNullParameter((Object)pkce, (String)"pkce");
        return CookieExtensionsKt.cookie$default((Response)CookieExtensionsKt.cookie$default((Response)redirect, (Cookie)this.expiring(this.pkceChallengeCookieName, pkce.getChallenge()), (boolean)false, (int)2, null), (Cookie)this.expiring(this.pkceVerifierCookieName, pkce.getVerifier()), (boolean)false, (int)2, null);
    }

    @Override
    @NotNull
    public Response authFailureResponse(@NotNull OAuthCallbackError reason) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        return CookieExtensionsKt.invalidateCookie$default((Response)CookieExtensionsKt.invalidateCookie$default((Response)CookieExtensionsKt.invalidateCookie$default((Response)CookieExtensionsKt.invalidateCookie$default((Response)Response.Companion.create$default((Response.Companion)Response.Companion, (Status)Status.FORBIDDEN, null, (int)2, null), (String)this.csrfName, null, null, (int)6, null), (String)this.accessTokenCookieName, null, null, (int)6, null), (String)this.nonceName, null, null, (int)6, null), (String)this.originalUriName, null, null, (int)6, null);
    }

    private final Cookie expiring(String name, String value) {
        return new Cookie(name, value, null, this.clock.instant().plus(this.cookieValidity), null, "/", false, false, null, 468, null);
    }
}

