/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.security.oauth.server;

import dev.forkhandles.result4k.Failure;
import dev.forkhandles.result4k.Result;
import dev.forkhandles.result4k.ResultKt;
import dev.forkhandles.result4k.Success;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.http4k.security.ResponseType;
import org.http4k.security.oauth.server.AuthRequest;
import org.http4k.security.oauth.server.AuthRequestTracking;
import org.http4k.security.oauth.server.AuthorizationCode;
import org.http4k.security.oauth.server.AuthorizationCodes;
import org.http4k.security.oauth.server.IdTokens;
import org.http4k.security.oauth.server.OAuthError;
import org.http4k.security.oauth.server.ResponseRender;
import org.http4k.security.oauth.server.UserRejectedRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002!\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\u0004\u0012\u00020\u00060\u0001j\u0002`\u0007B+\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0011\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0002H\u0096\u0002J&\u0010\u0013\u001a\u00020\u0014*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0005\u001a\u00020\u00022\b\b\u0002\u0010\u0017\u001a\u00020\u0006H\u0002J\u0014\u0010\u0018\u001a\u00020\u0014*\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u0014H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/http4k/security/oauth/server/AuthenticationComplete;", "Lkotlin/Function1;", "Lorg/http4k/core/Request;", "Lkotlin/ParameterName;", "name", "request", "Lorg/http4k/core/Response;", "Lorg/http4k/core/HttpHandler;", "authorizationCodes", "Lorg/http4k/security/oauth/server/AuthorizationCodes;", "requestTracking", "Lorg/http4k/security/oauth/server/AuthRequestTracking;", "idTokens", "Lorg/http4k/security/oauth/server/IdTokens;", "documentationUri", "", "<init>", "(Lorg/http4k/security/oauth/server/AuthorizationCodes;Lorg/http4k/security/oauth/server/AuthRequestTracking;Lorg/http4k/security/oauth/server/IdTokens;Ljava/lang/String;)V", "invoke", "addResponseTypeValues", "Lorg/http4k/security/oauth/server/ResponseRender;", "authorizationRequest", "Lorg/http4k/security/oauth/server/AuthRequest;", "response", "addTo", "responseRender", "http4k-security-oauth"})
@SourceDebugExtension(value={"SMAP\nAuthenticationComplete.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AuthenticationComplete.kt\norg/http4k/security/oauth/server/AuthenticationComplete\n+ 2 result.kt\ndev/forkhandles/result4k/ResultKt\n*L\n1#1,64:1\n42#2,10:65\n57#2:75\n77#2,4:76\n*S KotlinDebug\n*F\n+ 1 AuthenticationComplete.kt\norg/http4k/security/oauth/server/AuthenticationComplete\n*L\n35#1:65,10\n53#1:75\n53#1:76,4\n*E\n"})
public final class AuthenticationComplete
implements Function1<Request, Response> {
    @NotNull
    private final AuthorizationCodes authorizationCodes;
    @NotNull
    private final AuthRequestTracking requestTracking;
    @NotNull
    private final IdTokens idTokens;
    @Nullable
    private final String documentationUri;

    public AuthenticationComplete(@NotNull AuthorizationCodes authorizationCodes, @NotNull AuthRequestTracking requestTracking, @NotNull IdTokens idTokens, @Nullable String documentationUri) {
        Intrinsics.checkNotNullParameter((Object)authorizationCodes, (String)"authorizationCodes");
        Intrinsics.checkNotNullParameter((Object)requestTracking, (String)"requestTracking");
        Intrinsics.checkNotNullParameter((Object)idTokens, (String)"idTokens");
        this.authorizationCodes = authorizationCodes;
        this.requestTracking = requestTracking;
        this.idTokens = idTokens;
        this.documentationUri = documentationUri;
    }

    public /* synthetic */ AuthenticationComplete(AuthorizationCodes authorizationCodes, AuthRequestTracking authRequestTracking, IdTokens idTokens, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string = null;
        }
        this(authorizationCodes, authRequestTracking, idTokens, string);
    }

    @NotNull
    public Response invoke(@NotNull Request request2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        AuthRequest authRequest = this.requestTracking.resolveAuthRequest(request2);
        if (authRequest == null) {
            throw new IllegalStateException("Authorization request could not be found.".toString());
        }
        AuthRequest authorizationRequest = authRequest;
        return AuthenticationComplete.addResponseTypeValues$default(this, ResponseRender.Companion.forAuthRequest(authorizationRequest), authorizationRequest, request2, null, 4, null).withState(authorizationRequest.getState()).complete();
    }

    /*
     * WARNING - void declaration
     */
    private final ResponseRender addResponseTypeValues(ResponseRender $this$addResponseTypeValues, AuthRequest authorizationRequest, Request request2, Response response) {
        Result result;
        void $this$mapFailure$iv;
        Result result2;
        Object it;
        Result $this$addResponseTypeValues_u24lambda_u242 = this.authorizationCodes.create(request2, authorizationRequest, response);
        boolean bl = false;
        Result $this$map$iv = $this$addResponseTypeValues_u24lambda_u242;
        boolean $i$f$map = false;
        Result $this$flatMap$iv$iv = $this$map$iv;
        boolean $i$f$flatMap = false;
        Result result3 = $this$flatMap$iv$iv;
        if (result3 instanceof Success) {
            Object value$iv = ((Success)$this$flatMap$iv$iv).getValue();
            boolean bl2 = false;
            it = (AuthorizationCode)value$iv;
            boolean bl3 = false;
            ResponseRender responseRender = switch (WhenMappings.$EnumSwitchMapping$0[authorizationRequest.getResponseType().ordinal()]) {
                case 1 -> $this$addResponseTypeValues.addParameter("code", ((AuthorizationCode)it).getValue());
                case 2 -> $this$addResponseTypeValues.addParameter("code", ((AuthorizationCode)it).getValue()).addParameter("id_token", this.idTokens.createForAuthorization(request2, authorizationRequest, response, authorizationRequest.getNonce(), (AuthorizationCode)it).getValue());
                default -> throw new UnsupportedOperationException(authorizationRequest.getResponseType().getQueryParameterValue());
            };
            result2 = (Result)new Success((Object)responseRender);
        } else if (result3 instanceof Failure) {
            result2 = $this$flatMap$iv$iv;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        $this$map$iv = result2;
        boolean $i$f$mapFailure = false;
        void $this$flatMapFailure$iv$iv = $this$mapFailure$iv;
        boolean $i$f$flatMapFailure = false;
        result3 = $this$flatMapFailure$iv$iv;
        if (result3 instanceof Success) {
            result = $this$flatMapFailure$iv$iv;
        } else if (result3 instanceof Failure) {
            Object reason$iv = ((Failure)$this$flatMapFailure$iv$iv).getReason();
            boolean bl4 = false;
            it = (UserRejectedRequest)reason$iv;
            boolean bl5 = false;
            ResponseRender responseRender = $this$addResponseTypeValues.addParameter("error", ((OAuthError)it).getRfcError().getRfcValue()).addParameter("error_description", ((OAuthError)it).getDescription());
            Object object = this.documentationUri;
            if (object == null || (object = this.addTo((String)object, responseRender)) == null) {
                object = responseRender;
            }
            Object object2 = object;
            result = (Result)new Failure(object2);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return (ResponseRender)ResultKt.get((Result)result);
    }

    static /* synthetic */ ResponseRender addResponseTypeValues$default(AuthenticationComplete authenticationComplete, ResponseRender responseRender, AuthRequest authRequest, Request request2, Response response, int n, Object object) {
        if ((n & 4) != 0) {
            response = responseRender.complete();
        }
        return authenticationComplete.addResponseTypeValues(responseRender, authRequest, request2, response);
    }

    private final ResponseRender addTo(String $this$addTo, ResponseRender responseRender) {
        return responseRender.addParameter("error_uri", $this$addTo);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ResponseType.values().length];
            try {
                nArray[ResponseType.Code.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResponseType.CodeIdToken.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

