/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.security.oauth.server;

import dev.forkhandles.result4k.Failure;
import dev.forkhandles.result4k.Result;
import dev.forkhandles.result4k.ResultKt;
import dev.forkhandles.result4k.Success;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.http4k.core.Uri;
import org.http4k.lens.LensFailure;
import org.http4k.security.ResponseMode;
import org.http4k.security.ResponseType;
import org.http4k.security.State;
import org.http4k.security.oauth.server.AuthoriseRequestValidator;
import org.http4k.security.oauth.server.ClientId;
import org.http4k.security.oauth.server.InvalidRequestObject;
import org.http4k.security.oauth.server.JsonResponseErrorRenderer;
import org.http4k.security.oauth.server.OAuthError;
import org.http4k.security.oauth.server.OAuthServer;
import org.http4k.security.oauth.server.ResponseRender;
import org.http4k.security.oauth.server.request.RequestJWTValidator;
import org.http4k.security.oauth.server.request.RequestObjectExtractor;
import org.http4k.security.openid.RequestJwtContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J=\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00162\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a2\u0006\u0002\u0010\u001aJa\u0010\u001b\u001a\u0004\u0018\u0001H\u001c\"\u0004\b\u0000\u0010\u001c2\u0006\u0010\u000e\u001a\u00020\u000f2\u0010\u0010\u001d\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\t2\u0014\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u0001H\u001c0!2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u0002H\u001c0!H\u0002\u00a2\u0006\u0002\u0010#J3\u0010$\u001a\u0004\u0018\u0001H\u001c\"\u0004\b\u0000\u0010\u001c2\u0006\u0010\u000e\u001a\u00020\u000f2\u0014\u0010%\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u0001H\u001c0!H\u0002\u00a2\u0006\u0002\u0010&JA\u0010'\u001a\u0004\u0018\u0001H\u001c\"\u0004\b\u0000\u0010\u001c2\u0006\u0010\u001f\u001a\u00020\t2\u000e\u0010\u000e\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001e2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u0002H\u001c0!H\u0002\u00a2\u0006\u0002\u0010(R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/http4k/security/oauth/server/AuthoriseRequestErrorRender;", "", "authoriseRequestValidator", "Lorg/http4k/security/oauth/server/AuthoriseRequestValidator;", "requestJWTValidator", "Lorg/http4k/security/oauth/server/request/RequestJWTValidator;", "fallBack", "Lorg/http4k/security/oauth/server/JsonResponseErrorRenderer;", "documentationUri", "", "<init>", "(Lorg/http4k/security/oauth/server/AuthoriseRequestValidator;Lorg/http4k/security/oauth/server/request/RequestJWTValidator;Lorg/http4k/security/oauth/server/JsonResponseErrorRenderer;Ljava/lang/String;)V", "errorFor", "Lorg/http4k/core/Response;", "request", "Lorg/http4k/core/Request;", "error", "Lorg/http4k/security/oauth/server/OAuthError;", "isUnsafeToRedirectBackToRedirectUri", "", "isRequestJwtValid", "requestClientId", "Lorg/http4k/security/oauth/server/ClientId;", "requestJwtClientId", "requestRedirectUri", "Lorg/http4k/core/Uri;", "(Ljava/lang/Boolean;Lorg/http4k/security/oauth/server/ClientId;Lorg/http4k/security/oauth/server/ClientId;Lorg/http4k/core/Uri;Lorg/http4k/core/Request;)Z", "extractValue", "T", "requestObject", "", "key", "requestCallback", "Lkotlin/Function1;", "requestObjectCallback", "(Lorg/http4k/core/Request;Ljava/util/Map;Ljava/lang/String;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "extractValueFromRequestOrNull", "callback", "(Lorg/http4k/core/Request;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "extractValueFromRequestObjectOrNull", "(Ljava/lang/String;Ljava/util/Map;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "http4k-security-oauth"})
@SourceDebugExtension(value={"SMAP\nAuthoriseRequestErrorRender.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AuthoriseRequestErrorRender.kt\norg/http4k/security/oauth/server/AuthoriseRequestErrorRender\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 result.kt\ndev/forkhandles/result4k/ResultKt\n*L\n1#1,125:1\n1#2:126\n57#3:127\n77#3,4:128\n*S KotlinDebug\n*F\n+ 1 AuthoriseRequestErrorRender.kt\norg/http4k/security/oauth/server/AuthoriseRequestErrorRender\n*L\n33#1:127\n33#1:128,4\n*E\n"})
public final class AuthoriseRequestErrorRender {
    @NotNull
    private final AuthoriseRequestValidator authoriseRequestValidator;
    @NotNull
    private final RequestJWTValidator requestJWTValidator;
    @NotNull
    private final JsonResponseErrorRenderer fallBack;
    @Nullable
    private final String documentationUri;

    public AuthoriseRequestErrorRender(@NotNull AuthoriseRequestValidator authoriseRequestValidator, @NotNull RequestJWTValidator requestJWTValidator, @NotNull JsonResponseErrorRenderer fallBack, @Nullable String documentationUri) {
        Intrinsics.checkNotNullParameter((Object)authoriseRequestValidator, (String)"authoriseRequestValidator");
        Intrinsics.checkNotNullParameter((Object)requestJWTValidator, (String)"requestJWTValidator");
        Intrinsics.checkNotNullParameter((Object)fallBack, (String)"fallBack");
        this.authoriseRequestValidator = authoriseRequestValidator;
        this.requestJWTValidator = requestJWTValidator;
        this.fallBack = fallBack;
        this.documentationUri = documentationUri;
    }

    public /* synthetic */ AuthoriseRequestErrorRender(AuthoriseRequestValidator authoriseRequestValidator, RequestJWTValidator requestJWTValidator, JsonResponseErrorRenderer jsonResponseErrorRenderer, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string = null;
        }
        this(authoriseRequestValidator, requestJWTValidator, jsonResponseErrorRenderer, string);
    }

    @NotNull
    public final Response errorFor(@NotNull Request request2, @NotNull OAuthError error) {
        Response response;
        ClientId clientId;
        Map requestObjectMap;
        Map map;
        Map map2;
        Boolean isRequestJwtValid;
        RequestJwtContainer requestJwt;
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        ClientId requestClientId = (ClientId)this.extractValueFromRequestOrNull(request2, AuthoriseRequestErrorRender::errorFor$lambda$0);
        RequestJwtContainer requestJwtContainer = requestJwt = (RequestJwtContainer)this.extractValueFromRequestOrNull(request2, AuthoriseRequestErrorRender::errorFor$lambda$1);
        if (requestJwtContainer != null) {
            RequestJwtContainer jwt = requestJwtContainer;
            boolean bl = false;
            ClientId clientId2 = requestClientId;
            if (clientId2 != null) {
                ClientId clientId3 = clientId2;
                boolean bl2 = false;
                v2 = this.requestJWTValidator.validate(clientId3, jwt) == null;
            } else {
                v2 = null;
            }
        } else {
            v2 = isRequestJwtValid = null;
        }
        if (requestJwt != null) {
            RequestJwtContainer jwt = requestJwt;
            boolean bl = false;
            Boolean bl3 = isRequestJwtValid;
            if (bl3 != null) {
                boolean isValidJwt = bl3;
                boolean bl4 = false;
                if (isValidJwt) {
                    Result result;
                    Result $this$mapFailure$iv = RequestObjectExtractor.INSTANCE.extractRequestJwtClaimsAsMap(jwt.getValue());
                    boolean $i$f$mapFailure = false;
                    Result $this$flatMapFailure$iv$iv = $this$mapFailure$iv;
                    boolean $i$f$flatMapFailure = false;
                    Result result2 = $this$flatMapFailure$iv$iv;
                    if (result2 instanceof Success) {
                        result = $this$flatMapFailure$iv$iv;
                    } else if (result2 instanceof Failure) {
                        Object reason$iv = ((Failure)$this$flatMapFailure$iv$iv).getReason();
                        boolean bl5 = false;
                        InvalidRequestObject it = (InvalidRequestObject)reason$iv;
                        boolean bl6 = false;
                        Map map3 = MapsKt.emptyMap();
                        result = (Result)new Failure((Object)map3);
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    map2 = (Map)ResultKt.get(result);
                } else {
                    map2 = null;
                }
            } else {
                map2 = null;
            }
        } else {
            map2 = null;
        }
        if ((map = (requestObjectMap = map2)) != null && (map = map.get("client_id")) != null) {
            Map id = map;
            boolean bl = false;
            clientId = new ClientId(id.toString());
        } else {
            clientId = null;
        }
        ClientId requestJwtClientId = clientId;
        Uri requestRedirectUri = (Uri)this.extractValue(request2, requestObjectMap, "redirect_uri", AuthoriseRequestErrorRender::errorFor$lambda$5, AuthoriseRequestErrorRender::errorFor$lambda$6);
        ResponseMode requestResponseMode2 = (ResponseMode)((Object)this.extractValue(request2, requestObjectMap, "response_mode", AuthoriseRequestErrorRender::errorFor$lambda$7, (Function1)new Function1<String, ResponseMode>((Object)ResponseMode.Companion){

            public final ResponseMode invoke(String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((ResponseMode.Companion)this.receiver).fromQueryParameterValue(p0);
            }
        }));
        ResponseType responseType2 = (ResponseType)((Object)this.extractValue(request2, requestObjectMap, "response_type", AuthoriseRequestErrorRender::errorFor$lambda$8, (Function1)new Function1<String, ResponseType>((Object)ResponseType.Companion){

            public final ResponseType invoke(String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((ResponseType.Companion)this.receiver).fromQueryParameterValue(p0);
            }
        }));
        if (responseType2 == null) {
            responseType2 = ResponseType.Code;
        }
        ResponseType requestResponseType2 = responseType2;
        State requestState = (State)this.extractValue(request2, requestObjectMap, "state", AuthoriseRequestErrorRender::errorFor$lambda$9, AuthoriseRequestErrorRender::errorFor$lambda$10);
        if (this.isUnsafeToRedirectBackToRedirectUri(isRequestJwtValid, requestClientId, requestJwtClientId, requestRedirectUri, request2)) {
            response = this.fallBack.response(error);
        } else {
            Uri uri = requestRedirectUri;
            Intrinsics.checkNotNull((Object)uri);
            response = ResponseRender.Companion.forAuthRequest(requestResponseMode2, requestResponseType2, uri).withState(requestState).addParameter("error", error.getRfcError().getRfcValue()).addParameter("error_description", error.getDescription()).withDocumentationUri(this.documentationUri).complete();
        }
        return response;
    }

    private final boolean isUnsafeToRedirectBackToRedirectUri(Boolean isRequestJwtValid, ClientId requestClientId, ClientId requestJwtClientId, Uri requestRedirectUri, Request request2) {
        return Intrinsics.areEqual((Object)isRequestJwtValid, (Object)false) || requestClientId == null || requestJwtClientId != null && !Intrinsics.areEqual((Object)requestClientId, (Object)requestJwtClientId) || requestRedirectUri == null || !this.authoriseRequestValidator.isValidClientAndRedirectUriInCaseOfError(request2, requestClientId, requestRedirectUri);
    }

    private final <T> T extractValue(Request request2, Map<?, ?> requestObject, String key, Function1<? super Request, ? extends T> requestCallback, Function1<? super String, ? extends T> requestObjectCallback) {
        Object requestJwtState;
        T requestState = this.extractValueFromRequestOrNull(request2, requestCallback);
        Map<?, ?> map = requestObject;
        if (map != null) {
            Map<?, ?> it = map;
            boolean bl = false;
            v1 = this.extractValueFromRequestObjectOrNull(key, it, requestObjectCallback);
        } else {
            v1 = requestJwtState = null;
        }
        if (requestJwtState != null && requestState != null && !Intrinsics.areEqual(requestState, requestJwtState)) {
            return null;
        }
        T t = requestState;
        if (t == null) {
            t = requestJwtState;
        }
        return t;
    }

    private final <T> T extractValueFromRequestOrNull(Request request2, Function1<? super Request, ? extends T> callback) {
        Object object;
        try {
            object = callback.invoke((Object)request2);
        }
        catch (LensFailure e) {
            object = null;
        }
        return (T)object;
    }

    private final <T> T extractValueFromRequestObjectOrNull(String key, Map<?, ?> request2, Function1<? super String, ? extends T> callback) {
        Object object;
        try {
            Object obj = request2.get(key);
            object = obj != null && (obj = obj.toString()) != null ? callback.invoke(obj) : null;
        }
        catch (IllegalArgumentException e) {
            object = null;
        }
        return (T)object;
    }

    private static final ClientId errorFor$lambda$0(Request it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (ClientId)OAuthServer.Companion.getClientIdQueryParameter().invoke((Object)it);
    }

    private static final RequestJwtContainer errorFor$lambda$1(Request it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (RequestJwtContainer)OAuthServer.Companion.getRequest().invoke((Object)it);
    }

    private static final Uri errorFor$lambda$5(Request it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Uri)OAuthServer.Companion.getRedirectUriQueryParameter().invoke((Object)it);
    }

    private static final Uri errorFor$lambda$6(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Uri.Companion.of(it);
    }

    private static final ResponseMode errorFor$lambda$7(Request it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (ResponseMode)((Object)OAuthServer.Companion.getResponseMode().invoke((Object)it));
    }

    private static final ResponseType errorFor$lambda$8(Request it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (ResponseType)((Object)OAuthServer.Companion.getResponseType().invoke((Object)it));
    }

    private static final State errorFor$lambda$9(Request it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (State)OAuthServer.Companion.getState().invoke((Object)it);
    }

    private static final State errorFor$lambda$10(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new State(it);
    }
}

