/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.security.oauth.format;

import com.squareup.moshi.FromJson;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.ToJson;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.http4k.core.Uri;
import org.http4k.format.WriteKt;
import org.http4k.security.ResponseType;
import org.http4k.security.oauth.metadata.AuthMethod;
import org.http4k.security.oauth.metadata.ServerMetadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0002H\u0017J\u0010\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\u00020\fH\u0002\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010\u0011\u001a\u0004\u0018\u00010\u000f*\u00020\fH\u0002\u00a8\u0006\u0012"}, d2={"Lorg/http4k/security/oauth/format/ServerMetadataMoshiAdapter;", "Lcom/squareup/moshi/JsonAdapter;", "Lorg/http4k/security/oauth/metadata/ServerMetadata;", "<init>", "()V", "toJson", "", "writer", "Lcom/squareup/moshi/JsonWriter;", "value", "fromJson", "reader", "Lcom/squareup/moshi/JsonReader;", "readStringArray", "", "", "(Lcom/squareup/moshi/JsonReader;)[Ljava/lang/String;", "nextStringOrNull", "http4k-security-oauth"})
@SourceDebugExtension(value={"SMAP\nServerMetadataMoshiAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServerMetadataMoshiAdapter.kt\norg/http4k/security/oauth/format/ServerMetadataMoshiAdapter\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,127:1\n11228#2:128\n11563#2,3:129\n11228#2:132\n11563#2,3:133\n11228#2:136\n11563#2,3:137\n1#3:140\n37#4:141\n36#4,3:142\n1563#5:145\n1634#5,3:146\n1563#5:149\n1634#5,3:150\n1563#5:153\n1634#5,3:154\n*S KotlinDebug\n*F\n+ 1 ServerMetadataMoshiAdapter.kt\norg/http4k/security/oauth/format/ServerMetadataMoshiAdapter\n*L\n69#1:128\n69#1:129,3\n75#1:132\n75#1:133,3\n79#1:136\n79#1:137,3\n116#1:141\n116#1:142,3\n27#1:145\n27#1:146,3\n32#1:149\n32#1:150,3\n34#1:153\n34#1:154,3\n*E\n"})
public final class ServerMetadataMoshiAdapter
extends JsonAdapter<ServerMetadata> {
    @NotNull
    public static final ServerMetadataMoshiAdapter INSTANCE = new ServerMetadataMoshiAdapter();

    private ServerMetadataMoshiAdapter() {
    }

    @ToJson
    public void toJson(@NotNull JsonWriter writer, @Nullable ServerMetadata value) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        if (value == null) {
            writer.nullValue();
        } else {
            JsonWriter $this$toJson_u24lambda_u245 = writer;
            boolean bl = false;
            WriteKt.obj((JsonWriter)$this$toJson_u24lambda_u245, (Object)value, arg_0 -> ServerMetadataMoshiAdapter.toJson$lambda$5$lambda$4($this$toJson_u24lambda_u245, arg_0));
        }
    }

    @FromJson
    @NotNull
    public ServerMetadata fromJson(@NotNull JsonReader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        JsonReader $this$fromJson_u24lambda_u2416 = reader;
        boolean bl = false;
        $this$fromJson_u24lambda_u2416.beginObject();
        String issuer = null;
        Uri authorizationEndpoint = null;
        Uri tokenEndpoint = null;
        List tokenEndpointAuthMethods = CollectionsKt.emptyList();
        List tokenEndpointAuthSigningAlgs = CollectionsKt.emptyList();
        List responseTypesSupported = CollectionsKt.emptyList();
        List scopesSupported = CollectionsKt.emptyList();
        List uiLocalesSupported = null;
        Uri userinfoEndpoint = null;
        Uri jwksUri = null;
        Uri registrationEndpoint = null;
        Uri serviceDocumentation = null;
        String signedMetadata = null;
        block30: while ($this$fromJson_u24lambda_u2416.hasNext()) {
            block58: {
                String string = $this$fromJson_u24lambda_u2416.nextName();
                if (string == null) break block58;
                int n = -1;
                switch (string.hashCode()) {
                    case 2009754730: {
                        if (string.equals("response_types_supported")) {
                            n = 1;
                        }
                        break;
                    }
                    case 1544715506: {
                        if (string.equals("signed_metadata")) {
                            n = 2;
                        }
                        break;
                    }
                    case -2047579043: {
                        if (string.equals("ui_locales_supported")) {
                            n = 3;
                        }
                        break;
                    }
                    case -289185522: {
                        if (string.equals("scopes_supported")) {
                            n = 4;
                        }
                        break;
                    }
                    case -1179159879: {
                        if (string.equals("issuer")) {
                            n = 5;
                        }
                        break;
                    }
                    case 2140464795: {
                        if (string.equals("authorization_endpoint")) {
                            n = 6;
                        }
                        break;
                    }
                    case 146023451: {
                        if (string.equals("userinfo_endpoint")) {
                            n = 7;
                        }
                        break;
                    }
                    case 826219184: {
                        if (string.equals("service_documentation")) {
                            n = 8;
                        }
                        break;
                    }
                    case 22038049: {
                        if (string.equals("token_endpoint_auth_signing_alg_values_supported")) {
                            n = 9;
                        }
                        break;
                    }
                    case 1465527714: {
                        if (string.equals("jwks_uri")) {
                            n = 10;
                        }
                        break;
                    }
                    case 632677678: {
                        if (string.equals("token_endpoint_auth_methods_supported")) {
                            n = 11;
                        }
                        break;
                    }
                    case -1734334885: {
                        if (string.equals("registration_endpoint")) {
                            n = 12;
                        }
                        break;
                    }
                    case 495238427: {
                        if (string.equals("token_endpoint")) {
                            n = 13;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 5: {
                        issuer = $this$fromJson_u24lambda_u2416.nextString();
                        continue block30;
                    }
                    case 6: {
                        String string2 = $this$fromJson_u24lambda_u2416.nextString();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"nextString(...)");
                        authorizationEndpoint = Uri.Companion.of(string2);
                        continue block30;
                    }
                    case 13: {
                        String string3 = $this$fromJson_u24lambda_u2416.nextString();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"nextString(...)");
                        tokenEndpoint = Uri.Companion.of(string3);
                        continue block30;
                    }
                    case 11: {
                        String it;
                        Collection collection;
                        String item$iv$iv;
                        int n2;
                        String[] $this$mapTo$iv$iv;
                        String[] $this$map$iv = INSTANCE.readStringArray($this$fromJson_u24lambda_u2416);
                        boolean $i$f$map = false;
                        String[] stringArray = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                        boolean $i$f$mapTo = false;
                        int n3 = $this$mapTo$iv$iv.length;
                        for (n2 = 0; n2 < n3; ++n2) {
                            String string4 = item$iv$iv = $this$mapTo$iv$iv[n2];
                            collection = destination$iv$iv;
                            boolean bl2 = false;
                            collection.add(AuthMethod.valueOf(it));
                        }
                        tokenEndpointAuthMethods = (List)destination$iv$iv;
                        continue block30;
                    }
                    case 9: {
                        tokenEndpointAuthSigningAlgs = ArraysKt.toList((Object[])INSTANCE.readStringArray($this$fromJson_u24lambda_u2416));
                        continue block30;
                    }
                    case 1: {
                        String it;
                        Collection collection;
                        String item$iv$iv;
                        int n2;
                        String[] $this$map$iv = INSTANCE.readStringArray($this$fromJson_u24lambda_u2416);
                        boolean $i$f$map = false;
                        String[] $this$mapTo$iv$iv = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                        boolean $i$f$mapTo = false;
                        int n3 = $this$mapTo$iv$iv.length;
                        for (n2 = 0; n2 < n3; ++n2) {
                            it = item$iv$iv = $this$mapTo$iv$iv[n2];
                            collection = destination$iv$iv;
                            boolean bl3 = false;
                            collection.add(ResponseType.valueOf(it));
                        }
                        responseTypesSupported = (List)destination$iv$iv;
                        continue block30;
                    }
                    case 4: {
                        scopesSupported = ArraysKt.toList((Object[])INSTANCE.readStringArray($this$fromJson_u24lambda_u2416));
                        continue block30;
                    }
                    case 3: {
                        String it;
                        Collection collection;
                        String item$iv$iv;
                        int n2;
                        String[] $this$map$iv = INSTANCE.readStringArray($this$fromJson_u24lambda_u2416);
                        boolean $i$f$map = false;
                        String[] $this$mapTo$iv$iv = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                        boolean $i$f$mapTo = false;
                        int n3 = $this$mapTo$iv$iv.length;
                        for (n2 = 0; n2 < n3; ++n2) {
                            it = item$iv$iv = $this$mapTo$iv$iv[n2];
                            collection = destination$iv$iv;
                            boolean bl4 = false;
                            collection.add(Locale.forLanguageTag(it));
                        }
                        uiLocalesSupported = (List)destination$iv$iv;
                        continue block30;
                    }
                    case 7: {
                        Uri uri;
                        String it;
                        if (INSTANCE.nextStringOrNull($this$fromJson_u24lambda_u2416) != null) {
                            boolean bl5 = false;
                            uri = Uri.Companion.of(it);
                        } else {
                            uri = null;
                        }
                        userinfoEndpoint = uri;
                        continue block30;
                    }
                    case 10: {
                        Uri uri;
                        String it;
                        if (INSTANCE.nextStringOrNull($this$fromJson_u24lambda_u2416) != null) {
                            boolean bl6 = false;
                            uri = Uri.Companion.of(it);
                        } else {
                            uri = null;
                        }
                        jwksUri = uri;
                        continue block30;
                    }
                    case 12: {
                        Uri uri;
                        String it;
                        if (INSTANCE.nextStringOrNull($this$fromJson_u24lambda_u2416) != null) {
                            boolean bl7 = false;
                            uri = Uri.Companion.of(it);
                        } else {
                            uri = null;
                        }
                        registrationEndpoint = uri;
                        continue block30;
                    }
                    case 8: {
                        Uri uri;
                        String it;
                        if (INSTANCE.nextStringOrNull($this$fromJson_u24lambda_u2416) != null) {
                            boolean bl8 = false;
                            uri = Uri.Companion.of(it);
                        } else {
                            uri = null;
                        }
                        serviceDocumentation = uri;
                        continue block30;
                    }
                    case 2: {
                        signedMetadata = INSTANCE.nextStringOrNull($this$fromJson_u24lambda_u2416);
                        continue block30;
                    }
                }
            }
            $this$fromJson_u24lambda_u2416.skipValue();
        }
        $this$fromJson_u24lambda_u2416.endObject();
        String string = issuer;
        if (string == null) {
            boolean $i$a$-requireNotNull-ServerMetadataMoshiAdapter$fromJson$1$112 = false;
            String $i$a$-requireNotNull-ServerMetadataMoshiAdapter$fromJson$1$112 = "issuer is required";
            throw new IllegalArgumentException($i$a$-requireNotNull-ServerMetadataMoshiAdapter$fromJson$1$112.toString());
        }
        Uri uri = authorizationEndpoint;
        if (uri == null) {
            String string5 = string;
            boolean $i$a$-requireNotNull-ServerMetadataMoshiAdapter$fromJson$1$122 = false;
            String string6 = string5;
            String $i$a$-requireNotNull-ServerMetadataMoshiAdapter$fromJson$1$122 = "authorization_endpoint is required";
            throw new IllegalArgumentException($i$a$-requireNotNull-ServerMetadataMoshiAdapter$fromJson$1$122.toString());
        }
        Uri uri2 = tokenEndpoint;
        if (uri2 == null) {
            Uri uri3 = uri;
            String string7 = string;
            boolean bl9 = false;
            String string8 = "token_endpoint is required";
            String string9 = string7;
            Uri uri4 = uri3;
            String string10 = string8;
            throw new IllegalArgumentException(string10.toString());
        }
        String string11 = signedMetadata;
        Uri uri5 = serviceDocumentation;
        Uri uri6 = registrationEndpoint;
        Uri uri7 = jwksUri;
        Uri uri8 = userinfoEndpoint;
        List list = uiLocalesSupported;
        List list2 = scopesSupported;
        List list3 = responseTypesSupported;
        List list4 = tokenEndpointAuthSigningAlgs;
        List list5 = tokenEndpointAuthMethods;
        Uri uri9 = uri2;
        Uri uri10 = uri;
        String string12 = string;
        return new ServerMetadata(string12, uri10, uri9, list5, list4, list3, list2, list, uri8, uri7, uri6, uri5, string11);
    }

    private final String[] readStringArray(JsonReader $this$readStringArray) {
        List result = new ArrayList();
        $this$readStringArray.beginArray();
        while ($this$readStringArray.hasNext()) {
            String string = $this$readStringArray.nextString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nextString(...)");
            result.add(string);
        }
        $this$readStringArray.endArray();
        Collection $this$toTypedArray$iv = result;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }

    private final String nextStringOrNull(JsonReader $this$nextStringOrNull) {
        String string;
        if ($this$nextStringOrNull.peek() == JsonReader.Token.NULL) {
            $this$nextStringOrNull.nextNull();
            string = null;
        } else {
            string = $this$nextStringOrNull.nextString();
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit toJson$lambda$5$lambda$4(JsonWriter $this_with, ServerMetadata $this$obj) {
        ResponseType it;
        Collection<String> collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$this$obj, (String)"$this$obj");
        WriteKt.string((JsonWriter)$this_with, (String)"issuer", (String)$this$obj.getIssuer());
        WriteKt.string((JsonWriter)$this_with, (String)"authorization_endpoint", (String)$this$obj.getAuthorization_endpoint().toString());
        WriteKt.string((JsonWriter)$this_with, (String)"token_endpoint", (String)$this$obj.getToken_endpoint().toString());
        Iterable iterable = $this$obj.getToken_endpoint_auth_methods_supported();
        String string = "token_endpoint_auth_methods_supported";
        JsonWriter jsonWriter = $this_with;
        boolean $i$f$map = false;
        void var4_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            AuthMethod authMethod = (AuthMethod)((Object)item$iv$iv);
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.name());
        }
        collection = (List)destination$iv$iv;
        WriteKt.list((JsonWriter)jsonWriter, (String)string, (List)collection);
        WriteKt.list((JsonWriter)$this_with, (String)"token_endpoint_auth_signing_alg_values_supported", $this$obj.getToken_endpoint_auth_signing_alg_values_supported());
        $this$map$iv = $this$obj.getResponse_types_supported();
        string = "response_types_supported";
        jsonWriter = $this_with;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ResponseType)((Object)item$iv$iv);
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.name());
        }
        collection = (List)destination$iv$iv;
        WriteKt.list((JsonWriter)jsonWriter, (String)string, collection);
        WriteKt.list((JsonWriter)$this_with, (String)"scopes_supported", $this$obj.getScopes_supported());
        List<Locale> list = $this$obj.getUi_locales_supported();
        if (list != null) {
            Collection<String> collection2;
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            List<Locale> list2;
            List<Locale> it2 = list2 = list;
            boolean bl = false;
            Iterable $i$f$mapTo2 = it2;
            String string2 = "ui_locales_supported";
            JsonWriter jsonWriter2 = $this_with;
            boolean $i$f$map2 = false;
            void bl2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it3;
                Locale locale = (Locale)item$iv$iv;
                collection2 = destination$iv$iv2;
                boolean bl3 = false;
                collection2.add(it3.toLanguageTag());
            }
            collection2 = (List)destination$iv$iv2;
            WriteKt.list((JsonWriter)jsonWriter2, (String)string2, (List)collection2);
        }
        Uri uri = $this$obj.getUserinfo_endpoint();
        WriteKt.string((JsonWriter)$this_with, (String)"userinfo_endpoint", (String)(uri != null ? uri.toString() : null));
        Uri uri2 = $this$obj.getJwks_uri();
        WriteKt.string((JsonWriter)$this_with, (String)"jwks_uri", (String)(uri2 != null ? uri2.toString() : null));
        Uri uri3 = $this$obj.getRegistration_endpoint();
        WriteKt.string((JsonWriter)$this_with, (String)"registration_endpoint", (String)(uri3 != null ? uri3.toString() : null));
        Uri uri4 = $this$obj.getService_documentation();
        WriteKt.string((JsonWriter)$this_with, (String)"service_documentation", (String)(uri4 != null ? uri4.toString() : null));
        WriteKt.string((JsonWriter)$this_with, (String)"signed_metadata", (String)$this$obj.getSigned_metadata());
        return Unit.INSTANCE;
    }
}

