/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.security.oauth.client;

import dev.forkhandles.result4k.Failure;
import dev.forkhandles.result4k.Result;
import dev.forkhandles.result4k.Success;
import java.time.Clock;
import java.time.Duration;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.http4k.core.Credentials;
import org.http4k.core.Filter;
import org.http4k.core.Method;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.http4k.core.Uri;
import org.http4k.filter.ClientFilters;
import org.http4k.security.OAuthProviderConfig;
import org.http4k.security.oauth.client.ClientFilterExtensionsKt;
import org.http4k.security.oauth.format.OAuthMoshi;
import org.http4k.security.oauth.metadata.ServerMetadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000^\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001ao\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062%\u0010\u0007\u001a!\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\r0\bj\u0002`\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\b\b\u0002\u0010\u0014\u001a\u00020\u00012\b\b\u0002\u0010\u0015\u001a\u00020\u0016\u001aC\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\u0019\u0012\b\u0012\u00060\u001aj\u0002`\u001b0\u0018*!\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\r0\bj\u0002`\u000e2\u0006\u0010\u001c\u001a\u00020\u0004H\u0002\u00a8\u0006\u001d"}, d2={"AutoDiscoveryOAuthToken", "Lorg/http4k/core/Filter;", "Lorg/http4k/filter/ClientFilters;", "serverUri", "Lorg/http4k/core/Uri;", "credentials", "Lorg/http4k/core/Credentials;", "backend", "Lkotlin/Function1;", "Lorg/http4k/core/Request;", "Lkotlin/ParameterName;", "name", "request", "Lorg/http4k/core/Response;", "Lorg/http4k/core/HttpHandler;", "clock", "Ljava/time/Clock;", "scopes", "", "", "oAuthFlowFilter", "gracePeriod", "Ljava/time/Duration;", "discoverEndpoints", "Ldev/forkhandles/result4k/Result;", "Lorg/http4k/security/oauth/metadata/ServerMetadata;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "baseUri", "http4k-security-oauth"})
public final class AutoDiscoveryOAuthTokenKt {
    @NotNull
    public static final Filter AutoDiscoveryOAuthToken(@NotNull ClientFilters $this$AutoDiscoveryOAuthToken, @NotNull Uri serverUri, @NotNull Credentials credentials, @NotNull Function1<? super Request, ? extends Response> backend, @NotNull Clock clock, @NotNull List<String> scopes, @NotNull Filter oAuthFlowFilter, @NotNull Duration gracePeriod) {
        Filter filter;
        Intrinsics.checkNotNullParameter((Object)$this$AutoDiscoveryOAuthToken, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)serverUri, (String)"serverUri");
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        Intrinsics.checkNotNullParameter(backend, (String)"backend");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter(scopes, (String)"scopes");
        Intrinsics.checkNotNullParameter((Object)oAuthFlowFilter, (String)"oAuthFlowFilter");
        Intrinsics.checkNotNullParameter((Object)gracePeriod, (String)"gracePeriod");
        Result<ServerMetadata, Exception> discoveryResult = AutoDiscoveryOAuthTokenKt.discoverEndpoints(backend, serverUri);
        if (discoveryResult instanceof Success) {
            ServerMetadata metadata = (ServerMetadata)((Success)discoveryResult).getValue();
            OAuthProviderConfig config = new OAuthProviderConfig(serverUri, metadata.getAuthorization_endpoint().getPath(), metadata.getToken_endpoint().getPath(), credentials, null, null, null, 112, null);
            filter = ClientFilterExtensionsKt.RefreshingOAuthToken(ClientFilters.INSTANCE, config, backend, gracePeriod, clock, scopes, oAuthFlowFilter);
        } else if (discoveryResult instanceof Failure) {
            ClientFilters clientFilters = ClientFilters.INSTANCE;
            OAuthProviderConfig oAuthProviderConfig = new OAuthProviderConfig(serverUri, "/authorize", "/token", credentials, null, null, null, 112, null);
            filter = ClientFilterExtensionsKt.RefreshingOAuthToken(clientFilters, oAuthProviderConfig, backend, gracePeriod, clock, scopes, oAuthFlowFilter);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return filter;
    }

    public static /* synthetic */ Filter AutoDiscoveryOAuthToken$default(ClientFilters clientFilters, Uri uri, Credentials credentials, Function1 function1, Clock clock, List list, Filter filter, Duration duration, int n, Object object) {
        if ((n & 8) != 0) {
            clock = Clock.systemUTC();
        }
        if ((n & 0x10) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x20) != 0) {
            filter = ClientFilterExtensionsKt.OAuthClientCredentials(ClientFilters.INSTANCE, credentials, (List<String>)list);
        }
        if ((n & 0x40) != 0) {
            duration = Duration.ofSeconds(10L);
        }
        return AutoDiscoveryOAuthTokenKt.AutoDiscoveryOAuthToken(clientFilters, uri, credentials, (Function1<? super Request, ? extends Response>)function1, clock, list, filter, duration);
    }

    private static final Result<ServerMetadata, Exception> discoverEndpoints(Function1<? super Request, ? extends Response> $this$discoverEndpoints, Uri baseUri) {
        Response response = (Response)$this$discoverEndpoints.invoke((Object)Request.Companion.create$default((Request.Companion)Request.Companion, (Method)Method.GET, (Uri)baseUri.path("/.well-known/oauth-authorization-server"), null, (int)4, null));
        return response.getStatus().getSuccessful() ? (Result)new Success(OAuthMoshi.INSTANCE.asA(response.bodyString(), Reflection.getOrCreateKotlinClass(ServerMetadata.class))) : (Result)new Failure((Object)new Exception("Failed to discover OAuth endpoints"));
    }
}

