/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.security.oauth.server.accesstoken;

import dev.forkhandles.result4k.Failure;
import dev.forkhandles.result4k.Result;
import dev.forkhandles.result4k.Success;
import java.time.Clock;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.http4k.core.Body;
import org.http4k.core.HttpMessage;
import org.http4k.core.Request;
import org.http4k.lens.BiDiBodyLens;
import org.http4k.lens.BiDiLens;
import org.http4k.lens.FormField;
import org.http4k.lens.Lens;
import org.http4k.lens.LensBuilder;
import org.http4k.lens.Validator;
import org.http4k.lens.WebForm;
import org.http4k.lens.WebFormKt;
import org.http4k.security.AccessTokenDetails;
import org.http4k.security.oauth.server.AccessTokenError;
import org.http4k.security.oauth.server.AccessTokens;
import org.http4k.security.oauth.server.AuthorizationCodes;
import org.http4k.security.oauth.server.ClientId;
import org.http4k.security.oauth.server.IdTokens;
import org.http4k.security.oauth.server.OAuthServerKt;
import org.http4k.security.oauth.server.TokenRequest;
import org.http4k.security.oauth.server.UnsupportedGrantType;
import org.http4k.security.oauth.server.accesstoken.AccessTokenGenerator;
import org.http4k.security.oauth.server.accesstoken.AccessTokenRequestAuthentication;
import org.http4k.security.oauth.server.accesstoken.AuthorizationCodeAccessTokenGenerator;
import org.http4k.security.oauth.server.accesstoken.ClientCredentialsAccessTokenGenerator;
import org.http4k.security.oauth.server.accesstoken.GrantType;
import org.http4k.security.oauth.server.accesstoken.GrantTypesConfiguration;
import org.http4k.security.oauth.server.refreshtoken.RefreshTokenAccessTokenGenerator;
import org.http4k.security.oauth.server.refreshtoken.RefreshTokens;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 $2\u00020\u0001:\u0001$B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u00162\u0006\u0010\u0019\u001a\u00020\u001aJ(\u0010\u001b\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001c\u0012\u0004\u0012\u00020\u001f0\u00162\u0006\u0010 \u001a\u00020!H\u0002J\u001c\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u001f0\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\f\u0010#\u001a\u00020\u001d*\u00020!H\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/http4k/security/oauth/server/accesstoken/GenerateAccessTokenForGrantType;", "", "authorizationCodes", "Lorg/http4k/security/oauth/server/AuthorizationCodes;", "accessTokens", "Lorg/http4k/security/oauth/server/AccessTokens;", "clock", "Ljava/time/Clock;", "idTokens", "Lorg/http4k/security/oauth/server/IdTokens;", "refreshTokens", "Lorg/http4k/security/oauth/server/refreshtoken/RefreshTokens;", "grantTypes", "Lorg/http4k/security/oauth/server/accesstoken/GrantTypesConfiguration;", "<init>", "(Lorg/http4k/security/oauth/server/AuthorizationCodes;Lorg/http4k/security/oauth/server/AccessTokens;Ljava/time/Clock;Lorg/http4k/security/oauth/server/IdTokens;Lorg/http4k/security/oauth/server/refreshtoken/RefreshTokens;Lorg/http4k/security/oauth/server/accesstoken/GrantTypesConfiguration;)V", "authorizationCode", "Lorg/http4k/security/oauth/server/accesstoken/AuthorizationCodeAccessTokenGenerator;", "clientCredentials", "Lorg/http4k/security/oauth/server/accesstoken/ClientCredentialsAccessTokenGenerator;", "Lorg/http4k/security/oauth/server/refreshtoken/RefreshTokenAccessTokenGenerator;", "generate", "Ldev/forkhandles/result4k/Result;", "Lorg/http4k/security/AccessTokenDetails;", "Lorg/http4k/security/oauth/server/AccessTokenError;", "request", "Lorg/http4k/core/Request;", "resolveGrantTypeFromConfiguration", "Lkotlin/Pair;", "Lorg/http4k/security/oauth/server/accesstoken/AccessTokenGenerator;", "Lorg/http4k/security/oauth/server/accesstoken/AccessTokenRequestAuthentication;", "Lorg/http4k/security/oauth/server/UnsupportedGrantType;", "grantType", "Lorg/http4k/security/oauth/server/accesstoken/GrantType;", "resolveGrantTypeFromRequest", "generator", "Companion", "http4k-security-oauth"})
@SourceDebugExtension(value={"SMAP\nGenerateAccessTokenForGrantType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenerateAccessTokenForGrantType.kt\norg/http4k/security/oauth/server/accesstoken/GenerateAccessTokenForGrantType\n+ 2 result.kt\ndev/forkhandles/result4k/ResultKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,77:1\n122#2,4:78\n48#2,2:82\n48#2,4:84\n50#2,2:88\n1#3:90\n*S KotlinDebug\n*F\n+ 1 GenerateAccessTokenForGrantType.kt\norg/http4k/security/oauth/server/accesstoken/GenerateAccessTokenForGrantType\n*L\n41#1:78,4\n43#1:82,2\n45#1:84,4\n43#1:88,2\n*E\n"})
public final class GenerateAccessTokenForGrantType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GrantTypesConfiguration grantTypes;
    @NotNull
    private final AuthorizationCodeAccessTokenGenerator authorizationCode;
    @NotNull
    private final ClientCredentialsAccessTokenGenerator clientCredentials;
    @NotNull
    private final RefreshTokenAccessTokenGenerator refreshTokens;
    @NotNull
    private static final BiDiLens<WebForm, String> grantType = (BiDiLens)LensBuilder.DefaultImpls.required$default((LensBuilder)((LensBuilder)FormField.INSTANCE), (String)"grant_type", null, null, (int)6, null);
    @NotNull
    private static final BiDiBodyLens<WebForm> grantTypeForm;

    public GenerateAccessTokenForGrantType(@NotNull AuthorizationCodes authorizationCodes, @NotNull AccessTokens accessTokens, @NotNull Clock clock, @NotNull IdTokens idTokens, @NotNull RefreshTokens refreshTokens, @NotNull GrantTypesConfiguration grantTypes) {
        Intrinsics.checkNotNullParameter((Object)authorizationCodes, (String)"authorizationCodes");
        Intrinsics.checkNotNullParameter((Object)accessTokens, (String)"accessTokens");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)idTokens, (String)"idTokens");
        Intrinsics.checkNotNullParameter((Object)refreshTokens, (String)"refreshTokens");
        Intrinsics.checkNotNullParameter((Object)grantTypes, (String)"grantTypes");
        this.grantTypes = grantTypes;
        this.authorizationCode = new AuthorizationCodeAccessTokenGenerator(authorizationCodes, accessTokens, clock, idTokens);
        this.clientCredentials = new ClientCredentialsAccessTokenGenerator(accessTokens);
        this.refreshTokens = new RefreshTokenAccessTokenGenerator(refreshTokens);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final Result<AccessTokenDetails, AccessTokenError> generate(@NotNull Request request2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Result<GrantType, UnsupportedGrantType> $this$onFailure$iv = this.resolveGrantTypeFromRequest(request2);
        boolean $i$f$onFailure = false;
        Result<GrantType, UnsupportedGrantType> result = $this$onFailure$iv;
        if (!(result instanceof Success)) {
            if (!(result instanceof Failure)) throw new NoWhenBranchMatchedException();
            Failure it = (Failure)$this$onFailure$iv;
            return (Result)it;
        }
        GrantType grantType = (GrantType)((Object)((Success)$this$onFailure$iv).getValue());
        Result<Pair<AccessTokenGenerator, AccessTokenRequestAuthentication>, UnsupportedGrantType> $this$flatMap$iv = this.resolveGrantTypeFromConfiguration(grantType);
        boolean $i$f$flatMap = false;
        result = $this$flatMap$iv;
        if (result instanceof Success) {
            void $this$flatMap$iv2;
            Pair pair = (Pair)((Success)$this$flatMap$iv).getValue();
            boolean bl = false;
            AccessTokenGenerator generator = (AccessTokenGenerator)pair.component1();
            AccessTokenRequestAuthentication authenticator = (AccessTokenRequestAuthentication)pair.component2();
            Result<Triple<Request, ClientId, TokenRequest>, AccessTokenError> result2 = authenticator.validateCredentials(request2, OAuthServerKt.tokenRequest(request2, grantType));
            boolean $i$f$flatMap2 = false;
            void var12_14 = $this$flatMap$iv2;
            if (var12_14 instanceof Success) {
                Triple triple = (Triple)((Success)$this$flatMap$iv2).getValue();
                boolean bl2 = false;
                Request request3 = (Request)triple.component1();
                ClientId clientId = (ClientId)triple.component2();
                TokenRequest tokenRequest = (TokenRequest)triple.component3();
                object = generator.generate(request3, clientId, tokenRequest);
                return object;
            } else {
                if (!(var12_14 instanceof Failure)) throw new NoWhenBranchMatchedException();
                object = $this$flatMap$iv2;
            }
            return object;
        } else {
            if (!(result instanceof Failure)) throw new NoWhenBranchMatchedException();
            object = $this$flatMap$iv;
        }
        return object;
    }

    private final Result<Pair<AccessTokenGenerator, AccessTokenRequestAuthentication>, UnsupportedGrantType> resolveGrantTypeFromConfiguration(GrantType grantType) {
        Result result;
        AccessTokenRequestAuthentication accessTokenRequestAuthentication = this.grantTypes.getSupportedGrantTypes().get((Object)grantType);
        if (accessTokenRequestAuthentication != null) {
            AccessTokenRequestAuthentication it = accessTokenRequestAuthentication;
            boolean bl = false;
            result = (Result)new Success((Object)TuplesKt.to((Object)this.generator(grantType), (Object)it));
        } else {
            result = (Result)new Failure((Object)new UnsupportedGrantType(grantType.getRfcValue()));
        }
        return result;
    }

    private final Result<GrantType, UnsupportedGrantType> resolveGrantTypeFromRequest(Request request2) {
        WebForm form = (WebForm)grantTypeForm.invoke((HttpMessage)request2);
        boolean bl = false;
        String grantType = (String)GenerateAccessTokenForGrantType.grantType.invoke((Object)form);
        return Intrinsics.areEqual((Object)grantType, (Object)GrantType.AuthorizationCode.getRfcValue()) ? (Result)new Success((Object)GrantType.AuthorizationCode) : (Intrinsics.areEqual((Object)grantType, (Object)GrantType.ClientCredentials.getRfcValue()) ? (Result)new Success((Object)GrantType.ClientCredentials) : (Intrinsics.areEqual((Object)grantType, (Object)GrantType.RefreshToken.getRfcValue()) ? (Result)new Success((Object)GrantType.RefreshToken) : (Result)new Failure((Object)new UnsupportedGrantType(grantType))));
    }

    private final AccessTokenGenerator generator(GrantType $this$generator) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$generator.ordinal()]) {
            case 1 -> this.authorizationCode;
            case 2 -> this.clientCredentials;
            case 3 -> this.refreshTokens;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    static {
        Lens[] lensArray = new Lens[]{grantType};
        grantTypeForm = WebFormKt.webForm((Body.Companion)Body.Companion, (Validator)Validator.Strict, (Lens[])lensArray).toLens();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/http4k/security/oauth/server/accesstoken/GenerateAccessTokenForGrantType$Companion;", "", "<init>", "()V", "grantType", "Lorg/http4k/lens/BiDiLens;", "Lorg/http4k/lens/WebForm;", "", "getGrantType", "()Lorg/http4k/lens/BiDiLens;", "grantTypeForm", "Lorg/http4k/lens/BiDiBodyLens;", "getGrantTypeForm", "()Lorg/http4k/lens/BiDiBodyLens;", "http4k-security-oauth"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BiDiLens<WebForm, String> getGrantType() {
            return grantType;
        }

        @NotNull
        public final BiDiBodyLens<WebForm> getGrantTypeForm() {
            return grantTypeForm;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GrantType.values().length];
            try {
                nArray[GrantType.AuthorizationCode.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GrantType.ClientCredentials.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GrantType.RefreshToken.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

