/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.security;

import dev.forkhandles.result4k.Failure;
import dev.forkhandles.result4k.Result;
import dev.forkhandles.result4k.ResultKt;
import dev.forkhandles.result4k.Success;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.http4k.core.Status;
import org.http4k.security.AccessTokenDetails;
import org.http4k.security.AccessTokenFetcher;
import org.http4k.security.CrossSiteRequestForgeryToken;
import org.http4k.security.FragmentParametersKt;
import org.http4k.security.Nonce;
import org.http4k.security.OAuthCallbackError;
import org.http4k.security.OAuthPersistence;
import org.http4k.security.PkceChallengeAndVerifier;
import org.http4k.security.oauth.server.AuthorizationCode;
import org.http4k.security.openid.IdToken;
import org.http4k.security.openid.IdTokenConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002!\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\u0004\u0012\u00020\u00060\u0001j\u0002`\u0007:\u0001'B\u001f\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0011\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0002H\u0096\u0002J\u0018\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012*\u00020\u0002H\u0002J\u0018\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00140\u0012*\u00020\u0002H\u0002J.\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00180\u00122\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00022\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J&\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u001d0\u00122\u0006\u0010\u0019\u001a\u00020\u00132\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J\u001c\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020!0\u00122\u0006\u0010\u0019\u001a\u00020\u0013H\u0002J\u001c\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020!0\u00122\u0006\u0010#\u001a\u00020\"H\u0002J\u0010\u0010$\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0002H\u0002J\u0016\u0010%\u001a\u0004\u0018\u00010&*\u00020\u00022\u0006\u0010\u0004\u001a\u00020&H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/http4k/security/OAuthCallback;", "Lkotlin/Function1;", "Lorg/http4k/core/Request;", "Lkotlin/ParameterName;", "name", "request", "Lorg/http4k/core/Response;", "Lorg/http4k/core/HttpHandler;", "oAuthPersistence", "Lorg/http4k/security/OAuthPersistence;", "idTokenConsumer", "Lorg/http4k/security/openid/IdTokenConsumer;", "accessTokenFetcher", "Lorg/http4k/security/AccessTokenFetcher;", "<init>", "(Lorg/http4k/security/OAuthPersistence;Lorg/http4k/security/openid/IdTokenConsumer;Lorg/http4k/security/AccessTokenFetcher;)V", "invoke", "callbackParameters", "Ldev/forkhandles/result4k/Result;", "Lorg/http4k/security/OAuthCallback$CallbackParameters;", "Lorg/http4k/security/OAuthCallbackError$AuthorizationCodeMissing;", "authorizationCode", "Lorg/http4k/security/oauth/server/AuthorizationCode;", "validateCsrf", "Lorg/http4k/security/OAuthCallbackError$InvalidCsrfToken;", "parameters", "persistedToken", "Lorg/http4k/security/CrossSiteRequestForgeryToken;", "validateNonce", "Lorg/http4k/security/OAuthCallbackError$InvalidNonce;", "storedNonce", "Lorg/http4k/security/Nonce;", "consumeIdToken", "Lorg/http4k/security/OAuthCallbackError$InvalidIdToken;", "Lorg/http4k/security/AccessTokenDetails;", "tokenDetails", "redirectionResponse", "queryOrFragmentParameter", "", "CallbackParameters", "http4k-security-oauth"})
@SourceDebugExtension(value={"SMAP\nOAuthCallback.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OAuthCallback.kt\norg/http4k/security/OAuthCallback\n+ 2 result.kt\ndev/forkhandles/result4k/ResultKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,104:1\n48#2,4:105\n48#2,4:109\n48#2,4:113\n42#2,10:117\n48#2,4:127\n48#2,4:131\n42#2,10:135\n57#2:145\n77#2,4:146\n42#2,8:150\n50#2,2:159\n42#2,10:161\n42#2,10:171\n1#3:158\n*S KotlinDebug\n*F\n+ 1 OAuthCallback.kt\norg/http4k/security/OAuthCallback\n*L\n29#1:105,4\n30#1:109,4\n31#1:113,4\n32#1:117,10\n33#1:127,4\n34#1:131,4\n35#1:135,10\n43#1:145\n43#1:146,4\n47#1:150,8\n47#1:159,2\n77#1:161,10\n81#1:171,10\n*E\n"})
public final class OAuthCallback
implements Function1<Request, Response> {
    @NotNull
    private final OAuthPersistence oAuthPersistence;
    @NotNull
    private final IdTokenConsumer idTokenConsumer;
    @NotNull
    private final AccessTokenFetcher accessTokenFetcher;

    public OAuthCallback(@NotNull OAuthPersistence oAuthPersistence, @NotNull IdTokenConsumer idTokenConsumer, @NotNull AccessTokenFetcher accessTokenFetcher) {
        Intrinsics.checkNotNullParameter((Object)oAuthPersistence, (String)"oAuthPersistence");
        Intrinsics.checkNotNullParameter((Object)idTokenConsumer, (String)"idTokenConsumer");
        Intrinsics.checkNotNullParameter((Object)accessTokenFetcher, (String)"accessTokenFetcher");
        this.oAuthPersistence = oAuthPersistence;
        this.idTokenConsumer = idTokenConsumer;
        this.accessTokenFetcher = accessTokenFetcher;
    }

    @NotNull
    public Response invoke(@NotNull Request request2) {
        Result result;
        Result result2;
        Result result3;
        Object object;
        Result result4;
        Object value$iv;
        Object object2;
        Object object3;
        Object object4;
        CallbackParameters parameters;
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Result $this$flatMap$iv = this.callbackParameters(request2);
        boolean $i$f$flatMap = false;
        Result result5 = $this$flatMap$iv;
        if (result5 instanceof Success) {
            parameters = (CallbackParameters)((Success)$this$flatMap$iv).getValue();
            boolean bl = false;
            object4 = this.validateCsrf(parameters, request2, this.oAuthPersistence.retrieveCsrf(request2));
        } else if (result5 instanceof Failure) {
            object4 = $this$flatMap$iv;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        $this$flatMap$iv = object4;
        $i$f$flatMap = false;
        result5 = $this$flatMap$iv;
        if (result5 instanceof Success) {
            parameters = (CallbackParameters)((Success)$this$flatMap$iv).getValue();
            boolean bl = false;
            object3 = this.validateNonce(parameters, this.oAuthPersistence.retrieveNonce(request2));
        } else if (result5 instanceof Failure) {
            object3 = $this$flatMap$iv;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        $this$flatMap$iv = object3;
        $i$f$flatMap = false;
        result5 = $this$flatMap$iv;
        if (result5 instanceof Success) {
            parameters = (CallbackParameters)((Success)$this$flatMap$iv).getValue();
            boolean bl = false;
            object2 = this.consumeIdToken(parameters);
        } else if (result5 instanceof Failure) {
            object2 = $this$flatMap$iv;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Result $this$map$iv = object2;
        boolean $i$f$map = false;
        Result $this$flatMap$iv$iv = $this$map$iv;
        boolean $i$f$flatMap22 = false;
        Result bl = $this$flatMap$iv$iv;
        if (bl instanceof Success) {
            value$iv = ((Success)$this$flatMap$iv$iv).getValue();
            boolean bl2 = false;
            CallbackParameters parameters2 = (CallbackParameters)value$iv;
            boolean bl3 = false;
            Pair pair = TuplesKt.to((Object)parameters2, (Object)this.oAuthPersistence.retrievePkce(request2));
            result4 = (Result)new Success((Object)pair);
        } else if (bl instanceof Failure) {
            result4 = $this$flatMap$iv$iv;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        $this$flatMap$iv = result4;
        $i$f$flatMap = false;
        $this$flatMap$iv$iv = $this$flatMap$iv;
        if ($this$flatMap$iv$iv instanceof Success) {
            Pair $i$f$flatMap22 = (Pair)((Success)$this$flatMap$iv).getValue();
            boolean bl4 = false;
            CallbackParameters parameters3 = (CallbackParameters)$i$f$flatMap22.component1();
            PkceChallengeAndVerifier pkce = (PkceChallengeAndVerifier)$i$f$flatMap22.component2();
            PkceChallengeAndVerifier pkceChallengeAndVerifier = pkce;
            object = this.accessTokenFetcher.fetch(parameters3.getCode().getValue(), pkceChallengeAndVerifier != null ? pkceChallengeAndVerifier.getVerifier() : null);
        } else if ($this$flatMap$iv$iv instanceof Failure) {
            object = $this$flatMap$iv;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        $this$flatMap$iv = object;
        $i$f$flatMap = false;
        $this$flatMap$iv$iv = $this$flatMap$iv;
        if ($this$flatMap$iv$iv instanceof Success) {
            AccessTokenDetails tokenDetails = (AccessTokenDetails)((Success)$this$flatMap$iv).getValue();
            boolean bl5 = false;
            result3 = this.consumeIdToken(tokenDetails);
        } else if ($this$flatMap$iv$iv instanceof Failure) {
            result3 = $this$flatMap$iv;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        $this$map$iv = result3;
        $i$f$map = false;
        $this$flatMap$iv$iv = $this$map$iv;
        boolean $i$f$flatMap3 = false;
        Result result6 = $this$flatMap$iv$iv;
        if (result6 instanceof Success) {
            value$iv = ((Success)$this$flatMap$iv$iv).getValue();
            boolean bl6 = false;
            AccessTokenDetails tokenDetails = (AccessTokenDetails)value$iv;
            boolean bl7 = false;
            Response response = this.oAuthPersistence.assignToken(request2, this.redirectionResponse(request2), tokenDetails.getAccessToken(), tokenDetails.getIdToken());
            result2 = (Result)new Success((Object)response);
        } else if (result6 instanceof Failure) {
            result2 = $this$flatMap$iv$iv;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Result $this$mapFailure$iv = result2;
        boolean $i$f$mapFailure = false;
        Result $this$flatMapFailure$iv$iv = $this$mapFailure$iv;
        boolean $i$f$flatMapFailure = false;
        result6 = $this$flatMapFailure$iv$iv;
        if (result6 instanceof Success) {
            result = $this$flatMapFailure$iv$iv;
        } else if (result6 instanceof Failure) {
            Object reason$iv = ((Failure)$this$flatMapFailure$iv$iv).getReason();
            boolean bl8 = false;
            OAuthCallbackError it = (OAuthCallbackError)reason$iv;
            boolean bl9 = false;
            Response response = this.oAuthPersistence.authFailureResponse(it);
            result = (Result)new Failure((Object)response);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return (Response)ResultKt.get(result);
    }

    private final Result<CallbackParameters, OAuthCallbackError.AuthorizationCodeMissing> callbackParameters(Request $this$callbackParameters) {
        Result result;
        Result $this$map$iv = this.authorizationCode($this$callbackParameters);
        boolean $i$f$map = false;
        Result $this$flatMap$iv$iv = $this$map$iv;
        boolean $i$f$flatMap = false;
        Result result2 = $this$flatMap$iv$iv;
        if (result2 instanceof Success) {
            IdToken idToken2;
            CrossSiteRequestForgeryToken crossSiteRequestForgeryToken;
            String p0;
            AuthorizationCode authorizationCode;
            Object value$iv = ((Success)$this$flatMap$iv$iv).getValue();
            boolean bl = false;
            AuthorizationCode it = (AuthorizationCode)value$iv;
            boolean bl2 = false;
            AuthorizationCode authorizationCode2 = it;
            String string = this.queryOrFragmentParameter($this$callbackParameters, "state");
            if (string != null) {
                String string2 = string;
                authorizationCode = authorizationCode2;
                boolean bl3 = false;
                crossSiteRequestForgeryToken = new CrossSiteRequestForgeryToken(p0);
                authorizationCode2 = authorizationCode;
            } else {
                crossSiteRequestForgeryToken = null;
            }
            String string3 = this.queryOrFragmentParameter($this$callbackParameters, "id_token");
            if (string3 != null) {
                p0 = string3;
                CrossSiteRequestForgeryToken crossSiteRequestForgeryToken2 = crossSiteRequestForgeryToken;
                authorizationCode = authorizationCode2;
                boolean bl4 = false;
                IdToken idToken3 = new IdToken(p0);
                authorizationCode2 = authorizationCode;
                crossSiteRequestForgeryToken = crossSiteRequestForgeryToken2;
                idToken2 = idToken3;
            } else {
                idToken2 = null;
            }
            IdToken idToken4 = idToken2;
            CrossSiteRequestForgeryToken crossSiteRequestForgeryToken3 = crossSiteRequestForgeryToken;
            AuthorizationCode authorizationCode3 = authorizationCode2;
            CallbackParameters callbackParameters = new CallbackParameters(authorizationCode3, crossSiteRequestForgeryToken3, idToken4);
            result = (Result)new Success((Object)callbackParameters);
        } else if (result2 instanceof Failure) {
            result = $this$flatMap$iv$iv;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return result;
    }

    private final Result<AuthorizationCode, OAuthCallbackError.AuthorizationCodeMissing> authorizationCode(Request $this$authorizationCode) {
        Result result;
        String string = this.queryOrFragmentParameter($this$authorizationCode, "code");
        if (string != null) {
            String p0 = string;
            boolean bl = false;
            AuthorizationCode p02 = new AuthorizationCode(p0);
            boolean bl2 = false;
            result = (Result)new Success((Object)p02);
        } else {
            result = (Result)new Failure((Object)new OAuthCallbackError.AuthorizationCodeMissing($this$authorizationCode.getUri()));
        }
        return result;
    }

    private final Result<CallbackParameters, OAuthCallbackError.InvalidCsrfToken> validateCsrf(CallbackParameters parameters, Request request2, CrossSiteRequestForgeryToken persistedToken) {
        Result result;
        CrossSiteRequestForgeryToken crossSiteRequestForgeryToken;
        String string = this.queryOrFragmentParameter(request2, "state");
        if (string != null) {
            String p0 = string;
            boolean bl = false;
            crossSiteRequestForgeryToken = new CrossSiteRequestForgeryToken(p0);
        } else {
            crossSiteRequestForgeryToken = null;
        }
        CrossSiteRequestForgeryToken it = crossSiteRequestForgeryToken;
        boolean bl = false;
        if (Intrinsics.areEqual((Object)it, (Object)persistedToken)) {
            result = (Result)new Success((Object)parameters);
        } else {
            CrossSiteRequestForgeryToken crossSiteRequestForgeryToken2 = persistedToken;
            CrossSiteRequestForgeryToken crossSiteRequestForgeryToken3 = it;
            result = (Result)new Failure((Object)new OAuthCallbackError.InvalidCsrfToken(crossSiteRequestForgeryToken2 != null ? crossSiteRequestForgeryToken2.getValue() : null, crossSiteRequestForgeryToken3 != null ? crossSiteRequestForgeryToken3.getValue() : null));
        }
        return result;
    }

    private final Result<CallbackParameters, OAuthCallbackError.InvalidNonce> validateNonce(CallbackParameters parameters, Nonce storedNonce) {
        Result result;
        IdToken idToken2 = parameters.getIdToken();
        if (idToken2 != null) {
            IdToken idToken3 = idToken2;
            boolean bl = false;
            Nonce received = this.idTokenConsumer.nonceFromIdToken(idToken3);
            if (Intrinsics.areEqual((Object)received, (Object)storedNonce)) {
                result = (Result)new Success((Object)parameters);
            } else {
                Nonce nonce2 = storedNonce;
                Nonce nonce3 = received;
                result = (Result)new Failure((Object)new OAuthCallbackError.InvalidNonce(nonce2 != null ? nonce2.getValue() : null, nonce3 != null ? nonce3.getValue() : null));
            }
        } else {
            result = (Result)new Success((Object)parameters);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Result<CallbackParameters, OAuthCallbackError.InvalidIdToken> consumeIdToken(CallbackParameters parameters) {
        Result result;
        Result result2 = parameters.getIdToken();
        if (result2 != null) {
            Result result3 = result2;
            IdTokenConsumer idTokenConsumer = this.idTokenConsumer;
            Result p0 = result3;
            boolean bl = false;
            Result result4 = idTokenConsumer.consumeFromAuthorizationResponse((IdToken)p0);
            result2 = result4;
            if (result4 != null) {
                Result $this$map$iv = result2;
                boolean $i$f$map = false;
                Result $this$flatMap$iv$iv = $this$map$iv;
                boolean $i$f$flatMap = false;
                Result result5 = $this$flatMap$iv$iv;
                if (result5 instanceof Success) {
                    Object value$iv = ((Success)$this$flatMap$iv$iv).getValue();
                    boolean bl2 = false;
                    Unit it = (Unit)value$iv;
                    boolean bl3 = false;
                    CallbackParameters callbackParameters = parameters;
                    result = (Result)new Success((Object)callbackParameters);
                    return result;
                }
                if (!(result5 instanceof Failure)) throw new NoWhenBranchMatchedException();
                result = $this$flatMap$iv$iv;
                return result;
            }
        }
        result = (Result)new Success((Object)parameters);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Result<AccessTokenDetails, OAuthCallbackError.InvalidIdToken> consumeIdToken(AccessTokenDetails tokenDetails) {
        Result result;
        Result result2 = tokenDetails.getIdToken();
        if (result2 != null) {
            Result result3 = result2;
            IdTokenConsumer idTokenConsumer = this.idTokenConsumer;
            Result p0 = result3;
            boolean bl = false;
            Result result4 = idTokenConsumer.consumeFromAccessTokenResponse((IdToken)p0);
            result2 = result4;
            if (result4 != null) {
                Result $this$map$iv = result2;
                boolean $i$f$map = false;
                Result $this$flatMap$iv$iv = $this$map$iv;
                boolean $i$f$flatMap = false;
                Result result5 = $this$flatMap$iv$iv;
                if (result5 instanceof Success) {
                    Object value$iv = ((Success)$this$flatMap$iv$iv).getValue();
                    boolean bl2 = false;
                    Unit it = (Unit)value$iv;
                    boolean bl3 = false;
                    AccessTokenDetails accessTokenDetails = tokenDetails;
                    result = (Result)new Success((Object)accessTokenDetails);
                    return result;
                }
                if (!(result5 instanceof Failure)) throw new NoWhenBranchMatchedException();
                result = $this$flatMap$iv$iv;
                return result;
            }
        }
        result = (Result)new Success((Object)tokenDetails);
        return result;
    }

    private final Response redirectionResponse(Request request2) {
        Response response = Response.Companion.create$default((Response.Companion)Response.Companion, (Status)Status.TEMPORARY_REDIRECT, null, (int)2, null);
        Object object = this.oAuthPersistence.retrieveOriginalUri(request2);
        if (object == null || (object = object.toString()) == null) {
            object = "/";
        }
        return response.header("Location", (String)object);
    }

    private final String queryOrFragmentParameter(Request $this$queryOrFragmentParameter, String name) {
        String string = $this$queryOrFragmentParameter.query(name);
        if (string == null) {
            string = FragmentParametersKt.fragmentParameter($this$queryOrFragmentParameter, name);
        }
        return string;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J+\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lorg/http4k/security/OAuthCallback$CallbackParameters;", "", "code", "Lorg/http4k/security/oauth/server/AuthorizationCode;", "state", "Lorg/http4k/security/CrossSiteRequestForgeryToken;", "idToken", "Lorg/http4k/security/openid/IdToken;", "<init>", "(Lorg/http4k/security/oauth/server/AuthorizationCode;Lorg/http4k/security/CrossSiteRequestForgeryToken;Lorg/http4k/security/openid/IdToken;)V", "getCode", "()Lorg/http4k/security/oauth/server/AuthorizationCode;", "getState", "()Lorg/http4k/security/CrossSiteRequestForgeryToken;", "getIdToken", "()Lorg/http4k/security/openid/IdToken;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "http4k-security-oauth"})
    private static final class CallbackParameters {
        @NotNull
        private final AuthorizationCode code;
        @Nullable
        private final CrossSiteRequestForgeryToken state;
        @Nullable
        private final IdToken idToken;

        public CallbackParameters(@NotNull AuthorizationCode code, @Nullable CrossSiteRequestForgeryToken state2, @Nullable IdToken idToken2) {
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            this.code = code;
            this.state = state2;
            this.idToken = idToken2;
        }

        @NotNull
        public final AuthorizationCode getCode() {
            return this.code;
        }

        @Nullable
        public final CrossSiteRequestForgeryToken getState() {
            return this.state;
        }

        @Nullable
        public final IdToken getIdToken() {
            return this.idToken;
        }

        @NotNull
        public final AuthorizationCode component1() {
            return this.code;
        }

        @Nullable
        public final CrossSiteRequestForgeryToken component2() {
            return this.state;
        }

        @Nullable
        public final IdToken component3() {
            return this.idToken;
        }

        @NotNull
        public final CallbackParameters copy(@NotNull AuthorizationCode code, @Nullable CrossSiteRequestForgeryToken state2, @Nullable IdToken idToken2) {
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            return new CallbackParameters(code, state2, idToken2);
        }

        public static /* synthetic */ CallbackParameters copy$default(CallbackParameters callbackParameters, AuthorizationCode authorizationCode, CrossSiteRequestForgeryToken crossSiteRequestForgeryToken, IdToken idToken2, int n, Object object) {
            if ((n & 1) != 0) {
                authorizationCode = callbackParameters.code;
            }
            if ((n & 2) != 0) {
                crossSiteRequestForgeryToken = callbackParameters.state;
            }
            if ((n & 4) != 0) {
                idToken2 = callbackParameters.idToken;
            }
            return callbackParameters.copy(authorizationCode, crossSiteRequestForgeryToken, idToken2);
        }

        @NotNull
        public String toString() {
            return "CallbackParameters(code=" + this.code + ", state=" + this.state + ", idToken=" + this.idToken + ")";
        }

        public int hashCode() {
            int result = this.code.hashCode();
            result = result * 31 + (this.state == null ? 0 : this.state.hashCode());
            result = result * 31 + (this.idToken == null ? 0 : this.idToken.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CallbackParameters)) {
                return false;
            }
            CallbackParameters callbackParameters = (CallbackParameters)other;
            if (!Intrinsics.areEqual((Object)this.code, (Object)callbackParameters.code)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.state, (Object)callbackParameters.state)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.idToken, (Object)callbackParameters.idToken);
        }
    }
}

