/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.server;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpInetConnection;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.io.EmptyInputStream;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;
import org.http4k.core.Filter;
import org.http4k.core.HeadersKt;
import org.http4k.core.Http4kKt;
import org.http4k.core.Method;
import org.http4k.core.Request;
import org.http4k.core.RequestSource;
import org.http4k.core.Response;
import org.http4k.filter.ServerFilters;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0016\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u0002`\u0006\u00a2\u0006\u0002\u0010\u0007J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0014\u0010\u0014\u001a\u00020\u0004*\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0014\u0010\u0015\u001a\u00020\r*\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J3\u0010\u0016\u001a\u001e\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0018j\u0002`\u00190\u0017j\u0002`\u001a*\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002\u00a2\u0006\u0002\u0010\u001dR\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/http4k/server/Http4kApache4RequestHandler;", "Lorg/apache/http/protocol/HttpRequestHandler;", "handler", "Lkotlin/Function1;", "Lorg/http4k/core/Request;", "Lorg/http4k/core/Response;", "Lorg/http4k/core/HttpHandler;", "(Lkotlin/jvm/functions/Function1;)V", "headersThatApacheInterceptorSets", "", "", "safeHandler", "handle", "", "request", "Lorg/apache/http/HttpRequest;", "response", "Lorg/apache/http/HttpResponse;", "context", "Lorg/apache/http/protocol/HttpContext;", "asHttp4kRequest", "into", "toHttp4kHeaders", "", "Lkotlin/Pair;", "Lorg/http4k/core/Parameter;", "Lorg/http4k/core/Headers;", "", "Lorg/apache/http/Header;", "([Lorg/apache/http/Header;)Ljava/util/List;", "http4k-server-apache4"})
public final class Http4kApache4RequestHandler
implements HttpRequestHandler {
    @NotNull
    private final Function1<Request, Response> safeHandler;
    @NotNull
    private final Set<String> headersThatApacheInterceptorSets;

    public Http4kApache4RequestHandler(@NotNull Function1<? super Request, ? extends Response> handler) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        this.safeHandler = Http4kKt.then((Filter)ServerFilters.CatchAll.invoke$default((ServerFilters.CatchAll)ServerFilters.CatchAll.INSTANCE, null, (int)1, null), handler);
        Object[] objectArray = new String[]{"Transfer-Encoding", "Content-Length"};
        this.headersThatApacheInterceptorSets = SetsKt.setOf((Object[])objectArray);
    }

    public void handle(@NotNull HttpRequest request, @NotNull HttpResponse response, @NotNull HttpContext context) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.into((Response)this.safeHandler.invoke((Object)this.asHttp4kRequest(request, context)), response);
    }

    private final Request asHttp4kRequest(HttpRequest $this$asHttp4kRequest, HttpContext context) {
        Request request;
        Object object = context.getAttribute("http.connection");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.apache.http.HttpInetConnection");
        }
        HttpInetConnection connection = (HttpInetConnection)object;
        Object object2 = $this$asHttp4kRequest.getRequestLine().getMethod();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"requestLine.method");
        Method method = Method.valueOf((String)object2);
        object2 = $this$asHttp4kRequest.getRequestLine().getUri();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"requestLine.uri");
        Request request2 = Request.Companion.create$default((Request.Companion)Request.Companion, (Method)method, (String)object2, null, (int)4, null);
        object2 = $this$asHttp4kRequest.getAllHeaders();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"allHeaders");
        Request it = request2.headers(this.toHttp4kHeaders((Header[])object2));
        boolean bl = false;
        if ($this$asHttp4kRequest instanceof HttpEntityEnclosingRequest) {
            InputStream inputStream = ((HttpEntityEnclosingRequest)$this$asHttp4kRequest).getEntity().getContent();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"entity.content");
            Header header = $this$asHttp4kRequest.getFirstHeader("Content-Length");
            request = it.body(inputStream, HeadersKt.safeLong((String)(header == null ? null : header.getValue())));
        } else {
            EmptyInputStream emptyInputStream = EmptyInputStream.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)emptyInputStream, (String)"INSTANCE");
            request = it.body((InputStream)emptyInputStream, Long.valueOf(0L));
        }
        object2 = connection.getRemoteAddress().getHostAddress();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"connection.remoteAddress.hostAddress");
        return request.source(new RequestSource((String)object2, Integer.valueOf(connection.getRemotePort()), null, 4, null));
    }

    /*
     * WARNING - void declaration
     */
    private final void into(Response $this$into, HttpResponse response) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        HttpResponse $this$into_u24lambda_u2d3 = response;
        boolean bl = false;
        $this$into_u24lambda_u2d3.setStatusCode($this$into.getStatus().getCode());
        $this$into_u24lambda_u2d3.setReasonPhrase($this$into.getStatus().getDescription());
        Iterable $this$filter$iv = $this$into.getHeaders();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Pair it = (Pair)element$iv$iv;
            boolean bl2 = false;
            if (!(!this.headersThatApacheInterceptorSets.contains(it.getFirst()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair $dstr$key$value = (Pair)element$iv;
            boolean bl3 = false;
            String key = (String)$dstr$key$value.component1();
            String value = (String)$dstr$key$value.component2();
            $this$into_u24lambda_u2d3.addHeader(key, value);
        }
        Long l = $this$into.getBody().getLength();
        $this$into_u24lambda_u2d3.setEntity((HttpEntity)new InputStreamEntity($this$into.getBody().getStream(), l == null ? -1L : l));
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<String, String>> toHttp4kHeaders(Header[] $this$toHttp4kHeaders) {
        void $this$mapTo$iv$iv;
        Header[] $this$map$iv = $this$toHttp4kHeaders;
        boolean $i$f$map = false;
        Header[] headerArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            void var11_11 = item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)it.getName(), (Object)it.getValue()));
        }
        return (List)destination$iv$iv;
    }
}

