/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.server;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpInetConnection;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.io.EmptyInputStream;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;
import org.http4k.core.Filter;
import org.http4k.core.HeadersKt;
import org.http4k.core.Http4kKt;
import org.http4k.core.Method;
import org.http4k.core.Request;
import org.http4k.core.RequestSource;
import org.http4k.core.Response;
import org.http4k.core.Status;
import org.http4k.filter.ServerFilters;
import org.http4k.server.Http4kServerKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B,\u0012%\u0010\u0002\u001a!\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\b0\u0003j\u0002`\t\u00a2\u0006\u0002\u0010\nJ \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u0004*\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0014\u0010\u0017\u001a\u00020\u0010*\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J3\u0010\u0018\u001a\u001e\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\r0\u001aj\u0002`\u001b0\u0019j\u0002`\u001c*\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0002\u00a2\u0006\u0002\u0010\u001fR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R-\u0010\u000e\u001a!\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\b0\u0003j\u0002`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/http4k/server/Http4kApache4RequestHandler;", "Lorg/apache/http/protocol/HttpRequestHandler;", "handler", "Lkotlin/Function1;", "Lorg/http4k/core/Request;", "Lkotlin/ParameterName;", "name", "request", "Lorg/http4k/core/Response;", "Lorg/http4k/core/HttpHandler;", "(Lkotlin/jvm/functions/Function1;)V", "headersThatApacheInterceptorSets", "", "", "safeHandler", "handle", "", "Lorg/apache/http/HttpRequest;", "response", "Lorg/apache/http/HttpResponse;", "context", "Lorg/apache/http/protocol/HttpContext;", "asHttp4kRequest", "into", "toHttp4kHeaders", "", "Lkotlin/Pair;", "Lorg/http4k/core/Parameter;", "Lorg/http4k/core/Headers;", "", "Lorg/apache/http/Header;", "([Lorg/apache/http/Header;)Ljava/util/List;", "http4k-server-apache4"})
@SourceDebugExtension(value={"SMAP\nApache4Server.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Apache4Server.kt\norg/http4k/server/Http4kApache4RequestHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,115:1\n766#2:116\n857#2,2:117\n1855#2,2:119\n11065#3:121\n11400#3,3:122\n*S KotlinDebug\n*F\n+ 1 Apache4Server.kt\norg/http4k/server/Http4kApache4RequestHandler\n*L\n64#1:116\n64#1:117,2\n65#1:119,2\n70#1:121\n70#1:122,3\n*E\n"})
public final class Http4kApache4RequestHandler
implements HttpRequestHandler {
    @NotNull
    private final Function1<Request, Response> safeHandler;
    @NotNull
    private final Set<String> headersThatApacheInterceptorSets;

    public Http4kApache4RequestHandler(@NotNull Function1<? super Request, ? extends Response> handler) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        this.safeHandler = Http4kKt.then((Filter)ServerFilters.CatchAll.invoke$default((ServerFilters.CatchAll)ServerFilters.CatchAll.INSTANCE, null, (int)1, null), handler);
        Object[] objectArray = new String[]{"Transfer-Encoding", "Content-Length"};
        this.headersThatApacheInterceptorSets = SetsKt.setOf((Object[])objectArray);
    }

    public void handle(@NotNull HttpRequest request, @NotNull HttpResponse response, @NotNull HttpContext context) {
        Request request2;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Request request3 = this.asHttp4kRequest(request, context);
        if (request3 == null || (request3 = (Response)this.safeHandler.invoke((Object)(request2 = request3))) == null) {
            request3 = Response.Companion.create$default((Response.Companion)Response.Companion, (Status)Status.NOT_IMPLEMENTED, null, (int)2, null);
        }
        this.into((Response)request3, response);
    }

    private final Request asHttp4kRequest(HttpRequest $this$asHttp4kRequest, HttpContext context) {
        Request request;
        Object object = context.getAttribute("http.connection");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.apache.http.HttpInetConnection");
        HttpInetConnection connection = (HttpInetConnection)object;
        String string = $this$asHttp4kRequest.getRequestLine().getMethod();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMethod(...)");
        Method method = Http4kServerKt.supportedOrNull((Method.Companion)Method.Companion, (String)string);
        if (method != null) {
            Request request2;
            Method it = method;
            boolean bl = false;
            String string2 = $this$asHttp4kRequest.getRequestLine().getUri();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getUri(...)");
            Request request3 = Request.Companion.create$default((Request.Companion)Request.Companion, (Method)it, (String)string2, null, (int)4, null);
            Header[] headerArray = $this$asHttp4kRequest.getAllHeaders();
            Intrinsics.checkNotNullExpressionValue((Object)headerArray, (String)"getAllHeaders(...)");
            Request it2 = request3.headers(this.toHttp4kHeaders(headerArray));
            boolean bl2 = false;
            if ($this$asHttp4kRequest instanceof HttpEntityEnclosingRequest) {
                InputStream inputStream = ((HttpEntityEnclosingRequest)$this$asHttp4kRequest).getEntity().getContent();
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getContent(...)");
                Header header = $this$asHttp4kRequest.getFirstHeader("Content-Length");
                request2 = it2.body(inputStream, HeadersKt.safeLong((String)(header != null ? header.getValue() : null)));
            } else {
                EmptyInputStream emptyInputStream = EmptyInputStream.INSTANCE;
                Intrinsics.checkNotNullExpressionValue((Object)emptyInputStream, (String)"INSTANCE");
                request2 = it2.body((InputStream)emptyInputStream, Long.valueOf(0L));
            }
            String string3 = connection.getRemoteAddress().getHostAddress();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getHostAddress(...)");
            request = request2.source(new RequestSource(string3, Integer.valueOf(connection.getRemotePort()), null, 4, null));
        } else {
            request = null;
        }
        return request;
    }

    /*
     * WARNING - void declaration
     */
    private final void into(Response $this$into, HttpResponse response) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        HttpResponse $this$into_u24lambda_u244 = response;
        boolean bl = false;
        $this$into_u24lambda_u244.setStatusCode($this$into.getStatus().getCode());
        $this$into_u24lambda_u244.setReasonPhrase($this$into.getStatus().getDescription());
        Iterable $this$filter$iv = $this$into.getHeaders();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Pair it = (Pair)element$iv$iv;
            boolean bl2 = false;
            if (!(!this.headersThatApacheInterceptorSets.contains(it.getFirst()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl3 = false;
            String key = (String)pair.component1();
            String value = (String)pair.component2();
            $this$into_u24lambda_u244.addHeader(key, value);
        }
        Long l = $this$into.getBody().getLength();
        $this$into_u24lambda_u244.setEntity((HttpEntity)new InputStreamEntity($this$into.getBody().getStream(), l != null ? l : -1L));
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<String, String>> toHttp4kHeaders(Header[] $this$toHttp4kHeaders) {
        void $this$mapTo$iv$iv;
        Header[] $this$map$iv = $this$toHttp4kHeaders;
        boolean $i$f$map = false;
        Header[] headerArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var10_10 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)it.getName(), (Object)it.getValue()));
        }
        return (List)destination$iv$iv;
    }
}

