/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.server;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.thread.Scheduler;
import org.http4k.core.ContentType;
import org.http4k.core.Status;
import org.http4k.server.Jetty11EventStreamEmitter;
import org.http4k.servlet.jakarta.Http4kJakartaServletAdapterKt;
import org.http4k.sse.SseResponse;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B'\u0012\u0016\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u0002`\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ(\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/http4k/server/Jetty11EventStreamHandler;", "Lorg/eclipse/jetty/server/handler/HandlerWrapper;", "sse", "Lkotlin/Function1;", "Lorg/http4k/core/Request;", "Lorg/http4k/sse/SseResponse;", "Lorg/http4k/sse/SseHandler;", "heartBeatDuration", "Ljava/time/Duration;", "(Lkotlin/jvm/functions/Function1;Ljava/time/Duration;)V", "handle", "", "target", "", "baseRequest", "Lorg/eclipse/jetty/server/Request;", "request", "Ljakarta/servlet/http/HttpServletRequest;", "response", "Ljakarta/servlet/http/HttpServletResponse;", "Companion", "http4k-server-jetty11"})
@SourceDebugExtension(value={"SMAP\nJetty11EventStreamHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Jetty11EventStreamHandler.kt\norg/http4k/server/Jetty11EventStreamHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,74:1\n1#2:75\n*E\n"})
public final class Jetty11EventStreamHandler
extends HandlerWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<org.http4k.core.Request, SseResponse> sse;
    @NotNull
    private final Duration heartBeatDuration;

    public Jetty11EventStreamHandler(@NotNull Function1<? super org.http4k.core.Request, SseResponse> sse, @NotNull Duration heartBeatDuration) {
        Intrinsics.checkNotNullParameter(sse, (String)"sse");
        Intrinsics.checkNotNullParameter((Object)heartBeatDuration, (String)"heartBeatDuration");
        this.sse = sse;
        this.heartBeatDuration = heartBeatDuration;
    }

    public /* synthetic */ Jetty11EventStreamHandler(Function1 function1, Duration duration, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            Duration duration2 = Duration.ofSeconds(15L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
            duration = duration2;
        }
        this((Function1<? super org.http4k.core.Request, SseResponse>)function1, duration);
    }

    public void handle(@NotNull String target, @NotNull Request baseRequest, @NotNull HttpServletRequest request, @NotNull HttpServletResponse response) {
        org.http4k.core.Request connectRequest;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)baseRequest, (String)"baseRequest");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        if (!baseRequest.isHandled() && Jetty11EventStreamHandler.Companion.isEventStream(request) && (connectRequest = Http4kJakartaServletAdapterKt.asHttp4kRequest((HttpServletRequest)request)) != null) {
            SseResponse sseResponse = (SseResponse)this.sse.invoke((Object)connectRequest);
            Status status = sseResponse.component1();
            List headers = sseResponse.component2();
            Function1 consumer = sseResponse.component3();
            Jetty11EventStreamHandler.Companion.writeEventStreamResponse(response, status, headers);
            AsyncContext async = Jetty11EventStreamHandler.Companion.startAsyncWithNoTimeout(request);
            ServletOutputStream output = async.getResponse().getOutputStream();
            Scheduler scheduler = baseRequest.getHttpChannel().getConnector().getScheduler();
            Server server = baseRequest.getHttpChannel().getConnector().getServer();
            Intrinsics.checkNotNull((Object)output);
            OutputStream outputStream = (OutputStream)output;
            Intrinsics.checkNotNull((Object)scheduler);
            Jetty11EventStreamEmitter jetty11EventStreamEmitter = new Jetty11EventStreamEmitter(connectRequest, outputStream, this.heartBeatDuration, scheduler, (Function1<? super Jetty11EventStreamEmitter, Unit>)((Function1)new Function1<Jetty11EventStreamEmitter, Unit>(async, server){
                final /* synthetic */ AsyncContext $async;
                final /* synthetic */ Server $server;
                {
                    this.$async = $async;
                    this.$server = $server;
                    super(1);
                }

                public final void invoke(@NotNull Jetty11EventStreamEmitter it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.$async.complete();
                    this.$server.removeEventListener((EventListener)((Object)it));
                }
            }));
            EventListener p0 = (EventListener)((Object)jetty11EventStreamEmitter);
            boolean bl = false;
            server.addEventListener(p0);
            Jetty11EventStreamEmitter emitter2 = jetty11EventStreamEmitter;
            consumer.invoke((Object)emitter2);
            baseRequest.setHandled(true);
        }
        if (!baseRequest.isHandled()) {
            super.handle(target, baseRequest, request, response);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0005H\u0002J\u0014\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007*\u00020\u0005H\u0002J8\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\"\u0010\u000e\u001a\u001e\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010j\u0002`\u00120\u000fj\u0002`\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Lorg/http4k/server/Jetty11EventStreamHandler$Companion;", "", "()V", "isEventStream", "", "Ljakarta/servlet/http/HttpServletRequest;", "startAsyncWithNoTimeout", "Ljakarta/servlet/AsyncContext;", "kotlin.jvm.PlatformType", "writeEventStreamResponse", "", "Ljakarta/servlet/http/HttpServletResponse;", "newStatus", "Lorg/http4k/core/Status;", "headers", "", "Lkotlin/Pair;", "", "Lorg/http4k/core/Parameter;", "Lorg/http4k/core/Headers;", "http4k-server-jetty11"})
    @SourceDebugExtension(value={"SMAP\nJetty11EventStreamHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Jetty11EventStreamHandler.kt\norg/http4k/server/Jetty11EventStreamHandler$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,74:1\n1747#2,3:75\n1855#2,2:78\n*S KotlinDebug\n*F\n+ 1 Jetty11EventStreamHandler.kt\norg/http4k/server/Jetty11EventStreamHandler$Companion\n*L\n52#1:75,3\n62#1:78,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isEventStream(HttpServletRequest $this$isEventStream) {
            String it;
            if (!Intrinsics.areEqual((Object)$this$isEventStream.getMethod(), (Object)"GET")) return false;
            Enumeration enumeration = $this$isEventStream.getHeaders("Accept");
            Intrinsics.checkNotNullExpressionValue((Object)enumeration, (String)"getHeaders(...)");
            ArrayList arrayList = Collections.list(enumeration);
            Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
            Iterable $this$any$iv = arrayList;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator = $this$any$iv.iterator();
            do {
                if (!iterator.hasNext()) return false;
                Object element$iv = iterator.next();
                it = (String)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
            } while (!StringsKt.contains$default((CharSequence)it, (CharSequence)ContentType.Companion.getTEXT_EVENT_STREAM().getValue(), (boolean)false, (int)2, null));
            return true;
        }

        private final void writeEventStreamResponse(HttpServletResponse $this$writeEventStreamResponse, Status newStatus, List<Pair<String, String>> headers) {
            $this$writeEventStreamResponse.setStatus(newStatus.getCode());
            $this$writeEventStreamResponse.setCharacterEncoding(StandardCharsets.UTF_8.name());
            $this$writeEventStreamResponse.setContentType(ContentType.Companion.getTEXT_EVENT_STREAM().getValue());
            $this$writeEventStreamResponse.addHeader("Connection", "close");
            Iterable $this$forEach$iv = headers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair it = (Pair)element$iv;
                boolean bl = false;
                $this$writeEventStreamResponse.addHeader((String)it.getFirst(), (String)it.getSecond());
            }
            $this$writeEventStreamResponse.flushBuffer();
        }

        private final AsyncContext startAsyncWithNoTimeout(HttpServletRequest $this$startAsyncWithNoTimeout) {
            AsyncContext asyncContext;
            AsyncContext $this$startAsyncWithNoTimeout_u24lambda_u242 = asyncContext = $this$startAsyncWithNoTimeout.startAsync();
            boolean bl = false;
            $this$startAsyncWithNoTimeout_u24lambda_u242.setTimeout(0L);
            return asyncContext;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

