/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.server;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Utf8StringBuilder;
import org.eclipse.jetty.websocket.core.CloseStatus;
import org.eclipse.jetty.websocket.core.CoreSession;
import org.eclipse.jetty.websocket.core.Frame;
import org.eclipse.jetty.websocket.core.FrameHandler;
import org.http4k.core.Body;
import org.http4k.core.StreamBody;
import org.http4k.websocket.PushPullAdaptingWebSocket;
import org.http4k.websocket.Websocket;
import org.http4k.websocket.WsMessage;
import org.http4k.websocket.WsStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0016\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u0002`\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u001e\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/http4k/server/Http4kWebSocketFrameHandler;", "Lorg/eclipse/jetty/websocket/core/FrameHandler;", "consumer", "Lkotlin/Function1;", "Lorg/http4k/websocket/Websocket;", "", "Lorg/http4k/websocket/WsConsumer;", "<init>", "(Lkotlin/jvm/functions/Function1;)V", "websocket", "Lorg/http4k/websocket/PushPullAdaptingWebSocket;", "textBuffer", "Lorg/eclipse/jetty/util/Utf8StringBuilder;", "onFrame", "frame", "Lorg/eclipse/jetty/websocket/core/Frame;", "callback", "Lorg/eclipse/jetty/util/Callback;", "onOpen", "session", "Lorg/eclipse/jetty/websocket/core/CoreSession;", "onError", "cause", "", "onClosed", "closeStatus", "Lorg/eclipse/jetty/websocket/core/CloseStatus;", "http4k-server-jetty11"})
public final class Http4kWebSocketFrameHandler
implements FrameHandler {
    @NotNull
    private final Function1<Websocket, Unit> consumer;
    @Nullable
    private PushPullAdaptingWebSocket websocket;
    @NotNull
    private final Utf8StringBuilder textBuffer;

    public Http4kWebSocketFrameHandler(@NotNull Function1<? super Websocket, Unit> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        this.consumer = consumer;
        this.textBuffer = new Utf8StringBuilder();
    }

    public void onFrame(@NotNull Frame frame, @NotNull Callback callback) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        try {
            byte by = frame.getOpCode();
            if (by == 1 || by == 2 || by == 0) {
                this.textBuffer.append(frame.getPayload());
                if (frame.isFin()) {
                    PushPullAdaptingWebSocket pushPullAdaptingWebSocket = this.websocket;
                    if (pushPullAdaptingWebSocket != null) {
                        String string = this.textBuffer.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                        pushPullAdaptingWebSocket.triggerMessage(new WsMessage(Body.Companion.create(string)));
                    }
                    this.textBuffer.reset();
                }
            }
            callback.succeeded();
        }
        catch (Throwable e) {
            PushPullAdaptingWebSocket pushPullAdaptingWebSocket = this.websocket;
            if (pushPullAdaptingWebSocket != null) {
                pushPullAdaptingWebSocket.triggerError(e);
            }
            callback.failed(e);
        }
    }

    public void onOpen(@NotNull CoreSession session, @NotNull Callback callback) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        PushPullAdaptingWebSocket pushPullAdaptingWebSocket = new PushPullAdaptingWebSocket(session){
            final /* synthetic */ CoreSession $session;
            {
                this.$session = $session;
            }

            public void send(WsMessage message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                this.$session.sendFrame(new Frame(message.getBody() instanceof StreamBody ? (byte)2 : 1, message.getBody().getPayload()), new Callback(this.$session){
                    final /* synthetic */ CoreSession $session;
                    {
                        this.$session = $session;
                    }

                    public void succeeded() {
                        this.$session.flush(new Callback(){});
                    }
                }, false);
            }

            public void close(WsStatus status) {
                Intrinsics.checkNotNullParameter((Object)status, (String)"status");
                this.$session.close(status.getCode(), status.getDescription(), new Callback(this.$session){
                    final /* synthetic */ CoreSession $session;
                    {
                        this.$session = $session;
                    }

                    public void succeeded() {
                        this.$session.flush(new Callback(){});
                    }
                });
            }
        };
        this.consumer.invoke((Object)pushPullAdaptingWebSocket);
        this.websocket = pushPullAdaptingWebSocket;
        callback.succeeded();
    }

    public void onError(@NotNull Throwable cause, @NotNull Callback callback) {
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        PushPullAdaptingWebSocket pushPullAdaptingWebSocket = this.websocket;
        if (pushPullAdaptingWebSocket != null) {
            pushPullAdaptingWebSocket.triggerError(cause);
        }
        callback.succeeded();
    }

    public void onClosed(@NotNull CloseStatus closeStatus, @NotNull Callback callback) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)closeStatus, (String)"closeStatus");
            Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
            PushPullAdaptingWebSocket pushPullAdaptingWebSocket = this.websocket;
            if (pushPullAdaptingWebSocket == null) break block1;
            int n = closeStatus.getCode();
            String string = closeStatus.getReason();
            if (string == null) {
                string = "<unknown>";
            }
            pushPullAdaptingWebSocket.triggerClose(new WsStatus(n, string));
        }
    }
}

