/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.server;

import java.io.IOException;
import java.io.OutputStream;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.util.thread.Scheduler;
import org.http4k.core.Request;
import org.http4k.sse.PushAdaptingSse;
import org.http4k.sse.SseMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 '2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001'B;\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\"\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001cH\u0002J\u0010\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002J\u0010\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\tH\u0002J\b\u0010\"\u001a\u00020\u000eH\u0016J\u0010\u0010#\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\u000eH\u0016J\b\u0010&\u001a\u00020\u000eH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/http4k/server/Jetty11EventStreamEmitter;", "Lorg/http4k/sse/PushAdaptingSse;", "Ljava/lang/Runnable;", "Lorg/eclipse/jetty/util/component/LifeCycle$Listener;", "connectRequest", "Lorg/http4k/core/Request;", "output", "Ljava/io/OutputStream;", "heartBeatDuration", "Ljava/time/Duration;", "scheduler", "Lorg/eclipse/jetty/util/thread/Scheduler;", "onClose", "Lkotlin/Function1;", "", "<init>", "(Lorg/http4k/core/Request;Ljava/io/OutputStream;Ljava/time/Duration;Lorg/eclipse/jetty/util/thread/Scheduler;Lkotlin/jvm/functions/Function1;)V", "lock", "Lorg/eclipse/jetty/util/thread/AutoLock;", "heartBeat", "Lorg/eclipse/jetty/util/thread/Scheduler$Task;", "closed", "", "send", "message", "Lorg/http4k/sse/SseMessage;", "sendEvent", "event", "", "data", "id", "sendData", "sendRetry", "duration", "close", "lifeCycleStopping", "Lorg/eclipse/jetty/util/component/LifeCycle;", "run", "scheduleHeartBeat", "Companion", "http4k-server-jetty11"})
@SourceDebugExtension(value={"SMAP\nJetty11EventStreamEmitter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Jetty11EventStreamEmitter.kt\norg/http4k/server/Jetty11EventStreamEmitter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,114:1\n1863#2,2:115\n*S KotlinDebug\n*F\n+ 1 Jetty11EventStreamEmitter.kt\norg/http4k/server/Jetty11EventStreamEmitter\n*L\n50#1:115,2\n*E\n"})
public final class Jetty11EventStreamEmitter
extends PushAdaptingSse
implements Runnable,
LifeCycle.Listener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OutputStream output;
    @NotNull
    private final Duration heartBeatDuration;
    @NotNull
    private final Scheduler scheduler;
    @NotNull
    private final Function1<Jetty11EventStreamEmitter, Unit> onClose;
    @NotNull
    private final AutoLock lock;
    @Nullable
    private Scheduler.Task heartBeat;
    private boolean closed;
    @NotNull
    private static final byte[] DELIMITER;
    @NotNull
    private static final byte[] ID_FIELD;
    @NotNull
    private static final byte[] EVENT_FIELD;
    @NotNull
    private static final byte[] DATA_FIELD;
    @NotNull
    private static final byte[] RETRY_FIELD;

    public Jetty11EventStreamEmitter(@NotNull Request connectRequest, @NotNull OutputStream output, @NotNull Duration heartBeatDuration, @NotNull Scheduler scheduler, @NotNull Function1<? super Jetty11EventStreamEmitter, Unit> onClose) {
        Intrinsics.checkNotNullParameter((Object)connectRequest, (String)"connectRequest");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)heartBeatDuration, (String)"heartBeatDuration");
        Intrinsics.checkNotNullParameter((Object)scheduler, (String)"scheduler");
        Intrinsics.checkNotNullParameter(onClose, (String)"onClose");
        super(connectRequest);
        this.output = output;
        this.heartBeatDuration = heartBeatDuration;
        this.scheduler = scheduler;
        this.onClose = onClose;
        this.lock = new AutoLock();
        this.scheduleHeartBeat();
    }

    @NotNull
    public Jetty11EventStreamEmitter send(@NotNull SseMessage message) {
        Jetty11EventStreamEmitter jetty11EventStreamEmitter;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Jetty11EventStreamEmitter $this$send_u24lambda_u240 = jetty11EventStreamEmitter = this;
        boolean bl = false;
        SseMessage sseMessage = message;
        if (sseMessage instanceof SseMessage.Event) {
            $this$send_u24lambda_u240.sendEvent(((SseMessage.Event)message).getEvent(), ((SseMessage.Event)message).getData(), ((SseMessage.Event)message).getId());
        } else if (sseMessage instanceof SseMessage.Data) {
            $this$send_u24lambda_u240.sendData(((SseMessage.Data)message).getData());
        } else if (sseMessage instanceof SseMessage.Retry) {
            $this$send_u24lambda_u240.sendRetry(((SseMessage.Retry)message).getBackoff());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return jetty11EventStreamEmitter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void sendEvent(String event, String data, String id) {
        AutoCloseable autoCloseable = (AutoCloseable)this.lock.lock();
        Throwable throwable = null;
        try {
            AutoLock it = (AutoLock)autoCloseable;
            boolean bl = false;
            String string = id;
            if (string != null) {
                String string2;
                String it2 = string2 = string;
                boolean bl2 = false;
                this.output.write(ID_FIELD);
                byte[] byArray = it2.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                this.output.write(byArray);
                this.output.write(DELIMITER);
            }
            this.output.write(EVENT_FIELD);
            byte[] byArray = event.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            this.output.write(byArray);
            this.output.write(DELIMITER);
            this.sendData(data);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void sendData(String data) {
        AutoCloseable autoCloseable = (AutoCloseable)this.lock.lock();
        Throwable throwable = null;
        try {
            AutoLock it = (AutoLock)autoCloseable;
            boolean bl = false;
            Iterable $this$forEach$iv = StringsKt.lines((CharSequence)data);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String line = (String)element$iv;
                boolean bl2 = false;
                this.output.write(DATA_FIELD);
                byte[] byArray = line.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                this.output.write(byArray);
                this.output.write(DELIMITER);
            }
            this.output.write(DELIMITER);
            this.output.flush();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void sendRetry(Duration duration) {
        AutoCloseable autoCloseable = (AutoCloseable)this.lock.lock();
        Throwable throwable = null;
        try {
            AutoLock it = (AutoLock)autoCloseable;
            boolean bl = false;
            this.output.write(RETRY_FIELD);
            byte[] byArray = String.valueOf(duration.toMillis()).getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            this.output.write(byArray);
            this.output.write(DELIMITER);
            this.output.write(DELIMITER);
            this.output.flush();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        AutoCloseable autoCloseable = (AutoCloseable)this.lock.lock();
        Throwable throwable = null;
        try {
            AutoLock it = (AutoLock)autoCloseable;
            boolean bl = false;
            if (!this.closed) {
                this.closed = true;
                Scheduler.Task task = this.heartBeat;
                if (task != null) {
                    task.cancel();
                }
                this.onClose.invoke((Object)this);
                this.triggerClose();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public void lifeCycleStopping(@NotNull LifeCycle event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            AutoCloseable autoCloseable = (AutoCloseable)this.lock.lock();
            Throwable throwable = null;
            try {
                AutoLock it = (AutoLock)autoCloseable;
                boolean bl = false;
                this.output.write(13);
                this.output.flush();
                this.output.write(10);
                this.output.flush();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            this.scheduleHeartBeat();
        }
        catch (IOException e) {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void scheduleHeartBeat() {
        AutoCloseable autoCloseable = (AutoCloseable)this.lock.lock();
        Throwable throwable = null;
        try {
            AutoLock it = (AutoLock)autoCloseable;
            boolean bl = false;
            if (!this.closed) {
                this.heartBeat = this.scheduler.schedule((Runnable)this, this.heartBeatDuration.toMillis(), TimeUnit.MILLISECONDS);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    static {
        String string = "\n";
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        DELIMITER = byArray;
        string = "id:";
        byte[] byArray2 = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
        ID_FIELD = byArray2;
        string = "event:";
        byte[] byArray3 = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"getBytes(...)");
        EVENT_FIELD = byArray3;
        string = "data:";
        byte[] byArray4 = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray4, (String)"getBytes(...)");
        DATA_FIELD = byArray4;
        string = "retry:";
        byte[] byArray5 = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray5, (String)"getBytes(...)");
        RETRY_FIELD = byArray5;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/http4k/server/Jetty11EventStreamEmitter$Companion;", "", "<init>", "()V", "DELIMITER", "", "ID_FIELD", "EVENT_FIELD", "DATA_FIELD", "RETRY_FIELD", "http4k-server-jetty11"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

