/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.server;

import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.ByteArrayOutputStream2;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.websocket.core.CloseStatus;
import org.eclipse.jetty.websocket.core.CoreSession;
import org.eclipse.jetty.websocket.core.Frame;
import org.eclipse.jetty.websocket.core.FrameHandler;
import org.http4k.core.Body;
import org.http4k.core.MemoryBody;
import org.http4k.server.Http4kWebSocketFrameHandler;
import org.http4k.websocket.PushPullAdaptingWebSocket;
import org.http4k.websocket.Websocket;
import org.http4k.websocket.WsMessage;
import org.http4k.websocket.WsStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0016\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u0002`\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u001e\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/http4k/server/Http4kWebSocketFrameHandler;", "Lorg/eclipse/jetty/websocket/core/FrameHandler;", "consumer", "Lkotlin/Function1;", "Lorg/http4k/websocket/Websocket;", "", "Lorg/http4k/websocket/WsConsumer;", "<init>", "(Lkotlin/jvm/functions/Function1;)V", "websocket", "Lorg/http4k/websocket/PushPullAdaptingWebSocket;", "buffer", "Lorg/eclipse/jetty/util/ByteArrayOutputStream2;", "messageMode", "Lorg/http4k/websocket/WsMessage$Mode;", "onFrame", "frame", "Lorg/eclipse/jetty/websocket/core/Frame;", "callback", "Lorg/eclipse/jetty/util/Callback;", "onOpen", "session", "Lorg/eclipse/jetty/websocket/core/CoreSession;", "onError", "cause", "", "onClosed", "closeStatus", "Lorg/eclipse/jetty/websocket/core/CloseStatus;", "http4k-server-jetty11"})
public final class Http4kWebSocketFrameHandler
implements FrameHandler {
    @NotNull
    private final Function1<Websocket, Unit> consumer;
    @Nullable
    private PushPullAdaptingWebSocket websocket;
    @NotNull
    private final ByteArrayOutputStream2 buffer;
    @NotNull
    private WsMessage.Mode messageMode;

    public Http4kWebSocketFrameHandler(@NotNull Function1<? super Websocket, Unit> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        this.consumer = consumer;
        this.buffer = new ByteArrayOutputStream2();
        this.messageMode = WsMessage.Mode.Text;
    }

    public void onFrame(@NotNull Frame frame, @NotNull Callback callback) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        try {
            byte by = frame.getOpCode();
            if (by == 1) {
                this.messageMode = WsMessage.Mode.Text;
            } else if (by == 2) {
                this.messageMode = WsMessage.Mode.Binary;
            }
            by = frame.getOpCode();
            if (by == 1 || by == 2 || by == 0) {
                this.buffer.write(BufferUtil.toArray((ByteBuffer)frame.getPayload()));
                if (frame.isFin()) {
                    PushPullAdaptingWebSocket pushPullAdaptingWebSocket = this.websocket;
                    if (pushPullAdaptingWebSocket != null) {
                        byte[] byArray = this.buffer.toByteArray();
                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
                        pushPullAdaptingWebSocket.triggerMessage(new WsMessage((Body)new MemoryBody(byArray), this.messageMode));
                    }
                    this.buffer.reset();
                }
            }
            callback.succeeded();
        }
        catch (Throwable e) {
            PushPullAdaptingWebSocket pushPullAdaptingWebSocket = this.websocket;
            if (pushPullAdaptingWebSocket != null) {
                pushPullAdaptingWebSocket.triggerError(e);
            }
            callback.failed(e);
        }
    }

    public void onOpen(@NotNull CoreSession session, @NotNull Callback callback) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        PushPullAdaptingWebSocket pushPullAdaptingWebSocket = new PushPullAdaptingWebSocket(session){
            final /* synthetic */ CoreSession $session;
            {
                this.$session = $session;
            }

            public void send(WsMessage message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                this.$session.sendFrame(new Frame(switch (onOpen.WhenMappings.$EnumSwitchMapping$0[message.getMode().ordinal()]) {
                    case 1 -> 2;
                    case 2 -> 1;
                    default -> throw new NoWhenBranchMatchedException();
                }, message.getBody().getPayload()), new Callback(this.$session){
                    final /* synthetic */ CoreSession $session;
                    {
                        this.$session = $session;
                    }

                    public void succeeded() {
                        this.$session.flush(new Callback(){});
                    }
                }, false);
            }

            public void close(WsStatus status) {
                Intrinsics.checkNotNullParameter((Object)status, (String)"status");
                this.$session.close(status.getCode(), status.getDescription(), new Callback(this.$session){
                    final /* synthetic */ CoreSession $session;
                    {
                        this.$session = $session;
                    }

                    public void succeeded() {
                        this.$session.flush(new Callback(){});
                    }
                });
            }
        };
        this.consumer.invoke((Object)pushPullAdaptingWebSocket);
        this.websocket = pushPullAdaptingWebSocket;
        callback.succeeded();
    }

    public void onError(@NotNull Throwable cause, @NotNull Callback callback) {
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        PushPullAdaptingWebSocket pushPullAdaptingWebSocket = this.websocket;
        if (pushPullAdaptingWebSocket != null) {
            pushPullAdaptingWebSocket.triggerError(cause);
        }
        callback.succeeded();
    }

    public void onClosed(@NotNull CloseStatus closeStatus, @NotNull Callback callback) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)closeStatus, (String)"closeStatus");
            Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
            PushPullAdaptingWebSocket pushPullAdaptingWebSocket = this.websocket;
            if (pushPullAdaptingWebSocket == null) break block1;
            int n = closeStatus.getCode();
            String string = closeStatus.getReason();
            if (string == null) {
                string = "<unknown>";
            }
            pushPullAdaptingWebSocket.triggerClose(new WsStatus(n, string));
        }
    }
}

