/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.serverless;

import com.amazonaws.services.lambda.runtime.ClientContext;
import com.amazonaws.services.lambda.runtime.CognitoIdentity;
import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.LambdaLogger;
import java.time.Clock;
import java.time.Duration;
import java.time.temporal.Temporal;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.http4k.core.Request;
import org.http4k.serverless.LambdaRuntimeAPI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\n\u0010\n\u001a\u0004\u0018\u00010\u0006H\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\n\u0010\r\u001a\u0004\u0018\u00010\u0006H\u0016J\n\u0010\u000e\u001a\u0004\u0018\u00010\u0006H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0006H\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0006H\u0016J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0006H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0017H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/http4k/serverless/LambdaEnvironmentContext;", "Lcom/amazonaws/services/lambda/runtime/Context;", "req", "Lorg/http4k/core/Request;", "env", "", "", "clock", "Ljava/time/Clock;", "(Lorg/http4k/core/Request;Ljava/util/Map;Ljava/time/Clock;)V", "getAwsRequestId", "getClientContext", "Lcom/amazonaws/services/lambda/runtime/ClientContext;", "getFunctionName", "getFunctionVersion", "getIdentity", "Lcom/amazonaws/services/lambda/runtime/CognitoIdentity;", "getInvokedFunctionArn", "getLogGroupName", "getLogStreamName", "getLogger", "Lcom/amazonaws/services/lambda/runtime/LambdaLogger;", "getMemoryLimitInMB", "", "getRemainingTimeInMillis", "http4k-serverless-lambda-runtime"})
public final class LambdaEnvironmentContext
implements Context {
    private final Request req;
    private final Map<String, String> env;
    private final Clock clock;

    @Nullable
    public String getAwsRequestId() {
        UUID uUID = (UUID)LambdaRuntimeAPI.Companion.getRequestId().invoke((Object)this.req);
        return uUID != null ? uUID.toString() : null;
    }

    @Nullable
    public String getLogGroupName() {
        return this.env.get("AWS_LAMBDA_LOG_GROUP_NAME");
    }

    @Nullable
    public String getLogStreamName() {
        return this.env.get("AWS_LAMBDA_LOG_STREAM_NAME");
    }

    @Nullable
    public String getFunctionName() {
        return this.env.get("AWS_LAMBDA_FUNCTION_NAME");
    }

    @Nullable
    public String getFunctionVersion() {
        return this.env.get("AWS_LAMBDA_FUNCTION_VERSION");
    }

    @NotNull
    public String getInvokedFunctionArn() {
        return (String)LambdaRuntimeAPI.Companion.getLambdaArn().invoke((Object)this.req);
    }

    public int getRemainingTimeInMillis() {
        return (int)Duration.between(this.clock.instant(), (Temporal)LambdaRuntimeAPI.Companion.getDeadline().invoke((Object)this.req)).toMillis();
    }

    public int getMemoryLimitInMB() {
        int n;
        String string = this.env.get("AWS_LAMBDA_FUNCTION_MEMORY_SIZE");
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            n = Integer.parseInt(string2);
        } else {
            n = 0;
        }
        return n;
    }

    @NotNull
    public LambdaLogger getLogger() {
        return new LambdaLogger(){

            public void log(@NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                boolean bl = false;
                System.out.println((Object)message);
            }

            public void log(@NotNull byte[] message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                boolean bl = false;
                String string = new String(message, Charsets.UTF_8);
                boolean bl2 = false;
                System.out.println((Object)string);
            }
        };
    }

    @NotNull
    public CognitoIdentity getIdentity() {
        throw (Throwable)new UnsupportedOperationException("not implemented");
    }

    @NotNull
    public ClientContext getClientContext() {
        throw (Throwable)new UnsupportedOperationException("not implemented");
    }

    public LambdaEnvironmentContext(@NotNull Request req, @NotNull Map<String, String> env, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Intrinsics.checkNotNullParameter(env, (String)"env");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.req = req;
        this.env = env;
        this.clock = clock;
    }

    public /* synthetic */ LambdaEnvironmentContext(Request request, Map map, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue((Object)clock2, (String)"Clock.systemUTC()");
            clock = clock2;
        }
        this(request, map, clock);
    }
}

