/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.testing;

import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.http4k.core.HttpMessage;
import org.http4k.testing.ApprovalContent;
import org.http4k.testing.ApprovalFailed;
import org.http4k.testing.ApprovalSource;
import org.http4k.testing.Approver;
import org.http4k.testing.ReadResource;
import org.http4k.testing.ReadWriteResource;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001f\u0010\u000b\u001a\u00020\f\"\b\b\u0000\u0010\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u0002H\rH\u0016\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\f\u0010\u0013\u001a\u00020\u0003*\u00020\u0003H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/http4k/testing/NamedResourceApprover;", "Lorg/http4k/testing/Approver;", "name", "", "approvalContent", "Lorg/http4k/testing/ApprovalContent;", "approvalSource", "Lorg/http4k/testing/ApprovalSource;", "(Ljava/lang/String;Lorg/http4k/testing/ApprovalContent;Lorg/http4k/testing/ApprovalSource;)V", "matchAllLineEndings", "Lkotlin/text/Regex;", "assertApproved", "", "T", "Lorg/http4k/core/HttpMessage;", "httpMessage", "(Lorg/http4k/core/HttpMessage;)V", "withNameSuffix", "suffix", "normalizeLineEndings", "http4k-testing-approval"})
@SourceDebugExtension(value={"SMAP\nApprover.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Approver.kt\norg/http4k/testing/NamedResourceApprover\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,99:1\n1#2:100\n*E\n"})
public final class NamedResourceApprover
implements Approver {
    @NotNull
    private final String name;
    @NotNull
    private final ApprovalContent approvalContent;
    @NotNull
    private final ApprovalSource approvalSource;
    @NotNull
    private final Regex matchAllLineEndings;

    public NamedResourceApprover(@NotNull String name, @NotNull ApprovalContent approvalContent, @NotNull ApprovalSource approvalSource) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)approvalContent, (String)"approvalContent");
        Intrinsics.checkNotNullParameter((Object)approvalSource, (String)"approvalSource");
        this.name = name;
        this.approvalContent = approvalContent;
        this.approvalSource = approvalSource;
        this.matchAllLineEndings = new Regex("\\r\\n?");
    }

    private final String normalizeLineEndings(String $this$normalizeLineEndings) {
        CharSequence charSequence = $this$normalizeLineEndings;
        Regex regex = this.matchAllLineEndings;
        String string = "\n";
        return regex.replace(charSequence, string);
    }

    @Override
    @NotNull
    public Approver withNameSuffix(@NotNull String suffix) {
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        return new NamedResourceApprover(this.name + '.' + suffix, this.approvalContent, this.approvalSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends HttpMessage> void assertApproved(@NotNull T httpMessage) {
        Intrinsics.checkNotNullParameter(httpMessage, (String)"httpMessage");
        ReadResource approved = this.approvalSource.approvedFor(this.name);
        InputStream $this$assertApproved_u24lambda_u242 = approved.input();
        boolean bl = false;
        ReadWriteResource actual = this.approvalSource.actualFor(this.name);
        if ($this$assertApproved_u24lambda_u242 == null) {
            InputStream $this$assertApproved_u24lambda_u242_u24lambda_u240 = this.approvalContent.invoke(httpMessage);
            boolean bl2 = false;
            if ($this$assertApproved_u24lambda_u242_u24lambda_u240.available() > 0) {
                ByteStreamsKt.copyTo$default((InputStream)$this$assertApproved_u24lambda_u242_u24lambda_u240, (OutputStream)actual.output(), (int)0, (int)2, null);
                throw new ApprovalFailed("No approved content found", actual, approved);
            }
        } else {
            try {
                String string;
                Closeable closeable = this.approvalContent.invoke($this$assertApproved_u24lambda_u242);
                Object $this$assertApproved_u24lambda_u242_u24lambda_u240 = Charsets.UTF_8;
                closeable = new InputStreamReader((InputStream)closeable, (Charset)$this$assertApproved_u24lambda_u242_u24lambda_u240);
                $this$assertApproved_u24lambda_u242_u24lambda_u240 = null;
                try {
                    InputStreamReader it = (InputStreamReader)closeable;
                    boolean bl3 = false;
                    string = ((Object)StringsKt.trimEnd((CharSequence)this.normalizeLineEndings(TextStreamsKt.readText((Reader)it)))).toString();
                }
                catch (Throwable throwable) {
                    $this$assertApproved_u24lambda_u242_u24lambda_u240 = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)$this$assertApproved_u24lambda_u242_u24lambda_u240);
                }
                closeable = this.approvalContent.invoke(httpMessage);
                $this$assertApproved_u24lambda_u242_u24lambda_u240 = Charsets.UTF_8;
                Assertions.assertEquals((Object)string, (Object)((Object)StringsKt.trimEnd((CharSequence)this.normalizeLineEndings(TextStreamsKt.readText((Reader)new InputStreamReader((InputStream)closeable, (Charset)$this$assertApproved_u24lambda_u242_u24lambda_u240))))).toString());
                closeable = actual.output();
            }
            catch (AssertionError e) {
                ByteStreamsKt.copyTo$default((InputStream)this.approvalContent.invoke(httpMessage), (OutputStream)actual.output(), (int)0, (int)2, null);
                throw new AssertionError((Object)(new ApprovalFailed("Mismatch", actual, approved).getMessage() + '\n' + ((Throwable)((Object)e)).getMessage()));
            }
        }
    }
}

