/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.testing;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.http4k.core.HttpMessage;
import org.http4k.testing.ApprovalContent;
import org.http4k.testing.ApprovalSource;
import org.http4k.testing.ApprovalTransformer;
import org.http4k.testing.Approver;
import org.http4k.testing.ReadResource;
import org.http4k.testing.ReadWriteResource;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\b\u0002\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u001f\u0010\u000e\u001a\u00020\u000f\"\b\b\u0000\u0010\u0010*\u00020\u00112\u0006\u0010\u0012\u001a\u0002H\u0010H\u0016\u00a2\u0006\u0002\u0010\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/http4k/testing/NamedResourceApprover;", "Lorg/http4k/testing/Approver;", "name", "", "approvalContent", "Lorg/http4k/testing/ApprovalContent;", "approvalSource", "Lorg/http4k/testing/ApprovalSource;", "transformer", "Lorg/http4k/testing/ApprovalTransformer;", "<init>", "(Ljava/lang/String;Lorg/http4k/testing/ApprovalContent;Lorg/http4k/testing/ApprovalSource;Lorg/http4k/testing/ApprovalTransformer;)V", "withNameSuffix", "suffix", "assertApproved", "", "T", "Lorg/http4k/core/HttpMessage;", "httpMessage", "(Lorg/http4k/core/HttpMessage;)V", "http4k-testing-approval"})
public final class NamedResourceApprover
implements Approver {
    @NotNull
    private final String name;
    @NotNull
    private final ApprovalContent approvalContent;
    @NotNull
    private final ApprovalSource approvalSource;
    @NotNull
    private final ApprovalTransformer<?> transformer;

    public NamedResourceApprover(@NotNull String name, @NotNull ApprovalContent approvalContent, @NotNull ApprovalSource approvalSource, @NotNull ApprovalTransformer<?> transformer) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)approvalContent, (String)"approvalContent");
        Intrinsics.checkNotNullParameter((Object)approvalSource, (String)"approvalSource");
        Intrinsics.checkNotNullParameter(transformer, (String)"transformer");
        this.name = name;
        this.approvalContent = approvalContent;
        this.approvalSource = approvalSource;
        this.transformer = transformer;
    }

    public /* synthetic */ NamedResourceApprover(String string, ApprovalContent approvalContent, ApprovalSource approvalSource, ApprovalTransformer approvalTransformer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            approvalTransformer = ApprovalTransformer.Companion.StringWithNormalisedLineEndings();
        }
        this(string, approvalContent, approvalSource, approvalTransformer);
    }

    @Override
    @NotNull
    public NamedResourceApprover withNameSuffix(@NotNull String suffix) {
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        return new NamedResourceApprover(this.name + '.' + suffix, this.approvalContent, this.approvalSource, this.transformer);
    }

    @Override
    public <T extends HttpMessage> void assertApproved(@NotNull T httpMessage) {
        Intrinsics.checkNotNullParameter(httpMessage, (String)"httpMessage");
        ReadResource approved = this.approvalSource.approvedFor(this.name);
        ReadWriteResource actual = this.approvalSource.actualFor(this.name);
        byte[] actualBytes = ByteStreamsKt.readBytes((InputStream)this.approvalContent.invoke(httpMessage));
        InputStream $this$assertApproved_u24lambda_u242 = approved.input();
        boolean bl = false;
        actual.output();
        if ($this$assertApproved_u24lambda_u242 == null) {
            if (!(actualBytes.length == 0)) {
                actual.output().write(actualBytes);
                Assertions.assertNull((Object)new String(actualBytes, Charsets.UTF_8), () -> NamedResourceApprover.assertApproved$lambda$2$lambda$0(actual, approved));
            }
        } else {
            try {
                Assertions.assertEquals((Object)this.transformer.invoke(this.approvalContent.invoke($this$assertApproved_u24lambda_u242)), (Object)this.transformer.invoke(new ByteArrayInputStream(actualBytes)), () -> NamedResourceApprover.assertApproved$lambda$2$lambda$1(actual, approved));
            }
            catch (AssertionError e) {
                ByteStreamsKt.copyTo$default((InputStream)new ByteArrayInputStream(actualBytes), (OutputStream)actual.output(), (int)0, (int)2, null);
                throw e;
            }
        }
    }

    private static final String assertApproved$lambda$2$lambda$0(ReadWriteResource $actual, ReadResource $approved) {
        return "No approved content found. To approve output:\nmv '" + $actual + "' '" + $approved + '\'';
    }

    private static final String assertApproved$lambda$2$lambda$1(ReadWriteResource $actual, ReadResource $approved) {
        return "Mismatch. To approve output:\nmv '" + $actual + "' '" + $approved + '\'';
    }
}

