/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.chaos;

import com.fasterxml.jackson.databind.JsonNode;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Iterator;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.http4k.chaos.ChaosBehaviours;
import org.http4k.chaos.ChaosBehavioursKt;
import org.http4k.chaos.ChaosEngine;
import org.http4k.chaos.ChaosStages;
import org.http4k.chaos.ChaosStagesKt;
import org.http4k.chaos.ChaosTriggers;
import org.http4k.chaos.RemoteChaosApi;
import org.http4k.chaos.RemoteChaosApiKt;
import org.http4k.contract.ContractBuilder;
import org.http4k.contract.ContractRenderer;
import org.http4k.contract.ExtensionsKt;
import org.http4k.contract.RouteMetaDsl;
import org.http4k.contract.openapi.ApiInfo;
import org.http4k.contract.openapi.v3.JacksonExtKt;
import org.http4k.contract.security.NoSecurity;
import org.http4k.contract.security.Security;
import org.http4k.core.Body;
import org.http4k.core.Filter;
import org.http4k.core.Http4kKt;
import org.http4k.core.HttpKt;
import org.http4k.core.HttpMessage;
import org.http4k.core.Method;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.http4k.core.Status;
import org.http4k.filter.CorsPolicy;
import org.http4k.filter.ServerFilters;
import org.http4k.format.Jackson;
import org.http4k.format.Json;
import org.http4k.lens.BodyLens;
import org.http4k.routing.RoutingHttpHandler;
import org.http4k.routing.RoutingKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JM\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u000e2\b\b\u0002\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u000eH\u0086\u0002R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0017\u00b2\u0006\"\u0010\u0018\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u001b\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001aj\u0002`\u001d0\u0019X\u008a\u0084\u0002"}, d2={"Lorg/http4k/chaos/RemoteChaosApi;", "", "()V", "exampleChaos", "Lcom/fasterxml/jackson/databind/JsonNode;", "getExampleChaos", "()Lcom/fasterxml/jackson/databind/JsonNode;", "exampleChaos$delegate", "Lkotlin/Lazy;", "invoke", "Lorg/http4k/routing/RoutingHttpHandler;", "engine", "Lorg/http4k/chaos/ChaosEngine;", "controlsPath", "", "chaosSecurity", "Lorg/http4k/contract/security/Security;", "openApiPath", "corsPolicy", "Lorg/http4k/filter/CorsPolicy;", "clock", "Ljava/time/Clock;", "apiName", "http4k-testing-chaos", "setStages", "Lorg/http4k/lens/BodyLens;", "Lkotlin/Function1;", "Lorg/http4k/core/Request;", "Lorg/http4k/core/Filter;", "Lorg/http4k/chaos/Stage;"})
public final class RemoteChaosApi {
    @NotNull
    public static final RemoteChaosApi INSTANCE = new RemoteChaosApi();
    @NotNull
    private static final Lazy exampleChaos$delegate = LazyKt.lazy((Function0)exampleChaos.2.INSTANCE);

    private RemoteChaosApi() {
    }

    @NotNull
    public final RoutingHttpHandler invoke(@NotNull ChaosEngine engine, @NotNull String controlsPath, @NotNull Security chaosSecurity, @NotNull String openApiPath, @NotNull CorsPolicy corsPolicy, @NotNull Clock clock, @NotNull String apiName) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Intrinsics.checkNotNullParameter((Object)controlsPath, (String)"controlsPath");
        Intrinsics.checkNotNullParameter((Object)chaosSecurity, (String)"chaosSecurity");
        Intrinsics.checkNotNullParameter((Object)openApiPath, (String)"openApiPath");
        Intrinsics.checkNotNullParameter((Object)corsPolicy, (String)"corsPolicy");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)apiName, (String)"apiName");
        Lazy setStages$delegate = LazyKt.lazy((Function0)((Function0)new Function0<BodyLens<? extends Function1<? super Request, ? extends Filter>>>(clock){
            final /* synthetic */ Clock $clock;
            {
                this.$clock = $clock;
                super(0);
            }

            @NotNull
            public final BodyLens<Function1<Request, Filter>> invoke() {
                return Json.DefaultImpls.json$default((Json)((Json)Jackson.INSTANCE), (Body.Companion)Body.Companion, null, null, (int)3, null).map((Function1)new Function1<JsonNode, Function1<? super Request, ? extends Filter>>(this.$clock){
                    final /* synthetic */ Clock $clock;
                    {
                        this.$clock = $clock;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final Function1<Request, Filter> invoke(@NotNull JsonNode node) {
                        Sequence sequence;
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        if (node.isArray()) {
                            Iterator iterator = node.elements();
                            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"node.elements()");
                            sequence = SequencesKt.asSequence((Iterator)iterator);
                        } else {
                            Object[] objectArray = new JsonNode[]{node};
                            sequence = SequencesKt.sequenceOf((Object[])objectArray);
                        }
                        Sequence $this$reduce$iv = SequencesKt.map((Sequence)sequence, (Function1)((Function1)new Function1<JsonNode, Function1<? super Request, ? extends Filter>>(this.$clock){
                            final /* synthetic */ Clock $clock;
                            {
                                this.$clock = $clock;
                                super(1);
                            }

                            @NotNull
                            public final Function1<Request, Filter> invoke(JsonNode it) {
                                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                                return ChaosStagesKt.asStage(it, this.$clock);
                            }
                        }));
                        boolean $i$f$reduce = false;
                        Iterator iterator$iv = $this$reduce$iv.iterator();
                        if (!iterator$iv.hasNext()) {
                            throw new UnsupportedOperationException("Empty sequence can't be reduced.");
                        }
                        Object accumulator$iv = iterator$iv.next();
                        while (iterator$iv.hasNext()) {
                            void next;
                            Function1 function1 = (Function1)iterator$iv.next();
                            Function1 acc = (Function1)accumulator$iv;
                            boolean bl = false;
                            accumulator$iv = ChaosStagesKt.then((Function1<? super Request, ? extends Filter>)acc, (Function1<? super Request, ? extends Filter>)next);
                        }
                        return (Function1)accumulator$iv;
                    }
                }).toLens();
            }
        }));
        Function1 showCurrentStatus2 = (Function1)new Function1<Request, Response>(engine){
            final /* synthetic */ ChaosEngine $engine;
            {
                this.$engine = $engine;
                super(1);
            }

            @NotNull
            public final Response invoke(@NotNull Request it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Function1[] function1Array = new Function1[]{Json.DefaultImpls.json$default((Json)((Json)Jackson.INSTANCE), (Body.Companion)Body.Companion, null, null, (int)3, null).toLens().of((Object)RemoteChaosApiKt.access$chaosStatus(this.$engine.isEnabled() ? this.$engine.toString() : "none"))};
                return (Response)HttpKt.with((HttpMessage)((HttpMessage)Response.Companion.create$default((Response.Companion)Response.Companion, (Status)Status.OK, null, (int)2, null)), (Function1[])function1Array);
            }
        };
        Filter activate2 = arg_0 -> RemoteChaosApi.invoke$lambda$1(engine, setStages$delegate, arg_0);
        Filter deactivate2 = arg_0 -> RemoteChaosApi.invoke$lambda$2(engine, arg_0);
        Filter toggle2 = arg_0 -> RemoteChaosApi.invoke$lambda$3(engine, arg_0);
        String apiDescription = StringsKt.trimMargin$default((String)("This is the Open API interface for the " + apiName + " Chaos Engine. \n            |\n            |Using this UI you can inject new dynamic chaotic behaviour into any http4k application, or toggle/disable it. \n            |\n            |See the <a href=\"https://www.http4k.org/guide/modules/chaos/\">user guide</a> for details about the \n            | exact format of the JSON to post to the activation endpoint."), null, (int)1, null);
        String currentChaosDescription2 = ChaosStages.INSTANCE.Repeat((Function0<? extends Function1<? super Request, ? extends Filter>>)((Function0)new Function0<Function1<? super Request, ? extends Filter>>(clock){
            final /* synthetic */ Clock $clock;
            {
                this.$clock = $clock;
                super(0);
            }

            @NotNull
            public final Function1<Request, Filter> invoke() {
                Function1 function1 = ChaosStages.Wait.INSTANCE;
                Duration duration = Duration.ofMinutes(1L);
                Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMinutes(1)");
                Function1<Request, Filter> function12 = ChaosStagesKt.until((Function1<? super Request, ? extends Filter>)function1, ChaosTriggers.Delay.INSTANCE.invoke(duration, this.$clock));
                Function1<Request, Filter> function13 = ChaosBehavioursKt.appliedWhen(ChaosBehaviours.ReturnStatus.INSTANCE.invoke(Status.I_M_A_TEAPOT), ChaosTriggers.Always.INSTANCE.invoke());
                Instant instant = Instant.ofEpochSecond(1735689600L);
                Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"ofEpochSecond(1735689600)");
                return ChaosStagesKt.then(function12, ChaosStagesKt.until(function13, (Function1<? super Request, Boolean>)ChaosTriggers.Deadline.invoke$default(ChaosTriggers.Deadline.INSTANCE, instant, null, 2, null)));
            }
        })).toString();
        return RoutingKt.bind((String)controlsPath, (RoutingHttpHandler)Http4kKt.then((Filter)Http4kKt.then((Filter)ServerFilters.Cors.INSTANCE.invoke(corsPolicy), (Filter)ServerFilters.CatchAll.invoke$default((ServerFilters.CatchAll)ServerFilters.CatchAll.INSTANCE, null, (int)1, null)), (RoutingHttpHandler)((RoutingHttpHandler)ExtensionsKt.contract((Function1)((Function1)new Function1<ContractBuilder, Unit>(apiName, apiDescription, openApiPath, chaosSecurity, (Function1<? super Request, ? extends Response>)showCurrentStatus2, activate2, deactivate2, toggle2, currentChaosDescription2){
            final /* synthetic */ String $apiName;
            final /* synthetic */ String $apiDescription;
            final /* synthetic */ String $openApiPath;
            final /* synthetic */ Security $chaosSecurity;
            final /* synthetic */ Function1<Request, Response> $showCurrentStatus;
            final /* synthetic */ Filter $activate;
            final /* synthetic */ Filter $deactivate;
            final /* synthetic */ Filter $toggle;
            final /* synthetic */ String $currentChaosDescription;
            {
                this.$apiName = $apiName;
                this.$apiDescription = $apiDescription;
                this.$openApiPath = $openApiPath;
                this.$chaosSecurity = $chaosSecurity;
                this.$showCurrentStatus = $showCurrentStatus;
                this.$activate = $activate;
                this.$deactivate = $deactivate;
                this.$toggle = $toggle;
                this.$currentChaosDescription = $currentChaosDescription;
                super(1);
            }

            public final void invoke(@NotNull ContractBuilder $this$contract) {
                Intrinsics.checkNotNullParameter((Object)$this$contract, (String)"$this$contract");
                $this$contract.setRenderer((ContractRenderer)JacksonExtKt.OpenApi3$default((ApiInfo)new ApiInfo(this.$apiName + " Chaos Engine", "1.0", this.$apiDescription), null, null, null, (int)14, null));
                $this$contract.setDescriptionPath(this.$openApiPath);
                $this$contract.setSecurity(this.$chaosSecurity);
                $this$contract.getRoutes().plusAssign((Object)ExtensionsKt.meta((String)"/status", (Function1)((Function1)new Function1<RouteMetaDsl, Unit>(this.$currentChaosDescription){
                    final /* synthetic */ String $currentChaosDescription;
                    {
                        this.$currentChaosDescription = $currentChaosDescription;
                        super(1);
                    }

                    public final void invoke(@NotNull RouteMetaDsl $this$null) {
                        Intrinsics.checkNotNullParameter((Object)$this$null, (String)"$this$null");
                        $this$null.setSummary("Show the current Chaos being applied.");
                        $this$null.setDescription("Returns a textual description of the current Chaos behaviour being applied to traffic.");
                        RemoteChaosApi.access$invoke$returningExampleChaosDescription($this$null, this.$currentChaosDescription);
                    }
                })).bindContract(Method.GET).to(this.$showCurrentStatus));
                $this$contract.getRoutes().plusAssign((Object)ExtensionsKt.meta((String)"/activate/new", (Function1)((Function1)new Function1<RouteMetaDsl, Unit>(this.$currentChaosDescription){
                    final /* synthetic */ String $currentChaosDescription;
                    {
                        this.$currentChaosDescription = $currentChaosDescription;
                        super(1);
                    }

                    public final void invoke(@NotNull RouteMetaDsl $this$null) {
                        Intrinsics.checkNotNullParameter((Object)$this$null, (String)"$this$null");
                        $this$null.setSummary("Activate new Chaos on all routes.");
                        $this$null.setDescription("Replace the current Chaos being applied to traffic and activates that behaviour.");
                        RouteMetaDsl.receiving$default((RouteMetaDsl)$this$null, (Pair)TuplesKt.to((Object)Json.DefaultImpls.json$default((Json)((Json)Jackson.INSTANCE), (Body.Companion)Body.Companion, null, null, (int)3, null).toLens(), (Object)RemoteChaosApi.access$getExampleChaos(RemoteChaosApi.INSTANCE)), null, null, (int)6, null);
                        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Status.BAD_REQUEST, (Object)"New Chaos could not be deserialised from the request body.")};
                        $this$null.returningStatus(pairArray);
                        RemoteChaosApi.access$invoke$returningExampleChaosDescription($this$null, this.$currentChaosDescription);
                    }
                })).bindContract(Method.POST).to(Http4kKt.then((Filter)this.$activate, this.$showCurrentStatus)));
                $this$contract.getRoutes().plusAssign((Object)ExtensionsKt.meta((String)"/activate", (Function1)((Function1)new Function1<RouteMetaDsl, Unit>(this.$currentChaosDescription){
                    final /* synthetic */ String $currentChaosDescription;
                    {
                        this.$currentChaosDescription = $currentChaosDescription;
                        super(1);
                    }

                    public final void invoke(@NotNull RouteMetaDsl $this$null) {
                        Intrinsics.checkNotNullParameter((Object)$this$null, (String)"$this$null");
                        $this$null.setSummary("Activate Chaos on all routes.");
                        $this$null.setDescription("Toggles on the previously stored Chaos behaviour.");
                        RemoteChaosApi.access$invoke$returningExampleChaosDescription($this$null, this.$currentChaosDescription);
                    }
                })).bindContract(Method.POST).to(Http4kKt.then((Filter)this.$activate, this.$showCurrentStatus)));
                $this$contract.getRoutes().plusAssign((Object)ExtensionsKt.meta((String)"/deactivate", (Function1)((Function1)new Function1<RouteMetaDsl, Unit>(this.$currentChaosDescription){
                    final /* synthetic */ String $currentChaosDescription;
                    {
                        this.$currentChaosDescription = $currentChaosDescription;
                        super(1);
                    }

                    public final void invoke(@NotNull RouteMetaDsl $this$null) {
                        Intrinsics.checkNotNullParameter((Object)$this$null, (String)"$this$null");
                        $this$null.setSummary("Deactivate Chaos on all routes.");
                        $this$null.setDescription("Toggles off the previously stored Chaos behaviour.");
                        RemoteChaosApi.access$invoke$returningExampleChaosDescription($this$null, this.$currentChaosDescription);
                    }
                })).bindContract(Method.POST).to(Http4kKt.then((Filter)this.$deactivate, this.$showCurrentStatus)));
                $this$contract.getRoutes().plusAssign((Object)ExtensionsKt.meta((String)"/toggle", (Function1)((Function1)new Function1<RouteMetaDsl, Unit>(this.$currentChaosDescription){
                    final /* synthetic */ String $currentChaosDescription;
                    {
                        this.$currentChaosDescription = $currentChaosDescription;
                        super(1);
                    }

                    public final void invoke(@NotNull RouteMetaDsl $this$null) {
                        Intrinsics.checkNotNullParameter((Object)$this$null, (String)"$this$null");
                        $this$null.setSummary("Toggle on/off the Chaos on all routes.");
                        $this$null.setDescription("Toggles the previously stored Chaos behaviour.");
                        RemoteChaosApi.access$invoke$returningExampleChaosDescription($this$null, this.$currentChaosDescription);
                    }
                })).bindContract(Method.POST).to(Http4kKt.then((Filter)this.$toggle, this.$showCurrentStatus)));
            }
        })))));
    }

    public static /* synthetic */ RoutingHttpHandler invoke$default(RemoteChaosApi remoteChaosApi, ChaosEngine chaosEngine, String string, Security security, String string2, CorsPolicy corsPolicy, Clock clock, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string = "/chaos";
        }
        if ((n & 4) != 0) {
            security = (Security)NoSecurity.INSTANCE;
        }
        if ((n & 8) != 0) {
            string2 = "";
        }
        if ((n & 0x10) != 0) {
            corsPolicy = CorsPolicy.Companion.getUnsafeGlobalPermissive();
        }
        if ((n & 0x20) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue((Object)clock2, (String)"systemUTC()");
            clock = clock2;
        }
        if ((n & 0x40) != 0) {
            string3 = "http4k";
        }
        return remoteChaosApi.invoke(chaosEngine, string, security, string2, corsPolicy, clock, string3);
    }

    private final JsonNode getExampleChaos() {
        Lazy lazy = exampleChaos$delegate;
        return (JsonNode)lazy.getValue();
    }

    private static final BodyLens<Function1<Request, Filter>> invoke$lambda$0(Lazy<? extends BodyLens<? extends Function1<? super Request, ? extends Filter>>> $setStages$delegate) {
        Lazy<? extends BodyLens<? extends Function1<? super Request, ? extends Filter>>> lazy = $setStages$delegate;
        return (BodyLens)lazy.getValue();
    }

    private static final Function1 invoke$lambda$1(ChaosEngine $engine, Lazy $setStages$delegate, Function1 next) {
        Intrinsics.checkNotNullParameter((Object)$engine, (String)"$engine");
        Intrinsics.checkNotNullParameter((Object)$setStages$delegate, (String)"$setStages$delegate");
        Intrinsics.checkNotNullParameter((Object)next, (String)"next");
        return (Function1)new Function1<Request, Response>($engine, (Function1<? super Request, ? extends Response>)next, (Lazy<? extends BodyLens<? extends Function1<? super Request, ? extends Filter>>>)$setStages$delegate){
            final /* synthetic */ ChaosEngine $engine;
            final /* synthetic */ Function1<Request, Response> $next;
            final /* synthetic */ Lazy<BodyLens<Function1<Request, Filter>>> $setStages$delegate;
            {
                this.$engine = $engine;
                this.$next = $next;
                this.$setStages$delegate = $setStages$delegate;
                super(1);
            }

            @NotNull
            public final Response invoke(@NotNull Request it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (((CharSequence)it.bodyString()).length() > 0) {
                    this.$engine.enable((Function1<? super Request, ? extends Filter>)((Function1)RemoteChaosApi.access$invoke$lambda$0(this.$setStages$delegate).invoke((HttpMessage)it)));
                } else {
                    this.$engine.enable();
                }
                return (Response)this.$next.invoke((Object)it);
            }
        };
    }

    private static final Function1 invoke$lambda$2(ChaosEngine $engine, Function1 next) {
        Intrinsics.checkNotNullParameter((Object)$engine, (String)"$engine");
        Intrinsics.checkNotNullParameter((Object)next, (String)"next");
        return (Function1)new Function1<Request, Response>($engine, (Function1<? super Request, ? extends Response>)next){
            final /* synthetic */ ChaosEngine $engine;
            final /* synthetic */ Function1<Request, Response> $next;
            {
                this.$engine = $engine;
                this.$next = $next;
                super(1);
            }

            @NotNull
            public final Response invoke(@NotNull Request it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$engine.disable();
                return (Response)this.$next.invoke((Object)it);
            }
        };
    }

    private static final Function1 invoke$lambda$3(ChaosEngine $engine, Function1 next) {
        Intrinsics.checkNotNullParameter((Object)$engine, (String)"$engine");
        Intrinsics.checkNotNullParameter((Object)next, (String)"next");
        return (Function1)new Function1<Request, Response>($engine, (Function1<? super Request, ? extends Response>)next){
            final /* synthetic */ ChaosEngine $engine;
            final /* synthetic */ Function1<Request, Response> $next;
            {
                this.$engine = $engine;
                this.$next = $next;
                super(1);
            }

            @NotNull
            public final Response invoke(@NotNull Request it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ChaosEngine $this$invoke_u24lambda_u240 = this.$engine;
                boolean bl = false;
                ChaosEngine chaosEngine = $this$invoke_u24lambda_u240.isEnabled() ? $this$invoke_u24lambda_u240.disable() : $this$invoke_u24lambda_u240.enable();
                return (Response)this.$next.invoke((Object)it);
            }
        };
    }

    private static final void invoke$returningExampleChaosDescription(RouteMetaDsl $this$invoke_u24returningExampleChaosDescription, String currentChaosDescription2) {
        RouteMetaDsl.returningStatus$default((RouteMetaDsl)$this$invoke_u24returningExampleChaosDescription, (Status)Status.OK, (Pair)TuplesKt.to((Object)Json.DefaultImpls.json$default((Json)((Json)Jackson.INSTANCE), (Body.Companion)Body.Companion, null, null, (int)3, null).toLens(), (Object)RemoteChaosApiKt.access$chaosStatus(currentChaosDescription2)), (String)"The current Chaos being applied to requests.", null, null, (int)24, null);
    }

    public static final /* synthetic */ void access$invoke$returningExampleChaosDescription(RouteMetaDsl $receiver, String currentChaosDescription2) {
        RemoteChaosApi.invoke$returningExampleChaosDescription($receiver, currentChaosDescription2);
    }

    public static final /* synthetic */ JsonNode access$getExampleChaos(RemoteChaosApi $this) {
        return $this.getExampleChaos();
    }

    public static final /* synthetic */ BodyLens access$invoke$lambda$0(Lazy $setStages$delegate) {
        return RemoteChaosApi.invoke$lambda$0((Lazy<? extends BodyLens<? extends Function1<? super Request, ? extends Filter>>>)$setStages$delegate);
    }
}

