/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.chaos;

import com.fasterxml.jackson.databind.JsonNode;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Iterator;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.http4k.chaos.ChaosBehaviours;
import org.http4k.chaos.ChaosBehavioursKt;
import org.http4k.chaos.ChaosEngine;
import org.http4k.chaos.ChaosStages;
import org.http4k.chaos.ChaosStagesKt;
import org.http4k.chaos.ChaosTriggers;
import org.http4k.chaos.RemoteChaosApiKt;
import org.http4k.contract.ContractBuilder;
import org.http4k.contract.ContractRenderer;
import org.http4k.contract.ExtensionsKt;
import org.http4k.contract.RouteMetaDsl;
import org.http4k.contract.openapi.ApiInfo;
import org.http4k.contract.openapi.v3.JacksonExtKt;
import org.http4k.contract.security.NoSecurity;
import org.http4k.contract.security.Security;
import org.http4k.core.Body;
import org.http4k.core.Filter;
import org.http4k.core.Http4kKt;
import org.http4k.core.HttpKt;
import org.http4k.core.HttpMessage;
import org.http4k.core.Method;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.http4k.core.Status;
import org.http4k.filter.CorsPolicy;
import org.http4k.filter.ServerFilters;
import org.http4k.format.Jackson;
import org.http4k.format.Json;
import org.http4k.lens.BodyLens;
import org.http4k.routing.RoutingHttpHandler;
import org.http4k.routing.RoutingKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JM\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\t2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\tH\u0086\u0002R\u001b\u0010\u0012\u001a\u00020\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0018\u00b2\u0006\u001e\u0010\u0019\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u001c\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u001b0\u001aX\u008a\u0084\u0002"}, d2={"Lorg/http4k/chaos/RemoteChaosApi;", "", "<init>", "()V", "invoke", "Lorg/http4k/routing/RoutingHttpHandler;", "engine", "Lorg/http4k/chaos/ChaosEngine;", "controlsPath", "", "chaosSecurity", "Lorg/http4k/contract/security/Security;", "openApiPath", "corsPolicy", "Lorg/http4k/filter/CorsPolicy;", "clock", "Ljava/time/Clock;", "apiName", "exampleChaos", "Lcom/fasterxml/jackson/databind/JsonNode;", "getExampleChaos", "()Lcom/fasterxml/jackson/databind/JsonNode;", "exampleChaos$delegate", "Lkotlin/Lazy;", "http4k-testing-chaos", "setStages", "Lorg/http4k/lens/BodyLens;", "Lkotlin/Function1;", "Lorg/http4k/core/Request;", "Lorg/http4k/core/Filter;"})
@SourceDebugExtension(value={"SMAP\nRemoteChaosApi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteChaosApi.kt\norg/http4k/chaos/RemoteChaosApi\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,217:1\n2210#2,7:218\n*S KotlinDebug\n*F\n+ 1 RemoteChaosApi.kt\norg/http4k/chaos/RemoteChaosApi\n*L\n87#1:218,7\n*E\n"})
public final class RemoteChaosApi {
    @NotNull
    public static final RemoteChaosApi INSTANCE = new RemoteChaosApi();
    @NotNull
    private static final Lazy exampleChaos$delegate = LazyKt.lazy(RemoteChaosApi::exampleChaos_delegate$lambda$21);

    private RemoteChaosApi() {
    }

    @NotNull
    public final RoutingHttpHandler invoke(@NotNull ChaosEngine engine, @NotNull String controlsPath, @NotNull Security chaosSecurity, @NotNull String openApiPath, @NotNull CorsPolicy corsPolicy, @NotNull Clock clock, @NotNull String apiName) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Intrinsics.checkNotNullParameter((Object)controlsPath, (String)"controlsPath");
        Intrinsics.checkNotNullParameter((Object)chaosSecurity, (String)"chaosSecurity");
        Intrinsics.checkNotNullParameter((Object)openApiPath, (String)"openApiPath");
        Intrinsics.checkNotNullParameter((Object)corsPolicy, (String)"corsPolicy");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)apiName, (String)"apiName");
        Lazy setStages$delegate = LazyKt.lazy(() -> RemoteChaosApi.invoke$lambda$3(clock));
        Function1 showCurrentStatus = arg_0 -> RemoteChaosApi.invoke$lambda$5(engine, arg_0);
        Filter activate = arg_0 -> RemoteChaosApi.invoke$lambda$7(engine, setStages$delegate, arg_0);
        Filter deactivate = arg_0 -> RemoteChaosApi.invoke$lambda$9(engine, arg_0);
        Filter toggle = arg_0 -> RemoteChaosApi.invoke$lambda$12(engine, arg_0);
        String apiDescription = StringsKt.trimMargin$default((String)("This is the Open API interface for the " + apiName + " Chaos Engine. \n            |\n            |Using this UI you can inject new dynamic chaotic behaviour into any http4k application, or toggle/disable it. \n            |\n            |See the <a href=\"https://http4k.org/guide/reference/chaos/\">user guide</a> for details about the \n            | exact format of the JSON to post to the activation endpoint."), null, (int)1, null);
        String currentChaosDescription = ChaosStages.INSTANCE.Repeat((Function0<? extends Function1<? super Request, ? extends Filter>>)((Function0)() -> RemoteChaosApi.invoke$lambda$13(clock))).toString();
        return RoutingKt.bind((String)controlsPath, (RoutingHttpHandler)Http4kKt.then((Filter)Http4kKt.then((Filter)ServerFilters.Cors.INSTANCE.invoke(corsPolicy), (Filter)ServerFilters.CatchAll.invoke$default((ServerFilters.CatchAll)ServerFilters.CatchAll.INSTANCE, null, (int)1, null)), (RoutingHttpHandler)((RoutingHttpHandler)ExtensionsKt.contract(arg_0 -> RemoteChaosApi.invoke$lambda$19(apiName, apiDescription, openApiPath, chaosSecurity, showCurrentStatus, activate, deactivate, toggle, currentChaosDescription, arg_0)))));
    }

    public static /* synthetic */ RoutingHttpHandler invoke$default(RemoteChaosApi remoteChaosApi, ChaosEngine chaosEngine, String string, Security security, String string2, CorsPolicy corsPolicy, Clock clock, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string = "/chaos";
        }
        if ((n & 4) != 0) {
            security = (Security)NoSecurity.INSTANCE;
        }
        if ((n & 8) != 0) {
            string2 = "";
        }
        if ((n & 0x10) != 0) {
            corsPolicy = CorsPolicy.Companion.getUnsafeGlobalPermissive();
        }
        if ((n & 0x20) != 0) {
            clock = Clock.systemUTC();
        }
        if ((n & 0x40) != 0) {
            string3 = "http4k";
        }
        return remoteChaosApi.invoke(chaosEngine, string, security, string2, corsPolicy, clock, string3);
    }

    private final JsonNode getExampleChaos() {
        Lazy lazy = exampleChaos$delegate;
        return (JsonNode)lazy.getValue();
    }

    private static final Function1 invoke$lambda$3$lambda$2$lambda$0(Clock $clock, JsonNode it) {
        Intrinsics.checkNotNull((Object)it);
        return ChaosStagesKt.asStage(it, $clock);
    }

    /*
     * WARNING - void declaration
     */
    private static final Function1 invoke$lambda$3$lambda$2(Clock $clock, JsonNode node) {
        Sequence sequence;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (node.isArray()) {
            Iterator iterator = node.elements();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"elements(...)");
            sequence = SequencesKt.asSequence((Iterator)iterator);
        } else {
            Object[] objectArray = new JsonNode[]{node};
            sequence = SequencesKt.sequenceOf((Object[])objectArray);
        }
        Sequence $this$reduce$iv = SequencesKt.map((Sequence)sequence, arg_0 -> RemoteChaosApi.invoke$lambda$3$lambda$2$lambda$0($clock, arg_0));
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty sequence can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void next;
            Function1 function1 = (Function1)iterator$iv.next();
            Function1 acc = (Function1)accumulator$iv;
            boolean bl = false;
            accumulator$iv = ChaosStagesKt.then((Function1<? super Request, ? extends Filter>)acc, (Function1<? super Request, ? extends Filter>)next);
        }
        return (Function1)accumulator$iv;
    }

    private static final BodyLens invoke$lambda$3(Clock $clock) {
        return Json.DefaultImpls.json$default((Json)((Json)Jackson.INSTANCE), (Body.Companion)Body.Companion, null, null, (int)3, null).map(arg_0 -> RemoteChaosApi.invoke$lambda$3$lambda$2($clock, arg_0)).toLens();
    }

    private static final BodyLens<Function1<Request, Filter>> invoke$lambda$4(Lazy<? extends BodyLens<? extends Function1<? super Request, ? extends Filter>>> $setStages$delegate) {
        Lazy<? extends BodyLens<? extends Function1<? super Request, ? extends Filter>>> lazy = $setStages$delegate;
        return (BodyLens)lazy.getValue();
    }

    private static final Response invoke$lambda$5(ChaosEngine $engine, Request it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Function1[] function1Array = new Function1[]{Json.DefaultImpls.json$default((Json)((Json)Jackson.INSTANCE), (Body.Companion)Body.Companion, null, null, (int)3, null).toLens().of((Object)RemoteChaosApiKt.access$chaosStatus($engine.isEnabled() ? $engine.toString() : "none"))};
        return (Response)HttpKt.with((HttpMessage)((HttpMessage)Response.Companion.create$default((Response.Companion)Response.Companion, (Status)Status.OK, null, (int)2, null)), (Function1[])function1Array);
    }

    private static final Response invoke$lambda$7$lambda$6(ChaosEngine $engine, Function1 $next, Lazy $setStages$delegate, Request it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ChaosEngine chaosEngine = ((CharSequence)it.bodyString()).length() > 0 ? $engine.enable((Function1<? super Request, ? extends Filter>)((Function1)RemoteChaosApi.invoke$lambda$4((Lazy<? extends BodyLens<? extends Function1<? super Request, ? extends Filter>>>)$setStages$delegate).invoke((HttpMessage)it))) : $engine.enable();
        return (Response)$next.invoke((Object)it);
    }

    private static final Function1 invoke$lambda$7(ChaosEngine $engine, Lazy $setStages$delegate, Function1 next) {
        Intrinsics.checkNotNullParameter((Object)next, (String)"next");
        return arg_0 -> RemoteChaosApi.invoke$lambda$7$lambda$6($engine, next, $setStages$delegate, arg_0);
    }

    private static final Response invoke$lambda$9$lambda$8(ChaosEngine $engine, Function1 $next, Request it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $engine.disable();
        return (Response)$next.invoke((Object)it);
    }

    private static final Function1 invoke$lambda$9(ChaosEngine $engine, Function1 next) {
        Intrinsics.checkNotNullParameter((Object)next, (String)"next");
        return arg_0 -> RemoteChaosApi.invoke$lambda$9$lambda$8($engine, next, arg_0);
    }

    private static final Response invoke$lambda$12$lambda$11(ChaosEngine $engine, Function1 $next, Request it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ChaosEngine $this$invoke_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410 = $engine;
        boolean bl = false;
        ChaosEngine chaosEngine = $this$invoke_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410.isEnabled() ? $this$invoke_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410.disable() : $this$invoke_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410.enable();
        return (Response)$next.invoke((Object)it);
    }

    private static final Function1 invoke$lambda$12(ChaosEngine $engine, Function1 next) {
        Intrinsics.checkNotNullParameter((Object)next, (String)"next");
        return arg_0 -> RemoteChaosApi.invoke$lambda$12$lambda$11($engine, next, arg_0);
    }

    private static final Function1 invoke$lambda$13(Clock $clock) {
        Function1 function1 = ChaosStages.Wait.INSTANCE;
        Duration duration = Duration.ofMinutes(1L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMinutes(...)");
        Function1<Request, Filter> function12 = ChaosStagesKt.until((Function1<? super Request, ? extends Filter>)function1, ChaosTriggers.Delay.INSTANCE.invoke(duration, $clock));
        Function1<Request, Filter> function13 = ChaosBehavioursKt.appliedWhen(ChaosBehaviours.ReturnStatus.INSTANCE.invoke(Status.I_M_A_TEAPOT), ChaosTriggers.Always.INSTANCE.invoke());
        Instant instant = Instant.ofEpochSecond(1735689600L);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"ofEpochSecond(...)");
        return ChaosStagesKt.then(function12, ChaosStagesKt.until(function13, ChaosTriggers.Deadline.invoke$default(ChaosTriggers.Deadline.INSTANCE, instant, null, 2, null)));
    }

    private static final void invoke$returningExampleChaosDescription(RouteMetaDsl $this$invoke_u24returningExampleChaosDescription, String currentChaosDescription) {
        RouteMetaDsl.returningStatus$default((RouteMetaDsl)$this$invoke_u24returningExampleChaosDescription, (Status)Status.OK, (Pair)TuplesKt.to((Object)Json.DefaultImpls.json$default((Json)((Json)Jackson.INSTANCE), (Body.Companion)Body.Companion, null, null, (int)3, null).toLens(), (Object)RemoteChaosApiKt.access$chaosStatus(currentChaosDescription)), (String)"The current Chaos being applied to requests.", null, null, (int)24, null);
    }

    private static final Unit invoke$lambda$19$lambda$14(String $currentChaosDescription, RouteMetaDsl $this$meta) {
        Intrinsics.checkNotNullParameter((Object)$this$meta, (String)"$this$meta");
        $this$meta.setSummary("Show the current Chaos being applied.");
        $this$meta.setDescription("Returns a textual description of the current Chaos behaviour being applied to traffic.");
        RemoteChaosApi.invoke$returningExampleChaosDescription($this$meta, $currentChaosDescription);
        return Unit.INSTANCE;
    }

    private static final Unit invoke$lambda$19$lambda$15(String $currentChaosDescription, RouteMetaDsl $this$meta) {
        Intrinsics.checkNotNullParameter((Object)$this$meta, (String)"$this$meta");
        $this$meta.setSummary("Activate new Chaos on all routes.");
        $this$meta.setDescription("Replace the current Chaos being applied to traffic and activates that behaviour.");
        RouteMetaDsl.receiving$default((RouteMetaDsl)$this$meta, (Pair)TuplesKt.to((Object)Json.DefaultImpls.json$default((Json)((Json)Jackson.INSTANCE), (Body.Companion)Body.Companion, null, null, (int)3, null).toLens(), (Object)INSTANCE.getExampleChaos()), null, null, (int)6, null);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Status.BAD_REQUEST, (Object)"New Chaos could not be deserialised from the request body.")};
        $this$meta.returningStatus(pairArray);
        RemoteChaosApi.invoke$returningExampleChaosDescription($this$meta, $currentChaosDescription);
        return Unit.INSTANCE;
    }

    private static final Unit invoke$lambda$19$lambda$16(String $currentChaosDescription, RouteMetaDsl $this$meta) {
        Intrinsics.checkNotNullParameter((Object)$this$meta, (String)"$this$meta");
        $this$meta.setSummary("Activate Chaos on all routes.");
        $this$meta.setDescription("Toggles on the previously stored Chaos behaviour.");
        RemoteChaosApi.invoke$returningExampleChaosDescription($this$meta, $currentChaosDescription);
        return Unit.INSTANCE;
    }

    private static final Unit invoke$lambda$19$lambda$17(String $currentChaosDescription, RouteMetaDsl $this$meta) {
        Intrinsics.checkNotNullParameter((Object)$this$meta, (String)"$this$meta");
        $this$meta.setSummary("Deactivate Chaos on all routes.");
        $this$meta.setDescription("Toggles off the previously stored Chaos behaviour.");
        RemoteChaosApi.invoke$returningExampleChaosDescription($this$meta, $currentChaosDescription);
        return Unit.INSTANCE;
    }

    private static final Unit invoke$lambda$19$lambda$18(String $currentChaosDescription, RouteMetaDsl $this$meta) {
        Intrinsics.checkNotNullParameter((Object)$this$meta, (String)"$this$meta");
        $this$meta.setSummary("Toggle on/off the Chaos on all routes.");
        $this$meta.setDescription("Toggles the previously stored Chaos behaviour.");
        RemoteChaosApi.invoke$returningExampleChaosDescription($this$meta, $currentChaosDescription);
        return Unit.INSTANCE;
    }

    private static final Unit invoke$lambda$19(String $apiName, String $apiDescription, String $openApiPath, Security $chaosSecurity, Function1 $showCurrentStatus, Filter $activate, Filter $deactivate, Filter $toggle, String $currentChaosDescription, ContractBuilder $this$contract) {
        Intrinsics.checkNotNullParameter((Object)$this$contract, (String)"$this$contract");
        $this$contract.setRenderer((ContractRenderer)JacksonExtKt.OpenApi3$default((ApiInfo)new ApiInfo($apiName + " Chaos Engine", "1.0", $apiDescription), null, null, null, null, null, (int)62, null));
        $this$contract.setDescriptionPath($openApiPath);
        $this$contract.setSecurity($chaosSecurity);
        $this$contract.getRoutes().plusAssign((Object)ExtensionsKt.meta((String)"/status", arg_0 -> RemoteChaosApi.invoke$lambda$19$lambda$14($currentChaosDescription, arg_0)).bindContract(Method.GET).to($showCurrentStatus));
        $this$contract.getRoutes().plusAssign((Object)ExtensionsKt.meta((String)"/activate/new", arg_0 -> RemoteChaosApi.invoke$lambda$19$lambda$15($currentChaosDescription, arg_0)).bindContract(Method.POST).to(Http4kKt.then((Filter)$activate, (Function1)$showCurrentStatus)));
        $this$contract.getRoutes().plusAssign((Object)ExtensionsKt.meta((String)"/activate", arg_0 -> RemoteChaosApi.invoke$lambda$19$lambda$16($currentChaosDescription, arg_0)).bindContract(Method.POST).to(Http4kKt.then((Filter)$activate, (Function1)$showCurrentStatus)));
        $this$contract.getRoutes().plusAssign((Object)ExtensionsKt.meta((String)"/deactivate", arg_0 -> RemoteChaosApi.invoke$lambda$19$lambda$17($currentChaosDescription, arg_0)).bindContract(Method.POST).to(Http4kKt.then((Filter)$deactivate, (Function1)$showCurrentStatus)));
        $this$contract.getRoutes().plusAssign((Object)ExtensionsKt.meta((String)"/toggle", arg_0 -> RemoteChaosApi.invoke$lambda$19$lambda$18($currentChaosDescription, arg_0)).bindContract(Method.POST).to(Http4kKt.then((Filter)$toggle, (Function1)$showCurrentStatus)));
        return Unit.INSTANCE;
    }

    private static final JsonNode exampleChaos_delegate$lambda$21$lambda$20(Json $this$Jackson) {
        Intrinsics.checkNotNullParameter((Object)$this$Jackson, (String)"$this$Jackson");
        Pair[] pairArray = new Pair[3];
        pairArray[0] = TuplesKt.to((Object)"type", (Object)$this$Jackson.string("repeat"));
        Object[] objectArray = new JsonNode[2];
        Pair[] pairArray2 = new Pair[2];
        pairArray2[0] = TuplesKt.to((Object)"type", (Object)$this$Jackson.string("wait"));
        Pair[] pairArray3 = new Pair[]{TuplesKt.to((Object)"type", (Object)$this$Jackson.string("delay")), TuplesKt.to((Object)"period", (Object)$this$Jackson.string("PT30S"))};
        pairArray2[1] = TuplesKt.to((Object)"until", (Object)$this$Jackson.obj(pairArray3));
        objectArray[0] = $this$Jackson.obj(pairArray2);
        pairArray2 = new Pair[4];
        pairArray2[0] = TuplesKt.to((Object)"type", (Object)$this$Jackson.string("trigger"));
        pairArray3 = new Pair[]{TuplesKt.to((Object)"type", (Object)$this$Jackson.string("status")), TuplesKt.to((Object)"status", (Object)$this$Jackson.number(418))};
        pairArray2[1] = TuplesKt.to((Object)"behaviour", (Object)$this$Jackson.obj(pairArray3));
        pairArray3 = new Pair[]{TuplesKt.to((Object)"type", (Object)$this$Jackson.string("always"))};
        pairArray2[2] = TuplesKt.to((Object)"trigger", (Object)$this$Jackson.obj(pairArray3));
        pairArray3 = new Pair[]{TuplesKt.to((Object)"type", (Object)$this$Jackson.string("countdown")), TuplesKt.to((Object)"count", (Object)$this$Jackson.number(10))};
        pairArray2[3] = TuplesKt.to((Object)"until", (Object)$this$Jackson.obj(pairArray3));
        objectArray[1] = $this$Jackson.obj(pairArray2);
        pairArray[1] = TuplesKt.to((Object)"stages", (Object)$this$Jackson.array((Iterable)CollectionsKt.listOf((Object[])objectArray)));
        objectArray = new Pair[]{TuplesKt.to((Object)"type", (Object)$this$Jackson.string("deadline")), TuplesKt.to((Object)"endTime", (Object)$this$Jackson.string("2030-01-01T00:00:00Z"))};
        pairArray[2] = TuplesKt.to((Object)"until", (Object)$this$Jackson.obj((Pair[])objectArray));
        return (JsonNode)$this$Jackson.array((Iterable)CollectionsKt.listOf((Object)$this$Jackson.obj(pairArray)));
    }

    private static final JsonNode exampleChaos_delegate$lambda$21() {
        return (JsonNode)Jackson.INSTANCE.invoke(RemoteChaosApi::exampleChaos_delegate$lambda$21$lambda$20);
    }
}

