/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.tracing.renderer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.http4k.core.Status;
import org.http4k.tracing.Actor;
import org.http4k.tracing.ActorType;
import org.http4k.tracing.BiDirectional;
import org.http4k.tracing.FireAndForget;
import org.http4k.tracing.RequestResponse;
import org.http4k.tracing.StartInteraction;
import org.http4k.tracing.Trace;
import org.http4k.tracing.TraceRender;
import org.http4k.tracing.TraceRenderer;
import org.http4k.tracing.TraceStep;
import org.http4k.tracing.renderer.PumlSequenceDiagram;
import org.http4k.tracing.renderer.UtilKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\f\u0010\n\u001a\u00020\u0006*\u00020\u000bH\u0002J\f\u0010\n\u001a\u00020\u0006*\u00020\fH\u0002J\f\u0010\n\u001a\u00020\u0006*\u00020\rH\u0002J\f\u0010\n\u001a\u00020\u0006*\u00020\u000eH\u0002J\f\u0010\n\u001a\u00020\u0006*\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\b*\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\f\u0010\u0013\u001a\u00020\u0006*\u00020\u0006H\u0002J\f\u0010\u0014\u001a\u00020\u0006*\u00020\u0006H\u0002J\f\u0010\u0015\u001a\u00020\u0016*\u00020\u0006H\u0002\u00a8\u0006\u0017"}, d2={"Lorg/http4k/tracing/renderer/PumlSequenceDiagram;", "Lorg/http4k/tracing/TraceRenderer;", "()V", "render", "Lorg/http4k/tracing/TraceRender;", "scenarioName", "", "steps", "", "Lorg/http4k/tracing/TraceStep;", "asPumlSequenceDiagram", "Lorg/http4k/tracing/BiDirectional;", "Lorg/http4k/tracing/FireAndForget;", "Lorg/http4k/tracing/RequestResponse;", "Lorg/http4k/tracing/StartInteraction;", "Lorg/http4k/tracing/Trace;", "toActor", "", "Lorg/http4k/tracing/Actor;", "toArrow", "toColour", "toStatus", "Lorg/http4k/core/Status;", "http4k-testing-tracerbullet"})
@SourceDebugExtension(value={"SMAP\nPumlSequenceDiagram.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PumlSequenceDiagram.kt\norg/http4k/tracing/renderer/PumlSequenceDiagram\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,121:1\n800#2,11:122\n1789#2,3:133\n429#3:136\n502#3,5:137\n*S KotlinDebug\n*F\n+ 1 PumlSequenceDiagram.kt\norg/http4k/tracing/renderer/PumlSequenceDiagram\n*L\n19#1:122,11\n42#1:133,3\n117#1:136\n117#1:137,5\n*E\n"})
public final class PumlSequenceDiagram
implements TraceRenderer {
    @NotNull
    public static final PumlSequenceDiagram INSTANCE = new PumlSequenceDiagram();

    private PumlSequenceDiagram() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public TraceRender render(@NotNull String scenarioName, @NotNull List<? extends TraceStep> steps) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)scenarioName, (String)"scenarioName");
        Intrinsics.checkNotNullParameter(steps, (String)"steps");
        Iterable $this$filterIsInstance$iv = steps;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof Trace)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List<Actor> actors = UtilKt.chronologicalActors((List)destination$iv$iv);
        return new TraceRender(scenarioName + " - Sequence", "PUML", StringsKt.trimMargin$default((String)("@startuml\n            |title " + scenarioName + "\n            |" + CollectionsKt.joinToString$default((Iterable)this.toActor((Iterable<Actor>)actors), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null) + "\n            |" + CollectionsKt.joinToString$default((Iterable)steps, (CharSequence)"\n", null, null, (int)0, null, (Function1)render.1.INSTANCE, (int)30, null) + "\n@enduml"), null, (int)1, null));
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> toActor(Iterable<Actor> $this$toActor) {
        void $this$fold$iv;
        Iterable<Actor> iterable = $this$toActor;
        List initial$iv = CollectionsKt.emptyList();
        boolean $i$f$fold = false;
        List accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void next;
            Actor actor = (Actor)element$iv;
            List acc = accumulator$iv;
            boolean bl = false;
            String nextVal = (WhenMappings.$EnumSwitchMapping$0[next.getType().ordinal()] == 1 ? "database" : "participant") + " \"" + next.getName() + '\"';
            accumulator$iv = acc.contains(nextVal) ? acc : CollectionsKt.plus((Collection)acc, (Object)nextVal);
        }
        return accumulator$iv;
    }

    private final String asPumlSequenceDiagram(Trace $this$asPumlSequenceDiagram) {
        String string;
        Trace trace = $this$asPumlSequenceDiagram;
        if (trace instanceof RequestResponse) {
            string = this.asPumlSequenceDiagram((RequestResponse)$this$asPumlSequenceDiagram);
        } else if (trace instanceof BiDirectional) {
            string = this.asPumlSequenceDiagram((BiDirectional)$this$asPumlSequenceDiagram);
        } else if (trace instanceof FireAndForget) {
            string = this.asPumlSequenceDiagram((FireAndForget)$this$asPumlSequenceDiagram);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    private final String asPumlSequenceDiagram(RequestResponse $this$asPumlSequenceDiagram) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n           |\"").append($this$asPumlSequenceDiagram.getOrigin().getName()).append("\" -> \"").append($this$asPumlSequenceDiagram.getTarget().getName()).append("\": ").append($this$asPumlSequenceDiagram.getRequest()).append("\n           |activate \"").append($this$asPumlSequenceDiagram.getTarget().getName()).append("\"\n           |").append(CollectionsKt.joinToString$default((Iterable)$this$asPumlSequenceDiagram.getChildren(), (CharSequence)"\n", null, null, (int)0, null, (Function1)asPumlSequenceDiagram.1.INSTANCE, (int)30, null)).append("\n           |\"").append($this$asPumlSequenceDiagram.getTarget().getName()).append("\" ").append(this.toArrow($this$asPumlSequenceDiagram.getResponse())).append(" \"").append($this$asPumlSequenceDiagram.getOrigin().getName()).append("\": ").append(this.toColour($this$asPumlSequenceDiagram.getResponse())).append(' ').append($this$asPumlSequenceDiagram.getResponse()).append("\n           |deactivate \"").append($this$asPumlSequenceDiagram.getTarget().getName()).append("\"\n            ");
        return StringsKt.trimMargin$default((String)stringBuilder.toString(), null, (int)1, null);
    }

    private final String toColour(String $this$toColour) {
        String string;
        try {
            Status $this$toColour_u24lambda_u241 = this.toStatus($this$toColour);
            boolean bl = false;
            string = $this$toColour_u24lambda_u241.getSuccessful() ? "<color:DarkGreen>" : ($this$toColour_u24lambda_u241.getRedirection() ? "<color:DarkBlue>" : ($this$toColour_u24lambda_u241.getClientError() ? "<color:DarkOrange>" : ($this$toColour_u24lambda_u241.getServerError() ? "<color:FireBrick>" : "<color:Black>")));
        }
        catch (Exception e) {
            string = "<color:Black>>";
        }
        return string;
    }

    private final String asPumlSequenceDiagram(BiDirectional $this$asPumlSequenceDiagram) {
        return StringsKt.trimMargin$default((String)("\n           |\"" + $this$asPumlSequenceDiagram.getOrigin().getName() + "\" <-> \"" + $this$asPumlSequenceDiagram.getTarget().getName() + "\": " + $this$asPumlSequenceDiagram.getRequest() + (!((Collection)$this$asPumlSequenceDiagram.getChildren()).isEmpty() ? "|activate \"" + $this$asPumlSequenceDiagram.getTarget().getName() + "\"\n           |" + CollectionsKt.joinToString$default((Iterable)$this$asPumlSequenceDiagram.getChildren(), (CharSequence)"\n", null, null, (int)0, null, (Function1)asPumlSequenceDiagram.2.INSTANCE, (int)30, null) + "\n           |deactivate \"" + $this$asPumlSequenceDiagram.getTarget().getName() : "")), null, (int)1, null);
    }

    private final String asPumlSequenceDiagram(FireAndForget $this$asPumlSequenceDiagram) {
        return StringsKt.trimMargin$default((String)("\n           |\"" + $this$asPumlSequenceDiagram.getOrigin().getName() + "\" -> \"" + $this$asPumlSequenceDiagram.getTarget().getName() + "\": " + $this$asPumlSequenceDiagram.getRequest() + (!((Collection)$this$asPumlSequenceDiagram.getChildren()).isEmpty() ? "\n           |" + CollectionsKt.joinToString$default((Iterable)$this$asPumlSequenceDiagram.getChildren(), (CharSequence)"\n", null, null, (int)0, null, (Function1)asPumlSequenceDiagram.3.INSTANCE, (int)30, null) : "")), null, (int)1, null);
    }

    private final String asPumlSequenceDiagram(StartInteraction $this$asPumlSequenceDiagram) {
        return StringsKt.trimIndent((String)("\n\n    note over \"" + $this$asPumlSequenceDiagram.getOrigin() + "\" : \"" + $this$asPumlSequenceDiagram.getOrigin() + "\" " + $this$asPumlSequenceDiagram.getInteractionName() + "\n    "));
    }

    private final String toArrow(String $this$toArrow) {
        String string;
        try {
            Status $this$toArrow_u24lambda_u242 = this.toStatus($this$toArrow);
            boolean bl = false;
            string = $this$toArrow_u24lambda_u242.getSuccessful() ? "-[#DarkGreen]>" : ($this$toArrow_u24lambda_u242.getRedirection() ? "-[#DarkBlue]>" : ($this$toArrow_u24lambda_u242.getClientError() ? "X-[#DarkOrange]>" : ($this$toArrow_u24lambda_u242.getServerError() ? "X-[#FireBrick]>" : "-[#Black]>")));
        }
        catch (Exception e) {
            string = "-->";
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final Status toStatus(String $this$toStatus) {
        void $this$filterTo$iv$iv;
        String[] stringArray = new String[]{" "};
        String $this$filter$iv = (String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)$this$toStatus, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        boolean $i$f$filter = false;
        CharSequence charSequence = $this$filter$iv;
        Appendable destination$iv$iv = new StringBuilder();
        boolean $i$f$filterTo = false;
        int n = $this$filterTo$iv$iv.length();
        for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
            char element$iv$iv;
            char p0 = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            if (!Character.isDigit(p0)) continue;
            destination$iv$iv.append(element$iv$iv);
        }
        String string = ((StringBuilder)destination$iv$iv).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        stringArray = new String[]{" "};
        String string2 = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)$this$toStatus, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        int n2 = Integer.parseInt(string);
        return new Status(n2, string2);
    }

    public static final /* synthetic */ String access$asPumlSequenceDiagram(PumlSequenceDiagram $this, RequestResponse $receiver) {
        return $this.asPumlSequenceDiagram($receiver);
    }

    public static final /* synthetic */ String access$asPumlSequenceDiagram(PumlSequenceDiagram $this, BiDirectional $receiver) {
        return $this.asPumlSequenceDiagram($receiver);
    }

    public static final /* synthetic */ String access$asPumlSequenceDiagram(PumlSequenceDiagram $this, FireAndForget $receiver) {
        return $this.asPumlSequenceDiagram($receiver);
    }

    public static final /* synthetic */ String access$asPumlSequenceDiagram(PumlSequenceDiagram $this, StartInteraction $receiver) {
        return $this.asPumlSequenceDiagram($receiver);
    }

    public static final /* synthetic */ String access$asPumlSequenceDiagram(PumlSequenceDiagram $this, Trace $receiver) {
        return $this.asPumlSequenceDiagram($receiver);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ActorType.values().length];
            try {
                nArray[ActorType.Database.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

