/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.tracing.persistence;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.http4k.core.Uri;
import org.http4k.format.AutoMarshalling;
import org.http4k.tracing.ScenarioTraces;
import org.http4k.tracing.TraceLoader;
import org.http4k.tracing.TracePersistence;
import org.http4k.tracing.TraceRender;
import org.http4k.tracing.TraceRenderPersistence;
import org.http4k.tracing.persistence.FilesystemKt;
import org.http4k.tracing.persistence.TraceMoshi;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010\u0000\u001a\u00020\u0005*\u00020\u00062\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\u0007\u001a\u00020\b*\u00020\t2\u0006\u0010\n\u001a\u00020\u0004\u00a8\u0006\u000b"}, d2={"FileSystem", "Lorg/http4k/tracing/TracePersistence;", "Lorg/http4k/tracing/TracePersistence$Companion;", "dir", "Ljava/io/File;", "Lorg/http4k/tracing/TraceRenderPersistence;", "Lorg/http4k/tracing/TraceRenderPersistence$Companion;", "DirectoryTree", "Lorg/http4k/tracing/TraceLoader;", "Lorg/http4k/tracing/TraceLoader$Companion;", "start", "http4k-testing-tracerbullet"})
@SourceDebugExtension(value={"SMAP\nfilesystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 filesystem.kt\norg/http4k/tracing/persistence/FilesystemKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,50:1\n1#2:51\n*E\n"})
public final class FilesystemKt {
    @NotNull
    public static final TracePersistence FileSystem(@NotNull TracePersistence.Companion $this$FileSystem, @NotNull File dir) {
        Intrinsics.checkNotNullParameter((Object)$this$FileSystem, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        return new TracePersistence(dir){
            private final String TRACE_SUFFIX;
            final /* synthetic */ File $dir;
            {
                this.$dir = $dir;
                this.TRACE_SUFFIX = ".trace.json";
            }

            public void store(ScenarioTraces trace) {
                File file;
                Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
                File $this$store_u24lambda_u240 = file = this.$dir;
                boolean bl = false;
                $this$store_u24lambda_u240.mkdirs();
                String string = trace.getName() + this.TRACE_SUFFIX;
                File file2 = file;
                FilesKt.writeText$default((File)new File(file2, string), (String)TraceMoshi.INSTANCE.prettify(TraceMoshi.INSTANCE.asFormatString(trace)), null, (int)2, null);
            }

            /*
             * WARNING - void declaration
             */
            public List<ScenarioTraces> load() {
                List list;
                String[] stringArray = this.$dir.list();
                if (stringArray != null) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    void $this$filterTo$iv$iv;
                    String[] $this$filter$iv = stringArray;
                    boolean $i$f$filter22 = false;
                    Object object = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo22 = false;
                    int n = ((void)$this$filterTo$iv$iv).length;
                    for (int i = 0; i < n; ++i) {
                        void element$iv$iv;
                        void it = element$iv$iv = $this$filterTo$iv$iv[i];
                        boolean bl = false;
                        Intrinsics.checkNotNull((Object)it);
                        if (!StringsKt.endsWith$default((String)it, (String)this.TRACE_SUFFIX, (boolean)false, (int)2, null)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    Iterable $i$f$filter22 = (List)destination$iv$iv;
                    object = this.$dir;
                    boolean $i$f$map = false;
                    void $i$f$filterTo22 = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void this_$iv;
                        void it;
                        String bl = (String)item$iv$iv;
                        Collection collection = destination$iv$iv2;
                        boolean bl2 = false;
                        AutoMarshalling autoMarshalling = (AutoMarshalling)TraceMoshi.INSTANCE;
                        String input$iv = FilesKt.readText$default((File)new File((File)object, (String)it), null, (int)1, null);
                        boolean $i$f$stringAsA = false;
                        collection.add((ScenarioTraces)this_$iv.asA(input$iv, Reflection.getOrCreateKotlinClass(ScenarioTraces.class)));
                    }
                    list = (List)destination$iv$iv2;
                } else {
                    list = CollectionsKt.emptyList();
                }
                return list;
            }
        };
    }

    public static /* synthetic */ TracePersistence FileSystem$default(TracePersistence.Companion companion, File file, int n, Object object) {
        if ((n & 1) != 0) {
            File file2 = Files.createTempDirectory("", new FileAttribute[0]).toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"toFile(...)");
            file = file2;
        }
        return FilesystemKt.FileSystem(companion, file);
    }

    @NotNull
    public static final TraceRenderPersistence FileSystem(@NotNull TraceRenderPersistence.Companion $this$FileSystem, @NotNull File dir) {
        Intrinsics.checkNotNullParameter((Object)$this$FileSystem, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        return arg_0 -> FilesystemKt.FileSystem$lambda$1(dir, arg_0);
    }

    public static /* synthetic */ TraceRenderPersistence FileSystem$default(TraceRenderPersistence.Companion companion, File file, int n, Object object) {
        if ((n & 1) != 0) {
            File file2 = Files.createTempDirectory("", new FileAttribute[0]).toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"toFile(...)");
            file = file2;
        }
        return FilesystemKt.FileSystem(companion, file);
    }

    @NotNull
    public static final TraceLoader DirectoryTree(@NotNull TraceLoader.Companion $this$DirectoryTree, @NotNull File start) {
        Intrinsics.checkNotNullParameter((Object)$this$DirectoryTree, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        return new TraceLoader(start){
            final /* synthetic */ File $start;
            {
                this.$start = $start;
            }

            public List<ScenarioTraces> load() {
                Iterable $this$sortedBy$iv = SequencesKt.toList((Sequence)SequencesKt.flatMapIterable((Sequence)SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)this.$start)), DirectoryTree.1::load$lambda$0), DirectoryTree.1::load$lambda$1));
                boolean $i$f$sortedBy = false;
                return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        ScenarioTraces it = (ScenarioTraces)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)it.getName());
                        it = (ScenarioTraces)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
                    }
                });
            }

            private static final boolean load$lambda$0(File it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.isDirectory();
            }

            private static final Iterable load$lambda$1(File it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return FilesystemKt.FileSystem(TracePersistence.Companion, it).load();
            }
        };
    }

    private static final Uri FileSystem$lambda$1(File $dir, TraceRender it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = $dir;
        File $this$FileSystem_u24lambda_u241_u24lambda_u240 = object;
        boolean bl = false;
        $this$FileSystem_u24lambda_u241_u24lambda_u240.mkdirs();
        File file = object;
        String string = it.getTitle();
        object = it.getFormat();
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string2 = ((String)object).toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String string3 = string + "." + string2;
        File file2 = file;
        File file3 = new File(file2, string3);
        FilesKt.writeText$default((File)file3, (String)it.getContent(), null, (int)2, null);
        String string4 = file3.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getAbsolutePath(...)");
        return Uri.Companion.of("file:////" + StringsKt.replace$default((String)string4, (String)" ", (String)"%20", (boolean)false, (int)4, null));
    }
}

