/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.webdriver;

import java.net.URL;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.http4k.core.Method;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.http4k.webdriver.FeatureNotImplementedYet;
import org.http4k.webdriver.Page;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0016\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u0002`\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0011\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0096\u0002J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0015H\u0016J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0015H\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0015H\u0016J\n\u0010\u0019\u001a\u0004\u0018\u00010\u0015H\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00150\u001bH\u0016J\n\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010 \u001a\u00020\r2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010#\u001a\u00020\rH\u0016J\b\u0010$\u001a\u00020%H\u0016R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/http4k/webdriver/Http4kWebDriver;", "Lorg/openqa/selenium/WebDriver;", "handler", "Lkotlin/Function1;", "Lorg/http4k/core/Request;", "Lorg/http4k/core/Response;", "Lorg/http4k/core/HttpHandler;", "(Lkotlin/jvm/functions/Function1;)V", "activeElement", "Lorg/openqa/selenium/WebElement;", "current", "Lorg/http4k/webdriver/Page;", "close", "", "findElement", "by", "Lorg/openqa/selenium/By;", "findElements", "", "get", "url", "", "getCurrentUrl", "getPageSource", "getTitle", "getWindowHandle", "getWindowHandles", "", "manage", "Lorg/openqa/selenium/WebDriver$Options;", "navigate", "Lorg/openqa/selenium/WebDriver$Navigation;", "navigateTo", "method", "Lorg/http4k/core/Method;", "quit", "switchTo", "Lorg/openqa/selenium/WebDriver$TargetLocator;", "http4k-testing-webdriver_main"})
public final class Http4kWebDriver
implements WebDriver {
    private Page current;
    private WebElement activeElement;
    private final Function1<Request, Response> handler;

    private final void navigateTo(Method method, String url) {
        Function2 function2 = (Function2)new Function2<Method, String, Unit>(this){

            public final void invoke(@NotNull Method p1, @NotNull String p2) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                Intrinsics.checkParameterIsNotNull((Object)p2, (String)"p2");
                Http4kWebDriver.access$navigateTo((Http4kWebDriver)this.receiver, p1, p2);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(Http4kWebDriver.class);
            }

            public final String getName() {
                return "navigateTo";
            }

            public final String getSignature() {
                return "navigateTo(Lorg/http4k/core/Method;Ljava/lang/String;)V";
            }
        };
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkExpressionValueIsNotNull((Object)uUID, (String)"UUID.randomUUID()");
        this.current = new Page(function2, uUID, url, ((Response)this.handler.invoke((Object)Request.Companion.invoke(method, url))).bodyString(), this.current, null, 32, null);
    }

    public void get(@NotNull String url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        this.navigateTo(Method.GET, url);
    }

    @Nullable
    public String getCurrentUrl() {
        Page page = this.current;
        return page != null ? page.getUrl() : null;
    }

    @Nullable
    public String getTitle() {
        Page page = this.current;
        return page != null ? page.getTitle() : null;
    }

    @Nullable
    public List<WebElement> findElements(@NotNull By by) {
        Intrinsics.checkParameterIsNotNull((Object)by, (String)"by");
        Page page = this.current;
        return page != null ? page.findElements(by) : null;
    }

    @Nullable
    public WebElement findElement(@NotNull By by) {
        Intrinsics.checkParameterIsNotNull((Object)by, (String)"by");
        Object object = this.current;
        return object != null && (object = ((Page)object).findElements(by)) != null ? (WebElement)CollectionsKt.firstOrNull((List)object) : null;
    }

    @Nullable
    public String getPageSource() {
        Page page = this.current;
        return page != null ? page.getContents() : null;
    }

    public void close() {
        this.current = null;
    }

    public void quit() {
        this.current = null;
    }

    @NotNull
    public Set<String> getWindowHandles() {
        Page page;
        Page it;
        Object object = this.current;
        if (object == null || (object = SetsKt.setOf((Object)(it = (page = object)).getHandle().toString())) == null) {
            object = SetsKt.emptySet();
        }
        return object;
    }

    @Nullable
    public String getWindowHandle() {
        return (String)CollectionsKt.firstOrNull((Iterable)this.getWindowHandles());
    }

    @NotNull
    public WebDriver.TargetLocator switchTo() {
        Http4kWebDriver driver = this;
        return new WebDriver.TargetLocator(this, driver){
            final /* synthetic */ Http4kWebDriver this$0;
            final /* synthetic */ Http4kWebDriver $driver;

            @NotNull
            public WebDriver frame(int index) {
                throw (Throwable)new FeatureNotImplementedYet();
            }

            @NotNull
            public WebDriver frame(@Nullable String nameOrId) {
                throw (Throwable)new FeatureNotImplementedYet();
            }

            @NotNull
            public WebDriver frame(@Nullable WebElement frameElement) {
                throw (Throwable)new FeatureNotImplementedYet();
            }

            @NotNull
            public WebDriver parentFrame() {
                throw (Throwable)new FeatureNotImplementedYet();
            }

            @NotNull
            public Alert alert() {
                throw (Throwable)new FeatureNotImplementedYet();
            }

            @NotNull
            public WebElement activeElement() {
                WebElement webElement = Http4kWebDriver.access$getActiveElement$p(this.this$0);
                if (webElement == null) {
                    Page page = Http4kWebDriver.access$getCurrent$p(this.this$0);
                    webElement = page != null ? page.firstElement() : null;
                }
                if (webElement == null) {
                    throw (Throwable)new NoSuchElementException("no page loaded!");
                }
                return webElement;
            }

            @NotNull
            public WebDriver window(@Nullable String nameOrHandle) {
                Object object = Http4kWebDriver.access$getCurrent$p(this.this$0);
                if (Intrinsics.areEqual((Object)(object != null && (object = ((Page)object).getHandle()) != null ? ((UUID)object).toString() : null), (Object)nameOrHandle) ^ true) {
                    throw (Throwable)new NoSuchElementException("window with handle" + nameOrHandle);
                }
                return this.$driver;
            }

            @NotNull
            public WebDriver defaultContent() {
                return this.$driver;
            }
            {
                this.this$0 = $outer;
                this.$driver = $captured_local_variable$1;
            }
        };
    }

    @NotNull
    public WebDriver.Navigation navigate() {
        return new WebDriver.Navigation(this){
            final /* synthetic */ Http4kWebDriver this$0;

            public void to(@NotNull String url) {
                Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
                this.this$0.get(url);
            }

            public void to(@NotNull URL url) {
                Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
                String string = url.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"url.toString()");
                this.this$0.get(string);
            }

            public void forward() {
                block0: {
                    Page page;
                    Page page2 = Http4kWebDriver.access$getCurrent$p(this.this$0);
                    if (page2 == null || (page2 = page2.getNext()) == null) break block0;
                    Page it = page = page2;
                    Http4kWebDriver.access$setCurrent$p(this.this$0, it);
                }
            }

            public void refresh() {
                block0: {
                    Page page;
                    Page page2 = Http4kWebDriver.access$getCurrent$p(this.this$0);
                    if (page2 == null) break block0;
                    Page it = page = page2;
                    Http4kWebDriver.access$setCurrent$p(this.this$0, Page.copy$default(it, null, null, null, ((Response)Http4kWebDriver.access$getHandler$p(this.this$0).invoke((Object)Request.Companion.invoke(Method.GET, it.getUrl()))).bodyString(), null, null, 55, null));
                }
            }

            public void back() {
                block0: {
                    Page page;
                    Page page2 = Http4kWebDriver.access$getCurrent$p(this.this$0);
                    if (page2 == null || (page2 = page2.getPrevious()) == null) break block0;
                    Page it = page = page2;
                    Http4kWebDriver.access$setCurrent$p(this.this$0, Page.copy$default(it, null, null, null, null, null, Http4kWebDriver.access$getCurrent$p(this.this$0), 31, null));
                }
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    @Nullable
    public WebDriver.Options manage() {
        throw (Throwable)new FeatureNotImplementedYet();
    }

    public Http4kWebDriver(@NotNull Function1<? super Request, ? extends Response> handler) {
        Intrinsics.checkParameterIsNotNull(handler, (String)"handler");
        this.handler = handler;
    }

    public static final /* synthetic */ void access$navigateTo(Http4kWebDriver $this, @NotNull Method method, @NotNull String url) {
        $this.navigateTo(method, url);
    }

    @Nullable
    public static final /* synthetic */ WebElement access$getActiveElement$p(Http4kWebDriver $this) {
        return $this.activeElement;
    }

    public static final /* synthetic */ void access$setActiveElement$p(Http4kWebDriver $this, @Nullable WebElement webElement) {
        $this.activeElement = webElement;
    }

    @Nullable
    public static final /* synthetic */ Page access$getCurrent$p(Http4kWebDriver $this) {
        return $this.current;
    }

    public static final /* synthetic */ void access$setCurrent$p(Http4kWebDriver $this, @Nullable Page page) {
        $this.current = page;
    }

    @NotNull
    public static final /* synthetic */ Function1 access$getHandler$p(Http4kWebDriver $this) {
        return $this.handler;
    }
}

