/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.webdriver;

import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.reflect.KDeclarationContainer;
import kotlin.text.StringsKt;
import org.http4k.core.Method;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.http4k.core.Status;
import org.http4k.core.Uri;
import org.http4k.core.cookie.Cookie;
import org.http4k.core.cookie.CookieExtensionsKt;
import org.http4k.webdriver.FeatureNotImplementedYet;
import org.http4k.webdriver.Page;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0016\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u0002`\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u001a2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0011\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u000eH\u0096\u0002J\n\u0010\u001d\u001a\u0004\u0018\u00010\u000eH\u0016J\n\u0010\u001e\u001a\u0004\u0018\u00010\u000eH\u0016J\n\u0010\u001f\u001a\u0004\u0018\u00010\u000eH\u0016J\n\u0010 \u001a\u0004\u0018\u00010\u000eH\u0016J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000e0\"H\u0016J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\u00152\u0006\u0010(\u001a\u00020\u0004H\u0002J\u000e\u0010)\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020\u000eJ\b\u0010+\u001a\u00020\u0015H\u0016J\b\u0010,\u001a\u00020-H\u0016J\f\u0010.\u001a\u00020\u000f*\u00020/H\u0002R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u00060"}, d2={"Lorg/http4k/webdriver/Http4kWebDriver;", "Lorg/openqa/selenium/WebDriver;", "handler", "Lkotlin/Function1;", "Lorg/http4k/core/Request;", "Lorg/http4k/core/Response;", "Lorg/http4k/core/HttpHandler;", "(Lkotlin/jvm/functions/Function1;)V", "activeElement", "Lorg/openqa/selenium/WebElement;", "current", "Lorg/http4k/webdriver/Page;", "siteCookies", "", "", "Lorg/openqa/selenium/Cookie;", "status", "Lorg/http4k/core/Status;", "getStatus", "()Lorg/http4k/core/Status;", "close", "", "findElement", "by", "Lorg/openqa/selenium/By;", "findElements", "", "get", "url", "getCurrentUrl", "getPageSource", "getTitle", "getWindowHandle", "getWindowHandles", "", "manage", "Lorg/openqa/selenium/WebDriver$Options;", "navigate", "Lorg/openqa/selenium/WebDriver$Navigation;", "navigateTo", "request", "normalized", "path", "quit", "switchTo", "Lorg/openqa/selenium/WebDriver$TargetLocator;", "toWebDriver", "Lorg/http4k/core/cookie/Cookie;", "http4k-testing-webdriver"})
public final class Http4kWebDriver
implements WebDriver {
    private Page current;
    private WebElement activeElement;
    private final Map<String, org.openqa.selenium.Cookie> siteCookies;
    private final Function1<Request, Response> handler;

    /*
     * WARNING - void declaration
     */
    private final void navigateTo(Request request) {
        Request normalizedPath = request.uri(request.getUri().path(this.normalized(request.getUri().getPath())));
        Iterable $receiver$iv = this.siteCookies.entrySet();
        Request accumulator$iv = normalizedPath;
        for (Object element$iv : $receiver$iv) {
            void next;
            Map.Entry entry = (Map.Entry)element$iv;
            Request memo = accumulator$iv;
            String string = (String)next.getKey();
            String string2 = ((org.openqa.selenium.Cookie)next.getValue()).getValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"next.value.value");
            accumulator$iv = CookieExtensionsKt.cookie((Request)memo, (Cookie)new Cookie(string, string2, null, null, null, null, false, false, 252, null));
        }
        Request requestWithCookies = accumulator$iv;
        Response response = (Response)this.handler.invoke((Object)requestWithCookies);
        Iterable $receiver$iv2 = CookieExtensionsKt.cookies((Response)response);
        for (Object element$iv : $receiver$iv2) {
            Cookie it = (Cookie)element$iv;
            this.siteCookies.put(it.getName(), this.toWebDriver(it));
        }
        Status status = response.getStatus();
        Function1 function1 = (Function1)new Function1<Request, Unit>(this){

            public final void invoke(@NotNull Request p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                Http4kWebDriver.access$navigateTo((Http4kWebDriver)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(Http4kWebDriver.class);
            }

            public final String getName() {
                return "navigateTo";
            }

            public final String getSignature() {
                return "navigateTo(Lorg/http4k/core/Request;)V";
            }
        };
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkExpressionValueIsNotNull((Object)uUID, (String)"UUID.randomUUID()");
        this.current = new Page(status, function1, uUID, requestWithCookies.getUri().toString(), response.bodyString(), this.current, null, 64, null);
    }

    @NotNull
    public final String normalized(@NotNull String path) {
        Path path2;
        block4: {
            String string;
            block6: {
                block5: {
                    block3: {
                        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
                        if (!StringsKt.startsWith$default((String)path, (String)"/", (boolean)false, (int)2, null)) break block3;
                        path2 = Paths.get(path, new String[0]);
                        break block4;
                    }
                    string = this.getCurrentUrl();
                    if (string == null) break block5;
                    String string2 = string;
                    String it = string2;
                    String string3 = Uri.Companion.of(it).getPath();
                    String it2 = string3;
                    CharSequence charSequence = it2;
                    String string4 = charSequence.length() == 0 ? "/" : it2;
                    string = string4;
                    if (string4 != null) break block6;
                }
                string = "/";
            }
            String currentPath = string;
            path2 = Paths.get(currentPath, path);
        }
        Path newPath = path2;
        return ((Object)newPath.normalize()).toString();
    }

    private final org.openqa.selenium.Cookie toWebDriver(@NotNull Cookie $receiver) {
        Date date;
        org.openqa.selenium.Cookie cookie;
        org.openqa.selenium.Cookie cookie2 = cookie;
        org.openqa.selenium.Cookie cookie3 = cookie;
        String string = $receiver.getName();
        String string2 = $receiver.getValue();
        String string3 = $receiver.getDomain();
        String string4 = $receiver.getPath();
        LocalDateTime localDateTime = $receiver.getExpires();
        if (localDateTime != null) {
            LocalDateTime localDateTime2 = localDateTime;
            String string5 = string4;
            String string6 = string3;
            String string7 = string2;
            String string8 = string;
            org.openqa.selenium.Cookie cookie4 = cookie2;
            org.openqa.selenium.Cookie cookie5 = cookie3;
            LocalDateTime it = localDateTime2;
            Date date2 = Date.from(it.atZone(ZoneId.systemDefault()).toInstant());
            cookie3 = cookie5;
            cookie2 = cookie4;
            string = string8;
            string2 = string7;
            string3 = string6;
            string4 = string5;
            date = date2;
        } else {
            date = null;
        }
        cookie2(string, string2, string3, string4, date, $receiver.getSecure(), $receiver.getHttpOnly());
        return cookie3;
    }

    public void get(@NotNull String url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        this.navigateTo(Request.Companion.invoke(Method.GET, url).body(""));
    }

    @Nullable
    public String getCurrentUrl() {
        Page page = this.current;
        return page != null ? page.getUrl() : null;
    }

    @Nullable
    public String getTitle() {
        Page page = this.current;
        return page != null ? page.getTitle() : null;
    }

    @Nullable
    public final Status getStatus() {
        Page page = this.current;
        return page != null ? page.getStatus() : null;
    }

    @Nullable
    public List<WebElement> findElements(@NotNull By by) {
        Intrinsics.checkParameterIsNotNull((Object)by, (String)"by");
        Page page = this.current;
        return page != null ? page.findElements(by) : null;
    }

    @Nullable
    public WebElement findElement(@NotNull By by) {
        Intrinsics.checkParameterIsNotNull((Object)by, (String)"by");
        Object object = this.current;
        return object != null && (object = ((Page)object).findElements(by)) != null ? (WebElement)CollectionsKt.firstOrNull((List)object) : null;
    }

    @Nullable
    public String getPageSource() {
        Page page = this.current;
        return page != null ? page.getContents() : null;
    }

    public void close() {
        this.current = null;
    }

    public void quit() {
        this.current = null;
    }

    @NotNull
    public Set<String> getWindowHandles() {
        Page page;
        Page it;
        Object object = this.current;
        if (object == null || (object = SetsKt.setOf((Object)(it = (page = object)).getHandle().toString())) == null) {
            object = SetsKt.emptySet();
        }
        return object;
    }

    @Nullable
    public String getWindowHandle() {
        return (String)CollectionsKt.firstOrNull((Iterable)this.getWindowHandles());
    }

    @NotNull
    public WebDriver.TargetLocator switchTo() {
        Http4kWebDriver driver = this;
        return new WebDriver.TargetLocator(this, driver){
            final /* synthetic */ Http4kWebDriver this$0;
            final /* synthetic */ Http4kWebDriver $driver;

            @NotNull
            public WebDriver frame(int index) {
                throw (Throwable)FeatureNotImplementedYet.INSTANCE;
            }

            @NotNull
            public WebDriver frame(@Nullable String nameOrId) {
                throw (Throwable)FeatureNotImplementedYet.INSTANCE;
            }

            @NotNull
            public WebDriver frame(@Nullable WebElement frameElement) {
                throw (Throwable)FeatureNotImplementedYet.INSTANCE;
            }

            @NotNull
            public WebDriver parentFrame() {
                throw (Throwable)FeatureNotImplementedYet.INSTANCE;
            }

            @NotNull
            public Alert alert() {
                throw (Throwable)FeatureNotImplementedYet.INSTANCE;
            }

            @NotNull
            public WebElement activeElement() {
                WebElement webElement = Http4kWebDriver.access$getActiveElement$p(this.this$0);
                if (webElement == null) {
                    Page page = Http4kWebDriver.access$getCurrent$p(this.this$0);
                    webElement = page != null ? page.firstElement() : null;
                }
                if (webElement == null) {
                    throw (Throwable)new NoSuchElementException("no page loaded!");
                }
                return webElement;
            }

            @NotNull
            public WebDriver window(@Nullable String nameOrHandle) {
                Object object = Http4kWebDriver.access$getCurrent$p(this.this$0);
                if (Intrinsics.areEqual((Object)(object != null && (object = ((Page)object).getHandle()) != null ? ((UUID)object).toString() : null), (Object)nameOrHandle) ^ true) {
                    throw (Throwable)new NoSuchElementException("window with handle" + nameOrHandle);
                }
                return this.$driver;
            }

            @NotNull
            public WebDriver defaultContent() {
                return this.$driver;
            }
            {
                this.this$0 = $outer;
                this.$driver = $captured_local_variable$1;
            }
        };
    }

    @NotNull
    public WebDriver.Navigation navigate() {
        return new WebDriver.Navigation(this){
            final /* synthetic */ Http4kWebDriver this$0;

            public void to(@NotNull String url) {
                Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
                this.this$0.get(url);
            }

            public void to(@NotNull URL url) {
                Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
                String string = url.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"url.toString()");
                this.this$0.get(string);
            }

            public void forward() {
                block0: {
                    Page page;
                    Page page2 = Http4kWebDriver.access$getCurrent$p(this.this$0);
                    if (page2 == null || (page2 = page2.getNext()) == null) break block0;
                    Page it = page = page2;
                    Http4kWebDriver.access$setCurrent$p(this.this$0, it);
                }
            }

            public void refresh() {
                block0: {
                    Page page;
                    Page page2 = Http4kWebDriver.access$getCurrent$p(this.this$0);
                    if (page2 == null) break block0;
                    Page it = page = page2;
                    Http4kWebDriver.access$setCurrent$p(this.this$0, Page.copy$default(it, null, null, null, null, ((Response)Http4kWebDriver.access$getHandler$p(this.this$0).invoke((Object)Request.Companion.invoke(Method.GET, it.getUrl()))).bodyString(), null, null, 111, null));
                }
            }

            public void back() {
                block0: {
                    Page page;
                    Page page2 = Http4kWebDriver.access$getCurrent$p(this.this$0);
                    if (page2 == null || (page2 = page2.getPrevious()) == null) break block0;
                    Page it = page = page2;
                    Http4kWebDriver.access$setCurrent$p(this.this$0, Page.copy$default(it, null, null, null, null, null, null, Http4kWebDriver.access$getCurrent$p(this.this$0), 63, null));
                }
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    @NotNull
    public WebDriver.Options manage() {
        return new WebDriver.Options(this){
            final /* synthetic */ Http4kWebDriver this$0;

            public void addCookie(@NotNull org.openqa.selenium.Cookie cookie) {
                Intrinsics.checkParameterIsNotNull((Object)cookie, (String)"cookie");
                Map map = Http4kWebDriver.access$getSiteCookies$p(this.this$0);
                String string = cookie.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"cookie.name");
                map.put(string, cookie);
            }

            @NotNull
            public Set<org.openqa.selenium.Cookie> getCookies() {
                return CollectionsKt.toSet((Iterable)Http4kWebDriver.access$getSiteCookies$p(this.this$0).values());
            }

            public void deleteCookieNamed(@Nullable String name) {
                Map map;
                Map map2 = map = Http4kWebDriver.access$getSiteCookies$p(this.this$0);
                if (map2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableMap<K, V>");
                }
                TypeIntrinsics.asMutableMap((Object)map2).remove(name);
            }

            @Nullable
            public org.openqa.selenium.Cookie getCookieNamed(@NotNull String name) {
                Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                return (org.openqa.selenium.Cookie)Http4kWebDriver.access$getSiteCookies$p(this.this$0).get(name);
            }

            public void deleteAllCookies() {
                Http4kWebDriver.access$getSiteCookies$p(this.this$0).clear();
            }

            public void deleteCookie(@NotNull org.openqa.selenium.Cookie cookie) {
                Intrinsics.checkParameterIsNotNull((Object)cookie, (String)"cookie");
                Http4kWebDriver.access$getSiteCookies$p(this.this$0).remove(cookie.getName());
            }

            @NotNull
            public Void ime() {
                throw (Throwable)FeatureNotImplementedYet.INSTANCE;
            }

            @NotNull
            public Void logs() {
                throw (Throwable)FeatureNotImplementedYet.INSTANCE;
            }

            @NotNull
            public Void timeouts() {
                throw (Throwable)FeatureNotImplementedYet.INSTANCE;
            }

            @NotNull
            public Void window() {
                throw (Throwable)FeatureNotImplementedYet.INSTANCE;
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    public Http4kWebDriver(@NotNull Function1<? super Request, ? extends Response> handler) {
        Map map;
        Intrinsics.checkParameterIsNotNull(handler, (String)"handler");
        this.handler = handler;
        Http4kWebDriver http4kWebDriver = this;
        http4kWebDriver.siteCookies = map = (Map)new LinkedHashMap();
    }

    public static final /* synthetic */ void access$navigateTo(Http4kWebDriver $this, @NotNull Request request) {
        $this.navigateTo(request);
    }

    @Nullable
    public static final /* synthetic */ WebElement access$getActiveElement$p(Http4kWebDriver $this) {
        return $this.activeElement;
    }

    public static final /* synthetic */ void access$setActiveElement$p(Http4kWebDriver $this, @Nullable WebElement webElement) {
        $this.activeElement = webElement;
    }

    @Nullable
    public static final /* synthetic */ Page access$getCurrent$p(Http4kWebDriver $this) {
        return $this.current;
    }

    public static final /* synthetic */ void access$setCurrent$p(Http4kWebDriver $this, @Nullable Page page) {
        $this.current = page;
    }

    @NotNull
    public static final /* synthetic */ Function1 access$getHandler$p(Http4kWebDriver $this) {
        return $this.handler;
    }

    @NotNull
    public static final /* synthetic */ Map access$getSiteCookies$p(Http4kWebDriver $this) {
        return $this.siteCookies;
    }
}

