/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.webdriver;

import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.reflect.KDeclarationContainer;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.http4k.core.Filter;
import org.http4k.core.Http4kKt;
import org.http4k.core.Method;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.http4k.core.Status;
import org.http4k.core.Uri;
import org.http4k.core.cookie.Cookie;
import org.http4k.filter.ClientFilters;
import org.http4k.filter.cookie.CookieStorage;
import org.http4k.filter.cookie.LocalCookie;
import org.http4k.webdriver.FeatureNotImplementedYet;
import org.http4k.webdriver.Http4KNavigation;
import org.http4k.webdriver.Http4kWebDriver;
import org.http4k.webdriver.Page;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0091\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u0019\u0018\u00002\u00020\u0001:\u00019B\u001d\u0012\u0016\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u0002`\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\r\u0010\u0018\u001a\u00020\u0019H\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0012\u0010\u001b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u001f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0011\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u000eH\u0096\u0002J\u000e\u0010 \u001a\u00020\u00172\u0006\u0010\"\u001a\u00020#J\n\u0010$\u001a\u0004\u0018\u00010\u000eH\u0016J\n\u0010%\u001a\u0004\u0018\u00010\u000eH\u0016J\n\u0010&\u001a\u0004\u0018\u00010\u000eH\u0016J\n\u0010'\u001a\u0004\u0018\u00010\u000eH\u0016J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000e0)H\u0016J\b\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020\u00172\u0006\u0010/\u001a\u00020\u0004H\u0002J\u0010\u00100\u001a\u00020\u000e2\u0006\u00101\u001a\u00020\u000eH\u0002J\b\u00102\u001a\u00020\u0017H\u0016J\b\u00103\u001a\u000204H\u0016J\f\u00105\u001a\u000206*\u000207H\u0002J\f\u00105\u001a\u00020\u0011*\u000208H\u0002R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006:"}, d2={"Lorg/http4k/webdriver/Http4kWebDriver;", "Lorg/openqa/selenium/WebDriver;", "initialHandler", "Lkotlin/Function1;", "Lorg/http4k/core/Request;", "Lorg/http4k/core/Response;", "Lorg/http4k/core/HttpHandler;", "(Lkotlin/jvm/functions/Function1;)V", "activeElement", "Lorg/openqa/selenium/WebElement;", "current", "Lorg/http4k/webdriver/Page;", "handler", "latestUri", "", "siteCookies", "", "Lorg/http4k/webdriver/Http4kWebDriver$StoredCookie;", "status", "Lorg/http4k/core/Status;", "getStatus", "()Lorg/http4k/core/Status;", "close", "", "cookieStorage", "org/http4k/webdriver/Http4kWebDriver$cookieStorage$1", "()Lorg/http4k/webdriver/Http4kWebDriver$cookieStorage$1;", "findElement", "by", "Lorg/openqa/selenium/By;", "findElements", "", "get", "url", "uri", "Lorg/http4k/core/Uri;", "getCurrentUrl", "getPageSource", "getTitle", "getWindowHandle", "getWindowHandles", "", "manage", "Lorg/openqa/selenium/WebDriver$Options;", "navigate", "Lorg/http4k/webdriver/Http4KNavigation;", "navigateTo", "request", "normalized", "path", "quit", "switchTo", "Lorg/openqa/selenium/WebDriver$TargetLocator;", "toWebDriver", "Lorg/openqa/selenium/Cookie;", "Lorg/http4k/core/cookie/Cookie;", "Lorg/http4k/filter/cookie/LocalCookie;", "StoredCookie", "http4k-testing-webdriver"})
public final class Http4kWebDriver
implements WebDriver {
    private final Function1<Request, Response> handler;
    private Page current;
    private WebElement activeElement;
    private final Map<String, StoredCookie> siteCookies;
    private String latestUri;

    private final void navigateTo(Request request) {
        Request normalizedPath = request.uri(request.getUri().path(this.normalized(request.getUri().getPath())));
        Response response = (Response)this.handler.invoke((Object)normalizedPath);
        Status status = response.getStatus();
        Function1 function1 = (Function1)new Function1<Request, Unit>(this){

            public final void invoke(@NotNull Request p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                Http4kWebDriver.access$navigateTo((Http4kWebDriver)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(Http4kWebDriver.class);
            }

            public final String getName() {
                return "navigateTo";
            }

            public final String getSignature() {
                return "navigateTo(Lorg/http4k/core/Request;)V";
            }
        };
        Function0 function0 = (Function0)new Function0<String>(this){
            final /* synthetic */ Http4kWebDriver this$0;

            @Nullable
            public final String invoke() {
                return this.this$0.getCurrentUrl();
            }
            {
                this.this$0 = http4kWebDriver;
                super(0);
            }
        };
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkExpressionValueIsNotNull((Object)uUID, (String)"UUID.randomUUID()");
        this.current = new Page(status, function1, function0, uUID, this.normalized(this.latestUri), response.bodyString(), this.current, null, 128, null);
    }

    private final String normalized(String path) {
        String string;
        block4: {
            Path path2;
            block6: {
                String string2;
                block8: {
                    block7: {
                        block5: {
                            block3: {
                                if (!new Regex("http[s]?://.*").matches((CharSequence)path)) break block3;
                                string = path;
                                break block4;
                            }
                            if (!StringsKt.startsWith$default((String)path, (String)"/", (boolean)false, (int)2, null)) break block5;
                            path2 = Paths.get(path, new String[0]);
                            break block6;
                        }
                        string2 = this.getCurrentUrl();
                        if (string2 == null) break block7;
                        String string3 = string2;
                        String it = string3;
                        String string4 = Uri.Companion.of(it).getPath();
                        String it2 = string4;
                        CharSequence charSequence = it2;
                        String string5 = charSequence.length() == 0 ? "/" : it2;
                        string2 = string5;
                        if (string5 != null) break block8;
                    }
                    string2 = "/";
                }
                String currentPath = string2;
                path2 = Paths.get(currentPath, path);
            }
            Path newPath = path2;
            string = ((Object)newPath.normalize()).toString();
        }
        return string;
    }

    private final org.openqa.selenium.Cookie toWebDriver(@NotNull Cookie $receiver) {
        Date date;
        String string = $receiver.getName();
        String string2 = $receiver.getValue();
        String string3 = $receiver.getDomain();
        String string4 = $receiver.getPath();
        LocalDateTime localDateTime = $receiver.getExpires();
        if (localDateTime != null) {
            LocalDateTime localDateTime2 = localDateTime;
            String string5 = string4;
            String string6 = string3;
            String string7 = string2;
            String string8 = string;
            LocalDateTime it = localDateTime2;
            Date date2 = Date.from(it.atZone(ZoneId.systemDefault()).toInstant());
            string = string8;
            string2 = string7;
            string3 = string6;
            string4 = string5;
            date = date2;
        } else {
            date = null;
        }
        boolean bl = $receiver.getHttpOnly();
        boolean bl2 = $receiver.getSecure();
        Date date3 = date;
        String string9 = string4;
        String string10 = string3;
        String string11 = string2;
        String string12 = string;
        return new org.openqa.selenium.Cookie(string12, string11, string10, string9, date3, bl2, bl);
    }

    private final StoredCookie toWebDriver(@NotNull LocalCookie $receiver) {
        return new StoredCookie(this.toWebDriver($receiver.getCookie()), $receiver);
    }

    public void get(@NotNull String url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        this.navigateTo(Request.Companion.invoke$default((Request.Companion)Request.Companion, (Method)Method.GET, (String)url, null, (int)4, null).body(""));
    }

    public final void get(@NotNull Uri uri) {
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        this.get(uri.toString());
    }

    @Nullable
    public String getCurrentUrl() {
        Page page = this.current;
        return page != null ? page.getUrl() : null;
    }

    @Nullable
    public String getTitle() {
        Page page = this.current;
        return page != null ? page.getTitle() : null;
    }

    @Nullable
    public final Status getStatus() {
        Page page = this.current;
        return page != null ? page.getStatus() : null;
    }

    @Nullable
    public List<WebElement> findElements(@NotNull By by) {
        Intrinsics.checkParameterIsNotNull((Object)by, (String)"by");
        Page page = this.current;
        return page != null ? page.findElements(by) : null;
    }

    @Nullable
    public WebElement findElement(@NotNull By by) {
        Intrinsics.checkParameterIsNotNull((Object)by, (String)"by");
        Object object = this.current;
        return object != null && (object = ((Page)object).findElements(by)) != null ? (WebElement)CollectionsKt.firstOrNull((List)object) : null;
    }

    @Nullable
    public String getPageSource() {
        Page page = this.current;
        return page != null ? page.getContents() : null;
    }

    public void close() {
        this.current = null;
    }

    public void quit() {
        this.current = null;
    }

    @NotNull
    public Set<String> getWindowHandles() {
        Page page;
        Page it;
        Object object = this.current;
        if (object == null || (object = SetsKt.setOf((Object)(it = (page = object)).getHandle().toString())) == null) {
            object = SetsKt.emptySet();
        }
        return object;
    }

    @Nullable
    public String getWindowHandle() {
        return (String)CollectionsKt.firstOrNull((Iterable)this.getWindowHandles());
    }

    @NotNull
    public WebDriver.TargetLocator switchTo() {
        return new WebDriver.TargetLocator(this){
            final /* synthetic */ Http4kWebDriver this$0;

            @NotNull
            public WebDriver frame(int index) {
                throw (Throwable)FeatureNotImplementedYet.INSTANCE;
            }

            @NotNull
            public WebDriver frame(@Nullable String nameOrId) {
                throw (Throwable)FeatureNotImplementedYet.INSTANCE;
            }

            @NotNull
            public WebDriver frame(@Nullable WebElement frameElement) {
                throw (Throwable)FeatureNotImplementedYet.INSTANCE;
            }

            @NotNull
            public WebDriver parentFrame() {
                throw (Throwable)FeatureNotImplementedYet.INSTANCE;
            }

            @NotNull
            public Alert alert() {
                throw (Throwable)FeatureNotImplementedYet.INSTANCE;
            }

            @NotNull
            public WebElement activeElement() {
                WebElement webElement = Http4kWebDriver.access$getActiveElement$p(this.this$0);
                if (webElement == null) {
                    Page page = Http4kWebDriver.access$getCurrent$p(this.this$0);
                    webElement = page != null ? page.firstElement() : null;
                }
                if (webElement == null) {
                    throw (Throwable)new NoSuchElementException("no page loaded!");
                }
                return webElement;
            }

            @NotNull
            public WebDriver window(@Nullable String nameOrHandle) {
                Object object = Http4kWebDriver.access$getCurrent$p(this.this$0);
                if (Intrinsics.areEqual((Object)(object != null && (object = ((Page)object).getHandle()) != null ? ((UUID)object).toString() : null), (Object)nameOrHandle) ^ true) {
                    throw (Throwable)new NoSuchElementException("window with handle" + nameOrHandle);
                }
                return this.this$0;
            }

            @NotNull
            public WebDriver defaultContent() {
                return this.this$0;
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    @NotNull
    public Http4KNavigation navigate() {
        return new Http4KNavigation(this){
            final /* synthetic */ Http4kWebDriver this$0;

            public void to(@NotNull String url) {
                Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
                this.this$0.get(url);
            }

            public void to(@NotNull URL url) {
                Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
                String string = url.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"url.toString()");
                this.this$0.get(string);
            }

            public void forward() {
                block0: {
                    Page page;
                    Page page2 = Http4kWebDriver.access$getCurrent$p(this.this$0);
                    if (page2 == null || (page2 = page2.getNext()) == null) break block0;
                    Page it = page = page2;
                    Http4kWebDriver.access$setCurrent$p(this.this$0, it);
                }
            }

            public void refresh() {
                block0: {
                    Page page;
                    Page page2 = Http4kWebDriver.access$getCurrent$p(this.this$0);
                    if (page2 == null) break block0;
                    Page it = page = page2;
                    Http4kWebDriver.access$setCurrent$p(this.this$0, Page.copy$default(it, null, null, null, null, null, ((Response)Http4kWebDriver.access$getHandler$p(this.this$0).invoke((Object)Request.Companion.invoke$default((Request.Companion)Request.Companion, (Method)Method.GET, (String)it.getUrl(), null, (int)4, null))).bodyString(), null, null, 223, null));
                }
            }

            public void back() {
                block0: {
                    Page page;
                    Page page2 = Http4kWebDriver.access$getCurrent$p(this.this$0);
                    if (page2 == null || (page2 = page2.getPrevious()) == null) break block0;
                    Page it = page = page2;
                    Http4kWebDriver.access$setCurrent$p(this.this$0, Page.copy$default(it, null, null, null, null, null, null, null, Http4kWebDriver.access$getCurrent$p(this.this$0), 127, null));
                }
            }

            public void to(@NotNull Uri uri) {
                Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
                this.this$0.get(uri.toString());
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    @NotNull
    public WebDriver.Options manage() {
        return new WebDriver.Options(this){
            final /* synthetic */ Http4kWebDriver this$0;

            public void addCookie(@NotNull org.openqa.selenium.Cookie cookie) {
                Intrinsics.checkParameterIsNotNull((Object)cookie, (String)"cookie");
                Map map = Http4kWebDriver.access$getSiteCookies$p(this.this$0);
                String string = cookie.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"cookie.name");
                String string2 = string;
                String string3 = cookie.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"cookie.name");
                String string4 = cookie.getValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"cookie.value");
                Cookie cookie2 = new Cookie(string3, string4, null, null, null, null, false, false, 252, null);
                LocalDateTime localDateTime = LocalDateTime.now();
                Intrinsics.checkExpressionValueIsNotNull((Object)localDateTime, (String)"LocalDateTime.now()");
                StoredCookie storedCookie = new StoredCookie(cookie, new LocalCookie(cookie2, localDateTime));
                map.put(string2, storedCookie);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public Set<org.openqa.selenium.Cookie> getCookies() {
                void var3_3;
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                Iterable iterable = $receiver$iv = (Iterable)Http4kWebDriver.access$getSiteCookies$p(this.this$0).values();
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    void it;
                    StoredCookie storedCookie = (StoredCookie)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    org.openqa.selenium.Cookie cookie = it.getCookie();
                    collection.add(cookie);
                }
                return CollectionsKt.toSet((Iterable)((List)var3_3));
            }

            public void deleteCookieNamed(@Nullable String name) {
                Map map;
                Map map2 = map = Http4kWebDriver.access$getSiteCookies$p(this.this$0);
                if (map2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableMap<K, V>");
                }
                TypeIntrinsics.asMutableMap((Object)map2).remove(name);
            }

            @Nullable
            public org.openqa.selenium.Cookie getCookieNamed(@NotNull String name) {
                Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                StoredCookie storedCookie = (StoredCookie)Http4kWebDriver.access$getSiteCookies$p(this.this$0).get(name);
                return storedCookie != null ? storedCookie.getCookie() : null;
            }

            public void deleteAllCookies() {
                Http4kWebDriver.access$getSiteCookies$p(this.this$0).clear();
            }

            public void deleteCookie(@NotNull org.openqa.selenium.Cookie cookie) {
                Intrinsics.checkParameterIsNotNull((Object)cookie, (String)"cookie");
                Http4kWebDriver.access$getSiteCookies$p(this.this$0).remove(cookie.getName());
            }

            @NotNull
            public Void ime() {
                throw (Throwable)FeatureNotImplementedYet.INSTANCE;
            }

            @NotNull
            public Void logs() {
                throw (Throwable)FeatureNotImplementedYet.INSTANCE;
            }

            @NotNull
            public Void timeouts() {
                throw (Throwable)FeatureNotImplementedYet.INSTANCE;
            }

            @NotNull
            public Void window() {
                throw (Throwable)FeatureNotImplementedYet.INSTANCE;
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    private final cookieStorage.1 cookieStorage() {
        return new CookieStorage(this){
            final /* synthetic */ Http4kWebDriver this$0;

            public void store(@NotNull List<LocalCookie> cookies) {
                Intrinsics.checkParameterIsNotNull(cookies, (String)"cookies");
                Iterable $receiver$iv = cookies;
                for (T element$iv : $receiver$iv) {
                    LocalCookie it = (LocalCookie)element$iv;
                    Map map = Http4kWebDriver.access$getSiteCookies$p(this.this$0);
                    String string = it.getCookie().getName();
                    StoredCookie storedCookie = Http4kWebDriver.access$toWebDriver(this.this$0, it);
                    map.put(string, storedCookie);
                }
            }

            public void remove(@NotNull String name) {
                Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                Http4kWebDriver.access$getSiteCookies$p(this.this$0).remove(name);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public List<LocalCookie> retrieve() {
                void var3_3;
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                Iterable iterable = $receiver$iv = (Iterable)Http4kWebDriver.access$getSiteCookies$p(this.this$0).entrySet();
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    void it;
                    Map.Entry entry = (Map.Entry)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    LocalCookie localCookie = ((StoredCookie)it.getValue()).getLocalCookie();
                    collection.add(localCookie);
                }
                return (List)var3_3;
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    public Http4kWebDriver(@NotNull Function1<? super Request, ? extends Response> initialHandler) {
        Map map;
        Intrinsics.checkParameterIsNotNull(initialHandler, (String)"initialHandler");
        this.handler = Http4kKt.then((Filter)Http4kKt.then((Filter)Http4kKt.then((Filter)ClientFilters.FollowRedirects.INSTANCE.invoke(), (Filter)ClientFilters.Cookies.invoke$default((ClientFilters.Cookies)ClientFilters.Cookies.INSTANCE, null, (CookieStorage)this.cookieStorage(), (int)1, null)), (Filter)Filter.Companion.invoke((Function1)new Function1<Function1<? super Request, ? extends Response>, Function1<? super Request, ? extends Response>>(this){
            final /* synthetic */ Http4kWebDriver this$0;

            @NotNull
            public final Function1<Request, Response> invoke(@NotNull Function1<? super Request, ? extends Response> next) {
                Intrinsics.checkParameterIsNotNull(next, (String)"next");
                return (Function1)new Function1<Request, Response>(this, next){
                    final /* synthetic */ handler.1 this$0;
                    final /* synthetic */ Function1 $next;

                    @NotNull
                    public final Response invoke(@NotNull Request request) {
                        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                        Http4kWebDriver.access$setLatestUri$p(this.this$0.this$0, request.getUri().toString());
                        return (Response)this.$next.invoke((Object)request);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$next = function1;
                        super(1);
                    }
                };
            }
            {
                this.this$0 = http4kWebDriver;
                super(1);
            }
        })), initialHandler);
        Http4kWebDriver http4kWebDriver = this;
        http4kWebDriver.siteCookies = map = (Map)new LinkedHashMap();
        this.latestUri = "";
    }

    public static final /* synthetic */ void access$navigateTo(Http4kWebDriver $this, @NotNull Request request) {
        $this.navigateTo(request);
    }

    @Nullable
    public static final /* synthetic */ WebElement access$getActiveElement$p(Http4kWebDriver $this) {
        return $this.activeElement;
    }

    public static final /* synthetic */ void access$setActiveElement$p(Http4kWebDriver $this, @Nullable WebElement webElement) {
        $this.activeElement = webElement;
    }

    @Nullable
    public static final /* synthetic */ Page access$getCurrent$p(Http4kWebDriver $this) {
        return $this.current;
    }

    public static final /* synthetic */ void access$setCurrent$p(Http4kWebDriver $this, @Nullable Page page) {
        $this.current = page;
    }

    @NotNull
    public static final /* synthetic */ Function1 access$getHandler$p(Http4kWebDriver $this) {
        return $this.handler;
    }

    @NotNull
    public static final /* synthetic */ Map access$getSiteCookies$p(Http4kWebDriver $this) {
        return $this.siteCookies;
    }

    @NotNull
    public static final /* synthetic */ StoredCookie access$toWebDriver(Http4kWebDriver $this, @NotNull LocalCookie $receiver) {
        return $this.toWebDriver($receiver);
    }

    @NotNull
    public static final /* synthetic */ String access$getLatestUri$p(Http4kWebDriver $this) {
        return $this.latestUri;
    }

    public static final /* synthetic */ void access$setLatestUri$p(Http4kWebDriver $this, @NotNull String string) {
        $this.latestUri = string;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/http4k/webdriver/Http4kWebDriver$StoredCookie;", "", "cookie", "Lorg/openqa/selenium/Cookie;", "localCookie", "Lorg/http4k/filter/cookie/LocalCookie;", "(Lorg/openqa/selenium/Cookie;Lorg/http4k/filter/cookie/LocalCookie;)V", "getCookie", "()Lorg/openqa/selenium/Cookie;", "getLocalCookie", "()Lorg/http4k/filter/cookie/LocalCookie;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "http4k-testing-webdriver"})
    private static final class StoredCookie {
        @NotNull
        private final org.openqa.selenium.Cookie cookie;
        @NotNull
        private final LocalCookie localCookie;

        @NotNull
        public final org.openqa.selenium.Cookie getCookie() {
            return this.cookie;
        }

        @NotNull
        public final LocalCookie getLocalCookie() {
            return this.localCookie;
        }

        public StoredCookie(@NotNull org.openqa.selenium.Cookie cookie, @NotNull LocalCookie localCookie) {
            Intrinsics.checkParameterIsNotNull((Object)cookie, (String)"cookie");
            Intrinsics.checkParameterIsNotNull((Object)localCookie, (String)"localCookie");
            this.cookie = cookie;
            this.localCookie = localCookie;
        }

        @NotNull
        public final org.openqa.selenium.Cookie component1() {
            return this.cookie;
        }

        @NotNull
        public final LocalCookie component2() {
            return this.localCookie;
        }

        @NotNull
        public final StoredCookie copy(@NotNull org.openqa.selenium.Cookie cookie, @NotNull LocalCookie localCookie) {
            Intrinsics.checkParameterIsNotNull((Object)cookie, (String)"cookie");
            Intrinsics.checkParameterIsNotNull((Object)localCookie, (String)"localCookie");
            return new StoredCookie(cookie, localCookie);
        }

        @NotNull
        public static /* synthetic */ StoredCookie copy$default(StoredCookie storedCookie, org.openqa.selenium.Cookie cookie, LocalCookie localCookie, int n, Object object) {
            if ((n & 1) != 0) {
                cookie = storedCookie.cookie;
            }
            if ((n & 2) != 0) {
                localCookie = storedCookie.localCookie;
            }
            return storedCookie.copy(cookie, localCookie);
        }

        @NotNull
        public String toString() {
            return "StoredCookie(cookie=" + this.cookie + ", localCookie=" + this.localCookie + ")";
        }

        public int hashCode() {
            org.openqa.selenium.Cookie cookie = this.cookie;
            LocalCookie localCookie = this.localCookie;
            return (cookie != null ? cookie.hashCode() : 0) * 31 + (localCookie != null ? localCookie.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof StoredCookie)) break block3;
                    StoredCookie storedCookie = (StoredCookie)object;
                    if (!Intrinsics.areEqual((Object)this.cookie, (Object)storedCookie.cookie) || !Intrinsics.areEqual((Object)this.localCookie, (Object)storedCookie.localCookie)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

