/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.webdriver;

import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Clock;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.http4k.core.Credentials;
import org.http4k.core.Filter;
import org.http4k.core.Http4kKt;
import org.http4k.core.Method;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.http4k.core.Status;
import org.http4k.core.Uri;
import org.http4k.core.cookie.Cookie;
import org.http4k.filter.ClientFilters;
import org.http4k.filter.cookie.CookieStorage;
import org.http4k.filter.cookie.LocalCookie;
import org.http4k.lens.HeaderKt;
import org.http4k.webdriver.FeatureNotImplementedYet;
import org.http4k.webdriver.Http4KNavigation;
import org.http4k.webdriver.Http4kWebDriver;
import org.http4k.webdriver.JSoupWebElement;
import org.http4k.webdriver.Page;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.WindowType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a7\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001B\u0018\u00002\u00020\u0001:\u0001FB8\u0012%\u0010\u0002\u001a!\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\b\u0012\u0004\u0012\u00020\t0\u0004j\u0002`\u0003\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\u0005H\u0002J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u0017H\u0002J\u0014\u0010\u001f\u001a\u00020\u0017*\u00020\u00172\u0006\u0010 \u001a\u00020\u0017H\u0002J\f\u0010!\u001a\u00020\u0017*\u00020\u0017H\u0002J\f\u0010\"\u001a\u00020#*\u00020$H\u0002J\f\u0010\"\u001a\u00020\u0018*\u00020%H\u0002J\u0011\u0010&\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020\u0017H\u0096\u0002J\u000e\u0010&\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020)J\n\u0010*\u001a\u0004\u0018\u00010\u0017H\u0016J\n\u0010+\u001a\u0004\u0018\u00010\u0017H\u0016J\u0018\u00100\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u0001012\u0006\u00102\u001a\u000203H\u0016J\u0012\u00104\u001a\u0004\u0018\u00010\u00142\u0006\u00102\u001a\u000203H\u0016J\n\u00105\u001a\u0004\u0018\u00010\u0017H\u0016J\b\u00106\u001a\u00020\u001cH\u0016J\b\u00107\u001a\u00020\u001cH\u0016J\u000e\u00108\u001a\b\u0012\u0004\u0012\u00020\u001709H\u0016J\n\u0010:\u001a\u0004\u0018\u00010\u0017H\u0016J\b\u0010;\u001a\u00020<H\u0016J\b\u0010=\u001a\u00020>H\u0016J\b\u0010?\u001a\u00020@H\u0016J\r\u0010A\u001a\u00020BH\u0002\u00a2\u0006\u0002\u0010CJ\u000e\u0010D\u001a\u0004\u0018\u00010E*\u00020)H\u0002R,\u0010\u000e\u001a\u001d\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\b\u0012\u0004\u0012\u00020\t0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010,\u001a\u0004\u0018\u00010-8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010/\u00a8\u0006G"}, d2={"Lorg/http4k/webdriver/Http4kWebDriver;", "Lorg/openqa/selenium/WebDriver;", "initialHandler", "Lorg/http4k/core/HttpHandler;", "Lkotlin/Function1;", "Lorg/http4k/core/Request;", "Lkotlin/ParameterName;", "name", "request", "Lorg/http4k/core/Response;", "clock", "Ljava/time/Clock;", "<init>", "(Lkotlin/jvm/functions/Function1;Ljava/time/Clock;)V", "handler", "getHandler", "()Lkotlin/jvm/functions/Function1;", "current", "Lorg/http4k/webdriver/Page;", "activeElement", "Lorg/openqa/selenium/WebElement;", "siteCookies", "", "", "Lorg/http4k/webdriver/Http4kWebDriver$StoredCookie;", "latestUri", "latestHost", "navigateTo", "", "normalized", "path", "appendToPath", "pathToAppend", "normalizePath", "toWebDriver", "Lorg/openqa/selenium/Cookie;", "Lorg/http4k/core/cookie/Cookie;", "Lorg/http4k/filter/cookie/LocalCookie;", "get", "url", "uri", "Lorg/http4k/core/Uri;", "getCurrentUrl", "getTitle", "status", "Lorg/http4k/core/Status;", "getStatus", "()Lorg/http4k/core/Status;", "findElements", "", "by", "Lorg/openqa/selenium/By;", "findElement", "getPageSource", "close", "quit", "getWindowHandles", "", "getWindowHandle", "switchTo", "Lorg/openqa/selenium/WebDriver$TargetLocator;", "navigate", "Lorg/http4k/webdriver/Http4KNavigation;", "manage", "Lorg/openqa/selenium/WebDriver$Options;", "cookieStorage", "org/http4k/webdriver/Http4kWebDriver$cookieStorage$1", "()Lorg/http4k/webdriver/Http4kWebDriver$cookieStorage$1;", "credentials", "Lorg/http4k/core/Credentials;", "StoredCookie", "http4k-testing-webdriver"})
@SourceDebugExtension(value={"SMAP\nHttp4kWebDriver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Http4kWebDriver.kt\norg/http4k/webdriver/Http4kWebDriver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,263:1\n1#2:264\n774#3:265\n865#3,2:266\n1872#3,3:268\n*S KotlinDebug\n*F\n+ 1 Http4kWebDriver.kt\norg/http4k/webdriver/Http4kWebDriver\n*L\n104#1:265\n104#1:266,2\n106#1:268,3\n*E\n"})
public final class Http4kWebDriver
implements WebDriver {
    @NotNull
    private final Function1<Request, Response> handler;
    @Nullable
    private Page current;
    @Nullable
    private WebElement activeElement;
    @NotNull
    private final Map<String, StoredCookie> siteCookies;
    @NotNull
    private String latestUri;
    @Nullable
    private String latestHost;

    public Http4kWebDriver(@NotNull Function1<? super Request, ? extends Response> initialHandler, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter(initialHandler, (String)"initialHandler");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.handler = Http4kKt.then((Filter)Http4kKt.then((Filter)Http4kKt.then((Filter)Http4kKt.then(arg_0 -> Http4kWebDriver.handler$lambda$1(this, arg_0), (Filter)((Filter)new ClientFilters.FollowRedirects())), (Filter)ClientFilters.Cookies.INSTANCE.invoke(clock, (CookieStorage)this.cookieStorage())), arg_0 -> Http4kWebDriver.handler$lambda$3(this, arg_0)), initialHandler);
        this.siteCookies = new LinkedHashMap();
        this.latestUri = "";
    }

    public /* synthetic */ Http4kWebDriver(Function1 function1, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            clock = Clock.systemDefaultZone();
        }
        this((Function1<? super Request, ? extends Response>)function1, clock);
    }

    @NotNull
    public final Function1<Request, Response> getHandler() {
        return this.handler;
    }

    /*
     * WARNING - void declaration
     */
    private final void navigateTo(Request request) {
        String host;
        Object object;
        StringBuilder stringBuilder;
        Request normalizedPath;
        block5: {
            block4: {
                void it;
                normalizedPath = request.uri(request.getUri().path(this.normalized(request.getUri().getPath())));
                stringBuilder = new StringBuilder().append(request.getUri().getHost());
                object = request.getUri().getPort();
                if (object == null) break block4;
                int n = ((Number)object).intValue();
                StringBuilder stringBuilder2 = stringBuilder;
                boolean bl = false;
                String string = "" + ':' + (int)it;
                stringBuilder = stringBuilder2;
                object = string;
                if (string != null) break block5;
            }
            object = "";
        }
        if (((CharSequence)(host = stringBuilder.append((String)object).toString())).length() > 0) {
            this.latestHost = host;
        }
        Response response = (Response)this.handler.invoke((Object)normalizedPath);
        Status status = response.getStatus();
        Function1 function1 = (Function1)new Function1<Request, Unit>((Object)this){

            public final void invoke(Request p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Http4kWebDriver.access$navigateTo((Http4kWebDriver)this.receiver, p0);
            }
        };
        Function0 function0 = () -> Http4kWebDriver.navigateTo$lambda$5(this);
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
        this.current = new Page(status, function1, function0, uUID, this.normalized(this.latestUri), response.bodyString(), this.current, null, 128, null);
    }

    private final String normalized(String path) {
        String string;
        block8: {
            String string2;
            block10: {
                String string3;
                block12: {
                    block11: {
                        CharSequence charSequence;
                        block9: {
                            block7: {
                                if (!new Regex("http[s]?://.*").matches((CharSequence)path)) break block7;
                                string = path;
                                break block8;
                            }
                            if (!StringsKt.startsWith$default((String)path, (String)"/", (boolean)false, (int)2, null)) break block9;
                            string2 = path;
                            break block10;
                        }
                        string3 = this.getCurrentUrl();
                        if (string3 == null) break block11;
                        String it = string3;
                        boolean bl = false;
                        String it2 = Uri.Companion.of(it).getPath();
                        boolean bl2 = false;
                        CharSequence charSequence2 = it2;
                        if (charSequence2.length() == 0) {
                            boolean bl3 = false;
                            charSequence = "/";
                        } else {
                            charSequence = charSequence2;
                        }
                        String string4 = (String)charSequence;
                        string3 = string4;
                        if (string4 != null) break block12;
                    }
                    string3 = "/";
                }
                String currentPath = string3;
                if (StringsKt.endsWith$default((String)currentPath, (String)"/", (boolean)false, (int)2, null)) {
                    string2 = this.appendToPath(currentPath, path);
                } else {
                    Path path2 = Paths.get(currentPath, new String[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
                    List pathParts = CollectionsKt.toList((Iterable)path2);
                    Path path3 = Paths.get(path, new String[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(...)");
                    List newPathParts = CollectionsKt.toList((Iterable)path3);
                    List newPath = ((CharSequence)path).length() == 0 ? pathParts : CollectionsKt.plus((Collection)CollectionsKt.dropLast((List)pathParts, (int)1), (Iterable)newPathParts);
                    string2 = CollectionsKt.joinToString$default((Iterable)newPath, (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
                }
            }
            String newPath = string2;
            string = this.normalizePath(newPath);
        }
        return string;
    }

    private final String appendToPath(String $this$appendToPath, String pathToAppend) {
        StringBuilder newPath = new StringBuilder($this$appendToPath);
        if (!StringsKt.endsWith$default((String)$this$appendToPath, (String)"/", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)pathToAppend, (String)"/", (boolean)false, (int)2, null)) {
            newPath.append("/");
        }
        newPath.append(pathToAppend);
        String string = newPath.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final String normalizePath(String $this$normalizePath) {
        String part;
        void $this$filterTo$iv$iv;
        if (Intrinsics.areEqual((Object)$this$normalizePath, (Object)"/")) {
            return $this$normalizePath;
        }
        String[] stringArray = new String[]{"/"};
        Iterable $this$filter$iv = StringsKt.split$default((CharSequence)$this$normalizePath, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            part = (String)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)part, (Object)"."))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List pathParts = (List)destination$iv$iv;
        List newPathParts = new ArrayList();
        Iterable $this$forEachIndexed$iv = pathParts;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            part = (String)item$iv;
            int index = n;
            boolean bl = false;
            if ((index >= CollectionsKt.getLastIndex((List)pathParts) || Intrinsics.areEqual(pathParts.get(index + 1), (Object)"..")) && index != CollectionsKt.getLastIndex((List)pathParts) || Intrinsics.areEqual((Object)part, (Object)"..")) continue;
            newPathParts.add(part);
        }
        String normalizedPath = CollectionsKt.joinToString$default((Iterable)newPathParts, (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
        if (!StringsKt.startsWith$default((String)normalizedPath, (String)"/", (boolean)false, (int)2, null)) {
            normalizedPath = '/' + normalizedPath;
        }
        return normalizedPath;
    }

    /*
     * WARNING - void declaration
     */
    private final org.openqa.selenium.Cookie toWebDriver(Cookie $this$toWebDriver) {
        Date date;
        String string = $this$toWebDriver.getName();
        String string2 = $this$toWebDriver.getValue();
        String string3 = $this$toWebDriver.getDomain();
        String string4 = $this$toWebDriver.getPath();
        Instant instant = $this$toWebDriver.getExpires();
        if (instant != null) {
            void it;
            Instant instant2 = instant;
            String string5 = string4;
            String string6 = string3;
            String string7 = string2;
            String string8 = string;
            boolean bl = false;
            Date date2 = Date.from(it.atZone(ZoneId.systemDefault()).toInstant());
            string = string8;
            string2 = string7;
            string3 = string6;
            string4 = string5;
            date = date2;
        } else {
            date = null;
        }
        boolean bl = $this$toWebDriver.getHttpOnly();
        boolean bl2 = $this$toWebDriver.getSecure();
        Date date3 = date;
        String string9 = string4;
        String string10 = string3;
        String string11 = string2;
        String string12 = string;
        return new org.openqa.selenium.Cookie(string12, string11, string10, string9, date3, bl2, bl);
    }

    private final StoredCookie toWebDriver(LocalCookie $this$toWebDriver) {
        return new StoredCookie(this.toWebDriver($this$toWebDriver.getCookie()), $this$toWebDriver);
    }

    public void get(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.get(Uri.Companion.of(url));
    }

    public final void get(@NotNull Uri uri) {
        Credentials credentials;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
                Credentials basicAuthCredentials = this.credentials(uri);
                credentials = basicAuthCredentials;
                if (credentials == null) break block2;
                Credentials it = credentials;
                boolean bl = false;
                Request request = HeaderKt.basicAuthentication((Request)Request.Companion.create$default((Request.Companion)Request.Companion, (Method)Method.GET, (Uri)uri, null, (int)4, null).body(""), (Credentials)it);
                credentials = request;
                if (request != null) break block3;
            }
            credentials = Request.Companion.create$default((Request.Companion)Request.Companion, (Method)Method.GET, (Uri)uri, null, (int)4, null).body("");
        }
        Credentials request = credentials;
        this.navigateTo((Request)request);
    }

    @Nullable
    public String getCurrentUrl() {
        Page page = this.current;
        return page != null ? page.getUrl() : null;
    }

    @Nullable
    public String getTitle() {
        Page page = this.current;
        return page != null ? page.getTitle() : null;
    }

    @Nullable
    public final Status getStatus() {
        Page page = this.current;
        return page != null ? page.getStatus() : null;
    }

    @Nullable
    public List<WebElement> findElements(@NotNull By by) {
        Intrinsics.checkNotNullParameter((Object)by, (String)"by");
        Page page = this.current;
        return page != null ? page.findElements(by) : null;
    }

    @Nullable
    public WebElement findElement(@NotNull By by) {
        Intrinsics.checkNotNullParameter((Object)by, (String)"by");
        Object object = this.current;
        return object != null && (object = ((Page)object).findElements(by)) != null ? (WebElement)CollectionsKt.firstOrNull((List)object) : null;
    }

    @Nullable
    public String getPageSource() {
        Page page = this.current;
        return page != null ? page.getContents() : null;
    }

    public void close() {
        this.current = null;
    }

    public void quit() {
        this.current = null;
    }

    @NotNull
    public Set<String> getWindowHandles() {
        Object object;
        block3: {
            block2: {
                object = this.current;
                if (object == null) break block2;
                Page it = object;
                boolean bl = false;
                Set set = SetsKt.setOf((Object)it.getHandle().toString());
                object = set;
                if (set != null) break block3;
            }
            object = SetsKt.emptySet();
        }
        return object;
    }

    @Nullable
    public String getWindowHandle() {
        return (String)CollectionsKt.firstOrNull((Iterable)this.getWindowHandles());
    }

    @NotNull
    public WebDriver.TargetLocator switchTo() {
        return new WebDriver.TargetLocator(this){
            final /* synthetic */ Http4kWebDriver this$0;
            {
                this.this$0 = $receiver;
            }

            public WebDriver frame(int index) {
                throw FeatureNotImplementedYet.INSTANCE;
            }

            public WebDriver frame(String nameOrId) {
                throw FeatureNotImplementedYet.INSTANCE;
            }

            public WebDriver frame(WebElement frameElement) {
                throw FeatureNotImplementedYet.INSTANCE;
            }

            public WebDriver parentFrame() {
                throw FeatureNotImplementedYet.INSTANCE;
            }

            public Alert alert() {
                throw FeatureNotImplementedYet.INSTANCE;
            }

            public WebElement activeElement() {
                WebElement webElement = Http4kWebDriver.access$getActiveElement$p(this.this$0);
                if (webElement == null) {
                    Page page = Http4kWebDriver.access$getCurrent$p(this.this$0);
                    JSoupWebElement jSoupWebElement = page != null ? page.firstElement() : null;
                    if (jSoupWebElement != null) {
                        webElement = jSoupWebElement;
                    } else {
                        throw new NoSuchElementException("no page loaded!");
                    }
                }
                return webElement;
            }

            public WebDriver window(String nameOrHandle) {
                Object object = Http4kWebDriver.access$getCurrent$p(this.this$0);
                if (!Intrinsics.areEqual((Object)(object != null && (object = ((Page)object).getHandle()) != null ? ((UUID)object).toString() : null), (Object)nameOrHandle)) {
                    throw new NoSuchElementException("window with handle" + nameOrHandle);
                }
                return this.this$0;
            }

            public Void newWindow(WindowType typeHint) {
                throw FeatureNotImplementedYet.INSTANCE;
            }

            public WebDriver defaultContent() {
                return this.this$0;
            }
        };
    }

    @NotNull
    public Http4KNavigation navigate() {
        return new Http4KNavigation(this){
            final /* synthetic */ Http4kWebDriver this$0;
            {
                this.this$0 = $receiver;
            }

            public void to(String url) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                this.this$0.get(url);
            }

            public void to(URL url) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                String string = url.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                this.this$0.get(string);
            }

            public void forward() {
                block0: {
                    Page page = Http4kWebDriver.access$getCurrent$p(this.this$0);
                    if (page == null || (page = page.getNext()) == null) break block0;
                    Page page2 = page;
                    Http4kWebDriver http4kWebDriver = this.this$0;
                    Page it = page2;
                    boolean bl = false;
                    Http4kWebDriver.access$setCurrent$p(http4kWebDriver, it);
                }
            }

            public void refresh() {
                block0: {
                    Page page = Http4kWebDriver.access$getCurrent$p(this.this$0);
                    if (page == null) break block0;
                    Page page2 = page;
                    Http4kWebDriver http4kWebDriver = this.this$0;
                    Page it = page2;
                    boolean bl = false;
                    Http4kWebDriver.access$setCurrent$p(http4kWebDriver, Page.copy$default(it, null, null, null, null, null, ((Response)http4kWebDriver.getHandler().invoke((Object)Request.Companion.create$default((Request.Companion)Request.Companion, (Method)Method.GET, (String)it.getUrl(), null, (int)4, null))).bodyString(), null, null, 223, null));
                }
            }

            public void back() {
                block0: {
                    Page page = Http4kWebDriver.access$getCurrent$p(this.this$0);
                    if (page == null || (page = page.getPrevious()) == null) break block0;
                    Page page2 = page;
                    Http4kWebDriver http4kWebDriver = this.this$0;
                    Page it = page2;
                    boolean bl = false;
                    Http4kWebDriver.access$setCurrent$p(http4kWebDriver, Page.copy$default(it, null, null, null, null, null, null, null, Http4kWebDriver.access$getCurrent$p(http4kWebDriver), 127, null));
                }
            }

            public void to(Uri uri) {
                Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
                this.this$0.get(uri.toString());
            }
        };
    }

    @NotNull
    public WebDriver.Options manage() {
        return new WebDriver.Options(this){
            final /* synthetic */ Http4kWebDriver this$0;
            {
                this.this$0 = $receiver;
            }

            public void addCookie(org.openqa.selenium.Cookie cookie) {
                Intrinsics.checkNotNullParameter((Object)cookie, (String)"cookie");
                Map map = Http4kWebDriver.access$getSiteCookies$p(this.this$0);
                String string = cookie.getName();
                String string2 = cookie.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                String string3 = cookie.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getValue(...)");
                Cookie cookie2 = new Cookie(string2, string3, null, null, null, null, false, false, null, 508, null);
                Instant instant = LocalDateTime.now().toInstant(ZoneOffset.UTC);
                Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"toInstant(...)");
                StoredCookie storedCookie = new StoredCookie(cookie, new LocalCookie(cookie2, instant));
                map.put(string, storedCookie);
            }

            /*
             * WARNING - void declaration
             */
            public Set<org.openqa.selenium.Cookie> getCookies() {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = Http4kWebDriver.access$getSiteCookies$p(this.this$0).values();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    StoredCookie storedCookie = (StoredCookie)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getCookie());
                }
                return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            }

            public void deleteCookieNamed(String name) {
                TypeIntrinsics.asMutableMap((Object)Http4kWebDriver.access$getSiteCookies$p(this.this$0)).remove(name);
            }

            public org.openqa.selenium.Cookie getCookieNamed(String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                StoredCookie storedCookie = (StoredCookie)Http4kWebDriver.access$getSiteCookies$p(this.this$0).get(name);
                return storedCookie != null ? storedCookie.getCookie() : null;
            }

            public void deleteAllCookies() {
                Http4kWebDriver.access$getSiteCookies$p(this.this$0).clear();
            }

            public void deleteCookie(org.openqa.selenium.Cookie cookie) {
                Intrinsics.checkNotNullParameter((Object)cookie, (String)"cookie");
                Http4kWebDriver.access$getSiteCookies$p(this.this$0).remove(cookie.getName());
            }

            public Void logs() {
                throw FeatureNotImplementedYet.INSTANCE;
            }

            public Void timeouts() {
                throw FeatureNotImplementedYet.INSTANCE;
            }

            public Void window() {
                throw FeatureNotImplementedYet.INSTANCE;
            }
        };
    }

    private final cookieStorage.1 cookieStorage() {
        return new CookieStorage(this){
            final /* synthetic */ Http4kWebDriver this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public void store(List<LocalCookie> cookies) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter(cookies, (String)"cookies");
                Iterable iterable = cookies;
                Http4kWebDriver http4kWebDriver = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    LocalCookie it = (LocalCookie)element$iv;
                    boolean bl = false;
                    Http4kWebDriver.access$getSiteCookies$p(http4kWebDriver).put(it.getCookie().getName(), Http4kWebDriver.access$toWebDriver(http4kWebDriver, it));
                }
            }

            public void remove(String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Http4kWebDriver.access$getSiteCookies$p(this.this$0).remove(name);
            }

            /*
             * WARNING - void declaration
             */
            public List<LocalCookie> retrieve() {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = Http4kWebDriver.access$getSiteCookies$p(this.this$0).entrySet();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Map.Entry entry = (Map.Entry)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(((StoredCookie)it.getValue()).getLocalCookie());
                }
                return (List)destination$iv$iv;
            }
        };
    }

    private final Credentials credentials(Uri $this$credentials) {
        if (StringsKt.isBlank((CharSequence)$this$credentials.getUserInfo())) {
            return null;
        }
        String[] stringArray = new String[]{":"};
        List parts = StringsKt.split$default((CharSequence)$this$credentials.getUserInfo(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (parts.size() != 2) {
            return null;
        }
        String username = (String)parts.get(0);
        String password = (String)parts.get(1);
        return new Credentials(username, password);
    }

    private static final Response handler$lambda$1$lambda$0(Function1 $next, Http4kWebDriver this$0, Request request) {
        Intrinsics.checkNotNullParameter((Object)$next, (String)"$next");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return (Response)$next.invoke((Object)request.header("host", this$0.latestHost));
    }

    private static final Function1 handler$lambda$1(Http4kWebDriver this$0, Function1 next) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)next, (String)"next");
        return arg_0 -> Http4kWebDriver.handler$lambda$1$lambda$0(next, this$0, arg_0);
    }

    private static final Response handler$lambda$3$lambda$2(Http4kWebDriver this$0, Function1 $next, Request request) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$next, (String)"$next");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this$0.latestUri = request.getUri().toString();
        return (Response)$next.invoke((Object)request);
    }

    private static final Function1 handler$lambda$3(Http4kWebDriver this$0, Function1 next) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)next, (String)"next");
        return arg_0 -> Http4kWebDriver.handler$lambda$3$lambda$2(this$0, next, arg_0);
    }

    private static final String navigateTo$lambda$5(Http4kWebDriver this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.getCurrentUrl();
    }

    public static final /* synthetic */ void access$navigateTo(Http4kWebDriver $this, Request request) {
        $this.navigateTo(request);
    }

    public static final /* synthetic */ WebElement access$getActiveElement$p(Http4kWebDriver $this) {
        return $this.activeElement;
    }

    public static final /* synthetic */ Page access$getCurrent$p(Http4kWebDriver $this) {
        return $this.current;
    }

    public static final /* synthetic */ void access$setCurrent$p(Http4kWebDriver $this, Page page) {
        $this.current = page;
    }

    public static final /* synthetic */ Map access$getSiteCookies$p(Http4kWebDriver $this) {
        return $this.siteCookies;
    }

    public static final /* synthetic */ StoredCookie access$toWebDriver(Http4kWebDriver $this, LocalCookie $receiver) {
        return $this.toWebDriver($receiver);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/http4k/webdriver/Http4kWebDriver$StoredCookie;", "", "cookie", "Lorg/openqa/selenium/Cookie;", "localCookie", "Lorg/http4k/filter/cookie/LocalCookie;", "<init>", "(Lorg/openqa/selenium/Cookie;Lorg/http4k/filter/cookie/LocalCookie;)V", "getCookie", "()Lorg/openqa/selenium/Cookie;", "getLocalCookie", "()Lorg/http4k/filter/cookie/LocalCookie;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "http4k-testing-webdriver"})
    private static final class StoredCookie {
        @NotNull
        private final org.openqa.selenium.Cookie cookie;
        @NotNull
        private final LocalCookie localCookie;

        public StoredCookie(@NotNull org.openqa.selenium.Cookie cookie, @NotNull LocalCookie localCookie) {
            Intrinsics.checkNotNullParameter((Object)cookie, (String)"cookie");
            Intrinsics.checkNotNullParameter((Object)localCookie, (String)"localCookie");
            this.cookie = cookie;
            this.localCookie = localCookie;
        }

        @NotNull
        public final org.openqa.selenium.Cookie getCookie() {
            return this.cookie;
        }

        @NotNull
        public final LocalCookie getLocalCookie() {
            return this.localCookie;
        }

        @NotNull
        public final org.openqa.selenium.Cookie component1() {
            return this.cookie;
        }

        @NotNull
        public final LocalCookie component2() {
            return this.localCookie;
        }

        @NotNull
        public final StoredCookie copy(@NotNull org.openqa.selenium.Cookie cookie, @NotNull LocalCookie localCookie) {
            Intrinsics.checkNotNullParameter((Object)cookie, (String)"cookie");
            Intrinsics.checkNotNullParameter((Object)localCookie, (String)"localCookie");
            return new StoredCookie(cookie, localCookie);
        }

        public static /* synthetic */ StoredCookie copy$default(StoredCookie storedCookie, org.openqa.selenium.Cookie cookie, LocalCookie localCookie, int n, Object object) {
            if ((n & 1) != 0) {
                cookie = storedCookie.cookie;
            }
            if ((n & 2) != 0) {
                localCookie = storedCookie.localCookie;
            }
            return storedCookie.copy(cookie, localCookie);
        }

        @NotNull
        public String toString() {
            return "StoredCookie(cookie=" + this.cookie + ", localCookie=" + this.localCookie + ')';
        }

        public int hashCode() {
            int result = this.cookie.hashCode();
            result = result * 31 + this.localCookie.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof StoredCookie)) {
                return false;
            }
            StoredCookie storedCookie = (StoredCookie)other;
            if (!Intrinsics.areEqual((Object)this.cookie, (Object)storedCookie.cookie)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.localCookie, (Object)storedCookie.localCookie);
        }
    }
}

