/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.webdriver;

import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.http4k.core.Request;
import org.http4k.core.Status;
import org.http4k.webdriver.JSoupElementFinder;
import org.http4k.webdriver.JSoupWebElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001Bk\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u0002`\b\u0012\u0012\u0010\t\u001a\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nj\u0002`\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u000b\u0012\u0006\u0010\u0010\u001a\u00020\u000b\u0012\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0000\u0012\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020&J\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020$0(2\u0006\u0010%\u001a\u00020&J\b\u0010)\u001a\u0004\u0018\u00010*J\t\u0010-\u001a\u00020\u0003H\u00c6\u0003J\u0019\u0010.\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u0002`\bH\u00c2\u0003J\u0015\u0010/\u001a\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nj\u0002`\fH\u00c2\u0003J\t\u00100\u001a\u00020\u000eH\u00c6\u0003J\t\u00101\u001a\u00020\u000bH\u00c6\u0003J\t\u00102\u001a\u00020\u000bH\u00c6\u0003J\u000b\u00103\u001a\u0004\u0018\u00010\u0000H\u00c6\u0003J\u000b\u00104\u001a\u0004\u0018\u00010\u0000H\u00c6\u0003Jy\u00105\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0018\b\u0002\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u0002`\b2\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nj\u0002`\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u000b2\b\b\u0002\u0010\u0010\u001a\u00020\u000b2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00002\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0000H\u00c6\u0001J\u0013\u00106\u001a\u0002072\b\u00108\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00109\u001a\u00020:H\u00d6\u0001J\t\u0010;\u001a\u00020\u000bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u0002`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nj\u0002`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u000f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0010\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001aR\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001dR\u0018\u0010\u001f\u001a\n !*\u0004\u0018\u00010 0 X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\"R\u0011\u0010+\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\u001a\u00a8\u0006<"}, d2={"Lorg/http4k/webdriver/Page;", "", "status", "Lorg/http4k/core/Status;", "navigate", "Lkotlin/Function1;", "Lorg/http4k/core/Request;", "", "Lorg/http4k/webdriver/Navigate;", "getURL", "Lkotlin/Function0;", "", "Lorg/http4k/webdriver/GetURL;", "handle", "Ljava/util/UUID;", "url", "contents", "previous", "next", "<init>", "(Lorg/http4k/core/Status;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;Ljava/util/UUID;Ljava/lang/String;Ljava/lang/String;Lorg/http4k/webdriver/Page;Lorg/http4k/webdriver/Page;)V", "getStatus", "()Lorg/http4k/core/Status;", "getHandle", "()Ljava/util/UUID;", "getUrl", "()Ljava/lang/String;", "getContents", "getPrevious", "()Lorg/http4k/webdriver/Page;", "getNext", "parsed", "Lorg/jsoup/nodes/Document;", "kotlin.jvm.PlatformType", "Lorg/jsoup/nodes/Document;", "findElement", "Lorg/openqa/selenium/WebElement;", "by", "Lorg/openqa/selenium/By;", "findElements", "", "firstElement", "Lorg/http4k/webdriver/JSoupWebElement;", "title", "getTitle", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "", "other", "hashCode", "", "toString", "http4k-testing-webdriver"})
@SourceDebugExtension(value={"SMAP\nPage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Page.kt\norg/http4k/webdriver/Page\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,21:1\n1#2:22\n*E\n"})
public final class Page {
    @NotNull
    private final Status status;
    @NotNull
    private final Function1<Request, Unit> navigate;
    @NotNull
    private final Function0<String> getURL;
    @NotNull
    private final UUID handle;
    @NotNull
    private final String url;
    @NotNull
    private final String contents;
    @Nullable
    private final Page previous;
    @Nullable
    private final Page next;
    private final Document parsed;
    @NotNull
    private final String title;

    public Page(@NotNull Status status, @NotNull Function1<? super Request, Unit> navigate2, @NotNull Function0<String> getURL, @NotNull UUID handle, @NotNull String url, @NotNull String contents, @Nullable Page previous, @Nullable Page next) {
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        Intrinsics.checkNotNullParameter(navigate2, (String)"navigate");
        Intrinsics.checkNotNullParameter(getURL, (String)"getURL");
        Intrinsics.checkNotNullParameter((Object)handle, (String)"handle");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)contents, (String)"contents");
        this.status = status;
        this.navigate = navigate2;
        this.getURL = getURL;
        this.handle = handle;
        this.url = url;
        this.contents = contents;
        this.previous = previous;
        this.next = next;
        this.parsed = Jsoup.parse((String)this.contents);
        String string = this.parsed.title();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"title(...)");
        this.title = string;
    }

    public /* synthetic */ Page(Status status, Function1 function1, Function0 function0, UUID uUID, String string, String string2, Page page, Page page2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x40) != 0) {
            page = null;
        }
        if ((n & 0x80) != 0) {
            page2 = null;
        }
        this(status, (Function1<? super Request, Unit>)function1, (Function0<String>)function0, uUID, string, string2, page, page2);
    }

    @NotNull
    public final Status getStatus() {
        return this.status;
    }

    @NotNull
    public final UUID getHandle() {
        return this.handle;
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    @NotNull
    public final String getContents() {
        return this.contents;
    }

    @Nullable
    public final Page getPrevious() {
        return this.previous;
    }

    @Nullable
    public final Page getNext() {
        return this.next;
    }

    @Nullable
    public final WebElement findElement(@NotNull By by) {
        Intrinsics.checkNotNullParameter((Object)by, (String)"by");
        return (WebElement)CollectionsKt.firstOrNull(this.findElements(by));
    }

    @NotNull
    public final List<WebElement> findElements(@NotNull By by) {
        Intrinsics.checkNotNullParameter((Object)by, (String)"by");
        Document document = this.parsed;
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"parsed");
        List list = by.findElements((SearchContext)new JSoupElementFinder(this.navigate, this.getURL, (Element)document));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findElements(...)");
        return list;
    }

    @Nullable
    public final JSoupWebElement firstElement() {
        JSoupWebElement jSoupWebElement;
        Elements elements = this.parsed.body().children();
        Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"children(...)");
        Element element = (Element)CollectionsKt.firstOrNull((List)((List)elements));
        if (element != null) {
            Element it = element;
            boolean bl = false;
            jSoupWebElement = new JSoupWebElement(this.navigate, this.getURL, it);
        } else {
            jSoupWebElement = null;
        }
        return jSoupWebElement;
    }

    @NotNull
    public final String getTitle() {
        return this.title;
    }

    @NotNull
    public final Status component1() {
        return this.status;
    }

    private final Function1<Request, Unit> component2() {
        return this.navigate;
    }

    private final Function0<String> component3() {
        return this.getURL;
    }

    @NotNull
    public final UUID component4() {
        return this.handle;
    }

    @NotNull
    public final String component5() {
        return this.url;
    }

    @NotNull
    public final String component6() {
        return this.contents;
    }

    @Nullable
    public final Page component7() {
        return this.previous;
    }

    @Nullable
    public final Page component8() {
        return this.next;
    }

    @NotNull
    public final Page copy(@NotNull Status status, @NotNull Function1<? super Request, Unit> navigate2, @NotNull Function0<String> getURL, @NotNull UUID handle, @NotNull String url, @NotNull String contents, @Nullable Page previous, @Nullable Page next) {
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        Intrinsics.checkNotNullParameter(navigate2, (String)"navigate");
        Intrinsics.checkNotNullParameter(getURL, (String)"getURL");
        Intrinsics.checkNotNullParameter((Object)handle, (String)"handle");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)contents, (String)"contents");
        return new Page(status, navigate2, getURL, handle, url, contents, previous, next);
    }

    public static /* synthetic */ Page copy$default(Page page, Status status, Function1 function1, Function0 function0, UUID uUID, String string, String string2, Page page2, Page page3, int n, Object object) {
        if ((n & 1) != 0) {
            status = page.status;
        }
        if ((n & 2) != 0) {
            function1 = page.navigate;
        }
        if ((n & 4) != 0) {
            function0 = page.getURL;
        }
        if ((n & 8) != 0) {
            uUID = page.handle;
        }
        if ((n & 0x10) != 0) {
            string = page.url;
        }
        if ((n & 0x20) != 0) {
            string2 = page.contents;
        }
        if ((n & 0x40) != 0) {
            page2 = page.previous;
        }
        if ((n & 0x80) != 0) {
            page3 = page.next;
        }
        return page.copy(status, function1, function0, uUID, string, string2, page2, page3);
    }

    @NotNull
    public String toString() {
        return "Page(status=" + this.status + ", navigate=" + this.navigate + ", getURL=" + this.getURL + ", handle=" + this.handle + ", url=" + this.url + ", contents=" + this.contents + ", previous=" + this.previous + ", next=" + this.next + ")";
    }

    public int hashCode() {
        int result = this.status.hashCode();
        result = result * 31 + this.navigate.hashCode();
        result = result * 31 + this.getURL.hashCode();
        result = result * 31 + this.handle.hashCode();
        result = result * 31 + this.url.hashCode();
        result = result * 31 + this.contents.hashCode();
        result = result * 31 + (this.previous == null ? 0 : this.previous.hashCode());
        result = result * 31 + (this.next == null ? 0 : this.next.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Page)) {
            return false;
        }
        Page page = (Page)other;
        if (!Intrinsics.areEqual((Object)this.status, (Object)page.status)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.navigate, page.navigate)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.getURL, page.getURL)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.handle, (Object)page.handle)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.url, (Object)page.url)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.contents, (Object)page.contents)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.previous, (Object)page.previous)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.next, (Object)page.next);
    }
}

