/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.webhook.signing;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.http4k.core.Body;
import org.http4k.webhook.WebhookId;
import org.http4k.webhook.WebhookTimestamp;
import org.http4k.webhook.signing.HmacSha256SigningSecret;
import org.http4k.webhook.signing.SignatureIdentifier;
import org.http4k.webhook.signing.SignedPayload;
import org.http4k.webhook.signing.WebhookSignature;
import org.http4k.webhook.signing.WebhookSignatureVerifier;
import org.http4k.webhook.signing.WebhookSigner;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006J(\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0006H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/http4k/webhook/signing/HmacSha256;", "", "()V", "Signer", "Lorg/http4k/webhook/signing/WebhookSigner;", "signingSecret", "Lorg/http4k/webhook/signing/HmacSha256SigningSecret;", "Verifier", "Lorg/http4k/webhook/signing/WebhookSignatureVerifier;", "calculateSignature", "Lorg/http4k/webhook/signing/WebhookSignature;", "id", "Lorg/http4k/webhook/WebhookId;", "timestamp", "Lorg/http4k/webhook/WebhookTimestamp;", "body", "Lorg/http4k/core/Body;", "secret", "http4k-webhook"})
public final class HmacSha256 {
    @NotNull
    public static final HmacSha256 INSTANCE = new HmacSha256();

    private HmacSha256() {
    }

    @NotNull
    public final WebhookSigner Signer(@NotNull HmacSha256SigningSecret signingSecret) {
        Intrinsics.checkNotNullParameter((Object)((Object)signingSecret), (String)"signingSecret");
        return (arg_0, arg_1, arg_2) -> HmacSha256.Signer$lambda$0(signingSecret, arg_0, arg_1, arg_2);
    }

    @NotNull
    public final WebhookSignatureVerifier Verifier(@NotNull HmacSha256SigningSecret signingSecret) {
        Intrinsics.checkNotNullParameter((Object)((Object)signingSecret), (String)"signingSecret");
        return (arg_0, arg_1, arg_2, arg_3) -> HmacSha256.Verifier$lambda$1(signingSecret, arg_0, arg_1, arg_2, arg_3);
    }

    private final WebhookSignature calculateSignature(WebhookId id, WebhookTimestamp timestamp, Body body, HmacSha256SigningSecret secret) {
        StringBuilder stringBuilder = new StringBuilder().append((Object)id).append('.').append(timestamp.asInstant()).append('.');
        byte[] byArray = body.getPayload().array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
        Object object = byArray;
        String contentToSign = stringBuilder.append(new String((byte[])object, Charsets.UTF_8)).toString();
        object = secret.withNoPrefix();
        byte[] byArray2 = ((String)object).getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
        return WebhookSignature.Companion.of(SignatureIdentifier.v1, SignedPayload.Companion.encode(org.http4k.security.HmacSha256.INSTANCE.hmacSHA256(byArray2, contentToSign)));
    }

    private static final WebhookSignature Signer$lambda$0(HmacSha256SigningSecret $signingSecret, WebhookId id, WebhookTimestamp timestamp, Body body) {
        Intrinsics.checkNotNullParameter((Object)((Object)$signingSecret), (String)"$signingSecret");
        Intrinsics.checkNotNullParameter((Object)((Object)id), (String)"id");
        Intrinsics.checkNotNullParameter((Object)((Object)timestamp), (String)"timestamp");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        return INSTANCE.calculateSignature(id, timestamp, body, $signingSecret);
    }

    private static final boolean Verifier$lambda$1(HmacSha256SigningSecret $signingSecret, WebhookId id, WebhookTimestamp timestamp, WebhookSignature signature, Body body) {
        Intrinsics.checkNotNullParameter((Object)((Object)$signingSecret), (String)"$signingSecret");
        Intrinsics.checkNotNullParameter((Object)((Object)id), (String)"id");
        Intrinsics.checkNotNullParameter((Object)((Object)timestamp), (String)"timestamp");
        Intrinsics.checkNotNullParameter((Object)((Object)signature), (String)"signature");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        return Intrinsics.areEqual((Object)((Object)signature), (Object)((Object)INSTANCE.calculateSignature(id, timestamp, body, $signingSecret)));
    }
}

