/*
 * Decompiled with CFR 0.152.
 */
package org.httpobjects.demo;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.httpobjects.HttpObject;
import org.httpobjects.Representation;
import org.httpobjects.Request;
import org.httpobjects.Response;
import org.httpobjects.header.HeaderField;

public class CMSResources
extends HttpObject {
    private final File root;

    public CMSResources(File root) {
        super("/advertiser/{cid}/cms/content/{path*}");
        this.root = root;
    }

    public Response get(Request req) {
        String cid = req.pathVars().valueFor("cid");
        String path = req.pathVars().valueFor("path");
        File localPath = path == null || path.isEmpty() ? this.root : new File(this.root, path);
        System.out.println(path);
        System.out.println(localPath);
        if (localPath.isFile()) {
            String contentType = this.contentTypeOf(localPath);
            FileInputStream data = this.FileInputStream(localPath);
            return CMSResources.OK((Representation)CMSResources.Bytes((String)contentType, (InputStream)data), (HeaderField[])new HeaderField[0]);
        }
        if (localPath.isDirectory()) {
            return CMSResources.OK((Representation)CMSResources.Html((String)this.directoryListing(cid, localPath)), (HeaderField[])new HeaderField[0]);
        }
        return CMSResources.NOT_FOUND();
    }

    private String directoryListing(String cid, File localPath) {
        StringBuffer text = new StringBuffer("<html><body><h1>Stuff specially for my favorite " + cid + "</h1>");
        text.append("<div><a href=\"..\">..</a></div><hr/>");
        for (File next : localPath.listFiles()) {
            String s = next.isDirectory() ? next.getName() + "/" : next.getName();
            text.append("<div><a href=\"" + s + "\">" + s + "</a></div>");
            text.append('\n');
        }
        text.append("</body></html>");
        return text.toString();
    }

    private FileInputStream FileInputStream(File localPath) {
        try {
            return new FileInputStream(localPath);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private String contentTypeOf(File f) {
        return "text/plain";
    }
}

