/*
 * Decompiled with CFR 0.152.
 */
package org.httpobjects.demo;

import java.io.File;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.httpobjects.HttpObject;
import org.httpobjects.Representation;
import org.httpobjects.Request;
import org.httpobjects.Response;
import org.httpobjects.demo.CMSResources;
import org.httpobjects.demo.Favicon;
import org.httpobjects.demo.PersonResource;
import org.httpobjects.eventual.Eventual;
import org.httpobjects.header.HeaderField;
import org.httpobjects.jetty.HttpObjectsJettyHandler;
import org.httpobjects.servlet.ServletFilter;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.FilterHolder;
import org.mortbay.jetty.servlet.ServletHandler;

public class Demo {
    public static void main(String[] args) throws Exception {
        BasicConfigurator.configure();
        Logger.getRootLogger().setLevel(Level.INFO);
        boolean useJetty = true;
        HttpObject[] objects = new HttpObject[]{new HttpObject("/"){

            public Eventual<Response> get(Request req) {
                return 1.OK((Representation)1.Text((String)"Hello world"), (HeaderField[])new HeaderField[0]).resolved();
            }
        }, new CMSResources(new File(System.getProperty("user.dir"))), new PersonResource(), new Favicon()};
        Demo.serveViaJettyHandler(objects);
    }

    private static void serveViaJettyHandler(HttpObject[] objects) {
        HttpObjectsJettyHandler.launchServer((int)8080, (HttpObject[])objects);
    }

    private static void serveViaServletFilter(HttpObject ... objects) throws Exception {
        Server s = new Server(8080);
        ServletHandler servletHandler = new ServletHandler();
        ServletFilter filter = new ServletFilter(objects);
        servletHandler.addFilterWithMapping(new FilterHolder((Filter)filter), "/*", 0);
        servletHandler.addServletWithMapping(WelcomeServlet.class, "/*");
        s.setHandler((Handler)servletHandler);
        s.start();
    }

    public static class WelcomeServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            resp.getWriter().write("Default Content");
        }
    }

    public static class Person {
        String name = "Stu";
        String[] aliases = new String[]{"Stew", "schtugh"};
        String birthdate = "2011-01-01";

        public String getName() {
            return this.name;
        }

        public String[] getAliases() {
            return this.aliases;
        }

        public String getBirthdate() {
            return this.birthdate;
        }
    }
}

