/*
 * Decompiled with CFR 0.152.
 */
package org.httpobjects.proxy;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.httpobjects.HttpObject;
import org.httpobjects.Representation;
import org.httpobjects.Request;
import org.httpobjects.Response;
import org.httpobjects.ResponseCode;
import org.httpobjects.header.GenericHeaderField;
import org.httpobjects.header.HeaderField;
import org.httpobjects.header.response.LocationField;
import org.httpobjects.header.response.SetCookieField;

public class Proxy
extends HttpObject {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private String base;
    private final String me;

    public Proxy(String localPath, String base, String me) {
        super(localPath + "/{path*}", null);
        this.setBase(base);
        this.me = me;
    }

    public Proxy(String base, String me) {
        this("", base, me);
    }

    public void setBase(String base) {
        this.base = Proxy.stripTrailingSlash(base);
    }

    public String getBase() {
        return this.base;
    }

    public Response get(Request req) {
        return this.proxyRequest(req, (HttpMethodBase)new GetMethod());
    }

    public Response delete(Request req) {
        return this.proxyRequest(req, (HttpMethodBase)new DeleteMethod());
    }

    public Response put(Request req) {
        PutMethod m = new PutMethod();
        this.setRequestRepresentation(req, (EntityEnclosingMethod)m);
        return this.proxyRequest(req, (HttpMethodBase)m);
    }

    public Response patch(Request req) {
        PatchMethod m = new PatchMethod();
        this.setRequestRepresentation(req, m);
        return this.proxyRequest(req, (HttpMethodBase)m);
    }

    protected void setRequestRepresentation(Request req, EntityEnclosingMethod method) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        req.representation().write((OutputStream)out);
        method.setRequestEntity((RequestEntity)new InputStreamRequestEntity((InputStream)new ByteArrayInputStream(out.toByteArray())));
    }

    public Response post(Request req) {
        PostMethod m = new PostMethod();
        this.setRequestRepresentation(req, (EntityEnclosingMethod)m);
        return this.proxyRequest(req, (HttpMethodBase)m);
    }

    protected String getQuery(Request req) {
        return req.query().toString();
    }

    protected String processUrl(String url) {
        return url;
    }

    protected Response proxyRequest(Request req, HttpMethodBase method) {
        String query;
        method.setFollowRedirects(false);
        String path = req.path().valueFor("path");
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        query = (query = this.getQuery(req)) == null ? "" : "?" + query;
        String url = this.base + path + query;
        this.log.debug((Object)("doing a " + method.getClass().getSimpleName() + " for " + url));
        try {
            method.setURI(new URI(this.processUrl(url), true));
        }
        catch (URIException e1) {
            throw new RuntimeException("Error with uri: " + url, e1);
        }
        this.addRequestHeaders(req, method);
        if (req.representation().contentType() != null) {
            method.addRequestHeader("Content-Type", req.representation().contentType());
        }
        method.addRequestHeader("X-Forwarded-For", req.connectionInfo().remoteAddress);
        for (Header next : method.getRequestHeaders()) {
            this.log.debug((Object)("Sending header: " + next));
        }
        HttpClient client = this.createHttpClient();
        return this.executeMethod(client, method, req);
    }

    protected Response executeMethod(HttpClient client, HttpMethodBase method, Request req) {
        try {
            int codeValue = client.executeMethod((HttpMethod)method);
            ResponseCode responseCode = ResponseCode.forCode((int)codeValue);
            if (responseCode == null) {
                this.log.error((Object)("Unknown response code: " + codeValue));
            } else {
                this.log.debug((Object)("Response was " + responseCode));
            }
            List<HeaderField> headersReturned = this.extractResponseHeaders(method);
            return this.createResponse(method, responseCode, headersReturned);
        }
        catch (Exception e) {
            this.log.error((Object)"Error proxying", (Throwable)e);
            return Proxy.BAD_GATEWAY();
        }
    }

    protected HttpClient createHttpClient() {
        return new HttpClient();
    }

    protected void addRequestHeaders(Request req, HttpMethodBase method) {
        for (HeaderField next : req.header().fields()) {
            method.addRequestHeader(next.name(), next.value());
        }
    }

    protected List<HeaderField> extractResponseHeaders(HttpMethodBase method) {
        ArrayList<HeaderField> headersReturned = new ArrayList<HeaderField>();
        for (Header h : method.getResponseHeaders()) {
            this.log.debug((Object)("Found header: " + h.getName() + "=" + h.getValue()));
            String name = h.getName();
            String value = h.getValue();
            if (name.equals("Set-Cookie")) {
                SetCookieField setCookieField = SetCookieField.fromHeaderValue((String)value);
                this.log.debug((Object)("Cookie found: " + setCookieField));
                headersReturned.add((HeaderField)setCookieField);
                continue;
            }
            if (name.equals("Location")) {
                String a = this.processRedirect(value);
                this.log.debug((Object)("Redirecting to " + a));
                headersReturned.add((HeaderField)new LocationField(a));
                continue;
            }
            headersReturned.add((HeaderField)new GenericHeaderField(name, value));
        }
        return headersReturned;
    }

    protected String processRedirect(String url) {
        String a = url.replaceAll(Pattern.quote(this.base), this.me);
        return a;
    }

    protected Response createResponse(final HttpMethodBase method, ResponseCode responseCode, List<HeaderField> headersReturned) {
        return new Response(responseCode, new Representation(){

            public String contentType() {
                Header h = method.getResponseHeader("Content-Type");
                return h == null ? null : h.getValue();
            }

            public void write(OutputStream out) {
                try {
                    if (method.getResponseBodyAsStream() != null) {
                        byte[] buffer = new byte[1024];
                        InputStream in = method.getResponseBodyAsStream();
                        int x = in.read(buffer);
                        while (x != -1) {
                            out.write(buffer, 0, x);
                            x = in.read(buffer);
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new RuntimeException("Error writing response", e);
                }
            }
        }, headersReturned.toArray(new HeaderField[0]));
    }

    protected static final String stripTrailingSlash(String text) {
        if (text.endsWith("/") && text.length() > 1) {
            return text.substring(0, text.length() - 1);
        }
        return text;
    }

    private static class PatchMethod
    extends EntityEnclosingMethod {
        public PatchMethod() {
        }

        private PatchMethod(String uri) {
            super(uri);
        }

        public String getName() {
            return "PATCH";
        }
    }
}

