/*
 * Decompiled with CFR 0.152.
 */
package org.httpobjects.proxy;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.httpobjects.HttpObject;
import org.httpobjects.Representation;
import org.httpobjects.Request;
import org.httpobjects.Response;
import org.httpobjects.ResponseCode;
import org.httpobjects.client.HttpClient;
import org.httpobjects.header.HeaderField;
import org.httpobjects.header.response.LocationField;
import org.httpobjects.header.response.SetCookieField;
import org.httpobjects.impl.HTLog;
import org.httpobjects.path.PathPattern;
import org.httpobjects.path.RegexPathPattern;

public class Proxy
extends HttpObject {
    private final HTLog log = new HTLog((Object)this);
    private String base;
    private final String me;
    private final HttpClient client;

    public Proxy(String localPath, String base, String me, HttpClient client) {
        super(Proxy.makePathPattern(localPath), null);
        this.setBase(base);
        this.me = me;
        this.client = client;
    }

    public Proxy(String base, String me, HttpClient client) {
        this("", base, me, client);
    }

    private static PathPattern makePathPattern(String localPath) {
        return new RegexPathPattern(Pattern.compile(Pattern.quote(localPath) + "/?(.*)"), new String[]{"path"});
    }

    public void setBase(String base) {
        this.base = Proxy.stripTrailingSlash(base);
    }

    public String getBase() {
        return this.base;
    }

    public Response get(Request req) {
        return this.prepRequest(req).execute("get");
    }

    public Response delete(Request req) {
        return this.prepRequest(req).execute("delete");
    }

    public Response put(Request req) {
        return this.prepRequest(req).execute("put");
    }

    public Response patch(Request req) {
        return this.prepRequest(req).execute("patch");
    }

    public Response options(Request req) {
        return this.prepRequest(req).execute("options");
    }

    public Response post(Request req) {
        return this.prepRequest(req).execute("post");
    }

    protected String getQuery(Request req) {
        return req.query().toString();
    }

    private PreparedRequest prepRequest(Request req) {
        String query;
        String path = req.path().valueFor("path");
        if (path == null) {
            path = "";
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if ((query = this.getQuery(req)) == null || query.equals("?")) {
            query = "";
        }
        String url = this.base + path;
        ArrayList<HeaderField> headers = new ArrayList<HeaderField>();
        for (HeaderField next : req.header().fields()) {
            headers.add(HeaderField.parse((String)next.name(), (String)next.value()));
        }
        if (req.representation().contentType() != null) {
            headers.add(HeaderField.parse((String)"Content-Type", (String)req.representation().contentType()));
        }
        headers.add(HeaderField.parse((String)"X-Forwarded-For", (String)req.connectionInfo().remoteAddress));
        HeaderField maybeHostHeader = req.header().field("host");
        if (maybeHostHeader != null) {
            headers.add(HeaderField.parse((String)"X-Forwarded-Host", (String)maybeHostHeader.value()));
        }
        PreparedRequest prep = new PreparedRequest(url, req.representation(), query, headers.toArray(new HeaderField[0]), this.client.resource(url));
        System.out.println("Prepared request: " + prep);
        return prep;
    }

    private Response handleResponse(Response response) {
        System.out.println("Handling response:" + response);
        try {
            int codeValue = response.code().value();
            ResponseCode responseCode = ResponseCode.forCode((int)codeValue);
            if (responseCode == null) {
                this.log.error("Unknown response code: " + codeValue);
            } else {
                this.log.debug("Response was " + responseCode);
            }
            List<HeaderField> headersReturned = this.extractResponseHeaders(response);
            return this.createResponse(response, headersReturned);
        }
        catch (Exception e) {
            this.log.error("Error proxying", (Throwable)e);
            return Proxy.BAD_GATEWAY();
        }
    }

    private List<HeaderField> extractResponseHeaders(Response response) {
        ArrayList<HeaderField> headersReturned = new ArrayList<HeaderField>();
        for (HeaderField h : response.header()) {
            this.log.debug("Found header: " + h.name() + "=" + h.value());
            String name = h.name();
            String value = h.value();
            if (name.toLowerCase().equals("set-cookie")) {
                SetCookieField setCookieField = SetCookieField.fromHeaderValue((String)value);
                this.log.debug("Cookie found: " + setCookieField);
                headersReturned.add((HeaderField)setCookieField);
                continue;
            }
            if (name.toLowerCase().equals("location")) {
                String a = this.processRedirect(value);
                this.log.debug("Redirecting to " + a);
                headersReturned.add((HeaderField)new LocationField(a));
                continue;
            }
            headersReturned.add(HeaderField.parse((String)name, (String)value));
        }
        return headersReturned;
    }

    private String processRedirect(String url) {
        String a = url.replaceAll(Pattern.quote(this.base), this.me);
        return a;
    }

    private HeaderField getHeader(String name, HeaderField[] headers) {
        for (HeaderField header : headers) {
            if (!header.name().toLowerCase().equals(name.toLowerCase())) continue;
            return header;
        }
        return null;
    }

    private Response createResponse(final Response response, List<HeaderField> headersReturned) {
        return new Response(response.code(), response.hasRepresentation() ? new Representation(){

            public String contentType() {
                HeaderField h = Proxy.this.getHeader("Content-Type", response.header());
                return h == null ? null : h.value();
            }

            public void write(OutputStream out) {
                response.representation().write(out);
            }
        } : null, headersReturned.toArray(new HeaderField[0]));
    }

    private static String stripTrailingSlash(String text) {
        if (text.endsWith("/") && text.length() > 1) {
            return text.substring(0, text.length() - 1);
        }
        return text;
    }

    class PreparedRequest {
        final String url;
        final Representation representation;
        final String query;
        final HeaderField[] headerFields;
        final HttpClient.RemoteObject object;

        PreparedRequest(String url, Representation representation, String query, HeaderField[] headerFields, HttpClient.RemoteObject object) {
            this.url = url;
            this.representation = representation;
            this.query = query;
            this.headerFields = headerFields;
            this.object = object;
        }

        Response execute(String method) {
            Response r;
            Proxy.this.log.info("Executing " + method + " " + this.url);
            PreparedRequest prep = this;
            if (method.equalsIgnoreCase("get")) {
                r = prep.object.get(prep.representation, prep.query, prep.headerFields);
            } else if (method.equalsIgnoreCase("delete")) {
                r = prep.object.delete(prep.representation, prep.query, prep.headerFields);
            } else if (method.equalsIgnoreCase("put")) {
                r = prep.object.put(prep.representation, prep.query, prep.headerFields);
            } else if (method.equalsIgnoreCase("patch")) {
                r = prep.object.patch(prep.representation, prep.query, prep.headerFields);
            } else if (method.equalsIgnoreCase("options")) {
                r = prep.object.options(prep.representation, prep.query, prep.headerFields);
            } else if (method.equalsIgnoreCase("post")) {
                r = prep.object.post(prep.representation, prep.query, prep.headerFields);
            } else {
                throw new RuntimeException("Not a method I support: " + method);
            }
            Proxy.this.log.info("Immediate response: " + r.code().name());
            return Proxy.this.handleResponse(r);
        }
    }
}

