/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import com.thoughtworks.xstream.XStream;
import com.trilead.ssh2.DebugLogger;
import com.trilead.ssh2.SCPClient;
import com.trilead.ssh2.crypto.Base64;
import com.trilead.ssh2.log.Logger;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.XmlFile;
import hudson.matrix.MatrixConfiguration;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.ModelObject;
import hudson.model.ParametersAction;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.remoting.VirtualChannel;
import hudson.scm.BlameSubversionChangeLogBuilder;
import hudson.scm.BlameSubversionChangeLogParser;
import hudson.scm.BlameSubversionCredentialProvider;
import hudson.scm.BlameSubversionRepositoryBrowser;
import hudson.scm.BlameSubversionWorkspaceSelector;
import hudson.scm.ChangeLogParser;
import hudson.scm.ChangeLogSet;
import hudson.scm.FilterSVNAuthenticationManager;
import hudson.scm.PerJobCredentialStore;
import hudson.scm.PollingResult;
import hudson.scm.RepositoryBrowser;
import hudson.scm.RevisionParameterAction;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.scm.SCMRevisionState;
import hudson.scm.SVNRevisionState;
import hudson.scm.UserProvidedCredential;
import hudson.util.Scrambler;
import hudson.util.Secret;
import hudson.util.XStream2;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.xml.transform.stream.StreamResult;
import net.sf.json.JSONObject;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.io.FileUtils;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Chmod;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationOutcomeListener;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNPasswordAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSHAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSLAuthentication;
import org.tmatesoft.svn.core.auth.SVNUserNameAuthentication;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.dav.http.DefaultHTTPConnectionFactory;
import org.tmatesoft.svn.core.internal.io.dav.http.IHTTPConnectionFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.internal.wc.SVNExternal;
import org.tmatesoft.svn.core.internal.wc.admin.ISVNAdminAreaFactorySelector;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaFactory;
import org.tmatesoft.svn.core.io.ISVNTunnelProvider;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlameSubversionSCM
extends SCM
implements Serializable {
    private boolean alwaysCollectSVNInfo;
    private ModuleLocation[] locations = new ModuleLocation[0];
    private boolean useUpdate;
    private boolean doRevert;
    private String excludedRegions;
    private String includedRegions;
    private String excludedUsers;
    private String excludedRevprop;
    private String excludedCommitMessages;
    @Deprecated
    private String modules;
    static final Pattern URL_PATTERN = Pattern.compile("(https?|svn(\\+[a-z0-9]+)?|file)://.+");
    private static final long serialVersionUID = 1L;
    private static final java.util.logging.Logger LOGGER;
    public static int DEFAULT_TIMEOUT;

    public boolean getAlwaysCollectSVNInfo() {
        return this.alwaysCollectSVNInfo;
    }

    @DataBoundConstructor
    public BlameSubversionSCM(boolean alwaysCollectSVNInfo) {
        this.alwaysCollectSVNInfo = alwaysCollectSVNInfo;
    }

    public String getModules() {
        return null;
    }

    @Exported
    public ModuleLocation[] getLocations() {
        return this.getLocations(null);
    }

    public ModuleLocation[] getLocations(AbstractBuild<?, ?> build) {
        if (this.modules != null) {
            ArrayList<ModuleLocation> oldLocations = new ArrayList<ModuleLocation>();
            StringTokenizer tokens = new StringTokenizer(this.modules);
            while (tokens.hasMoreTokens()) {
                String remoteLoc = Util.removeTrailingSlash((String)tokens.nextToken());
                oldLocations.add(new ModuleLocation(remoteLoc, null));
            }
            this.locations = oldLocations.toArray(new ModuleLocation[oldLocations.size()]);
            this.modules = null;
        }
        if (build == null) {
            return this.locations;
        }
        ModuleLocation[] outLocations = new ModuleLocation[this.locations.length];
        for (int i = 0; i < outLocations.length; ++i) {
            outLocations[i] = this.locations[i].getExpandedLocation(build);
        }
        return outLocations;
    }

    @Exported
    public boolean isUseUpdate() {
        return this.useUpdate;
    }

    @Exported
    public boolean isDoRevert() {
        return this.doRevert;
    }

    @Exported
    public String getExcludedRegions() {
        return this.excludedRegions;
    }

    public String[] getExcludedRegionsNormalized() {
        return this.excludedRegions == null || this.excludedRegions.trim().equals("") ? null : this.excludedRegions.split("[\\r\\n]+");
    }

    private Pattern[] getExcludedRegionsPatterns() {
        String[] excluded = this.getExcludedRegionsNormalized();
        if (excluded != null) {
            Pattern[] patterns = new Pattern[excluded.length];
            int i = 0;
            for (String excludedRegion : excluded) {
                patterns[i++] = Pattern.compile(excludedRegion);
            }
            return patterns;
        }
        return new Pattern[0];
    }

    @Exported
    public String getIncludedRegions() {
        return this.includedRegions;
    }

    public String[] getIncludedRegionsNormalized() {
        return this.includedRegions == null || this.includedRegions.trim().equals("") ? null : this.includedRegions.split("[\\r\\n]+");
    }

    private Pattern[] getIncludedRegionsPatterns() {
        String[] included = this.getIncludedRegionsNormalized();
        if (included != null) {
            Pattern[] patterns = new Pattern[included.length];
            int i = 0;
            for (String includedRegion : included) {
                patterns[i++] = Pattern.compile(includedRegion);
            }
            return patterns;
        }
        return new Pattern[0];
    }

    @Exported
    public String getExcludedUsers() {
        return this.excludedUsers;
    }

    public Set<String> getExcludedUsersNormalized() {
        String s = Util.fixEmptyAndTrim((String)this.excludedUsers);
        if (s == null) {
            return Collections.emptySet();
        }
        HashSet<String> users = new HashSet<String>();
        for (String user : s.split("[\\r\\n]+")) {
            users.add(user.trim());
        }
        return users;
    }

    @Exported
    public String getExcludedRevprop() {
        return this.excludedRevprop;
    }

    private String getExcludedRevpropNormalized() {
        String s = Util.fixEmptyAndTrim((String)this.getExcludedRevprop());
        if (s != null) {
            return s;
        }
        return this.getDescriptor().getGlobalExcludedRevprop();
    }

    @Exported
    public String getExcludedCommitMessages() {
        return this.excludedCommitMessages;
    }

    public String[] getExcludedCommitMessagesNormalized() {
        String s = Util.fixEmptyAndTrim((String)this.excludedCommitMessages);
        return s == null ? new String[]{} : s.split("[\\r\\n]+");
    }

    private Pattern[] getExcludedCommitMessagesPatterns() {
        String[] excluded = this.getExcludedCommitMessagesNormalized();
        Pattern[] patterns = new Pattern[excluded.length];
        int i = 0;
        for (String excludedCommitMessage : excluded) {
            patterns[i++] = Pattern.compile(excludedCommitMessage);
        }
        return patterns;
    }

    public void buildEnvVars(AbstractBuild<?, ?> build, Map<String, String> env) {
        super.buildEnvVars(build, env);
        ModuleLocation[] svnLocations = this.getLocations(build);
        try {
            Long rev;
            Map<String, Long> revisions = BlameSubversionSCM.parseRevisionFile(build);
            if (svnLocations.length == 1 && (rev = revisions.get(svnLocations[0].remote)) != null) {
                env.put("SVN_REVISION", rev.toString());
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean calcChangeLog(AbstractBuild<?, ?> build, File changelogFile, BuildListener listener, List<External> externals) throws IOException, InterruptedException {
        boolean created;
        if (build.getPreviousBuild() == null) {
            return this.createEmptyChangeLog(changelogFile, listener, "log");
        }
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(changelogFile));
        try {
            created = new BlameSubversionChangeLogBuilder(build, listener, this).run(externals, new StreamResult(os));
        }
        finally {
            ((OutputStream)os).close();
        }
        if (!created) {
            this.createEmptyChangeLog(changelogFile, listener, "log");
        }
        return true;
    }

    static Map<String, Long> parseRevisionFile(AbstractBuild<?, ?> build) throws IOException {
        return BlameSubversionSCM.parseRevisionFile(build, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<String, Long> parseRevisionFile(AbstractBuild<?, ?> build, boolean findClosest) throws IOException {
        HashMap<String, Long> revisions;
        block10: {
            File file;
            revisions = new HashMap<String, Long>();
            if (findClosest) {
                for (AbstractBuild b = build; b != null; b = (AbstractBuild)b.getPreviousBuild()) {
                    if (!BlameSubversionSCM.getRevisionFile(b).exists()) continue;
                    build = b;
                    break;
                }
            }
            if (!(file = BlameSubversionSCM.getRevisionFile(build)).exists()) {
                return revisions;
            }
            BufferedReader br = new BufferedReader(new FileReader(file));
            block6: while (true) {
                String line;
                while ((line = br.readLine()) != null) {
                    int index = line.lastIndexOf(47);
                    if (index < 0) continue;
                    try {
                        revisions.put(line.substring(0, index), Long.parseLong(line.substring(index + 1)));
                        continue block6;
                    }
                    catch (NumberFormatException e) {
                    }
                }
                break block10;
                {
                    continue block6;
                    break;
                }
                break;
            }
            finally {
                br.close();
            }
        }
        return revisions;
    }

    static List<External> parseExternalsFile(AbstractProject project) throws IOException {
        File file = BlameSubversionSCM.getExternalsFile(project);
        if (file.exists()) {
            try {
                return (List)new XmlFile(External.XSTREAM, file).read();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return Collections.emptyList();
    }

    public boolean requiresWorkspaceForPolling() {
        return false;
    }

    public boolean checkout(AbstractBuild build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        if (!this.alwaysCollectSVNInfo && !this.isBuildTriggeredByUpStreamJob(build.getCauses())) {
            return true;
        }
        return this.recordTheUpstreamRecipients(build, workspace, listener, changelogFile);
    }

    private boolean isBuildTriggeredByUpStreamJob(List<Cause> causes) {
        return causes != null & causes.size() > 0 & causes.get(causes.size() - 1) instanceof Cause.UpstreamCause;
    }

    protected PollingResult compareRemoteRevisionWith(AbstractProject<?, ?> project, Launcher launcher, FilePath workspace, TaskListener listener, SCMRevisionState baseline) throws IOException, InterruptedException {
        return PollingResult.NO_CHANGES;
    }

    private boolean recordTheUpstreamRecipients(AbstractBuild build, FilePath workspace, BuildListener listener, File changelogFile) {
        List upstreamProjects = build.getProject().getUpstreamProjects();
        AbstractBuild upStreamLastTriggerBuild = this.getTrigerBuild(upstreamProjects);
        if (upStreamLastTriggerBuild != null) {
            ChangeLogSet upStreamBuildChangeSet = upStreamLastTriggerBuild.getChangeSet();
            listener.getLogger().println("begin get changelog from the project " + upStreamLastTriggerBuild.getProject().getName() + " and the build number is " + upStreamLastTriggerBuild.getNumber());
            for (ChangeLogSet.Entry entry : upStreamBuildChangeSet) {
                listener.getLogger().println("the committer is :" + entry.getAuthor());
                listener.getLogger().println("message   is :" + entry.getMsg());
                listener.getLogger().println("affect path   is :" + entry.getAffectedPaths());
            }
            this.copyChangeLogFromTriggerJob(build, upStreamLastTriggerBuild);
            this.copyRevisionFromTriggerJob(build, upStreamLastTriggerBuild);
            listener.getLogger().println("end copy the changelog from the project " + upStreamLastTriggerBuild.getProject().getName());
        } else if (build.getProject() instanceof MatrixConfiguration) {
            MatrixConfiguration configuration = (MatrixConfiguration)build.getProject();
            this.copyChangeLogFromTriggerJob(build, (AbstractBuild)configuration.getParent().getLastBuild());
            this.copyRevisionFromTriggerJob(build, (AbstractBuild)configuration.getParent().getLastBuild());
        }
        return true;
    }

    private AbstractBuild getTrigerBuild(List<AbstractProject> upstreamProjects) {
        AbstractBuild upStreamLastTriggerBuild = null;
        for (AbstractProject project : upstreamProjects) {
            AbstractBuild upStreamLastBuild = (AbstractBuild)project.getLastBuild();
            AbstractBuild abstractBuild = upStreamLastTriggerBuild = upStreamLastTriggerBuild == null ? upStreamLastBuild : upStreamLastTriggerBuild;
            if (upStreamLastBuild.getTimeInMillis() <= upStreamLastTriggerBuild.getTimeInMillis()) continue;
            upStreamLastTriggerBuild = upStreamLastBuild;
        }
        return upStreamLastTriggerBuild;
    }

    private void copyChangeLogFromTriggerJob(AbstractBuild build, AbstractBuild triggerBuild) {
        try {
            String s;
            BufferedReader reader = new BufferedReader(new FileReader(triggerBuild.getRootDir() + "/" + "changelog.xml"));
            ArrayList<String> buffer = new ArrayList<String>();
            while ((s = reader.readLine()) != null) {
                buffer.add(s);
            }
            reader.close();
            this.writeChgLog(buffer, build.getRootDir() + "/" + "changelog.xml");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    private void copyRevisionFromTriggerJob(AbstractBuild build, AbstractBuild triggerBuild) {
        try {
            String s;
            BufferedReader reader = new BufferedReader(new FileReader(triggerBuild.getRootDir() + "/" + "revision.txt"));
            ArrayList<String> buffer = new ArrayList<String>();
            while ((s = reader.readLine()) != null) {
                buffer.add(s + "\n");
            }
            reader.close();
            this.writeChgLog(buffer, build.getRootDir() + "/" + "revision.txt");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    private void writeChgLog(List<String> buffer, String filename) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(filename));
        for (String str : buffer) {
            writer.write(str);
        }
        writer.close();
    }

    private boolean isSVNRepositoryURLNull(AbstractBuild build) {
        ModuleLocation[] locations;
        for (ModuleLocation location : locations = this.getLocations(build)) {
            if (location.local != null && !location.remote.trim().equals("")) continue;
            return true;
        }
        return false;
    }

    public static SVNClientManager createSvnClientManager(ISVNAuthenticationProvider authProvider) {
        ISVNAuthenticationManager sam = SVNWCUtil.createDefaultAuthenticationManager();
        sam.setAuthenticationProvider(authProvider);
        return SVNClientManager.newInstance((ISVNOptions)SVNWCUtil.createDefaultOptions((boolean)true), (ISVNAuthenticationManager)sam);
    }

    public static SVNClientManager createSvnClientManager(AbstractProject context) {
        return BlameSubversionSCM.createSvnClientManager(((DescriptorImpl)Hudson.getInstance().getDescriptorByType(DescriptorImpl.class)).createAuthenticationProvider(context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SVNInfo parseSvnInfo(File workspace, ISVNAuthenticationProvider authProvider) throws SVNException {
        SVNClientManager manager = BlameSubversionSCM.createSvnClientManager(authProvider);
        try {
            SVNWCClient svnWc = manager.getWCClient();
            SVNInfo sVNInfo = svnWc.doInfo(workspace, SVNRevision.WORKING);
            return sVNInfo;
        }
        finally {
            manager.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SVNInfo parseSvnInfo(SVNURL remoteUrl, ISVNAuthenticationProvider authProvider) throws SVNException {
        SVNClientManager manager = BlameSubversionSCM.createSvnClientManager(authProvider);
        try {
            SVNWCClient svnWc = manager.getWCClient();
            SVNInfo sVNInfo = svnWc.doInfo(remoteUrl, SVNRevision.HEAD, SVNRevision.HEAD);
            return sVNInfo;
        }
        finally {
            manager.dispose();
        }
    }

    public static File getRevisionFile(AbstractBuild build) {
        return new File(build.getRootDir(), "revision.txt");
    }

    private static File getExternalsFile(AbstractProject project) {
        return new File(project.getRootDir(), "svnexternals.txt");
    }

    public SCMRevisionState calcRevisionsFromBuild(AbstractBuild<?, ?> build, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        Map<String, Long> wsRev = BlameSubversionSCM.parseRevisionFile(build, true);
        for (External e : BlameSubversionSCM.parseExternalsFile(build.getProject())) {
            if (!e.isRevisionFixed()) continue;
            wsRev.remove(e.url);
        }
        return new SVNRevisionState(wsRev);
    }

    public ChangeLogParser createChangeLogParser() {
        return new BlameSubversionChangeLogParser();
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public FilePath getModuleRoot(FilePath workspace) {
        if (this.getLocations().length > 0) {
            return workspace.child(this.getLocations()[0].getLocalDir());
        }
        return workspace;
    }

    public FilePath[] getModuleRoots(FilePath workspace) {
        ModuleLocation[] moduleLocations = this.getLocations();
        if (moduleLocations.length > 0) {
            FilePath[] moduleRoots = new FilePath[moduleLocations.length];
            for (int i = 0; i < moduleLocations.length; ++i) {
                moduleRoots[i] = workspace.child(moduleLocations[i].getLocalDir());
            }
            return moduleRoots;
        }
        return new FilePath[]{this.getModuleRoot(workspace)};
    }

    private static String getLastPathComponent(String s) {
        String[] tokens = s.split("/");
        return tokens[tokens.length - 1];
    }

    public boolean repositoryLocationsNoLongerExist(AbstractBuild<?, ?> build, TaskListener listener) {
        PrintStream out = listener.getLogger();
        for (ModuleLocation l : this.getLocations(build)) {
            try {
                if (this.getDescriptor().checkRepositoryPath(build.getProject(), l.getSVNURL()) != SVNNodeKind.NONE) continue;
                out.println("Location '" + l.remote + "' does not exist");
                ParametersAction params = (ParametersAction)build.getAction(ParametersAction.class);
                if (params != null) {
                    LOGGER.fine("Location could be expanded on build '" + build + "' parameters values:");
                    return false;
                }
                return true;
            }
            catch (SVNException e) {
                LOGGER.log(Level.FINE, "Location check failed", e);
            }
        }
        return false;
    }

    public static void init() {
    }

    public static void enableSshDebug(Level level) {
        if (level == null) {
            level = Level.FINEST;
        }
        final Level lv = level;
        Logger.enabled = true;
        Logger.logger = new DebugLogger(){
            private final java.util.logging.Logger LOGGER = java.util.logging.Logger.getLogger(SCPClient.class.getPackage().getName());

            public void log(int level, String className, String message) {
                this.LOGGER.log(lv, className + ' ' + message);
            }
        };
    }

    static boolean compareSVNAuthentications(SVNAuthentication a1, SVNAuthentication a2) {
        if (a1 == null && a2 == null) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        if (a1.getClass() != a2.getClass()) {
            return false;
        }
        try {
            return ((Object)BlameSubversionSCM.describeBean(a1)).equals(BlameSubversionSCM.describeBean(a2));
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            return false;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private static Map describeBean(Object o) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        Map m = PropertyUtils.describe((Object)o);
        for (Map.Entry entry : m.entrySet()) {
            Object v = entry.getValue();
            if (!(v instanceof char[])) continue;
            char[] chars = (char[])v;
            entry.setValue(new String(chars));
        }
        return m;
    }

    static {
        new Initializer();
        LOGGER = java.util.logging.Logger.getLogger(BlameSubversionSCM.class.getName());
        DEFAULT_TIMEOUT = Integer.getInteger(BlameSubversionSCM.class.getName() + ".timeout", 3600000);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @ExportedBean
    public static final class ModuleLocation
    implements Serializable {
        @Exported
        public final String remote;
        @Exported
        public final String local;
        private volatile transient UUID repositoryUUID;
        private volatile transient SVNURL repositoryRoot;
        private static final long serialVersionUID = 1L;

        @DataBoundConstructor
        public ModuleLocation(String remote, String local) {
            this.remote = Util.removeTrailingSlash((String)Util.fixNull((String)remote).trim());
            this.local = Util.fixEmptyAndTrim((String)local);
        }

        public String getLocalDir() {
            if (this.local == null) {
                return BlameSubversionSCM.getLastPathComponent(this.remote);
            }
            return this.local;
        }

        public String getURL() {
            int idx = this.remote.lastIndexOf(64);
            if (idx > 0) {
                try {
                    String n = this.remote.substring(idx + 1);
                    Long.parseLong(n);
                    return this.remote.substring(0, idx);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return this.remote;
        }

        public SVNURL getSVNURL() throws SVNException {
            return SVNURL.parseURIEncoded((String)this.getURL());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public UUID getUUID(AbstractProject context) throws SVNException {
            if (this.repositoryUUID == null || this.repositoryRoot == null) {
                ModuleLocation moduleLocation = this;
                synchronized (moduleLocation) {
                    SVNRepository r = this.openRepository(context);
                    r.testConnection();
                    this.repositoryUUID = UUID.fromString(r.getRepositoryUUID(false));
                    this.repositoryRoot = r.getRepositoryRoot(false);
                }
            }
            return this.repositoryUUID;
        }

        public SVNRepository openRepository(AbstractProject context) throws SVNException {
            return ((DescriptorImpl)Hudson.getInstance().getDescriptorByType(DescriptorImpl.class)).getRepository(context, this.getSVNURL());
        }

        public SVNURL getRepositoryRoot(AbstractProject context) throws SVNException {
            this.getUUID(context);
            return this.repositoryRoot;
        }

        public SVNRevision getRevision(SVNRevision defaultValue) {
            int idx = this.remote.lastIndexOf(64);
            if (idx > 0) {
                try {
                    String n = this.remote.substring(idx + 1);
                    return SVNRevision.create((long)Long.parseLong(n));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return defaultValue;
        }

        private String getExpandedRemote(AbstractBuild<?, ?> build) {
            String outRemote = this.remote;
            ParametersAction parameters = (ParametersAction)build.getAction(ParametersAction.class);
            if (parameters != null) {
                outRemote = parameters.substitute(build, this.remote);
            }
            return outRemote;
        }

        public ModuleLocation getExpandedLocation(AbstractBuild<?, ?> build) {
            return new ModuleLocation(this.getExpandedRemote(build), this.getLocalDir());
        }

        public String toString() {
            return this.remote;
        }

        public static List<ModuleLocation> parse(String[] remoteLocations, String[] localLocations) {
            ArrayList<ModuleLocation> modules = new ArrayList<ModuleLocation>();
            if (remoteLocations != null && localLocations != null) {
                int entries = Math.min(remoteLocations.length, localLocations.length);
                for (int i = 0; i < entries; ++i) {
                    String remoteLoc = Util.nullify((String)remoteLocations[i]);
                    if (remoteLoc == null) continue;
                    remoteLoc = Util.removeTrailingSlash((String)remoteLoc.trim());
                    modules.add(new ModuleLocation(remoteLoc, Util.nullify((String)localLocations[i])));
                }
            }
            return modules;
        }
    }

    private static final class Initializer {
        private Initializer() {
        }

        static {
            if (Boolean.getBoolean("hudson.spool-svn")) {
                DAVRepositoryFactory.setup((IHTTPConnectionFactory)new DefaultHTTPConnectionFactory(null, true, null));
            } else {
                DAVRepositoryFactory.setup();
            }
            SVNRepositoryFactoryImpl.setup();
            FSRepositoryFactory.setup();
            if (System.getProperty("svnkit.ssh2.persistent") == null) {
                System.setProperty("svnkit.ssh2.persistent", "false");
            }
            SVNAdminAreaFactory.setSelector((ISVNAdminAreaFactorySelector)new BlameSubversionWorkspaceSelector());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends SCMDescriptor<BlameSubversionSCM>
    implements ModelObject {
        private final Map<String, Credential> credentials = new Hashtable<String, Credential>();
        private String globalExcludedRevprop = null;
        private final transient RemotableSVNAuthenticationProviderImpl remotableProvider = new RemotableSVNAuthenticationProviderImpl();
        private static final Pattern USERNAME_PATTERN = Pattern.compile("(\\w+\\\\)?+(\\w+)");

        public SCM newInstance(StaplerRequest staplerRequest, JSONObject jsonObject) throws Descriptor.FormException {
            return (SCM)super.newInstance(staplerRequest, jsonObject);
        }

        public DescriptorImpl() {
            super(BlameSubversionRepositoryBrowser.class);
            this.load();
        }

        protected DescriptorImpl(Class clazz, Class<? extends RepositoryBrowser> repositoryBrowser) {
            super(clazz, repositoryBrowser);
        }

        public String getDisplayName() {
            return "Blame Subversion";
        }

        public String getGlobalExcludedRevprop() {
            return this.globalExcludedRevprop;
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.globalExcludedRevprop = Util.fixEmptyAndTrim((String)req.getParameter("svn.global_excluded_revprop"));
            this.save();
            return super.configure(req, formData);
        }

        public boolean isBrowserReusable(BlameSubversionSCM x, BlameSubversionSCM y) {
            ModuleLocation[] yl;
            ModuleLocation[] xl = x.getLocations();
            if (xl.length != (yl = y.getLocations()).length) {
                return false;
            }
            for (int i = 0; i < xl.length; ++i) {
                if (xl[i].getURL().equals(yl[i].getURL())) continue;
                return false;
            }
            return true;
        }

        public ISVNAuthenticationProvider createAuthenticationProvider(AbstractProject<?, ?> inContextOf) {
            return new SVNAuthenticationProviderImpl(inContextOf == null ? null : new PerJobCredentialStore(inContextOf), this.remotableProvider);
        }

        public ISVNAuthenticationProvider createAuthenticationProvider() {
            return new SVNAuthenticationProviderImpl(null, this.remotableProvider);
        }

        public void postCredential(String url, String username, String password, File keyFile, PrintWriter logWriter) throws SVNException, IOException {
            this.postCredential(null, url, username, password, keyFile, logWriter);
        }

        public void postCredential(AbstractProject inContextOf, String url, String username, String password, File keyFile, PrintWriter logWriter) throws SVNException, IOException {
            this.postCredential(url, new UserProvidedCredential(username, password, keyFile, inContextOf), logWriter);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void postCredential(String url, final UserProvidedCredential upc, PrintWriter logWriter) throws SVNException, IOException {
            SVNRepository repository = null;
            try {
                repository = SVNRepositoryFactory.create((SVNURL)SVNURL.parseURIDecoded((String)url));
                repository.setTunnelProvider((ISVNTunnelProvider)SVNWCUtil.createDefaultOptions((boolean)true));
                UserProvidedCredential userProvidedCredential = upc;
                userProvidedCredential.getClass();
                UserProvidedCredential.AuthenticationManagerImpl authManager = new UserProvidedCredential.AuthenticationManagerImpl(userProvidedCredential, logWriter){
                    {
                        UserProvidedCredential userProvidedCredential2 = x0;
                        userProvidedCredential2.getClass();
                        super(userProvidedCredential2, x1);
                    }

                    protected void onSuccess(String realm, Credential cred) {
                        LOGGER.info("Persisted " + cred + " for " + realm);
                        DescriptorImpl.this.credentials.put(realm, cred);
                        DescriptorImpl.this.save();
                        if (upc.inContextOf != null) {
                            new PerJobCredentialStore(upc.inContextOf).acknowledgeAuthentication(realm, cred);
                        }
                    }
                };
                authManager.setAuthenticationForced(true);
                repository.setAuthenticationManager((ISVNAuthenticationManager)authManager);
                repository.testConnection();
                authManager.checkIfProtocolCompleted();
            }
            finally {
                if (repository != null) {
                    repository.closeSession();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SVNNodeKind checkRepositoryPath(AbstractProject context, SVNURL repoURL) throws SVNException {
            SVNRepository repository = null;
            try {
                repository = this.getRepository(context, repoURL);
                repository.testConnection();
                long rev = repository.getLatestRevision();
                String repoPath = DescriptorImpl.getRelativePath(repoURL, repository);
                SVNNodeKind sVNNodeKind = repository.checkPath(repoPath, rev);
                return sVNNodeKind;
            }
            finally {
                if (repository != null) {
                    repository.closeSession();
                }
            }
        }

        protected SVNRepository getRepository(AbstractProject context, SVNURL repoURL) throws SVNException {
            SVNRepository repository = SVNRepositoryFactory.create((SVNURL)repoURL);
            ISVNAuthenticationManager sam = SVNWCUtil.createDefaultAuthenticationManager();
            sam = new FilterSVNAuthenticationManager(sam){

                public int getReadTimeout(SVNRepository repository) {
                    int r = super.getReadTimeout(repository);
                    if (r <= 0) {
                        r = DEFAULT_TIMEOUT;
                    }
                    return r;
                }
            };
            sam.setAuthenticationProvider(this.createAuthenticationProvider(context));
            repository.setTunnelProvider((ISVNTunnelProvider)SVNWCUtil.createDefaultOptions((boolean)true));
            repository.setAuthenticationManager(sam);
            return repository;
        }

        public static String getRelativePath(SVNURL repoURL, SVNRepository repository) throws SVNException {
            String repoPath = repoURL.getPath().substring(repository.getRepositoryRoot(false).getPath().length());
            if (!repoPath.startsWith("/")) {
                repoPath = "/" + repoPath;
            }
            return repoPath;
        }

        static {
            new Initializer();
        }

        private static final class SVNAuthenticationProviderImpl
        implements ISVNAuthenticationProvider,
        ISVNAuthenticationOutcomeListener,
        Serializable {
            private final RemotableSVNAuthenticationProvider local;
            private final RemotableSVNAuthenticationProvider global;
            private Credential lastCredential;
            private static final long serialVersionUID = 1L;

            public SVNAuthenticationProviderImpl(RemotableSVNAuthenticationProvider local, RemotableSVNAuthenticationProvider global) {
                this.global = global;
                this.local = local;
            }

            private SVNAuthentication fromProvider(SVNURL url, String realm, String kind, RemotableSVNAuthenticationProvider src, String debugName) throws SVNException {
                if (src == null) {
                    return null;
                }
                Credential cred = src.getCredential(url, realm);
                LOGGER.fine(String.format("%s.requestClientAuthentication(%s,%s,%s)=>%s", debugName, kind, url, realm, cred));
                this.lastCredential = cred;
                if (cred != null) {
                    return cred.createSVNAuthentication(kind);
                }
                return null;
            }

            public SVNAuthentication requestClientAuthentication(String kind, SVNURL url, String realm, SVNErrorMessage errorMessage, SVNAuthentication previousAuth, boolean authMayBeStored) {
                try {
                    SVNAuthentication auth = this.fromProvider(url, realm, kind, this.local, "local");
                    if (auth == null || BlameSubversionSCM.compareSVNAuthentications(auth, previousAuth)) {
                        auth = this.fromProvider(url, realm, kind, this.global, "global");
                    }
                    if (previousAuth != null && BlameSubversionSCM.compareSVNAuthentications(auth, previousAuth)) {
                        LOGGER.fine("Previous authentication attempt failed, so aborting: " + previousAuth);
                        return null;
                    }
                    if (auth == null && "svn.username".equals(kind)) {
                        return new SVNUserNameAuthentication("", false);
                    }
                    return auth;
                }
                catch (SVNException e) {
                    LOGGER.log(Level.SEVERE, "Failed to authorize", e);
                    throw new RuntimeException("Failed to authorize", e);
                }
            }

            public void acknowledgeAuthentication(boolean accepted, String kind, String realm, SVNErrorMessage errorMessage, SVNAuthentication authentication) throws SVNException {
                if (accepted && this.local != null) {
                    this.local.acknowledgeAuthentication(realm, this.lastCredential);
                }
            }

            public int acceptServerAuthentication(SVNURL url, String realm, Object certificate, boolean resultMayBeStored) {
                return 1;
            }
        }

        private final class RemotableSVNAuthenticationProviderImpl
        implements RemotableSVNAuthenticationProvider {
            private RemotableSVNAuthenticationProviderImpl() {
            }

            public Credential getCredential(SVNURL url, String realm) {
                for (BlameSubversionCredentialProvider p : BlameSubversionCredentialProvider.all()) {
                    Credential c = p.getCredential(url, realm);
                    if (c == null) continue;
                    LOGGER.fine(String.format("getCredential(%s)=>%s by %s", realm, c, p));
                    return c;
                }
                LOGGER.fine(String.format("getCredential(%s)=>%s", realm, DescriptorImpl.this.credentials.get(realm)));
                return (Credential)DescriptorImpl.this.credentials.get(realm);
            }

            public void acknowledgeAuthentication(String realm, Credential credential) {
            }

            private Object writeReplace() {
                return Channel.current().export(RemotableSVNAuthenticationProvider.class, (Object)this);
            }
        }

        static interface RemotableSVNAuthenticationProvider
        extends Serializable {
            public Credential getCredential(SVNURL var1, String var2);

            public void acknowledgeAuthentication(String var1, Credential var2);
        }

        public static final class SslClientCertificateCredential
        extends Credential {
            private final Secret certificate;
            private final String password;

            public SslClientCertificateCredential(File certificate, String password) throws IOException {
                this.password = Scrambler.scramble((String)password);
                this.certificate = Secret.fromString((String)new String(Base64.encode((byte[])FileUtils.readFileToByteArray((File)certificate))));
            }

            public SVNAuthentication createSVNAuthentication(String kind) {
                if (kind.equals("svn.ssl.client-passphrase")) {
                    try {
                        return new SVNSSLAuthentication(Base64.decode((char[])this.certificate.toString().toCharArray()), Scrambler.descramble((String)this.password), false);
                    }
                    catch (IOException e) {
                        throw new Error(e);
                    }
                }
                return null;
            }
        }

        public static final class SshPublicKeyCredential
        extends Credential {
            private final String userName;
            private final String passphrase;
            private final String id;

            public SshPublicKeyCredential(String userName, String passphrase, File keyFile) throws SVNException {
                this.userName = userName;
                this.passphrase = Scrambler.scramble((String)passphrase);
                Random r = new Random();
                StringBuilder buf = new StringBuilder();
                for (int i = 0; i < 16; ++i) {
                    buf.append(Integer.toHexString(r.nextInt(16)));
                }
                this.id = buf.toString();
                try {
                    FileUtils.copyFile((File)keyFile, (File)this.getKeyFile());
                }
                catch (IOException e) {
                    throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.AUTHN_CREDS_UNAVAILABLE, (String)"Unable to save private key"), (Throwable)e);
                }
            }

            private File getKeyFile() {
                File dir = new File(Hudson.getInstance().getRootDir(), "subversion-credentials");
                if (dir.mkdirs()) {
                    try {
                        Chmod chmod = new Chmod();
                        chmod.setProject(new Project());
                        chmod.setFile(dir);
                        chmod.setPerm("600");
                        chmod.execute();
                    }
                    catch (Throwable e) {
                        LOGGER.log(Level.WARNING, "Failed to set directory permission of " + dir, e);
                    }
                }
                return new File(dir, this.id);
            }

            public SVNSSHAuthentication createSVNAuthentication(String kind) throws SVNException {
                if (kind.equals("svn.ssh")) {
                    try {
                        Channel channel = Channel.current();
                        String privateKey = channel != null ? (String)channel.call((Callable)new Callable<String, IOException>(){

                            public String call() throws IOException {
                                return FileUtils.readFileToString((File)SshPublicKeyCredential.this.getKeyFile(), (String)"iso-8859-1");
                            }
                        }) : FileUtils.readFileToString((File)this.getKeyFile(), (String)"iso-8859-1");
                        return new SVNSSHAuthentication(this.userName, privateKey.toCharArray(), Scrambler.descramble((String)this.passphrase), -1, false);
                    }
                    catch (IOException e) {
                        throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.AUTHN_CREDS_UNAVAILABLE, (String)"Unable to load private key"), (Throwable)e);
                    }
                    catch (InterruptedException e) {
                        throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.AUTHN_CREDS_UNAVAILABLE, (String)"Unable to load private key"), (Throwable)e);
                    }
                }
                return null;
            }
        }

        public static final class PasswordCredential
        extends Credential {
            private final String userName;
            private final String password;

            public PasswordCredential(String userName, String password) {
                this.userName = userName;
                this.password = Scrambler.scramble((String)password);
            }

            public SVNAuthentication createSVNAuthentication(String kind) {
                if (kind.equals("svn.ssh")) {
                    return new SVNSSHAuthentication(this.userName, Scrambler.descramble((String)this.password), -1, false);
                }
                return new SVNPasswordAuthentication(this.userName, Scrambler.descramble((String)this.password), false);
            }
        }

        public static abstract class Credential
        implements Serializable {
            public abstract SVNAuthentication createSVNAuthentication(String var1) throws SVNException;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IsUpdatableTask
    implements FilePath.FileCallable<Boolean> {
        private final TaskListener listener;
        private final ISVNAuthenticationProvider authProvider;
        private final ModuleLocation[] locations;
        private static final long serialVersionUID = 1L;

        IsUpdatableTask(AbstractBuild<?, ?> build, BlameSubversionSCM parent, TaskListener listener) {
            this.authProvider = parent.getDescriptor().createAuthenticationProvider((AbstractProject)build.getParent());
            this.listener = listener;
            this.locations = parent.getLocations(build);
        }

        public Boolean invoke(File ws, VirtualChannel channel) throws IOException {
            for (ModuleLocation l : this.locations) {
                String moduleName = l.getLocalDir();
                File module = new File(ws, moduleName).getCanonicalFile();
                if (!module.exists()) {
                    this.listener.getLogger().println("Checking out a fresh workspace because " + module + " doesn't exist");
                    return false;
                }
                try {
                    SVNInfo svnkitInfo = BlameSubversionSCM.parseSvnInfo(module, this.authProvider);
                    SvnInfo svnInfo = new SvnInfo(svnkitInfo);
                    String url = l.getURL();
                    if (svnInfo.url.equals(url)) continue;
                    this.listener.getLogger().println("Checking out a fresh workspace because the workspace is not " + url);
                    return false;
                }
                catch (SVNException e) {
                    if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_DIRECTORY) {
                        this.listener.getLogger().println("Checking out a fresh workspace because there's no workspace at " + module);
                    } else {
                        this.listener.getLogger().println("Checking out a fresh workspace because Hudson failed to detect the current workspace " + module);
                        e.printStackTrace(this.listener.error(e.getMessage()));
                    }
                    return false;
                }
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BuildRevisionMapTask
    implements FilePath.FileCallable<Map<String, SvnInfo>> {
        private final ISVNAuthenticationProvider authProvider;
        private final TaskListener listener;
        private final List<External> externals;
        private final ModuleLocation[] locations;
        private static final long serialVersionUID = 1L;

        public BuildRevisionMapTask(AbstractBuild<?, ?> build, BlameSubversionSCM parent, TaskListener listener, List<External> externals) {
            this.authProvider = parent.getDescriptor().createAuthenticationProvider((AbstractProject)build.getParent());
            this.listener = listener;
            this.externals = externals;
            this.locations = parent.getLocations(build);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<String, SvnInfo> invoke(File ws, VirtualChannel channel) throws IOException {
            HashMap<String, SvnInfo> revisions = new HashMap<String, SvnInfo>();
            SVNClientManager manager = BlameSubversionSCM.createSvnClientManager(this.authProvider);
            try {
                SVNWCClient svnWc = manager.getWCClient();
                for (ModuleLocation module : this.locations) {
                    try {
                        SvnInfo info = new SvnInfo(svnWc.doInfo(new File(ws, module.getLocalDir()), SVNRevision.WORKING));
                        revisions.put(info.url, info);
                    }
                    catch (SVNException e) {
                        e.printStackTrace(this.listener.error("Failed to parse svn info for " + module.remote));
                    }
                }
                for (External ext : this.externals) {
                    try {
                        SvnInfo info = new SvnInfo(svnWc.doInfo(new File(ws, ext.path), SVNRevision.WORKING));
                        revisions.put(info.url, info);
                    }
                    catch (SVNException e) {
                        e.printStackTrace(this.listener.error("Failed to parse svn info for external " + ext.url + " at " + ext.path));
                    }
                }
                HashMap<String, SvnInfo> hashMap = revisions;
                return hashMap;
            }
            finally {
                manager.dispose();
            }
        }
    }

    static final class External
    implements Serializable {
        final String path;
        final String url;
        final long revision;
        private static final long serialVersionUID = 1L;
        private static final XStream XSTREAM = new XStream2();

        External(String modulePath, SVNExternal ext) {
            this.path = modulePath + '/' + ext.getPath();
            this.url = ext.getResolvedURL().toDecodedString();
            this.revision = ext.getRevision().getNumber();
        }

        boolean isRevisionFixed() {
            return this.revision != -1L;
        }

        static {
            XSTREAM.alias("external", External.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SvnInfo
    implements Serializable,
    Comparable<SvnInfo> {
        public final String url;
        public final long revision;
        private static final long serialVersionUID = 1L;

        public SvnInfo(String url, long revision) {
            this.url = url;
            this.revision = revision;
        }

        public SvnInfo(SVNInfo info) {
            this(info.getURL().toDecodedString(), info.getCommittedRevision().getNumber());
        }

        public SVNURL getSVNURL() throws SVNException {
            return SVNURL.parseURIDecoded((String)this.url);
        }

        @Override
        public int compareTo(SvnInfo that) {
            int r = this.url.compareTo(that.url);
            if (r != 0) {
                return r;
            }
            if (this.revision < that.revision) {
                return -1;
            }
            if (this.revision > that.revision) {
                return 1;
            }
            return 0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SvnInfo svnInfo = (SvnInfo)o;
            return this.revision == svnInfo.revision && this.url.equals(svnInfo.url);
        }

        public int hashCode() {
            int result = this.url.hashCode();
            result = 31 * result + (int)(this.revision ^ this.revision >>> 32);
            return result;
        }

        public String toString() {
            return String.format("%s (rev.%s)", this.url, this.revision);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CheckOutTask
    implements FilePath.FileCallable<List<External>> {
        private final ISVNAuthenticationProvider authProvider;
        private final Date timestamp;
        private boolean update;
        private boolean revert;
        private final TaskListener listener;
        private final ModuleLocation[] locations;
        private final RevisionParameterAction revisions;
        private static final long serialVersionUID = 1L;

        public CheckOutTask(AbstractBuild<?, ?> build, BlameSubversionSCM parent, Date timestamp, boolean update, boolean revert, TaskListener listener) {
            this.authProvider = parent.getDescriptor().createAuthenticationProvider((AbstractProject)build.getParent());
            this.timestamp = timestamp;
            this.update = update;
            this.revert = revert;
            this.listener = listener;
            this.locations = parent.getLocations(build);
            this.revisions = (RevisionParameterAction)build.getAction(RevisionParameterAction.class);
        }

        /*
         * Exception decompiling
         */
        public List<External> invoke(File ws, VirtualChannel channel) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private SVNRevision getRevision(ModuleLocation l) {
            SVNRevision r = null;
            if (this.revisions != null) {
                r = this.revisions.getRevision(l.getURL());
            }
            if (r == null) {
                r = SVNRevision.create((Date)this.timestamp);
            }
            r = l.getRevision(r);
            return r;
        }
    }
}

