// CHECKSTYLE:OFF

package hudson.jumble;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;

@SuppressWarnings({
    "",
    "PMD"
})
public class Messages {

    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * There is no Jumble report generated yet
     * 
     */
    public static String projectScore_noReportsYet() {
        return holder.format("projectScore.noReportsYet");
    }

    /**
     * There is no Jumble report generated yet
     * 
     */
    public static Localizable _projectScore_noReportsYet() {
        return new Localizable(holder, "projectScore.noReportsYet");
    }

    /**
     * Jumble Score Health
     * 
     */
    public static String reportBuild_jumbleScore() {
        return holder.format("reportBuild.jumbleScore");
    }

    /**
     * Jumble Score Health
     * 
     */
    public static Localizable _reportBuild_jumbleScore() {
        return new Localizable(holder, "reportBuild.jumbleScore");
    }

    /**
     * Jumble Graph
     * 
     */
    public static String graph_displayName() {
        return holder.format("graph.displayName");
    }

    /**
     * Jumble Graph
     * 
     */
    public static Localizable _graph_displayName() {
        return new Localizable(holder, "graph.displayName");
    }

    /**
     * Unable to find the report in the workspace, make sure the path is correct
     * 
     */
    public static String plugin_reportPathValidationFailed() {
        return holder.format("plugin.reportPathValidationFailed");
    }

    /**
     * Unable to find the report in the workspace, make sure the path is correct
     * 
     */
    public static Localizable _plugin_reportPathValidationFailed() {
        return new Localizable(holder, "plugin.reportPathValidationFailed");
    }

    /**
     * The target score must be an integer number between 0 and 100.
     * 
     */
    public static String plugin_targetScoreValidationFailed() {
        return holder.format("plugin.targetScoreValidationFailed");
    }

    /**
     * The target score must be an integer number between 0 and 100.
     * 
     */
    public static Localizable _plugin_targetScoreValidationFailed() {
        return new Localizable(holder, "plugin.targetScoreValidationFailed");
    }

    /**
     * Publishing jumble report.
     * 
     */
    public static String plugin_publishingReport() {
        return holder.format("plugin.publishingReport");
    }

    /**
     * Publishing jumble report.
     * 
     */
    public static Localizable _plugin_publishingReport() {
        return new Localizable(holder, "plugin.publishingReport");
    }

    /**
     * Jumble Report
     * 
     */
    public static String reportBuild_displayName() {
        return holder.format("reportBuild.displayName");
    }

    /**
     * Jumble Report
     * 
     */
    public static Localizable _reportBuild_displayName() {
        return new Localizable(holder, "reportBuild.displayName");
    }

    /**
     * Jumble report not found at {0}, jumble report will not be available. Make sure the path is correct and check job configuration.
     * 
     */
    public static String plugin_reportNotFound(Object arg1) {
        return holder.format("plugin.reportNotFound", arg1);
    }

    /**
     * Jumble report not found at {0}, jumble report will not be available. Make sure the path is correct and check job configuration.
     * 
     */
    public static Localizable _plugin_reportNotFound(Object arg1) {
        return new Localizable(holder, "plugin.reportNotFound", arg1);
    }

    /**
     * n/a
     * 
     */
    public static String graph_notApplicable() {
        return holder.format("graph.notApplicable");
    }

    /**
     * n/a
     * 
     */
    public static Localizable _graph_notApplicable() {
        return new Localizable(holder, "graph.notApplicable");
    }

    /**
     * Jumble Report
     * 
     */
    public static String plugin_displayName() {
        return holder.format("plugin.displayName");
    }

    /**
     * Jumble Report
     * 
     */
    public static Localizable _plugin_displayName() {
        return new Localizable(holder, "plugin.displayName");
    }

    /**
     * {0} project score {1}
     * 
     */
    public static String graph_scoreLabel(Object arg1, Object arg2) {
        return holder.format("graph.scoreLabel", arg1, arg2);
    }

    /**
     * {0} project score {1}
     * 
     */
    public static Localizable _graph_scoreLabel(Object arg1, Object arg2) {
        return new Localizable(holder, "graph.scoreLabel", arg1, arg2);
    }

    /**
     * {0} target score {1}
     * 
     */
    public static String graph_targetLabel(Object arg1, Object arg2) {
        return holder.format("graph.targetLabel", arg1, arg2);
    }

    /**
     * {0} target score {1}
     * 
     */
    public static Localizable _graph_targetLabel(Object arg1, Object arg2) {
        return new Localizable(holder, "graph.targetLabel", arg1, arg2);
    }

    /**
     * Jumble Latests Report
     * 
     */
    public static String projectScore_displayName() {
        return holder.format("projectScore.displayName");
    }

    /**
     * Jumble Latests Report
     * 
     */
    public static Localizable _projectScore_displayName() {
        return new Localizable(holder, "projectScore.displayName");
    }

}
