/*
 * Decompiled with CFR 0.152.
 */
package com.jumble.report;

import com.jumble.report.MutatedClassReport;
import com.jumble.report.Package;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JumbleRunReport {
    private String score = "0%";
    private Integer totalScore = 0;
    private List<Package> packages = new ArrayList();
    private Map<String, Package> packagesMap = new HashMap();

    public void add(MutatedClassReport report) {
        String packageName = this.parsePackagName(report.getClassName());
        Package thePackage = (Package)this.packagesMap.get(packageName);
        if (thePackage == null) {
            thePackage = new Package(packageName);
            this.packagesMap.put(packageName, thePackage);
            this.packages.add(thePackage);
        }
        thePackage.add(report);
    }

    private String parsePackagName(String className) {
        int lastDotIndex = className.lastIndexOf(".");
        return className.substring(0, lastDotIndex);
    }

    public String processScores() {
        this.totalScore = 0;
        for (Package aPackage : this.packages) {
            this.totalScore = this.totalScore + aPackage.processScores();
        }
        this.score = this.totalScore / this.packages.size() + "%";
        return this.score;
    }

    public List<Package> getPackages() {
        return Collections.unmodifiableList(this.packages);
    }

    public String getScore() {
        return this.score;
    }

    public Integer getScoreAsInt() {
        return Integer.valueOf(this.score.substring(0, this.score.length() - 1));
    }
}

