/*
 * Decompiled with CFR 0.152.
 */
package com.jumble.report;

import com.jumble.report.Fail;
import com.jumble.report.JumbleRunReport;
import com.jumble.report.MutatedClassReport;
import com.jumble.report.Package;
import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;

public class ReportWriter {
    private static final String JUMBLE_REPORT_XML = "jumbleReport.xml";
    private XStream xStream = new XStream();

    public ReportWriter() {
        this.xStream.alias("testquality", JumbleRunReport.class);
        this.xStream.aliasAttribute(JumbleRunReport.class, "score", "score");
        this.xStream.omitField(JumbleRunReport.class, "totalScore");
        this.xStream.omitField(JumbleRunReport.class, "packagesMap");
        this.xStream.alias("package", Package.class);
        this.xStream.aliasAttribute(Package.class, "name", "name");
        this.xStream.aliasAttribute(Package.class, "score", "score");
        this.xStream.alias("class", MutatedClassReport.class);
        this.xStream.aliasAttribute(MutatedClassReport.class, "name", "name");
        this.xStream.aliasAttribute(MutatedClassReport.class, "point", "point");
        this.xStream.aliasAttribute(MutatedClassReport.class, "time", "time");
        this.xStream.aliasAttribute(MutatedClassReport.class, "score", "score");
        this.xStream.omitField(MutatedClassReport.class, "fullClassName");
        this.xStream.omitField(MutatedClassReport.class, "passCount");
        this.xStream.alias("fail", Fail.class);
        this.xStream.aliasAttribute(Fail.class, "line", "line");
        this.xStream.aliasAttribute(Fail.class, "mutant", "mutant");
    }

    public void write(JumbleRunReport jumbleRunReport, String folderPath) {
        this.xStream.toXML((Object)jumbleRunReport, this.createReportFile(folderPath + JUMBLE_REPORT_XML));
    }

    private Writer createReportFile(String filePath) {
        try {
            File reportFile = new File(filePath);
            if (reportFile.exists()) {
                reportFile.delete();
            }
            reportFile.createNewFile();
            return new OutputStreamWriter((OutputStream)new FileOutputStream(reportFile), Charset.forName("UTF-8"));
        }
        catch (IOException e) {
            throw new RuntimeException("Error creating jumble report file " + filePath, e);
        }
    }

    public JumbleRunReport read(String reportFolder) throws Exception {
        return this.read((InputStream)new FileInputStream(new File(reportFolder + JUMBLE_REPORT_XML)));
    }

    public JumbleRunReport read(InputStream report) throws Exception {
        return (JumbleRunReport)this.xStream.fromXML(report);
    }
}

