/*
 * Decompiled with CFR 0.152.
 */
package hudson.jumble;

import com.jumble.report.JumbleRunReport;
import com.jumble.report.ReportWriter;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.jumble.GraphAction;
import hudson.jumble.Messages;
import hudson.jumble.Plugin;
import hudson.jumble.ProjectScoreAction;
import hudson.jumble.ReportBuildAction;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.IOUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.kohsuke.stapler.DataBoundConstructor;

public class Plugin
extends Recorder {
    private final String reportPath;
    private final Integer targetScore;
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();
    private JumbleRunReport jumbleReport;

    @DataBoundConstructor
    public Plugin(String reportPath, Integer targetScore) {
        this.reportPath = reportPath;
        this.targetScore = targetScore;
    }

    public String getReportPath() {
        return this.reportPath;
    }

    public Integer getTargetScore() {
        return this.targetScore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException {
        InputStream reportStream = null;
        try {
            FilePath report = build.getWorkspace().child(this.reportPath);
            reportStream = report.read();
            this.jumbleReport = new ReportWriter().read(reportStream);
            listener.getLogger().println(Messages.plugin_publishingReport());
            this.copyReportToBuildFolder(build, report);
            build.getActions().add(new ReportBuildAction(this.jumbleReport, this.targetScore, build));
            ((GraphAction)build.getProject().getAction(GraphAction.class)).addReportToGraph(this.jumbleReport, build);
        }
        catch (FileNotFoundException e) {
            listener.getLogger().println(Messages.plugin_reportNotFound((Object)this.reportPath));
            IOUtils.closeQuietly((InputStream)reportStream);
        }
        catch (Exception e2) {
            listener.getLogger().println("error:" + e2.getClass().getCanonicalName() + ":" + e2.getMessage());
            e2.printStackTrace();
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(reportStream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)reportStream);
        }
        IOUtils.closeQuietly((InputStream)reportStream);
        return true;
    }

    private void copyReportToBuildFolder(AbstractBuild<?, ?> build, FilePath report) throws IOException, InterruptedException {
        FilePath buildTarget = new FilePath(build.getRootDir());
        FilePath toFile = buildTarget.child("jumbleReport.xml");
        report.copyTo(toFile);
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        return true;
    }

    public BuildStepDescriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public Collection<Action> getProjectActions(AbstractProject<?, ?> project) {
        ArrayList<Object> actions = new ArrayList<Object>();
        actions.add(new ProjectScoreAction(project));
        actions.add(new GraphAction(project));
        return Collections.unmodifiableList(actions);
    }
}

