/*
 * Decompiled with CFR 0.152.
 */
package hudson.jumble;

import com.jumble.report.JumbleRunReport;
import com.jumble.report.Package;
import hudson.jumble.Messages;
import hudson.jumble.PackageReportAction;
import hudson.model.AbstractBuild;
import hudson.model.HealthReport;
import hudson.model.HealthReportingAction;
import java.util.HashMap;
import java.util.Map;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class ReportBuildAction
implements HealthReportingAction {
    public static final String REPORT_URL = "jumblereport";
    private final JumbleRunReport jumbleReport;
    private final Integer targetScore;
    private final AbstractBuild<?, ?> build;
    private Map<String, Package> packagesByName = new HashMap();

    public ReportBuildAction(JumbleRunReport jumbleReport, Integer targetScore, AbstractBuild<?, ?> build) {
        this.jumbleReport = jumbleReport;
        this.targetScore = targetScore;
        this.build = build;
        for (Package aPackage : jumbleReport.getPackages()) {
            this.packagesByName.put(aPackage.getName(), aPackage);
        }
    }

    public String getIconFileName() {
        return "clipboard.gif";
    }

    public String getDisplayName() {
        return Messages.reportBuild_displayName();
    }

    public String getUrlName() {
        return REPORT_URL;
    }

    public HealthReport getBuildHealth() {
        Integer score = this.jumbleReport.getScoreAsInt();
        Integer buildHealth = 100;
        if (this.targetScore != null && (buildHealth = Integer.valueOf(score * 100 / this.targetScore)) > 100) {
            buildHealth = 100;
        }
        return new HealthReport(buildHealth.intValue(), Messages._reportBuild_jumbleScore());
    }

    public String getScore() {
        return this.jumbleReport.getScore();
    }

    public Integer getTargetScore() {
        return this.targetScore;
    }

    public JumbleRunReport getJumbleReport() {
        return this.jumbleReport;
    }

    public AbstractBuild<?, ?> getBuild() {
        return this.build;
    }

    public Object getDynamic(String token, StaplerRequest req, StaplerResponse rsp) {
        Package aPackage = (Package)this.packagesByName.get(token);
        PackageReportAction action = null;
        if (aPackage != null) {
            action = new PackageReportAction(aPackage, this.build);
        }
        return action;
    }
}

