/*
 * Decompiled with CFR 0.152.
 */
package com.jumble.report;

import com.jumble.report.Fail;
import java.util.ArrayList;
import java.util.List;

public class MutatedClassReport {
    private final List<Fail> fails = new ArrayList<Fail>();
    private final String name;
    private final String time;
    private Integer point = 0;
    private String score = "0%";
    private Integer passCount = 0;
    private String fullClassName;
    private String errorMessage;

    public MutatedClassReport(String fullClassName, long timeoutInMillis, int mutationCount) {
        this.fullClassName = fullClassName;
        this.name = this.parseClassName(fullClassName);
        if (mutationCount > 0) {
            this.point = mutationCount;
        }
        double timeInSeconds = (double)timeoutInMillis / 1000.0;
        this.time = timeInSeconds + "s";
        this.updateScore();
    }

    private String parseClassName(String className) {
        return className.substring(className.lastIndexOf(".") + 1);
    }

    public String getClassName() {
        return this.fullClassName;
    }

    public void add(Boolean passed, String description) {
        if (passed.booleanValue()) {
            Integer n = this.passCount;
            Integer n2 = this.passCount = Integer.valueOf(this.passCount + 1);
        } else {
            this.fails.add(new Fail(description));
        }
        this.updateScore();
    }

    public void addError(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    private void updateScore() {
        this.score = this.calculateScore() + "%";
    }

    private Integer calculateScore() {
        Integer score = 0;
        score = this.point == 0 ? Integer.valueOf(100) : Integer.valueOf(this.passCount * 100 / this.point);
        return score;
    }

    public Integer getScore() {
        return this.calculateScore();
    }

    public String getFormattedScore() {
        return this.score;
    }

    public List<Fail> getFails() {
        return this.fails;
    }

    public Integer getPoint() {
        return this.point;
    }

    public String getName() {
        return this.name;
    }

    public String getTime() {
        return this.time;
    }
}

