/*
 * Decompiled with CFR 0.152.
 */
package hudson.jumble;

import com.jumble.report.JumbleRunReport;
import hudson.Functions;
import hudson.jumble.Messages;
import hudson.jumble.ReportBuildAction;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.util.Area;
import hudson.util.ChartUtil;
import hudson.util.ColorPalette;
import hudson.util.Graph;
import hudson.util.ShiftedCategoryAxis;
import hudson.util.StackedAreaRenderer2;
import java.awt.Color;
import java.awt.Paint;
import java.io.IOException;
import javax.servlet.ServletException;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.Range;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.RectangleInsets;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class GraphAction
implements Action {
    private static final String TARGET_SERIES = "target";
    private static final String SCORE_SERIES = "score";
    private final AbstractProject<?, ?> project;
    private final DefaultCategoryDataset dataset;
    private final JFreeChart chart;

    public GraphAction(AbstractProject<?, ?> project) {
        this.project = project;
        this.dataset = this.buildDataset();
        this.chart = this.createChart((CategoryDataset)this.dataset);
    }

    private DefaultCategoryDataset buildDataset() {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        for (AbstractBuild build = this.findFirstBuildWithJumble(this.project); build != null; build = (AbstractBuild)build.getNextBuild()) {
            JumbleRunReport report = this.lookupReportFor(build);
            if (report == null) continue;
            this.addReportToGraph(dataset, report, build);
        }
        return dataset;
    }

    private AbstractBuild<?, ?> findFirstBuildWithJumble(AbstractProject<?, ?> project) {
        AbstractBuild build;
        for (build = (AbstractBuild)project.getFirstBuild(); build != null && this.lookupReportFor(build) == null; build = (AbstractBuild)build.getNextBuild()) {
        }
        return build;
    }

    private JumbleRunReport lookupReportFor(AbstractBuild<?, ?> build) {
        ReportBuildAction action = this.lookupJumbleAction(build);
        if (action != null) {
            return action.getJumbleReport();
        }
        return null;
    }

    private ReportBuildAction lookupJumbleAction(AbstractBuild<?, ?> build) {
        ReportBuildAction action = null;
        if (build != null) {
            action = (ReportBuildAction)build.getAction(ReportBuildAction.class);
        }
        return action;
    }

    public void addReportToGraph(JumbleRunReport report, AbstractBuild<?, ?> build) {
        this.addReportToGraph(this.dataset, report, build);
    }

    private void addReportToGraph(DefaultCategoryDataset dataset, JumbleRunReport report, AbstractBuild<?, ?> build) {
        dataset.setValue(null, (Comparable)((Object)SCORE_SERIES), (Comparable)new ChartUtil.NumberOnlyBuildLabel(build));
        dataset.setValue(null, (Comparable)((Object)TARGET_SERIES), (Comparable)new ChartUtil.NumberOnlyBuildLabel(build));
        Integer score = report.getScoreAsInt();
        dataset.addValue((Number)score, (Comparable)((Object)SCORE_SERIES), (Comparable)new ChartUtil.NumberOnlyBuildLabel(build));
        Integer targetScore = this.lookupTargetScorefor(build);
        Integer diff = targetScore - score;
        if (diff < 0) {
            diff = 0;
        }
        dataset.addValue((Number)diff, (Comparable)((Object)TARGET_SERIES), (Comparable)new ChartUtil.NumberOnlyBuildLabel(build));
    }

    private Integer lookupTargetScorefor(AbstractBuild<?, ?> build) {
        ReportBuildAction action = this.lookupJumbleAction(build);
        Integer targetScore = 0;
        if (action != null && action.getTargetScore() != null) {
            targetScore = action.getTargetScore();
        }
        return targetScore;
    }

    public void doTrend(StaplerRequest request, StaplerResponse response) throws IOException, ServletException {
        if (this.isThereEnoughInformationForAGraph()) {
            this.buildGraph(this.project).doPng(request, response);
        } else {
            this.returnNoContent(response);
        }
    }

    public void doTrendMap(StaplerRequest request, StaplerResponse response) throws IOException {
        if (this.isThereEnoughInformationForAGraph()) {
            this.buildGraph(this.project).doMap(request, response);
        } else {
            this.returnNoContent(response);
        }
    }

    public boolean isThereEnoughInformationForAGraph() {
        return this.project.getBuilds().size() > 1 && this.dataset.getColumnCount() > 1;
    }

    private void returnNoContent(StaplerResponse response) throws IOException {
        response.sendError(204);
    }

    private Graph buildGraph(AbstractProject<?, ?> project) {
        Area graphSize = this.calculateDefaultSize();
        return new Graph(((AbstractBuild)project.getLastBuild()).getTimestamp(), graphSize.width, graphSize.height){

            protected JFreeChart createGraph() {
                return GraphAction.this.chart;
            }
        };
    }

    private Area calculateDefaultSize() {
        Area res = Functions.getScreenResolution();
        if (res != null && res.width <= 800) {
            return new Area(250, 100);
        }
        return new Area(500, 200);
    }

    private JFreeChart createChart(CategoryDataset dataset) {
        JFreeChart chart = ChartFactory.createStackedAreaChart(null, null, (String)SCORE_SERIES, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setForegroundAlpha(0.8f);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        plot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 5.0));
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        NumberAxis ax = (NumberAxis)plot.getRangeAxis();
        ax.setRange(new Range(0.0, 105.0));
        ax.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        StackedAreaRenderer2 ar = new StackedAreaRenderer2(){

            public String generateURL(CategoryDataset dataset, int row, int column) {
                ChartUtil.NumberOnlyBuildLabel label = (ChartUtil.NumberOnlyBuildLabel)dataset.getColumnKey(column);
                return label.build.getNumber() + "/" + "jumblereport" + "/";
            }

            public String generateToolTip(CategoryDataset dataset, int row, int column) {
                ChartUtil.NumberOnlyBuildLabel label = (ChartUtil.NumberOnlyBuildLabel)dataset.getColumnKey(column);
                switch (row) {
                    case 0: {
                        return Messages.graph_scoreLabel(label.build.getDisplayName(), GraphAction.this.lookupReportFor(label.build).getScore());
                    }
                    case 1: {
                        return Messages.graph_targetLabel(label.build.getDisplayName(), GraphAction.this.lookupTargetScorefor(label.build));
                    }
                }
                return Messages.graph_notApplicable();
            }
        };
        plot.setRenderer((CategoryItemRenderer)ar);
        plot.getRenderer().setSeriesPaint(0, (Paint)ColorPalette.BLUE);
        plot.getRenderer().setSeriesPaint(1, (Paint)ColorPalette.RED);
        return chart;
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return Messages.graph_displayName();
    }

    public String getUrlName() {
        return "jumbleGraph";
    }

    public DefaultCategoryDataset getDataset() {
        return this.dataset;
    }

    public AbstractProject<?, ?> getProject() {
        return this.project;
    }
}

