/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.active_directory;

import hudson.Util;
import hudson.model.Hudson;
import hudson.plugins.active_directory.AbstractActiveDirectoryAuthenticationProvider;
import hudson.plugins.active_directory.ActiveDirectoryAuthenticationProvider;
import hudson.plugins.active_directory.ActiveDirectorySecurityRealm;
import hudson.plugins.active_directory.ActiveDirectoryUnixAuthenticationProvider;
import hudson.plugins.active_directory.SocketInfo;
import hudson.security.AbstractPasswordBasedSecurityRealm;
import hudson.security.GroupDetails;
import hudson.security.SecurityRealm;
import hudson.util.Secret;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.eclipse.hudson.security.HudsonSecurityEntitiesHolder;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.springframework.dao.DataAccessException;
import org.springframework.security.authentication.AnonymousAuthenticationProvider;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.authentication.RememberMeAuthenticationProvider;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.web.authentication.RememberMeServices;

public class ActiveDirectorySecurityRealm
extends AbstractPasswordBasedSecurityRealm {
    public final String domain;
    public final String site;
    public final String bindName;
    public final Secret bindPassword;
    public final String server;
    private static final Logger LOGGER = Logger.getLogger(ActiveDirectorySecurityRealm.class.getName());
    public static String DOMAIN_CONTROLLERS = System.getProperty(ActiveDirectorySecurityRealm.class.getName() + ".domainControllers");
    public static boolean FORCE_LDAPS = Boolean.getBoolean(ActiveDirectoryUnixAuthenticationProvider.class.getName() + ".forceLdaps");

    @DataBoundConstructor
    public ActiveDirectorySecurityRealm(String domain, String site, String bindName, String bindPassword, String server) {
        this.domain = Util.fixEmpty((String)domain);
        this.site = Util.fixEmpty((String)site);
        this.bindName = Util.fixEmpty((String)bindName);
        this.bindPassword = Secret.fromString((String)Util.fixEmpty((String)bindPassword));
        server = Util.fixEmpty((String)server);
        if (server != null && !server.contains(":")) {
            server = server + ":3268";
        }
        this.server = server;
    }

    public SecurityRealm.SecurityComponents createSecurityComponents() {
        ActiveDirectoryUnixAuthenticationProvider adp;
        ActiveDirectoryUnixAuthenticationProvider uds = this.getDescriptor().canDoNativeAuth() && this.domain == null ? (adp = new ActiveDirectoryAuthenticationProvider()) : (adp = new ActiveDirectoryUnixAuthenticationProvider(this));
        1 rms = new /* Unavailable Anonymous Inner Class!! */;
        rms.setUserDetailsService((UserDetailsService)uds);
        rms.setKey(Hudson.getInstance().getSecretKey());
        rms.setParameter("remember_me");
        RememberMeAuthenticationProvider rememberMeAuthenticationProvider = new RememberMeAuthenticationProvider();
        rememberMeAuthenticationProvider.setKey(HudsonSecurityEntitiesHolder.getHudsonSecurityManager().getSecretKey());
        AnonymousAuthenticationProvider anonymousAuthenticationProvider = new AnonymousAuthenticationProvider();
        anonymousAuthenticationProvider.setKey("anonymous");
        AuthenticationProvider[] authenticationProvider = new AuthenticationProvider[]{adp, rememberMeAuthenticationProvider, anonymousAuthenticationProvider};
        ProviderManager providerManager = new ProviderManager();
        providerManager.setProviders(Arrays.asList(authenticationProvider));
        return new SecurityRealm.SecurityComponents((AuthenticationManager)providerManager, (UserDetailsService)uds, (RememberMeServices)rms);
    }

    public DesciprotrImpl getDescriptor() {
        return (DesciprotrImpl)super.getDescriptor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAuthTest(StaplerRequest req, StaplerResponse rsp, @QueryParameter String username, @QueryParameter String password) throws IOException, ServletException {
        Hudson.getInstance().checkPermission(Hudson.ADMINISTER);
        StringWriter out = new StringWriter();
        PrintWriter pw = new PrintWriter(out);
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            AbstractActiveDirectoryAuthenticationProvider uds = this.getAuthenticationProvider();
            if (uds instanceof ActiveDirectoryUnixAuthenticationProvider) {
                ActiveDirectoryUnixAuthenticationProvider p = (ActiveDirectoryUnixAuthenticationProvider)uds;
                DesciprotrImpl descriptor = this.getDescriptor();
                for (String domainName : this.domain.split(",")) {
                    try {
                        pw.println("Domain=" + domainName + " site=" + this.site);
                        List ldapServers = descriptor.obtainLDAPServer(domainName, this.site, this.server);
                        pw.println("List of domain controllers: " + ldapServers);
                        for (SocketInfo ldapServer : ldapServers) {
                            pw.println("Trying a domain controller at " + ldapServer);
                            try {
                                UserDetails d = p.retrieveUser(username, password, domainName, Collections.singletonList(ldapServer));
                                pw.println("Authenticated as " + d);
                            }
                            catch (AuthenticationException e) {
                                e.printStackTrace(pw);
                            }
                        }
                    }
                    catch (NamingException e) {
                        pw.println("Failing to resolve domain controllers");
                        e.printStackTrace(pw);
                    }
                }
            } else {
                pw.println("Using Windows ADSI. No diagnostics available.");
            }
        }
        catch (Exception e) {
            e.printStackTrace(pw);
        }
        finally {
            Thread.currentThread().setContextClassLoader(ccl);
        }
        req.setAttribute("output", (Object)out.toString());
        req.getView((Object)this, "test.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    public GroupDetails loadGroupByGroupname(String groupname) throws UsernameNotFoundException, DataAccessException {
        return this.getAuthenticationProvider().loadGroupByGroupname(groupname);
    }

    public AbstractActiveDirectoryAuthenticationProvider getAuthenticationProvider() {
        return (AbstractActiveDirectoryAuthenticationProvider)this.getSecurityComponents().userDetails;
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        return this.getAuthenticationProvider().loadUserByUsername(username);
    }

    protected UserDetails authenticate(String username, String password) throws AuthenticationException {
        return this.getAuthenticationProvider().retrieveUser(username, new UsernamePasswordAuthenticationToken((Object)username, (Object)password));
    }

    static /* synthetic */ Logger access$000() {
        return LOGGER;
    }
}

