/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.active_directory;

import hudson.Util;
import hudson.plugins.active_directory.AbstractActiveDirectoryAuthenticationProvider;
import hudson.plugins.active_directory.ActiveDirectoryGroupDetails;
import hudson.plugins.active_directory.ActiveDirectorySecurityRealm;
import hudson.plugins.active_directory.ActiveDirectoryUserDetail;
import hudson.plugins.active_directory.Cache;
import hudson.plugins.active_directory.LDAPSearchBuilder;
import hudson.plugins.active_directory.MultiCauseBadCredentialsException;
import hudson.plugins.active_directory.MultiCauseUserNotFoundException;
import hudson.plugins.active_directory.SocketInfo;
import hudson.security.GroupDetails;
import hudson.security.SecurityRealm;
import hudson.security.UserMayOrMayNotExistException;
import hudson.util.Secret;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapName;
import org.apache.commons.lang.StringUtils;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.GrantedAuthorityImpl;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class ActiveDirectoryUnixAuthenticationProvider
extends AbstractActiveDirectoryAuthenticationProvider {
    private final String[] domainNames;
    private final String site;
    private final String server;
    private final String bindName;
    private final String bindPassword;
    private final ActiveDirectorySecurityRealm.DesciprotrImpl descriptor;
    private final Cache<String, ActiveDirectoryGroupDetails, UsernameNotFoundException> groupCache = new /* Unavailable Anonymous Inner Class!! */;
    private static final Logger LOGGER = Logger.getLogger(ActiveDirectoryUnixAuthenticationProvider.class.getName());
    private static final String NO_AUTHENTICATION = "\u0000\u0000\u0000\u0000\u0000\u0000";

    public ActiveDirectoryUnixAuthenticationProvider(ActiveDirectorySecurityRealm realm) {
        if (realm.domain == null) {
            throw new IllegalArgumentException("Active Directory domain name is required but it is not set");
        }
        this.domainNames = realm.domain.split(",");
        this.site = realm.site;
        this.bindName = realm.bindName;
        this.server = realm.server;
        this.bindPassword = Secret.toString((Secret)realm.bindPassword);
        this.descriptor = realm.getDescriptor();
    }

    protected UserDetails retrieveUser(String username, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        try {
            ArrayList<BadCredentialsException> errors = new ArrayList<BadCredentialsException>();
            ArrayList<UsernameNotFoundException> notFound = new ArrayList<UsernameNotFoundException>();
            for (String domainName : this.domainNames) {
                try {
                    return this.retrieveUser(username, authentication, domainName);
                }
                catch (UsernameNotFoundException e) {
                    notFound.add(e);
                }
                catch (BadCredentialsException bce) {
                    LOGGER.log(Level.WARNING, "Credential exception tying to authenticate against " + domainName + " domain", bce);
                    errors.add(bce);
                }
            }
            switch (errors.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    throw (BadCredentialsException)((Object)errors.get(0));
                }
                default: {
                    throw new MultiCauseBadCredentialsException("Either no such user '" + username + "' or incorrect password", errors);
                }
            }
            if (notFound.size() == 1) {
                throw (UsernameNotFoundException)((Object)notFound.get(0));
            }
            if (!Util.filter(notFound, UserMayOrMayNotExistException.class).isEmpty()) {
                throw new MultiCauseUserNotFoundException("We can't tell if the user exists or not: " + username, notFound);
            }
            if (!notFound.isEmpty()) {
                throw new MultiCauseUserNotFoundException("No such user: " + username, notFound);
            }
            throw new AssertionError((Object)"no domain is configured");
        }
        catch (AuthenticationException e) {
            LOGGER.log(Level.FINE, "Failed toretrieve user " + username, e);
            throw e;
        }
    }

    protected boolean canRetrieveUserByName() {
        return this.bindName != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserDetails retrieveUser(String username, UsernamePasswordAuthenticationToken authentication, String domainName) throws AuthenticationException {
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            String password = "\u0000\u0000\u0000\u0000\u0000\u0000";
            if (authentication != null) {
                password = (String)authentication.getCredentials();
            }
            UserDetails userDetails = this.retrieveUser(username, password, domainName, this.obtainLDAPServers(domainName));
            return userDetails;
        }
        finally {
            Thread.currentThread().setContextClassLoader(ccl);
        }
    }

    private List<SocketInfo> obtainLDAPServers(String domainName) throws AuthenticationServiceException {
        try {
            return this.descriptor.obtainLDAPServer(domainName, this.site, this.server);
        }
        catch (NamingException e) {
            LOGGER.log(Level.WARNING, "Failed to find the LDAP service", e);
            throw new AuthenticationServiceException("Failed to find the LDAP service for the domain " + domainName, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserDetails retrieveUser(String username, String password, String domainName, List<SocketInfo> ldapServers) {
        boolean anonymousBind;
        DirContext context;
        String id;
        if (StringUtils.isEmpty((String)password)) {
            throw new BadCredentialsException("Empty password");
        }
        if (this.bindName != null) {
            try {
                id = username;
                context = this.descriptor.bind(this.bindName, this.bindPassword, ldapServers);
                anonymousBind = false;
            }
            catch (BadCredentialsException e) {
                throw new AuthenticationServiceException("Failed to bind to LDAP server with the bind name/password", (Throwable)e);
            }
        }
        String principalName = this.getPrincipalName(username, domainName);
        id = principalName.substring(0, principalName.indexOf(64));
        anonymousBind = password == "\u0000\u0000\u0000\u0000\u0000\u0000";
        try {
            context = this.descriptor.bind(principalName, anonymousBind ? "" : password, ldapServers);
        }
        catch (BadCredentialsException e) {
            if (anonymousBind) {
                throw new UserMayOrMayNotExistException("Unable to retrieve the user information without bind DN/password configured");
            }
            throw e;
        }
        try {
            String domainDN = ActiveDirectoryUnixAuthenticationProvider.toDC((String)domainName);
            Attributes user = new LDAPSearchBuilder(context, domainDN).subTreeScope().searchOne("(& (userPrincipalName={0})(objectCategory=user))", new Object[]{id});
            if (user == null) {
                LOGGER.fine("Failed to find " + id + " in userPrincipalName. Trying sAMAccountName");
                user = new LDAPSearchBuilder(context, domainDN).subTreeScope().searchOne("(& (sAMAccountName={0})(objectCategory=user))", new Object[]{id});
                if (user == null) {
                    throw new UsernameNotFoundException("Authentication was successful but cannot locate the user information for " + username);
                }
            }
            LOGGER.fine("Found user " + id + " : " + user);
            Object dn = user.get("distinguishedName").get();
            if (dn == null) {
                throw new AuthenticationServiceException("No distinguished name for " + username);
            }
            if (this.bindName != null && password != "\u0000\u0000\u0000\u0000\u0000\u0000") {
                LOGGER.fine("Attempting to validate password for DN=" + dn);
                DirContext test = this.descriptor.bind(dn.toString(), password, ldapServers);
                try {
                    new LDAPSearchBuilder(test, domainDN).searchOne("(& (userPrincipalName={0})(objectCategory=user))", new Object[]{id});
                }
                finally {
                    this.closeQuietly(test);
                }
            }
            Set groups = this.resolveGroups(domainDN, dn.toString(), context);
            groups.add(SecurityRealm.AUTHENTICATED_AUTHORITY);
            UserDetails userDetails = new ActiveDirectoryUserDetail(id, password, true, true, true, true, groups.toArray(new GrantedAuthority[groups.size()]), this.getStringAttribute(user, "displayName"), this.getStringAttribute(user, "mail"), this.getStringAttribute(user, "telephoneNumber")).updateUserInfo();
            return userDetails;
        }
        catch (NamingException e) {
            if (anonymousBind && e.getMessage().contains("successful bind must be completed") && e.getMessage().contains("000004DC")) {
                throw new UserMayOrMayNotExistException("Unable to retrieve the user information without bind DN/password configured");
            }
            LOGGER.log(Level.WARNING, "Failed to retrieve user information for " + username, e);
            throw new BadCredentialsException("Failed to retrieve user information for " + username, (Throwable)e);
        }
        finally {
            this.closeQuietly(context);
        }
    }

    public GroupDetails loadGroupByGroupname(String groupname) {
        if (this.bindName == null) {
            throw new UserMayOrMayNotExistException("Unable to retrieve group information without bind DN/password configured");
        }
        ActiveDirectoryGroupDetails details = (ActiveDirectoryGroupDetails)this.groupCache.get((Object)groupname);
        if (details == null) {
            throw new UsernameNotFoundException(groupname);
        }
        return details;
    }

    private void closeQuietly(DirContext context) {
        try {
            if (context != null) {
                context.close();
            }
        }
        catch (NamingException e) {
            LOGGER.log(Level.INFO, "Failed to close DirContext: " + context, e);
        }
    }

    private String getStringAttribute(Attributes user, String name) throws NamingException {
        Attribute a = user.get(name);
        if (a == null) {
            return null;
        }
        Object v = a.get();
        if (v == null) {
            return null;
        }
        return v.toString();
    }

    private String getPrincipalName(String username, String domainName) {
        int slash = username.indexOf(92);
        String principalName = slash > 0 ? username.substring(slash + 1) + '@' + username.substring(0, slash) + '.' + domainName : (username.contains("@") ? username + '.' + domainName : username + '@' + domainName);
        return principalName;
    }

    private Set<GrantedAuthority> resolveGroups(String domainDN, String userDN, DirContext context) throws NamingException {
        LOGGER.finer("Looking up group of " + userDN);
        Attributes id = context.getAttributes(userDN, new String[]{"tokenGroups", "memberOf", "CN"});
        Attribute tga = id.get("tokenGroups");
        if (tga == null) {
            LOGGER.warning("Failed to retrieve tokenGroups for " + userDN);
            HashSet<GrantedAuthority> r = new HashSet<GrantedAuthority>();
            r.add((GrantedAuthority)new GrantedAuthorityImpl("unable-to-retrieve-tokenGroups"));
            return r;
        }
        StringBuilder query = new StringBuilder("(|");
        ArrayList<byte[]> sids = new ArrayList<byte[]>();
        NamingEnumeration<?> tokenGroups = tga.getAll();
        while (tokenGroups.hasMore()) {
            byte[] gsid = (byte[])tokenGroups.next();
            query.append("(objectSid={" + sids.size() + "})");
            sids.add(gsid);
        }
        tokenGroups.close();
        query.append(")");
        HashSet<GrantedAuthority> groups = new HashSet<GrantedAuthority>();
        NamingEnumeration renum = new LDAPSearchBuilder(context, domainDN).subTreeScope().returns(new String[]{"cn"}).search(query.toString(), sids.toArray());
        while (renum.hasMore()) {
            Attributes a = ((SearchResult)renum.next()).getAttributes();
            Attribute cn = a.get("cn");
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(userDN + " is a member of " + cn);
            }
            groups.add((GrantedAuthority)new GrantedAuthorityImpl(cn.get().toString()));
        }
        renum.close();
        LOGGER.fine("Stage 2: looking up via memberOf");
        Stack<Attributes> q = new Stack<Attributes>();
        q.push(id);
        while (!q.isEmpty()) {
            Attributes identity = (Attributes)q.pop();
            LOGGER.finer("Looking up group of " + identity);
            Attribute memberOf = identity.get("memberOf");
            if (memberOf == null) continue;
            for (int i = 0; i < memberOf.size(); ++i) {
                Attributes group = context.getAttributes(new LdapName(memberOf.get(i).toString()), new String[]{"CN", "memberOf"});
                Attribute cn = group.get("CN");
                if (cn == null) {
                    LOGGER.fine("Failed to obtain CN of " + memberOf.get(i));
                    continue;
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(cn.get() + " is a member of " + memberOf.get(i));
                }
                if (!groups.add((GrantedAuthority)new GrantedAuthorityImpl(cn.get().toString()))) continue;
                q.add(group);
            }
        }
        return groups;
    }

    static String toDC(String domainName) {
        StringBuilder buf = new StringBuilder();
        for (String token : domainName.split("\\.")) {
            if (token.length() == 0) continue;
            if (buf.length() > 0) {
                buf.append(",");
            }
            buf.append("DC=").append(token);
        }
        return buf.toString();
    }

    static /* synthetic */ String[] access$000(ActiveDirectoryUnixAuthenticationProvider x0) {
        return x0.domainNames;
    }

    static /* synthetic */ String access$100(ActiveDirectoryUnixAuthenticationProvider x0) {
        return x0.bindName;
    }

    static /* synthetic */ String access$200(ActiveDirectoryUnixAuthenticationProvider x0) {
        return x0.bindPassword;
    }

    static /* synthetic */ List access$300(ActiveDirectoryUnixAuthenticationProvider x0, String x1) throws AuthenticationServiceException {
        return x0.obtainLDAPServers(x1);
    }

    static /* synthetic */ ActiveDirectorySecurityRealm.DesciprotrImpl access$400(ActiveDirectoryUnixAuthenticationProvider x0) {
        return x0.descriptor;
    }

    static /* synthetic */ Logger access$500() {
        return LOGGER;
    }

    static /* synthetic */ void access$600(ActiveDirectoryUnixAuthenticationProvider x0, DirContext x1) {
        x0.closeQuietly(x1);
    }
}

