/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.active_directory;

import hudson.Extension;
import hudson.model.Hudson;
import hudson.model.User;
import hudson.plugins.active_directory.ActiveDirectorySecurityRealm;
import hudson.plugins.active_directory.ActiveDirectoryUserDetail;
import hudson.security.SecurityRealm;
import hudson.tasks.MailAddressResolver;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.dao.DataAccessException;
import org.springframework.security.core.AuthenticationException;

@Extension
public class ActiveDirectoryMailAddressResolverImpl
extends MailAddressResolver {
    private static final Logger LOGGER = Logger.getLogger(ActiveDirectoryMailAddressResolverImpl.class.getName());

    public String findMailAddressFor(User u) {
        SecurityRealm realm = Hudson.getInstance().getSecurityRealm();
        if (!(realm instanceof ActiveDirectorySecurityRealm)) {
            return null;
        }
        try {
            ActiveDirectoryUserDetail details = (ActiveDirectoryUserDetail)realm.getSecurityComponents().userDetails.loadUserByUsername(u.getId());
            LOGGER.log(Level.FINE, "Email address = '" + details.getMail() + "'");
            return details.getMail();
        }
        catch (DataAccessException e) {
            LOGGER.log(Level.FINE, "Failed to look Active Directory for e-mail address", e);
            return null;
        }
        catch (AuthenticationException e) {
            LOGGER.log(Level.FINE, "Failed to look up Active Directory for e-mail address", e);
            return null;
        }
    }
}

