/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.collector;

import hudson.plugins.analysis.graph.BuildResultGraph;
import hudson.plugins.analysis.graph.GraphConfiguration;
import java.util.Collection;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalysisGraphConfiguration
extends GraphConfiguration {
    private boolean canDeactivateGraphs;

    public AnalysisGraphConfiguration(Collection<BuildResultGraph> availableGraphs) {
        super(availableGraphs);
    }

    protected boolean initializeLocal(String[] localConfiguration) {
        if (localConfiguration.length == 1) {
            if ("0".equals(localConfiguration[0])) {
                this.canDeactivateGraphs = false;
                return true;
            }
            if ("1".equals(localConfiguration[0])) {
                this.canDeactivateGraphs = true;
                return true;
            }
        }
        return false;
    }

    protected boolean initializeLocal(JSONObject localConfiguration) {
        try {
            this.canDeactivateGraphs = localConfiguration.getBoolean("canDeacticateOtherTrendGraphs");
            return true;
        }
        catch (JSONException exception) {
            this.canDeactivateGraphs = false;
            return false;
        }
    }

    public boolean canDeacticateOtherTrendGraphs() {
        return this.canDeactivateGraphs;
    }

    public boolean getCanDeacticateOtherTrendGraphs() {
        return this.canDeactivateGraphs;
    }

    public String serializeToString() {
        return super.serializeToString() + "!" + this.serializeBoolean(this.canDeactivateGraphs);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = prime * result + (this.canDeactivateGraphs ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnalysisGraphConfiguration other = (AnalysisGraphConfiguration)obj;
        return this.canDeactivateGraphs == other.canDeactivateGraphs;
    }
}

