/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.collector.dashboard;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import hudson.model.Job;
import hudson.plugins.analysis.collector.AnalysisProjectAction;
import hudson.plugins.analysis.core.AbstractProjectAction;
import hudson.plugins.analysis.core.BuildResult;
import hudson.plugins.analysis.dashboard.AbstractWarningsTablePortlet;
import hudson.plugins.checkstyle.CheckStyleProjectAction;
import hudson.plugins.dry.DryProjectAction;
import hudson.plugins.findbugs.FindBugsProjectAction;
import hudson.plugins.pmd.PmdProjectAction;
import hudson.plugins.tasks.TasksProjectAction;
import hudson.plugins.warnings.WarningsProjectAction;
import java.util.Collection;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WarningsTablePortlet
extends AbstractWarningsTablePortlet {
    private static final String NO_RESULTS_FOUND = "-";
    private final boolean useImages;
    private final boolean isCheckStyleDeactivated;
    private final boolean isDryDeactivated;
    private final boolean isFindBugsDeactivated;
    private final boolean isPmdDeactivated;
    private final boolean isOpenTasksDeactivated;
    private final boolean isWarningsDeactivated;

    @DataBoundConstructor
    public WarningsTablePortlet(String name, boolean useImages, boolean isCheckStyleActivated, boolean isDryActivated, boolean isFindBugsActivated, boolean isPmdActivated, boolean isOpenTasksActivated, boolean isWarningsActivated, boolean canHideZeroWarningsProjects) {
        super(name, canHideZeroWarningsProjects);
        this.useImages = useImages;
        this.isDryDeactivated = !isDryActivated;
        this.isFindBugsDeactivated = !isFindBugsActivated;
        this.isPmdDeactivated = !isPmdActivated;
        this.isOpenTasksDeactivated = !isOpenTasksActivated;
        this.isWarningsDeactivated = !isWarningsActivated;
        this.isCheckStyleDeactivated = !isCheckStyleActivated;
    }

    protected Class<? extends AbstractProjectAction<?>> getAction() {
        return AnalysisProjectAction.class;
    }

    public boolean getUseImages() {
        return this.useImages;
    }

    public boolean useIcons() {
        return this.useImages;
    }

    public boolean isTotalsVisible() {
        return this.toInt(this.isCheckStyleActivated()) + this.toInt(this.isDryActivated()) + this.toInt(this.isFindBugsActivated()) + this.toInt(this.isPmdActivated()) + this.toInt(this.isOpenTasksActivated()) + this.toInt(this.isWarningsActivated()) > 1;
    }

    private int toInt(boolean isActivated) {
        return isActivated ? 1 : 0;
    }

    public boolean isCheckStyleActivated() {
        return !this.isCheckStyleDeactivated;
    }

    public boolean isDryActivated() {
        return !this.isDryDeactivated;
    }

    public boolean isFindBugsActivated() {
        return !this.isFindBugsDeactivated;
    }

    public boolean isPmdActivated() {
        return !this.isPmdDeactivated;
    }

    public boolean isOpenTasksActivated() {
        return !this.isOpenTasksDeactivated;
    }

    public boolean isWarningsActivated() {
        return !this.isWarningsDeactivated;
    }

    protected boolean isVisibleJob(Job<?, ?> job) {
        return this.toInt(this.getTotal(job)) > 0;
    }

    public String getCheckStyle(Job<?, ?> job) {
        if (this.isCheckStyleActivated()) {
            return this.getWarnings(job, CheckStyleProjectAction.class, "checkstyle");
        }
        return NO_RESULTS_FOUND;
    }

    public String getDry(Job<?, ?> job) {
        if (this.isDryActivated()) {
            return this.getWarnings(job, DryProjectAction.class, "dry");
        }
        return NO_RESULTS_FOUND;
    }

    public String getFindBugs(Job<?, ?> job) {
        if (this.isFindBugsActivated()) {
            return this.getWarnings(job, FindBugsProjectAction.class, "findbugs");
        }
        return NO_RESULTS_FOUND;
    }

    public String getPmd(Job<?, ?> job) {
        if (this.isPmdActivated()) {
            return this.getWarnings(job, PmdProjectAction.class, "pmd");
        }
        return NO_RESULTS_FOUND;
    }

    public String getTasks(Job<?, ?> job) {
        if (this.isOpenTasksActivated()) {
            return this.getWarnings(job, TasksProjectAction.class, "tasks");
        }
        return NO_RESULTS_FOUND;
    }

    public String getCompilerWarnings(Job<?, ?> job) {
        if (this.isWarningsActivated()) {
            return this.getWarnings(job, WarningsProjectAction.class, "warnings");
        }
        return NO_RESULTS_FOUND;
    }

    public String getTotal(Job<?, ?> job) {
        return String.valueOf(this.toInt(this.getCheckStyle(job)) + this.toInt(this.getDry(job)) + this.toInt(this.getFindBugs(job)) + this.toInt(this.getPmd(job)) + this.toInt(this.getTasks(job)) + this.toInt(this.getCompilerWarnings(job)));
    }

    public String getCheckStyle(Collection<Job<?, ?>> jobs) {
        int sum = 0;
        for (Job<?, ?> job : jobs) {
            sum += this.toInt(this.getCheckStyle(job));
        }
        return String.valueOf(sum);
    }

    public String getDry(Collection<Job<?, ?>> jobs) {
        int sum = 0;
        for (Job<?, ?> job : jobs) {
            sum += this.toInt(this.getDry(job));
        }
        return String.valueOf(sum);
    }

    public String getFindBugs(Collection<Job<?, ?>> jobs) {
        int sum = 0;
        for (Job<?, ?> job : jobs) {
            sum += this.toInt(this.getFindBugs(job));
        }
        return String.valueOf(sum);
    }

    public String getPmd(Collection<Job<?, ?>> jobs) {
        int sum = 0;
        for (Job<?, ?> job : jobs) {
            sum += this.toInt(this.getPmd(job));
        }
        return String.valueOf(sum);
    }

    public String getTasks(Collection<Job<?, ?>> jobs) {
        int sum = 0;
        for (Job<?, ?> job : jobs) {
            sum += this.toInt(this.getTasks(job));
        }
        return String.valueOf(sum);
    }

    public String getWarnings(Collection<Job<?, ?>> jobs) {
        int sum = 0;
        for (Job<?, ?> job : jobs) {
            sum += this.toInt(this.getCompilerWarnings(job));
        }
        return String.valueOf(sum);
    }

    public String getTotal(Collection<Job<?, ?>> jobs) {
        int sum = 0;
        for (Job<?, ?> job : jobs) {
            sum += Integer.parseInt(this.getTotal(job));
        }
        return String.valueOf(sum);
    }

    @SuppressWarnings(value={"NP"})
    private String getWarnings(Job<?, ?> job, Class<? extends AbstractProjectAction<?>> actionType, String plugin) {
        AbstractProjectAction action = (AbstractProjectAction)job.getAction(actionType);
        if (action != null && action.hasValidResults()) {
            BuildResult result = action.getLastAction().getResult();
            int numberOfAnnotations = result.getNumberOfAnnotations();
            String value = numberOfAnnotations > 0 ? String.format("<a href=\"%s%s\">%d</a>", job.getShortUrl(), plugin, numberOfAnnotations) : String.valueOf(numberOfAnnotations);
            if (result.isSuccessfulTouched() && !result.isSuccessful()) {
                return value + result.getResultIcon();
            }
            return value;
        }
        return NO_RESULTS_FOUND;
    }
}

