/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.collector;

import hudson.Launcher;
import hudson.matrix.MatrixAggregator;
import hudson.matrix.MatrixBuild;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.plugins.analysis.collector.AnalysisAnnotationsAggregator;
import hudson.plugins.analysis.collector.AnalysisDescriptor;
import hudson.plugins.analysis.collector.AnalysisProjectAction;
import hudson.plugins.analysis.collector.AnalysisResult;
import hudson.plugins.analysis.collector.AnalysisResultAction;
import hudson.plugins.analysis.core.BuildResult;
import hudson.plugins.analysis.core.HealthAwarePublisher;
import hudson.plugins.analysis.core.HealthDescriptor;
import hudson.plugins.analysis.core.ParserResult;
import hudson.plugins.analysis.core.ResultAction;
import hudson.plugins.analysis.util.PluginLogger;
import hudson.plugins.checkstyle.CheckStyleMavenResultAction;
import hudson.plugins.checkstyle.CheckStyleResultAction;
import hudson.plugins.dry.DryMavenResultAction;
import hudson.plugins.dry.DryResultAction;
import hudson.plugins.findbugs.FindBugsMavenResultAction;
import hudson.plugins.findbugs.FindBugsResultAction;
import hudson.plugins.pmd.PmdMavenResultAction;
import hudson.plugins.pmd.PmdResultAction;
import hudson.plugins.tasks.TasksMavenResultAction;
import hudson.plugins.tasks.TasksResultAction;
import hudson.plugins.warnings.WarningsResultAction;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalysisPublisher
extends HealthAwarePublisher {
    private static final long serialVersionUID = 5512072640635006098L;
    private final boolean isCheckStyleDeactivated;
    private final boolean isDryDeactivated;
    private final boolean isFindBugsDeactivated;
    private final boolean isPmdDeactivated;
    private final boolean isOpenTasksDeactivated;
    private final boolean isWarningsDeactivated;

    @DataBoundConstructor
    public AnalysisPublisher(String healthy, String unHealthy, String thresholdLimit, String defaultEncoding, boolean useDeltaValues, String unstableTotalAll, String unstableTotalHigh, String unstableTotalNormal, String unstableTotalLow, String unstableNewAll, String unstableNewHigh, String unstableNewNormal, String unstableNewLow, String failedTotalAll, String failedTotalHigh, String failedTotalNormal, String failedTotalLow, String failedNewAll, String failedNewHigh, String failedNewNormal, String failedNewLow, boolean isCheckStyleActivated, boolean isDryActivated, boolean isFindBugsActivated, boolean isPmdActivated, boolean isOpenTasksActivated, boolean isWarningsActivated, boolean canRunOnFailed, boolean canComputeNew) {
        super(healthy, unHealthy, thresholdLimit, defaultEncoding, useDeltaValues, unstableTotalAll, unstableTotalHigh, unstableTotalNormal, unstableTotalLow, unstableNewAll, unstableNewHigh, unstableNewNormal, unstableNewLow, failedTotalAll, failedTotalHigh, failedTotalNormal, failedTotalLow, failedNewAll, failedNewHigh, failedNewNormal, failedNewLow, canRunOnFailed, false, canComputeNew, "ANALYSIS-COLLECTOR");
        this.isDryDeactivated = !isDryActivated;
        this.isFindBugsDeactivated = !isFindBugsActivated;
        this.isPmdDeactivated = !isPmdActivated;
        this.isOpenTasksDeactivated = !isOpenTasksActivated;
        this.isWarningsDeactivated = !isWarningsActivated;
        this.isCheckStyleDeactivated = !isCheckStyleActivated;
    }

    public boolean isCheckStyleActivated() {
        return !this.isCheckStyleDeactivated;
    }

    public boolean isDryActivated() {
        return !this.isDryDeactivated;
    }

    public boolean isFindBugsActivated() {
        return !this.isFindBugsDeactivated;
    }

    public boolean isPmdActivated() {
        return !this.isPmdDeactivated;
    }

    public boolean isOpenTasksActivated() {
        return !this.isOpenTasksDeactivated;
    }

    public boolean isWarningsActivated() {
        return !this.isWarningsDeactivated;
    }

    private List<Class<? extends ResultAction<? extends BuildResult>>> getParticipatingPlugins() {
        ArrayList<Class<? extends ResultAction<? extends BuildResult>>> pluginResults = new ArrayList<Class<? extends ResultAction<? extends BuildResult>>>();
        if (AnalysisDescriptor.isCheckStyleInstalled() && this.isCheckStyleActivated()) {
            pluginResults.add(CheckStyleResultAction.class);
            pluginResults.add(CheckStyleMavenResultAction.class);
        }
        if (AnalysisDescriptor.isDryInstalled() && this.isDryActivated()) {
            pluginResults.add(DryResultAction.class);
            pluginResults.add(DryMavenResultAction.class);
        }
        if (AnalysisDescriptor.isFindBugsInstalled() && this.isFindBugsActivated()) {
            pluginResults.add(FindBugsResultAction.class);
            pluginResults.add(FindBugsMavenResultAction.class);
        }
        if (AnalysisDescriptor.isPmdInstalled() && this.isPmdActivated()) {
            pluginResults.add(PmdResultAction.class);
            pluginResults.add(PmdMavenResultAction.class);
        }
        if (AnalysisDescriptor.isOpenTasksInstalled() && this.isOpenTasksActivated()) {
            pluginResults.add(TasksResultAction.class);
            pluginResults.add(TasksMavenResultAction.class);
        }
        if (AnalysisDescriptor.isWarningsInstalled() && this.isWarningsActivated()) {
            pluginResults.add(WarningsResultAction.class);
        }
        return pluginResults;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new AnalysisProjectAction(project);
    }

    public BuildResult perform(AbstractBuild<?, ?> build, PluginLogger logger) throws InterruptedException, IOException {
        ParserResult overallResult = new ParserResult(build.getWorkspace());
        for (Class<? extends ResultAction<? extends BuildResult>> result : this.getParticipatingPlugins()) {
            ResultAction action = (ResultAction)build.getAction(result);
            if (action == null) continue;
            BuildResult actualResult = action.getResult();
            Set annotactualResultations = actualResult.getAnnotations();
            overallResult.addAnnotations((Collection)annotactualResultations);
        }
        AnalysisResult result = new AnalysisResult(build, this.getDefaultEncoding(), overallResult);
        build.getActions().add(new AnalysisResultAction(build, (HealthDescriptor)this, result));
        return result;
    }

    public AnalysisDescriptor getDescriptor() {
        return (AnalysisDescriptor)super.getDescriptor();
    }

    public MatrixAggregator createAggregator(MatrixBuild build, Launcher launcher, BuildListener listener) {
        return new AnalysisAnnotationsAggregator(build, launcher, listener, (HealthDescriptor)this, this.getDefaultEncoding());
    }
}

