/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.collector.dashboard;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.plugins.analysis.collector.AnalysisDescriptor;
import hudson.plugins.analysis.collector.AnalysisProjectAction;
import hudson.plugins.analysis.collector.Messages;
import hudson.plugins.analysis.collector.OriginGraph;
import hudson.plugins.analysis.core.AbstractProjectAction;
import hudson.plugins.analysis.dashboard.AbstractWarningsGraphPortlet;
import hudson.plugins.analysis.graph.BuildResultGraph;
import hudson.plugins.view.dashboard.DashboardPortlet;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WarningsOriginGraphPortlet
extends AbstractWarningsGraphPortlet {
    private final boolean isCheckStyleDeactivated;
    private final boolean isDryDeactivated;
    private final boolean isFindBugsDeactivated;
    private final boolean isPmdDeactivated;
    private final boolean isOpenTasksDeactivated;
    private final boolean isWarningsDeactivated;

    @DataBoundConstructor
    public WarningsOriginGraphPortlet(String name, String width, String height, String dayCountString, boolean isCheckStyleActivated, boolean isDryActivated, boolean isFindBugsActivated, boolean isPmdActivated, boolean isOpenTasksActivated, boolean isWarningsActivated) {
        super(name, width, height, dayCountString);
        this.isDryDeactivated = !isDryActivated;
        this.isFindBugsDeactivated = !isFindBugsActivated;
        this.isPmdDeactivated = !isPmdActivated;
        this.isOpenTasksDeactivated = !isOpenTasksActivated;
        this.isWarningsDeactivated = !isWarningsActivated;
        this.isCheckStyleDeactivated = !isCheckStyleActivated;
        this.configureGraph(this.getGraphType());
    }

    public boolean isCheckStyleActivated() {
        return !this.isCheckStyleDeactivated;
    }

    public boolean isDryActivated() {
        return !this.isDryDeactivated;
    }

    public boolean isFindBugsActivated() {
        return !this.isFindBugsDeactivated;
    }

    public boolean isPmdActivated() {
        return !this.isPmdDeactivated;
    }

    public boolean isOpenTasksActivated() {
        return !this.isOpenTasksDeactivated;
    }

    public boolean isWarningsActivated() {
        return !this.isWarningsDeactivated;
    }

    protected Class<? extends AbstractProjectAction<?>> getAction() {
        return AnalysisProjectAction.class;
    }

    protected String getPluginName() {
        return "analysis";
    }

    protected BuildResultGraph getGraphType() {
        return new OriginGraph(this.isCheckStyleActivated(), this.isDryActivated(), this.isFindBugsActivated(), this.isPmdActivated(), this.isOpenTasksActivated(), this.isWarningsActivated());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension(optional=true)
    public static class WarningsGraphDescriptor
    extends Descriptor<DashboardPortlet> {
        public boolean isCheckStyleInstalled() {
            return AnalysisDescriptor.isCheckStyleInstalled();
        }

        public boolean isDryInstalled() {
            return AnalysisDescriptor.isDryInstalled();
        }

        public boolean isFindBugsInstalled() {
            return AnalysisDescriptor.isFindBugsInstalled();
        }

        public boolean isPmdInstalled() {
            return AnalysisDescriptor.isPmdInstalled();
        }

        public boolean isOpenTasksInstalled() {
            return AnalysisDescriptor.isOpenTasksInstalled();
        }

        public boolean isWarningsInstalled() {
            return AnalysisDescriptor.isWarningsInstalled();
        }

        public String getDisplayName() {
            return Messages.Portlet_WarningsOriginGraph();
        }
    }
}

