/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.collector;

import com.google.common.collect.Maps;
import hudson.model.AbstractBuild;
import hudson.plugins.analysis.collector.AnalysisDescriptor;
import hudson.plugins.analysis.collector.AnalysisResultAction;
import hudson.plugins.analysis.collector.Messages;
import hudson.plugins.analysis.core.BuildHistory;
import hudson.plugins.analysis.core.BuildResult;
import hudson.plugins.analysis.core.ParserResult;
import hudson.plugins.analysis.core.ResultAction;
import hudson.plugins.analysis.util.model.FileAnnotation;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class AnalysisResult
extends BuildResult {
    private static final long serialVersionUID = 847650789493429154L;
    private Map<String, Integer> annotationsByOrigin;
    private transient Object mappingLock = new Object();

    public AnalysisResult(AbstractBuild<?, ?> build, String defaultEncoding, ParserResult result) {
        this(build, new BuildHistory(build, AnalysisResultAction.class), result, defaultEncoding, true);
    }

    AnalysisResult(AbstractBuild<?, ?> build, BuildHistory history, ParserResult result, String defaultEncoding, boolean canSerialize) {
        super(build, history, result, defaultEncoding);
        this.annotationsByOrigin = this.countAnnotations();
        if (canSerialize) {
            this.serializeAnnotations((Collection)result.getAnnotations());
        }
    }

    public String getHeader() {
        return Messages.Analysis_ResultAction_Header();
    }

    protected Object readResolve() {
        super.readResolve();
        this.mappingLock = new Object();
        return this;
    }

    private Map<String, Integer> countAnnotations() {
        HashMap mapping = Maps.newHashMap();
        for (FileAnnotation annotation : this.getAnnotations()) {
            if (!mapping.containsKey(annotation.getOrigin())) {
                mapping.put(annotation.getOrigin(), 0);
            }
            mapping.put(annotation.getOrigin(), (Integer)mapping.get(annotation.getOrigin()) + 1);
        }
        return mapping;
    }

    public String getSummary() {
        return Messages.Analysis_ProjectAction_Name() + ": " + AnalysisResult.createDefaultSummary((String)AnalysisDescriptor.RESULT_URL, (int)this.getNumberOfAnnotations(), (int)this.getNumberOfModules());
    }

    protected String createDeltaMessage() {
        return AnalysisResult.createDefaultDeltaMessage((String)AnalysisDescriptor.RESULT_URL, (int)this.getNumberOfNewWarnings(), (int)this.getNumberOfFixedWarnings());
    }

    protected String getSerializationFileName() {
        return "analysis.xml";
    }

    public String getDisplayName() {
        return Messages.Analysis_ProjectAction_Name();
    }

    protected Class<? extends ResultAction<? extends BuildResult>> getResultActionType() {
        return AnalysisResultAction.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfAnnotationsByOrigin(String origin) {
        Object object = this.mappingLock;
        synchronized (object) {
            if (this.annotationsByOrigin == null) {
                this.annotationsByOrigin = this.countAnnotations();
                try {
                    this.getOwner().save();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (this.annotationsByOrigin.containsKey(origin)) {
            return (Integer)this.annotationsByOrigin.get(origin);
        }
        return 0;
    }
}

