/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hudson.plugins.birtcharts;

import java.awt.Color;
import java.util.List;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.LegendItemType;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.Marker;
import org.eclipse.birt.chart.model.attribute.MarkerType;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.RiserType;
import org.eclipse.birt.chart.model.attribute.TickStyle;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.LineAttributesImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.TextDataSet;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.data.impl.TextDataSetImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.type.BarSeries;
import org.eclipse.birt.chart.model.type.LineSeries;
import org.eclipse.birt.chart.model.type.impl.AreaSeriesImpl;
import org.eclipse.birt.chart.model.type.impl.BarSeriesImpl;
import org.eclipse.birt.chart.model.type.impl.LineSeriesImpl;
import org.eclipse.hudson.graph.DataSet;
import org.eclipse.hudson.graph.GraphSeries;

class BirtChart {
    protected String chartTitle;
    protected String xAxisLabel;
    protected String yAxisLabel;
    protected DataSet dataSet;

    BirtChart(String title, String xLabel, String yLabel, DataSet data) {
        this.chartTitle = title;
        this.xAxisLabel = xLabel;
        this.yAxisLabel = yLabel;
        this.dataSet = data;
    }

    Chart createChart() {
        ChartWithAxes stackedAreaChart = ChartWithAxesImpl.create();
        stackedAreaChart.setType("Area Chart");
        stackedAreaChart.setSubType("Stacked");
        stackedAreaChart.getBlock().setBackground((Fill)ColorDefinitionImpl.CREAM().brighter());
        stackedAreaChart.getBlock().getOutline().setVisible(true);
        stackedAreaChart.getTitle().getLabel().getCaption().setValue(this.chartTitle);
        Legend lg = stackedAreaChart.getLegend();
        lg.setItemType(LegendItemType.SERIES_LITERAL);
        lg.getText().getFont().setSize(10.0f);
        lg.getText().getFont().setBold(true);
        lg.getInsets().set(5.0, 0.0, 5.0, 5.0);
        lg.getClientArea().getInsets().set(5.0, 5.0, 5.0, 5.0);
        Axis xAxis = stackedAreaChart.getPrimaryBaseAxes()[0];
        xAxis.setType(AxisType.TEXT_LITERAL);
        xAxis.getMajorGrid().setTickStyle(TickStyle.BELOW_LITERAL);
        xAxis.getOrigin().setType(IntersectionType.MIN_LITERAL);
        xAxis.getTitle().getCaption().setValue(this.xAxisLabel);
        xAxis.getLabel().getCaption().getFont().setRotation(90.0);
        xAxis.getLabel().getCaption().getFont().setItalic(true);
        xAxis.getLabel().getCaption().setColor(ColorDefinitionImpl.BLUE().darker());
        xAxis.getLineAttributes().setColor(ColorDefinitionImpl.BLUE().darker());
        xAxis.getMajorGrid().setLineAttributes(LineAttributesImpl.create((ColorDefinition)ColorDefinitionImpl.PINK().translucent(), (LineStyle)LineStyle.SOLID_LITERAL, (int)1));
        this.setXData(xAxis);
        Axis yAxis = stackedAreaChart.getPrimaryOrthogonalAxis(xAxis);
        yAxis.getMajorGrid().setTickStyle(TickStyle.LEFT_LITERAL);
        yAxis.getTitle().getCaption().setValue(this.yAxisLabel);
        yAxis.getTitle().getCaption().setColor(ColorDefinitionImpl.BLUE().darker());
        yAxis.getLabel().getCaption().getFont().setItalic(true);
        yAxis.getLabel().getCaption().setColor(ColorDefinitionImpl.BLUE().darker());
        yAxis.getLineAttributes().setColor(ColorDefinitionImpl.BLUE().darker());
        yAxis.getTitle().setVisible(true);
        yAxis.getMajorGrid().setLineAttributes(LineAttributesImpl.create((ColorDefinition)ColorDefinitionImpl.PINK().translucent(), (LineStyle)LineStyle.SOLID_LITERAL, (int)1));
        this.setYData(yAxis);
        return stackedAreaChart;
    }

    protected void setXData(Axis xAxis) {
        GraphSeries grpahXSeries = this.dataSet.getXSeries();
        String[] seriesData = grpahXSeries.getData().toArray(new String[grpahXSeries.getData().size()]);
        TextDataSet xData = TextDataSetImpl.create((Object)seriesData);
        Series xSeries = SeriesImpl.create();
        xSeries.setDataSet((org.eclipse.birt.chart.model.data.DataSet)xData);
        xSeries.setSeriesIdentifier((Object)grpahXSeries.getCaption());
        SeriesDefinition xSeriesDefinition = SeriesDefinitionImpl.create();
        xAxis.getSeriesDefinitions().add((Object)xSeriesDefinition);
        xSeriesDefinition.getSeries().add((Object)xSeries);
    }

    protected void setYData(Axis yAxis) {
        List grpahYSerieses = this.dataSet.getYSeries();
        for (GraphSeries grpahYSeries : grpahYSerieses) {
            if (grpahYSeries.getData().size() <= 0) continue;
            Number[] seriesData = grpahYSeries.getData().toArray(new Number[grpahYSeries.getData().size()]);
            NumberDataSet yData = NumberDataSetImpl.create((Object)seriesData);
            Series ySeries = BarSeriesImpl.create();
            switch (grpahYSeries.getType()) {
                case 2: {
                    ySeries = BarSeriesImpl.create();
                    ((BarSeries)ySeries).setRiser(RiserType.TUBE_LITERAL);
                    ySeries.setTranslucent(true);
                    break;
                }
                case 1: {
                    ySeries = AreaSeriesImpl.create();
                    ySeries.setTranslucent(true);
                    break;
                }
                case 3: {
                    ySeries = LineSeriesImpl.create();
                    LineSeries ls = (LineSeries)ySeries;
                    ls.getLineAttributes().setColor(this.getColor(grpahYSeries.getColor()));
                    for (int i = 0; i < ls.getMarkers().size(); ++i) {
                        ((Marker)ls.getMarkers().get(i)).setType(MarkerType.CIRCLE_LITERAL);
                        ((Marker)ls.getMarkers().get(i)).setSize(2);
                    }
                    break;
                }
            }
            ySeries.setDataSet((org.eclipse.birt.chart.model.data.DataSet)yData);
            if (grpahYSeries.isStacked()) {
                ySeries.setStacked(true);
            }
            ySeries.setSeriesIdentifier((Object)grpahYSeries.getCaption());
            if (grpahYSeries.isValueLabelDisplayed()) {
                ySeries.getLabel().setVisible(true);
            } else {
                ySeries.getLabel().setVisible(false);
            }
            if (grpahYSeries.isLabelInside()) {
                ySeries.setLabelPosition(Position.INSIDE_LITERAL);
                ySeries.getLabel().getCaption().getFont().setRotation(90.0);
            }
            SeriesDefinition ySeriesDefinition = SeriesDefinitionImpl.create();
            ySeriesDefinition.getSeriesPalette().update((Fill)this.getColor(grpahYSeries.getColor()));
            yAxis.getSeriesDefinitions().add((Object)ySeriesDefinition);
            ySeriesDefinition.getSeries().add((Object)ySeries);
        }
    }

    protected ColorDefinition getColor(Color color) {
        return ColorDefinitionImpl.create((int)color.getRed(), (int)color.getGreen(), (int)color.getBlue());
    }
}

